<?php


class ctWaitlistAdmin{

    protected $pluginDomain;
    protected $sortResults ;
    protected $group;
    protected $clause;
    public function getPluginDomain(){
        return $this->pluginDomain;
    }
    public function setPluginDomain($value){
        $this->pluginDomain = $value;
    }
    public function getSortResults(){
        return $this->sortResults;
    }
    public function setSortResults($value){
        $this->sortResults = $value;
    }
    public function getGroup(){
        return $this->group;
    }
    public function setGroup($value){
        $this->group = $value;
    }
    public function getClause(){
        return $this->clause;
    }
    public function setClause($value){
        $this->clause = $value;
    }
    public function __construct(){
        $this->setClause('');
        $this->setGroup('');
        $this->setSortResults('');
        $this->setPluginDomain('ct_waitlist');
        add_action( 'admin_menu', array( $this, 'ctWaitlistRegisterMenuPage' ) );
        add_action( 'admin_init', array( $this, 'adminInit' ) );
        add_action( 'admin_init', array( $this, 'checkWoo' ) );
        add_action( 'save_post', array( $this, 'productSave' ) ,10 ,3 );
        add_action( 'wp_loaded', array( $this, 'deletectEntry' ) );
        add_action( 'admin_enqueue_scripts', array( $this, 'enqueueAjaxScript' ) );
        add_action( 'woocommerce_product_options_inventory_product_data', array( $this, 'wooProductData' ) );
        add_filter( 'views_edit-product', array( $this, 'mostWantedLink' ) );

    }

    /**
     * Adding 'Most wanted items' link to woocommerce 'Products' page
     * @param $views
     * @return mixed
     */
    public function mostWantedLink($views){
        if ( ! current_user_can('edit_others_pages') ) {
            return $views;
        }
        $views['mostwanted'] = '<a href="'.esc_url('admin.php?page='.$this->getPluginDomain().'&tab=usersData&group=mw').'">' . __( 'Mostly added to Waitlist', 'ct_waitlist') . '</a>';
        return $views;
    }

    /**
     * Adding Waitlist options to woocommerce edit inventory product page
     */
    public function wooProductData(){

        if(ctWaitlistOptions::getOption('ctWaitlist_use_postpone') == 'on'){
            $postId = get_the_ID();
            $postponeEmails = get_post_meta($postId, '_postponed_notification', true);
            $postponeEmails = $postponeEmails == 'on' ? true : false;
            $postpone = $postponeEmails ? 'checked="checked"' : '';
            echo '<div class="options_group show_if_simple show_if_variable"><p class="form-field show_if_simple show_if_variable"><label for="ct-waitlist-postpone">';
            _e('Postpone sending emails','ct_waitlist');
            echo '</label><input type="checkbox" name="ct-waitlist-postpone" id="ct-waitlist-postpone" '.$postpone.'><span class="description">';
            _e('"Back in stock" email notifications sending requires ' ,'ct_waitlist');
            echo '<a href="'.esc_url('admin.php?page='.$this->getPluginDomain().'&tab=usersData&group=queued').'">'.__('triggering','ct_waitlist').'</a>';
            echo '</span></p></div>';
        }


        if (ctWaitlistOptions::getOption('ctWaitlist_add_disable_option_to_product_page')){
            $postId = get_the_ID();
            $disableSubscription = get_post_meta($postId,'_disabled_subscription',true);
            $disableSubscription  = $disableSubscription == 'on' ? true : false;
            $checked = $disableSubscription ? 'checked="checked"' : '';
            echo '<div class="options_group show_if_simple show_if_variable"><p class="form-field show_if_simple show_if_variable"><label for="ct-waitlist-disable">';
            _e('Disable','ct_waitlist');
            echo '</label><input type="checkbox" name="ct-waitlist-disable" id="ct-waitlist-disable" '.$checked.'><span class="description">';
            _e('Disable Waitlist subscription for this item','ct_waitlist');
            echo '</span></p></div>';
            echo '<div class="options_group show_if_simple show_if_variable"><p class="form-field show_if_simple show_if_variable"><label for="">';
            _e('Waitlist subscriptions: ','ct_waitlist');
            $results = $this->countNotNotified($postId);
            echo '</label><span class="description">'.$results;
            echo '</span></p></div>';
        }
    }
    /**
     * Displays terms
     * @param $id
     */
    public function displayTerms($id){
        $terms = get_the_terms($id, 'product_cat');
        $counter = 0;
        if($terms) {
            foreach ($terms as $term) {
                echo '<a href="' . admin_url('edit.php?post_type=product&product_cat=' . $term->slug) . '" title="' . $term->name . '">' . $term->name . '</a>';
                $counter++;
                if ($counter < count($terms)) {
                    echo ', ';
                }
            }
        }
    }

    /**
     * Registering scripts and admin css
     */
    public function enqueueAjaxScript(){
        wp_enqueue_script( 'jquery' );
        wp_enqueue_script( 'admin' , plugins_url('assets/js/admin.js' ,  __FILE__ ) );

        wp_enqueue_style( 'ct-admin-style' ,plugins_url('assets/css/adminicons.css' ,  __FILE__ ) );
        wp_enqueue_style( 'ct-icon' ,plugins_url('assets/css/cticon.css' ,  __FILE__ ) );
    }

    /**
     * Deleting Waitlist Entry
     */
    public function deletectEntry(){
        $choosenOption = '';
        global $wpdb;
        if (isset($_GET['delete'])){
            $wpdb->delete($wpdb->prefix.$this->getPluginDomain() , array('id' => $_GET['delete']));
        }
        if (isset($_GET['send'])){

            $id = $_GET['send'];
            $res = $this->dbEntriesToNotify($id);
            $backInStockSubject = ctWaitlistOptions::getOption('ctWaitlist_mail_subject');
            $backInStockBody = ctWaitlistOptions::getOption('ctWaitlist_back_in_stock_email_content');
            $useWooTemplate = ctWaitlistOptions::getOption('ctWaitlist_use_woo_template');
            $header = ctWaitlistOptions::getOption('ctWaitlist_mail_subject');
            $public = ctWaitlist::getInstance();
            foreach ($res as $result) {
                if ($result->variationId != 0) {
                    $postId = $result->variationId;
                    $backInStockBody = $public->replaceShortcodes($backInStockBody, $postId, null, $result->variationId);
                    $backInStockSubject = $public->replaceShortcodes($backInStockSubject, $postId, null, $result->variationId);
                } else {
                    $postId = $result->productId;
                    $backInStockBody = $public->replaceShortcodes($backInStockBody, $postId);
                    $backInStockSubject = $public->replaceShortcodes($backInStockSubject, $postId);
                }


                $public->setHeader($public->replaceShortcodes($header, $postId));
                $public->setSenderFromName($public->replaceShortcodes(ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_name') == '' ? get_option('woocommerce_email_from_name') : ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_name'), $postId));
                $public->setSenderFromAddress($public->replaceShortcodes(ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_address') == '' ? get_option('woocommerce_email_from_address') : ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_address'), $postId));
                $public->sendConfirmMail($result->email, $subject = $backInStockSubject, $message = $useWooTemplate ? $public->getMailTemplate($backInStockBody, $type = 'backInStock') : $backInStockBody, $headers = $public->getHeaders(), $attachments = null);
                $this->setToNotified($id);
                $this->removeQueue($id);
            }
        }
        if (isset($_GET['remove'])){

            global $wpdb;
            $tableName = $wpdb->prefix . $this->getPluginDomain();
            $wpdb->update($tableName,
                array('queued' => 0),
                array('id' => $_GET['remove']),
                array('%d'),
                array('%d'));

        }
        if (isset($_GET['group'])){
            switch($_GET['group']){
                case 'all':
                    $this->setGroup(' notified = 0');
                    $this->setClause(' WHERE ' .$this->getGroup());
                    break;
                case 'notified':
                    $this->setGroup(' notified <> 0');
                    $this->setClause(' WHERE ' .$this->getGroup());
                    break;
                case 'queued':
                    $this->setGroup(' queued = 1');
                    $this->setClause(' WHERE ' .$this->getGroup());
                    break;
            }
        }
        if(isset($_POST['waitlistdataaction']) && $_POST['waitlistdataaction'] != 'actions'){
            $choosenOption = $_POST['waitlistdataaction'];
            } elseif(isset($_POST['waitlistdataaction2'])&& $_POST['waitlistdataaction2'] != 'actions'){
                $choosenOption = $_POST['waitlistdataaction2'];
            }
        if($choosenOption != ''){
                switch($choosenOption){
                    case 'delete':
                        if (isset($_POST['cbarray'])) {
                            $ids = $_POST['cbarray'];
                            foreach ($ids as  $val) {
                                global $wpdb;
                                $wpdb->delete($wpdb->prefix.$this->getPluginDomain() ,array('id' => $val));
                            }
                        }
                        break;
                    case 'export':
                        if (isset($_POST['cbarray'])) {
                            $var = isset($_GET['export-var']) ? $_GET['export-var'] : '1';
                            $ids = $_POST['cbarray'];
                            $this->exportCSV($ids,$var);
                        }
                        break;
                    case 'send':
                        if (isset($_POST['cbarray'])) {
                            $ids = $_POST['cbarray'];
                            foreach ($ids as $val) {

                                $id = $val;
                                $res = $this->dbEntriesToNotify($id);
                                $backInStockSubject = ctWaitlistOptions::getOption('ctWaitlist_mail_subject');
                                $backInStockBody = ctWaitlistOptions::getOption('ctWaitlist_back_in_stock_email_content');
                                $useWooTemplate = ctWaitlistOptions::getOption('ctWaitlist_use_woo_template');
                                $header = ctWaitlistOptions::getOption('ctWaitlist_mail_subject');
                                $public = ctWaitlist::getInstance();

                                foreach($res as $result) {
                                    if ($result->variationId != 0) {
                                        $postId = $result->variationId;
                                        $backInStockBody = $public->replaceShortcodes($backInStockBody, $postId, null, $result->variationId);
                                        $backInStockSubject = $public->replaceShortcodes($backInStockSubject, $postId, null, $result->variationId);
                                    } else {
                                        $postId = $result->productId;
                                        $backInStockBody = $public->replaceShortcodes($backInStockBody, $postId);
                                        $backInStockSubject = $public->replaceShortcodes($backInStockSubject, $postId);
                                    }

                                    $public->setHeader($public->replaceShortcodes($header, $postId));
                                    $public->setSenderFromName($public->replaceShortcodes(ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_name') == '' ? get_option('woocommerce_email_from_name') : ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_name'), $postId));
                                    $public->setSenderFromAddress($public->replaceShortcodes(ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_address') == '' ? get_option('woocommerce_email_from_address') : ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_address'), $postId));
                                    $public->sendConfirmMail($result->email, $subject = $backInStockSubject, $message = $useWooTemplate ? $public->getMailTemplate($backInStockBody, $type = 'backInStock') : $backInStockBody, $headers = $public->getHeaders(), $attachments = null);
                                    $this->setToNotified($id);
                                    $this->removeQueue($id);
                                }
                            }
                        }
                        break;
                    case 'remove':
                        if (isset($_POST['cbarray'])) {
                            $ids = $_POST['cbarray'];
                            foreach ($ids as $val) {
                                $this->removeQueue($val);

                            }
                        }
                        break;
                }
            }
        if(isset($_GET['sort']) && $_GET['sort'] === 'asc'){
            $this->setSortResults($wpdb->get_results("SELECT * FROM " . $wpdb->prefix.$this->getPluginDomain() .$this->getClause() . " ORDER BY " .$_GET['sortitem']." ".strtoupper($_GET['sort'])));
            $_GET['sort'] = 'desc';
        } elseif(isset($_GET['sort']) && $_GET['sort'] === 'desc'){
            $this->setSortResults($wpdb->get_results("SELECT * FROM " . $wpdb->prefix.$this->getPluginDomain() .$this->getClause() .  " ORDER BY " .$_GET['sortitem']." ".strtoupper($_GET['sort'])));
            $_GET['sort'] = 'asc';
        }
    }

    /**
     * When product saved
     *
     * @param $post_ID
     * @param $post
     */
    public function productSave($post_ID,$post)    {

        $backInStockSubject = ctWaitlistOptions::getOption('ctWaitlist_mail_subject');
        $backInStockBody = ctWaitlistOptions::getOption('ctWaitlist_back_in_stock_email_content');
        $useWooTemplate = ctWaitlistOptions::getOption('ctWaitlist_use_woo_template');
        $header = ctWaitlistOptions::getOption('ctWaitlist_mail_subject');

        $public = ctWaitlist::getInstance();

        $public->setHeader($public->replaceShortcodes($header,$post_ID));

        $minAmountToSend = intval(ctWaitlistOptions::getOption('ctWaitlist_amount_to_send_back_in_stock_email'));

        $postpone = ctWaitlistOptions::getOption('ctWaitlist_use_postpone') == 'on' ? true : false;

            if ($post->post_type = 'product') {
                if (wp_is_post_revision($post_ID)) {
                    return;
                }
                if($postpone) {
                    if (isset($_POST['ct-waitlist-postpone']) && $_POST['ct-waitlist-postpone'] == 'on') {
                        update_post_meta($post_ID, '_postponed_notification', $_POST['ct-waitlist-postpone']);
                    } else {
                        update_post_meta($post_ID, '_postponed_notification', '');
                    }
                }
                if (isset($_POST['ct-waitlist-disable']) && $_POST['ct-waitlist-disable'] == 'on') {
                    update_post_meta($post_ID, '_disabled_subscription', $_POST['ct-waitlist-disable']);
                } else {
                    update_post_meta($post_ID, '_disabled_subscription', '');
                }

                $waitlistDb = $this->dbEntriesToNotify();

                if (get_post_meta($post_ID, '_postponed_notification' , true ) == 'on' )
                {
                    foreach ($waitlistDb as $res) {
                        if(isset($res->variationId) && ($res->variationId != 0)) {
                            if (get_post_meta($res->variationId, '_stock_status', true) == 'instock') {
                                $this->setToQueued($res->id);
                            }
                        }elseif (isset($res->grouped_parentId) && ($res->grouped_parentId != 0)) {
                            if ((get_post_meta($res->productId, '_stock_status', true) == 'instock') && (get_post_meta($res->grouped_parentId, '_stock_status', true) == 'instock')){
                                $this->setToQueued($res->id);
                            }
                        }else {
                            if (get_post_meta($res->productId, '_stock_status', true) == 'instock') {
                                $this->setToQueued($res->id);
                            }
                        }
                     }
                } else {
                    foreach ($waitlistDb as $res) {
                        if (isset($res->variationId) && ($res->variationId != 0)) {
                            if (get_post_meta($res->variationId, '_stock_status', true) == 'instock') {
                                if (((intval(get_post_meta($res->variationId, '_stock', true))) >= $minAmountToSend) && (get_post_meta($post_ID, '_postponed_notification', true) != 'on')) {

                                    $backInStockBody = $public->replaceShortcodes($backInStockBody, $post_ID,null,$res->variationId);
                                    $backInStockSubject = $public->replaceShortcodes($backInStockSubject, $post_ID,null,$res->variationId);
                                    $public->setSenderFromName($public->replaceShortcodes(ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_name') == '' ? get_option('woocommerce_email_from_name') : ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_name'), $post_ID));
                                    $public->setSenderFromAddress($public->replaceShortcodes(ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_address') == '' ? get_option('woocommerce_email_from_address') : ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_address'), $post_ID));
                                    $public->sendConfirmMail($res->email, $subject = $backInStockSubject, $message = $useWooTemplate ? $public->getMailTemplate($backInStockBody, $type = 'backInStock') : $backInStockBody, $headers = $public->getHeaders(), $attachments = null);
                                    $this->setToNotified($res->id);
                                    $this->removeQueue($res->id);

                                }
                            }
                        } elseif (isset($res->grouped_parentId) && ($res->grouped_parentId != 0)) {
                            if ((get_post_meta($res->productId, '_stock_status', true) == 'instock') && (get_post_meta($res->grouped_parentId, '_stock_status', true) == 'instock')) {
                                if (((intval(get_post_meta($res->productId, '_stock', true))) >= $minAmountToSend) && (get_post_meta($post_ID, '_postponed_notification', true) != 'on')) {
                                    $backInStockBody = $public->replaceShortcodes($backInStockBody, $post_ID);
                                    $backInStockSubject = $public->replaceShortcodes($backInStockSubject, $post_ID);
                                    $public->setSenderFromName($public->replaceShortcodes(ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_name') == '' ? get_option('woocommerce_email_from_name') : ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_name'), $post_ID));
                                    $public->setSenderFromAddress($public->replaceShortcodes(ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_address') == '' ? get_option('woocommerce_email_from_address') : ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_address'), $post_ID));
                                    $public->sendConfirmMail($res->email, $subject = $backInStockSubject, $message = $useWooTemplate ? $public->getMailTemplate($backInStockBody, $type = 'backInStock') : $backInStockBody, $headers = $public->getHeaders(), $attachments = null);
                                    $this->setToNotified($res->id);

                                    $this->removeQueue($res->id);
                                }
                            }
                        } else {
                            if (get_post_meta($res->productId, '_stock_status', true) == 'instock') {
                                if ((((intval(get_post_meta($res->productId, '_stock', true))) >= $minAmountToSend) && (get_post_meta($post_ID, '_postponed_notification', true) != 'on'))) {
                                    $backInStockBody = $public->replaceShortcodes($backInStockBody, $post_ID);
                                    $backInStockSubject = $public->replaceShortcodes($backInStockSubject, $post_ID);
                                    $public->setSenderFromName($public->replaceShortcodes(ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_name') == '' ? get_option('woocommerce_email_from_name') : ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_name'), $post_ID));
                                    $public->setSenderFromAddress($public->replaceShortcodes(ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_address') == '' ? get_option('woocommerce_email_from_address') : ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_address'), $post_ID));
                                    $public->sendConfirmMail($res->email, $subject = $backInStockSubject, $message = $useWooTemplate ? $public->getMailTemplate($backInStockBody, $type = 'backInStock') : $backInStockBody, $headers = $public->getHeaders(), $attachments = null);
                                    $this->setToNotified($res->id);

                                    $this->removeQueue($res->id);

                                }
                            }
                        }
                    }
                }
            }
    }


    /**
     * Admin tabs
     *
     * @param string $activeTab
     */
    public function adminTabs( $activeTab = 'mainSettings' ) {
        $tabs = array(
            'mainSettings' 	=> __( 'Plugin Settings' , 'ct_waitlist' ) ,
            'email'         => __( 'Email Settings', 'ct_waitlist' ),
            'usersData'		=> __( 'Subscriptions list' , 'ct_waitlist' ),
            'disabling'     => __( 'Disabling options', 'ct_waitlist')

        );
        echo '<h2 class="nav-tab-wrapper">';
        foreach( $tabs as $tab => $tabName ){
            $tabClass = ( $tab == $activeTab ) ? ' nav-tab-active' : '';
            $tabString = ( $tab == 'mainSettings' ) ? "" : "&tab=$tab";
            echo '<a class="nav-tab'.$tabClass.'" href="'.esc_url('?page=' . $this->getPluginDomain() . $tabString ).'">'.$tabName.'</a>';
        }
        echo '</h2>';
    }

    /**
     * Admin tabs
     */
    public function ctWaitlistRegisterMenuPage(){
        if(!current_user_can('manage_options')){
            $role = get_role('shop_manager');
            $role->remove_cap('manage_options');
            $options = add_menu_page(
                __('WaitList', 'ct_waitlist'),
                __('WaitList', 'ct_waitlist'),
                'manage_woocommerce',
                $this->getPluginDomain(),
                array($this, 'displayAdminSettings'),
                '',
                56
            );


        }else {
            $options = add_menu_page(
                __('WaitList', 'ct_waitlist'),
                __('WaitList', 'ct_waitlist'),
                'manage_options',
                $this->getPluginDomain(),
                array($this, 'displayAdminSettings'),
                '',
                56
            );


        }

    }
    /**
     * Admin view callback
     */
    public function displayAdminSettings(){
       require_once('views/adminView.php');
    }

    /**
     * Checks if woocommerce is installed and activated
     */
    public function checkWoo(){
        if ( ! self::hasWoo() ) {
            add_action( 'admin_notices', array( $this, 'showWooError' ) );
        }
    }
    public function showWooError() {
        echo '<div><p><strong>' . __( 'Waitlist Plugin', 'ct_waitlist' ) . '</strong>' . __( 'This plugin requires installed and activated WooCommerce', 'ct_waitlist' ) . '</p></div>';
    }
    public static function hasWoo(){
        return class_exists('Woocommerce');
    }

    /**
     * Processing options
     */
    public function adminInit() {
        add_action( 'admin_post_save_ctWaitlist_options',array($this,
            'processCtWaitlistOptions' ));
    }

    public function subscribe_message_change(){
        return $value =  'New subscribe message';
    }
    /**
     * Processing options
     */
    public function processCtWaitlistOptions()
    {

        if (!current_user_can('manage_options'))
            wp_die('Not allowed');
        check_admin_referer('ctWaitlist');

        if(isset($_POST['toDisable'])) {
            $myterms = $_POST['toDisable'];
            foreach ($myterms as $key => $singleTerm) {
                foreach($singleTerm as $term) {
                    $args = array(
                        'post_type' => 'product',
                        'tax_query' => array(
                            array(
                                'taxonomy' => $key,
                                'field' => 'slug',
                                'terms' => $term

                            )
                        )
                    );
                    $loop = new WP_Query($args);
                    if (isset($_POST['disableAction'])) {
                        foreach ($loop->get_posts() as $post) {
                            if ($_POST['disableAction'] == 'disable') {
                                update_post_meta($post->ID, '_disabled_subscription', 'on');
                            } elseif ($_POST['disableAction'] == 'enable') {
                                update_post_meta($post->ID, '_disabled_subscription', '');
                            }
                        }

                    }
                }
            }
            wp_redirect( esc_url_raw(add_query_arg(
                array( 'page' => $this->getPluginDomain(),
                    'message' => '1' ,
                    'tab' => 'disabling'),
                admin_url(  ) ) ) );
            exit;
        }

        $options = get_option('ctWaitlist_options');



        $optionsTable = $_POST;

        foreach($optionsTable as $key => $value) {

            if (array_key_exists($key, $options)) {
                $value = trim(wp_unslash($value));
                $options[$key] = $value;
            }
            $options[$key] = apply_filters('ctWaitlist_options_' . $key, $value);
        }

        update_option('ctWaitlist_options', $options);





        if($_POST['tab'] == 'email'){
            wp_redirect( esc_url_raw(add_query_arg(
                array( 'page' => $this->getPluginDomain(),
                    'message' => '1' ,
                    'tab' => 'email'),
                admin_url(  ) ) ) );
            exit;
        }
        wp_redirect( esc_url_raw(add_query_arg(
            array( 'page' => $this->getPluginDomain(),
                'message' => '1'),
            admin_url( ) ) ) );
        exit;
    }
    /**
     * Waitlist entries
     *
     * @param null $id
     * @return int|mixed
     */

    public function getDbEntries($id = null){
        global $wpdb;
        if($id){
            $sql = "SELECT COUNT(*) AS cnt FROM ".$wpdb->prefix.$this->getPluginDomain()." WHERE productId = ".$id;
            $res = $wpdb->get_row($sql);
            return intval($res->cnt);
        }else{
            $sql = "SELECT * FROM ".$wpdb->prefix.$this->getPluginDomain() ." ".$this->getClause();
            $result = $wpdb->get_results($sql);
            return $result;
        }
    }
    public function countNotNotified($id){
        global $wpdb;
        if($id){
            $sql = "SELECT COUNT(*) AS cnt FROM ".$wpdb->prefix.$this->getPluginDomain()." WHERE productId = ".$id." AND notified = 0";
            $res = $wpdb->get_row($sql);
            return intval($res->cnt);
        }

    }
    public function dbEntriesNotified(){
        global $wpdb;
        $sql = "SELECT * FROM " .$wpdb->prefix . $this->getPluginDomain() . " WHERE notified <> 0 ";
        $res = $wpdb->get_results($sql);
        return $res;
    }
    public function dbEntriesToNotify($id = null){
        global $wpdb;
        $sql = "SELECT * FROM " .$wpdb->prefix . $this->getPluginDomain() . " WHERE notified = 0 ";
        if($id){
            $clause = 'AND id = '.$id;
            $sql .= $clause;
        }

        $res = $wpdb->get_results($sql);
        return $res;
    }
    public function dbEntriesQueued(){
        global $wpdb;
        $sql = "SELECT * FROM " .$wpdb->prefix . $this->getPluginDomain() . " WHERE queued = 1";
        $res = $wpdb->get_results($sql);
        return $res;
    }
    public function removeEntry($id){
        global $wpdb;
        $wpdb->delete($wpdb->prefix.$this->getPluginDomain() , array('id' => $id));
    }
    public function setToQueued($id){
        global $wpdb;
        $tableName = $wpdb->prefix.$this->getPluginDomain();
        $wpdb->update($tableName,
            array('queued' => 1),
            array('id' => $id),
            array('%d'),
            array('%d'));
    }
    public function removeQueue($id){
        global $wpdb;
        $tableName = $wpdb->prefix . $this->getPluginDomain();
        $wpdb->update($tableName,
            array('queued' => 0),
            array('id' => $id),
            array('%d'),
            array('%d'));
    }

    public function setToNotified($id){
        global $wpdb;
        $tableName = $wpdb->prefix . $this->getPluginDomain();
        $wpdb->update($tableName,
            array('notified' => current_time('mysql', 1)),
            array('id' => $id),
            array('%s'),
            array('%s'));
        if(ctWaitlistOptions::getOption('ctWaitlist_admin_send_on_notify') == 'on') {
            $result = $wpdb->get_row("SELECT * FROM ".$tableName." WHERE id ='".$id."'");
            $public = ctWaitlist::getInstance();
            $public->sendAdminNotificationOnSubscriberNotify( $result->email, $result->productId,$result->variationId);
        }
    }

    /**
     * @param $result
     */
    public function getIcon($result){
        if($result->variationId){
            echo 'waitlist-variable';
        } elseif($result->grouped_parentId){
            echo 'waitlist-group';
        } else {
            echo 'waitlist-simple';
        }
    }
    /**
     * @param $ids
     * @param $var
     */
    public function exportCSV( $ids , $var){

        if ($var == '1'){
            if ($ids) {
                if (!is_array($ids)) {
                    $ids = array($ids);
                }
                $filename =  current_time('mysql') ."waitlist-data" . ".csv";
                $filename = str_replace(" ", "_", $filename);
                $filename = str_replace(":", "-", $filename);
                $csvHeader = array();
                $csvHeader[] = "Email";
                $csvHeader[] = "Product Title";
                $csvHeader[] = "Variation";
                $csvHeader[] = "Categories";
                $csvHeader[] = "Date Added";
                header("Pragma: public");
                header("Expires: 0");
                header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
                header("Cache-Control: private", false);
                header("Content-Type: application/octet-stream");
                header("Content-Disposition: attachment; filename=" . $filename . ";");
                header("Content-Transfer-Encoding: binary");
                $t = implode(",", $csvHeader);
                print $t . "\r\n";
                global $wpdb;
                $sql = "SELECT * FROM " . $wpdb->prefix.$this->getPluginDomain() . " WHERE id IN (" . implode(",", $ids) . ") ORDER BY date DESC";
                $ret = $wpdb->get_results($sql);
                foreach ($ret as $k => $v) {
                    if (in_array($v->id, $ids)) {
                        $product_title = get_the_title($v->productId);
                        $subscription = array();
                        $subscription[] = $v->email;
                        $subscription[] = $product_title;
                        if ($v->variationId == 0) {
                            $subscription[] = '-';
                        } else {
                            $public = ctWaitlist::getInstance();
                            $variationTitle = $public->displayVariationName($v->variationId);
                            if ($variationTitle) {
                                $subscription[] = $variationTitle;
                            }
                        }
                        $terms = get_the_terms($v->productId, 'product_cat');
                        if ($terms) {
                            $counter = 0;
                            $g = "";
                            foreach ($terms as $term) {
                                $g .= $term->name;
                                $counter++;
                                if ($counter < count($terms)) {
                                    $g .= ' / ';
                                }
                            }
                            $subscription[] = $g;
                        } else {
                            $subscription[] = "-";
                        }
                        $subscription[] = $v->date;
                        $t = implode(",", $subscription);
                        print $t . "\r\n";
                    }

                }

                exit;
            }
        } elseif($var == '2') {
            if ($ids) {
                if (!is_array($ids)) {
                    $ids = array($ids);
                }
                $filename =  current_time('mysql') ."waitlist-data" . ".csv";
                $filename = str_replace(" ", "_", $filename);
                $filename = str_replace(":", "-", $filename);
                $csvHeader = array();
                $csvHeader[] = "Email";
                $csvHeader[] = "Product Title";
                $csvHeader[] = "Variation";
                $csvHeader[] = "Categories";
                $csvHeader[] = "Date Subscribed";
                $csvHeader[] = "Date Notified";
                $csvHeader[] = "Date Bought";

                header("Pragma: public");
                header("Expires: 0");
                header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
                header("Cache-Control: private", false);
                header("Content-Type: application/octet-stream");
                header("Content-Disposition: attachment; filename=" . $filename . ";");
                header("Content-Transfer-Encoding: binary");
                $t = implode(",", $csvHeader);
                print $t . "\r\n";
                global $wpdb;
                $sql = "SELECT * FROM " . $wpdb->prefix.$this->getPluginDomain() . " WHERE id IN (" . implode(",", $ids) . ") ORDER BY date DESC";
                $ret = $wpdb->get_results($sql);
                foreach ($ret as $k => $v) {
                    if (in_array($v->id, $ids)) {
                        $product_title = get_the_title($v->productId);
                        $subscription = array();
                        $subscription[] = $v->email;
                        $subscription[] = $product_title;
                        if ($v->variationId == 0) {
                            $subscription[] = '-';
                        } else {
                            $public = ctWaitlist::getInstance();
                            $variationTitle = $public->displayVariationName($v->variationId);
                            if ($variationTitle) {
                                $subscription[] = $variationTitle;
                            }
                        }
                        $terms = get_the_terms($v->productId, 'product_cat');
                        if ($terms) {
                            $counter = 0;
                            $g = "";
                            foreach ($terms as $term) {
                                $g .= $term->name;
                                $counter++;
                                if ($counter < count($terms)) {
                                    $g .= ' / ';
                                }
                            }
                            $subscription[] = $g;
                        } else {
                            $subscription[] = "-";
                        }
                        $subscription[] = $v->subscribed;
                        $subscription[] = $v->notified;
                        $subscription[] = $v->bought;
                        $t = implode(",", $subscription);
                        print $t . "\r\n";
                    }

                }

                exit;
            }
        }

    }

}

new ctWaitlistAdmin();