<div xmlns="http://www.w3.org/1999/html">
    <?php if ( isset( $_GET['message'] ) && $_GET['message'] == '1' ) { ?>
        <div id='message' class='updated fade'>
            <p>
                <strong><?php _e('Changes Saved','ct_waitlist');?></strong>
            </p>
        </div>
    <?php }
    $activeTab = "mainSettings";
    $activeTabAddress = "?page=".$this->getPluginDomain();
    if (isset($_GET['tab'])){
        $this->adminTabs( $_GET['tab'] );
        if( $_GET['tab'] != "mainSettings" ){
            $activeTab = $_GET['tab'];
            $activeTabAddress .= "&tab=".$activeTab;
        }
    }
    else{
        $this->adminTabs('mainSettings');
    }
    $activeTabAddress = esc_url($activeTabAddress);
    switch($activeTab) {
        case 'mainSettings':
?>
            <form method="post" action="admin-post.php">
                <input type="hidden" name="action" value="save_ctWaitlist_options" />
                <?php wp_nonce_field( 'ctWaitlist' ); ?>
                <table class="ct-waitlist-table-options">
                    <tr>
                        <td colspan="2"><h3><?php _e('Public facilities','ct_waitlist'); ?></h3></td>
                    </tr>
                    <tr>
                        <td><label for="ctWaitlist_button_text"><?php _e( 'Subscribe button text:' , 'ct_waitlist' ); ?></label></td>
                        <td><input type="text" id="ctWaitlist_button_text" class="input-waitlist" name="ctWaitlist_button_text" value="<?php echo ctWaitlistOptions::getOption('ctWaitlist_button_text');?>"/><br /></td>
                    </tr>
                    <tr>
                        <td><label for="ctWaitlist_subscribe_message"><?php _e( 'Subscribe message (appearing after availability message):' , 'ct_waitlist' ); ?></label></td>
                        <td><input type="text" id="ctWaitlist_subscribe_message" class="input-waitlist" name="ctWaitlist_subscribe_message" value="<?php echo ctWaitlistOptions::getOption('ctWaitlist_subscribe_message'); ?>"/><br /></td>
                    </tr>
                    <tr>
                        <td><label for="ctWaitlist_already_subscribed_message"><?php _e( 'Product already subscribed message:' , 'ct_waitlist' ); ?></label></td>
                        <td><input type="text" id="ctWaitlist_already_subscribed_message" class="input-waitlist" name ="ctWaitlist_already_subscribed_message" value="<?php echo ctWaitlistOptions::getOption('ctWaitlist_already_subscribed_message');?>"/><br/></td>
                    </tr>
                    <tr>
                        <td><label for="ctWaitlist_var_already_subscribed_message"><?php _e( 'Variation already subscribed message:' , 'ct_waitlist' ); ?></label></td>
                        <td><input type="text" id="ctWaitlist_var_already_subscribed_message" class="input-waitlist" name ="ctWaitlist_var_already_subscribed_message" value="<?php echo ctWaitlistOptions::getOption('ctWaitlist_var_already_subscribed_message');?>"/><br/><td>
                    </tr>
                    <tr>
                        <td><label for="ctWaitlist_oos_message"><?php _e( 'Simple product out of stock message:' , 'ct_waitlist' ); ?></label></td>
                        <td><input type="text" id="ctWaitlist_oos_message" class="input-waitlist" name="ctWaitlist_oos_message" value="<?php echo ctWaitlistOptions::getOption('ctWaitlist_oos_message');?>"/><br/></td>
                    </tr>
                    <tr>
                        <td><label for="ctWaitlist_var_oos_message"><?php _e( 'Variable product out of stock message:' , 'ct_waitlist' ); ?></label></td>
                        <td><input type="text" id="ctWaitlist_var_oos_message" class="input-waitlist" name="ctWaitlist_var_oos_message" value="<?php echo ctWaitlistOptions::getOption('ctWaitlist_var_oos_message');?>"/><br/></td>
                    </tr>
                    <tr>
                        <td><label for="ctWaitlist_subscription_succes_message"><?php _e( 'Waitlist simple product subscription success:' , 'ct_waitlist' ); ?></label></td>
                        <td><input type="text" id="ctWaitlist_subscription_succes_message" class="input-waitlist" name="ctWaitlist_subscription_succes_message" value="<?php echo ctWaitlistOptions::getOption('ctWaitlist_subscription_succes_message');?>"/><br/></td>
                    </tr>
                    <tr>
                        <td><label for="ctWaitlist_subscription_var_succes_message"><?php _e( 'Waitlist variation subscription success:' , 'ct_waitlist' ); ?></label></td>
                        <td><input type="text" id="ctWaitlist_subscription_var_succes_message" class="input-waitlist" name="ctWaitlist_subscription_var_succes_message" value="<?php echo ctWaitlistOptions::getOption('ctWaitlist_subscription_var_succes_message');?>"/><br/></td>
                    </tr>
                    <tr>
                        <td><label for="ctWaitlist_placeholder_email"><?php _e( 'User email box text:' , 'ct_waitlist' ); ?></label></td>
                        <td><input type="text" id="ctWaitlist_placeholder_email" class="input-waitlist" name="ctWaitlist_placeholder_email" value="<?php echo ctWaitlistOptions::getOption('ctWaitlist_placeholder_email');?>"/><br/></td>
                    </tr>
                    <tr>
                        <td><label for="ctWaitlist_front_style"><?php _e( 'Select style (visible on product page)' , 'ct_waitlist' ); ?></label></td>
                        <td>
                            <select name="ctWaitlist_front_style" id="ctWaitlist_front_style" class="input-waitlist">
                                <option value="0"<?php if(ctWaitlistOptions::getOption('ctWaitlist_front_style') == 0)  echo'selected="selected"';?>><?php _e('Normal','ct_waitlist');?></option>
                                <option value="1"<?php if(ctWaitlistOptions::getOption('ctWaitlist_front_style') == 1)  echo'selected="selected"';?>><?php _e('Minimalistic','ct_waitlist');?></option>
                            </select>
                        </td>
                    </tr>

                    <tr>
                        <td><label for="ctWaitlist_use_custom_css"><?php _e('Use custom CSS style','ct_waitlist');?></label></td>
                        <td>
                            <input type="hidden" value="0" name="ctWaitlist_use_custom_css"/>
                            <input type="checkbox" name="ctWaitlist_use_custom_css" id="ctWaitlist_use_custom_css" <?php if (ctWaitlistOptions::getOption('ctWaitlist_use_custom_css') == 'on' ) echo ' checked="checked" ';?> />
                        </td>
                    </tr>
                    <tr class="tr6" <?php if (ctWaitlistOptions::getOption('ctWaitlist_use_custom_css') != 'on' ) echo 'hidden';?>>
                        <td><label for="ctWaitlist_custom_css"><?php _e('Custom CSS:','ct_waitlist');?></label></td>
                        <td><textarea rows="8" id="ctWaitlist_custom_css" class="input-waitlist" name="ctWaitlist_custom_css"><?php echo ctWaitlistOptions::getOption('ctWaitlist_custom_css');?></textarea></td>
                    </tr>

                    <tr>
                        <td colspan="2"><h3><?php _e('Subscription removing options','ct_waitlist'); ?></h3></td>
                    </tr>
                    <tr>
                    <td><label for="ctWaitlist_select_unsubscribe_page"><?php _e( 'Select un-subscribe page' , 'ct_waitlist' ); ?></label></td>
                    <td>
                        <select name="ctWaitlist_select_unsubscribe_page" id="ctWaitlist_select_unsubscribe_page" class="input-waitlist">
                            <option value="0"<?php if(ctWaitlistOptions::getOption('ctWaitlist_select_unsubscribe_page') == 0)  echo'selected="selected"';?>><?php _e('Disabled','ct_waitlist');?></option>
                            <option value="1"<?php if(ctWaitlistOptions::getOption('ctWaitlist_select_unsubscribe_page') == 1)  echo'selected="selected"';?>><?php _e('My Account','ct_waitlist');?></option>
                            <option value="2"<?php if(ctWaitlistOptions::getOption('ctWaitlist_select_unsubscribe_page') == 2)  echo'selected="selected"';?>><?php _e('Product Page','ct_waitlist');?></option>
                            <option value="3"<?php if(ctWaitlistOptions::getOption('ctWaitlist_select_unsubscribe_page') == 3)  echo'selected="selected"';?>><?php _e('My Account and Product Page','ct_waitlist');?></option>
                        </select>
                    </td>
                    </tr>
                    <tr>
                        <td><label for="ctWaitlist_unsubscribe_button_text"><?php _e( 'Un-subscribe Button Text:' , 'ct_waitlist' ); ?></label></td>
                        <td><input type="text" class="input-waitlist" id="ctWaitlist_unsubscribe_button_text" name ="ctWaitlist_unsubscribe_button_text" value="<?php echo ctWaitlistOptions::getOption('ctWaitlist_unsubscribe_button_text');?>"/><br/></td>
                    </tr>
                    <tr>
                        <td><label for="ctWaitlist_remove_from_waitlist"><?php _e( 'Removed from waitlist notification:' , 'ct_waitlist' ); ?></label></td>
                        <td><input type="text" class="input-waitlist" id="ctWaitlist_remove_from_waitlist" name ="ctWaitlist_remove_from_waitlist" value="<?php echo ctWaitlistOptions::getOption('ctWaitlist_remove_from_waitlist');?>"/><br/></td>
                    </tr>

                    <tr>
                        <td colspan="2">
                            <br />
                            <hr>
                            <br />
                        </td>
                    </tr>
                    <tr>
                        <td><label for="ctWaitlist_amount_to_send_back_in_stock_email"><?php _e( 'Minimum stock amount to send "Item is back" message:' , 'ct_waitlist' ); ?></label></td>
                        <td><input type="number" id="ctWaitlist_amount_to_send_back_in_stock_email" class="input-waitlist" min="0" max="" name ="ctWaitlist_amount_to_send_back_in_stock_email" value="<?php echo ctWaitlistOptions::getOption('ctWaitlist_amount_to_send_back_in_stock_email');?>"/><br/></td>
                    </tr>
                    <tr>
                        <br/>
                    </tr>
                    <?php
                    if( current_user_can( "manage_options" ) ){
                        ?>
                        <tr>
                            <td><label for="ctWaitlist_enable_shop_manager"><?php _e( 'Enable plugin data to Shop Manager:' , 'ct_waitlist' ); ?></label></td>
                            <td>
                                <input type="hidden" value="0" name="ctWaitlist_enable_shop_manager"/>
                                <input type="checkbox" id="ctWaitlist_enable_shop_manager" name ="ctWaitlist_enable_shop_manager"  <?php if (
                                ctWaitlistOptions::getOption('ctWaitlist_enable_shop_manager') == 'on' ) echo ' checked="checked" ';
                                ?>/><br/></td>
                        </tr>
                    <?php
                    }
                    ?>
                    <tr>
                        <td><label class="label-waitlist" for="ctWaitlist_remove_data_on_delete"><?php _e( 'Remove data on plugin deletion:' , 'ct_waitlist' ); ?></label></td>
                        <td>
                            <input type="hidden" value="0" name="ctWaitlist_remove_data_on_delete"/>
                            <input type="checkbox" id="ctWaitlist_remove_data_on_delete" name ="ctWaitlist_remove_data_on_delete" <?php if (
                            ctWaitlistOptions::getOption('ctWaitlist_remove_data_on_delete') == 'on' ) echo ' checked="checked" ';
                            ?>/><br/></td>
                    </tr>
                    <tr>
                        <td><label for="ctWaitlist_add_disable_option_to_product_page"><?php _e( 'Display Waitlist data on WooCommerce product page edit:' , 'ct_waitlist' ); ?></label></td>
                        <td>
                            <input type="hidden" value="0" name="ctWaitlist_add_disable_option_to_product_page"/>
                            <input type="checkbox" id="ctWaitlist_add_disable_option_to_product_page" name ="ctWaitlist_add_disable_option_to_product_page" <?php if (
                                ctWaitlistOptions::getOption('ctWaitlist_add_disable_option_to_product_page') == 'on' ) echo ' checked="checked" ';
                            ?>/><br/></td>
                    </tr>
                    <tr>
                        <td><label class="label-waitlist" for="ctWaitlist_use_postpone"><?php _e( 'Enable postponing emails option in product edit page:' , 'ct_waitlist' ); ?></label></td>
                        <td>
                            <input type="hidden" value="0" name="ctWaitlist_use_postpone"/>
                            <input type="checkbox" id="ctWaitlist_use_postpone" name ="ctWaitlist_use_postpone" <?php if (
                                ctWaitlistOptions::getOption('ctWaitlist_use_postpone') == 'on' ) echo ' checked="checked" ';
                            ?>/><br/></td>
                    </tr>
                    <tr><td><br /></td></tr>
                    <tr>
                        <td colspan="2">
                            <input type="submit" value="<?php _e('Submit changes','ct_waitlist'); ?>" class="button-primary"/>
                        </td>
                    </tr>
                </table>
            </form>
            <?php
            break;
        case 'usersData':
            ?>
            <form method="POST" action="<?php echo $activeTabAddress;?>">
                <p>
                    <a style="text-decoration:none ; <?php if(!isset($_GET['group']) || $_GET['group'] == 'all' )  echo 'color:black; font-weight:bold;';  ?>" href="<?php echo $activeTabAddress; ?>&amp;group=all"><?php _e('Subscriptions','ct_waitlist');?><strong>&nbsp(<?php echo count($this->dbEntriesToNotify()); ?>)</strong></a>&nbsp|
                    <a style="text-decoration:none ; <?php if($_GET['group'] == 'notified') echo 'color:black; font-weight:bold;';  ?>" href="<?php echo $activeTabAddress; ?>&amp;group=notified"><?php _e('Notified Subscribers','ct_waitlist');?><strong>&nbsp(<?php echo count($this->dbEntriesNotified()) ?>)</strong></a>&nbsp|
                    <a style="text-decoration:none ; <?php if($_GET['group'] == 'mw') echo 'color:black; font-weight:bold;';  ?>" href="<?php echo $activeTabAddress; ?>&amp;group=mw">&nbsp<?php _e('Most Waitlisted Items','ct_waitlist');?></a>
                    <?php if(ctWaitlistOptions::getOption('ctWaitlist_use_postpone') == 'on') {?>
                    |<a style="text-decoration:none ; <?php if($_GET['group'] == 'queued') echo 'color:black; font-weight:bold;';  ?>" href="<?php echo $activeTabAddress; ?>&amp;group=queued">&nbsp<?php _e('Queued Notifications','ct_waitlist');?><strong>&nbsp(<?php echo count($this->dbEntriesQueued()) ?>)</strong></a>
                    <?php } ?>
                </p>
                <?php if(!isset($_GET['group']) || $_GET['group'] != 'mw'){ ?>
                <p>
                    <select name="waitlistdataaction">
                        <option value="actions"><?php _e('Actions','ct_waitlist')?></option>

                        <?php if (isset($_GET['group']) && $_GET['group'] == 'queued'){ ?>
                        <option value="send"><?php _e('Send','ct_waitlist');?></option>
                        <option value="remove"><?php _e('Remove','ct_waitlist')?></option>
                    </select>
                    <input type="submit" name="submitbtn" class="button-secondary" value="<?php  _e( 'Apply', 'ct_waitlist' )?>" />
                        <?php } else {?>
                        <option value="delete"><?php _e('Delete','ct_waitlist')?></option>
                        <option value="export"><?php _e('Export','ct_waitlist')?></option>

                    </select>
                    <input type="hidden" name="export-var" value="<?php if(isset($_GET['group']) && $_GET['group'] == 'notified') {echo '2';}else {echo '1';} ?>"/>
                    <input type="submit" name="submitbtn" class="button-secondary" value="<?php  _e( 'Apply', 'ct_waitlist' )?>" />
                    <?php } ?>
                </p>
              <?php }?>
                <table class="wp-list-table widefat fixed pages">
                    <thead>
                    <tr>
                        <?php if(isset($_GET['group']) && $_GET['group'] == 'mw') {?>
                            <th  scope="col" id="title" class="manage-column column-title sortable">
                                <a href="<?php echo $activeTabAddress; ?>&amp;sort=<?php echo $sort = isset($_GET['sort']) ? $_GET['sort'] : 'desc'; if(isset($_GET['group'])) echo '&group='.$_GET['group']; ?>&amp;sortitem=email">
                                    <span><?php _e('Subscription count','ct_waitlist');?></span>
                                </a>
                            </th>
                        <?php } else {
                            ?>
                            <th scope="col" id="cb" class="manage-column column-cb check-column" >
                                <label class="screen-reader-text" for="cb-select-all-1">Select All</label>
                                <input id="cb-select-all-1" type="checkbox">
                            </th>
                            <th scope="col" id="title" class="manage-column column-title sortable">
                                <a href="<?php echo $activeTabAddress; ?>&amp;sort=<?php echo $sort = isset($_GET['sort']) ? $_GET['sort'] : 'desc'; if(isset($_GET['group'])) echo '&group='.$_GET['group']; ?>&amp;sortitem=email">
                                    <span><?php _e('Subscriber','ct_waitlist');?></span>
                                </a>
                            </th>
                        <?php
                        } ?>
                        <th text-align="center">
                                <span style="display:table; margin:0 auto;" class="waitlist-nail"></span>
                        </th>
                        <th scope="col" id="title" class="manage-column column-title sortable">
                            <a href="<?php echo $activeTabAddress; ?>&amp;sort=<?php echo $sort = isset($_GET['sort']) ? $_GET['sort'] : 'desc'; if(isset($_GET['group'])) echo '&group='.$_GET['group']; ?>&amp;sortitem=productId">
                                <span><?php _e('Product','ct_waitlist');?></span>
                            </a>
                        </th>
                        <th scope="col" id="title" class="manage-column column-title sortable">
                            <a href="<?php echo $activeTabAddress; ?>&amp;sort=<?php echo $sort = isset($_GET['sort']) ? $_GET['sort'] : 'desc'; if(isset($_GET['group'])) echo '&group='.$_GET['group']; ?>&amp;sortitem=grouped_parentId">
                                <span><?php _e('Group','ct_waitlist');?></span>
                            </a>
                        </th>
                        <th scope="col" id="title" class="manage-column column-title sortable">
                            <a href="<?php echo $activeTabAddress; ?>&amp;sort=<?php echo $sort = isset($_GET['sort']) ? $_GET['sort'] : 'desc'; if(isset($_GET['group'])) echo '&group='.$_GET['group']; ?>&amp;sortitem=variationId">
                                <span><?php _e('Variation','ct_waitlist');?></span>
                            </a>
                        </th>
                        <th scope="col" id="title" class="manage-column column-title">
                                <span><?php _e('Category','ct_waitlist');?></span>
                        </th>
                        <th scope="col" id="title" class="manage-column column-product-type">
                            <span class="waitlist-type">
                            </span>
                        </th>

                        <?php
                        if(isset($_GET['group']) && $_GET['group'] == 'notified')
                        {
                            ?>
                            <th scope="col" id="date" class="manage-column column-date sortable ">
                                <a href="<?php echo $activeTabAddress; ?>&amp;sort=<?php echo $sort = isset($_GET['sort']) ? $_GET['sort'] : 'desc'; if(isset($_GET['group'])) echo '&group='.$_GET['group']; ?>&amp;sortitem=date">
                                    <span><?php _e('Date Notified','ct_waitlist');?></span>
                                </a>
                            </th>
                            <th scope="col" id="date" class="manage-column column-date sortable ">
                                <a href="<?php echo $activeTabAddress; ?>&amp;sort=<?php echo $sort = isset($_GET['sort']) ? $_GET['sort'] : 'desc'; if(isset($_GET['group'])) echo '&group='.$_GET['group']; ?>&amp;sortitem=date">
                                    <span><?php _e('Date Bought','ct_waitlist');?></span>
                                </a>
                            </th>
                        <?php
                        } elseif(!isset($_GET['group']) || $_GET['group'] == 'all')
                        {?>

                            <th scope="col" class="manage-column column-date sortable">
                                <a href="<?php echo $activeTabAddress; ?>&amp;sort=<?php echo $sort = isset($_GET['sort']) ? $_GET['sort'] : 'asc'; if(isset($_GET['group'])) echo '&group='.$_GET['group']; ?>&amp;sortitem=date">
                                    <span><?php _e('Date','ct_waitlist');?></span>
                            </th>
                        <?php
                        }
                        ?>
                    </tr>
                    </thead>
                    <tfoot>
                    <tr>
                        <?php if(isset($_GET['group']) && $_GET['group'] == 'mw') {?>
                            <th scope="col" style="text-align:center;" class="manage-column column-title sortable">
                                <a href="<?php echo $activeTabAddress; ?>&amp;sort=<?php echo $sort = isset($_GET['sort']) ? $_GET['sort'] : 'asc'; if(isset($_GET['group'])) echo '&group='.$_GET['group']; ?>&amp;sortitem=email">
                                    <span><?php _e('Subscription count','ct_waitlist');?></span>
                                </a>
                            </th>
                        <?php } else { ?>
                            <th scope="col" class="manage-column column-cb check-column">
                                <label class="screen-reader-text" for="cb-select-all-2">Select All</label>
                                <input id="cb-select-all-2" type="checkbox"></th>
                            <th scope="col" class="manage-column column-title sortable">
                                <a href="<?php echo $activeTabAddress; ?>&amp;sort=<?php echo $sort = isset($_GET['sort']) ? $_GET['sort'] : 'asc'; if(isset($_GET['group'])) echo '&group='.$_GET['group']; ?>&amp;sortitem=email">
                                    <span><?php _e('Subscriber','ct_waitlist');?></span>
                                </a>
                            </th>
                        <?php } ?>
                        <th text-align="center">
                            <span style="display:table; margin:0 auto;" class="waitlist-nail"></span>
                        </th>
                        <th scope="col" class="manage-column column-title sortable">
                            <a href="<?php echo $activeTabAddress; ?>&amp;sort=<?php echo $sort = isset($_GET['sort']) ? $_GET['sort'] : 'asc'; if(isset($_GET['group'])) echo '&group='.$_GET['group']; ?>&amp;sortitem=productId">
                                <span><?php _e('Product','ct_waitlist');?></span>
                            </a>
                        </th>
                        <th scope="col" class="manage-column column-title sortable">
                            <a href="<?php echo $activeTabAddress; ?>&amp;sort=<?php echo $sort = isset($_GET['sort']) ? $_GET['sort'] : 'asc'; if(isset($_GET['group'])) echo '&group='.$_GET['group']; ?>&amp;sortitem=grouped_parentId">
                                <span><?php _e('Group','ct_waitlist');?></span>
                            </a>
                        </th>
                        <th scope="col" class="manage-column column-title sortable">
                            <a href="<?php echo $activeTabAddress; ?>&amp;sort=<?php echo $sort = isset($_GET['sort']) ? $_GET['sort'] : 'asc'; if(isset($_GET['group'])) echo '&group='.$_GET['group']; ?>&amp;sortitem=variationId">
                                <span><?php _e('Variation','ct_waitlist');?></span>
                            </a>
                        </th>
                        <th scope="col" class="manage-column column-title">
                                <span><?php _e('Category','ct_waitlist');?></span>
                        </th>
                        <th scope="col" id="title" class="manage-column column-product-type">
                            <span class="waitlist-type" data-tip="Type">
                            </span>
                        </th>
                        <?php
                        if(isset($_GET['group']) && $_GET['group'] == 'notified')
                        {
                            ?>
                            <th scope="col" id="date" class="manage-column column-date sortable ">
                                <a href="<?php echo $activeTabAddress; ?>&amp;sort=<?php echo $sort = isset($_GET['sort']) ? $_GET['sort'] : 'desc'; if(isset($_GET['group'])) echo '&group='.$_GET['group']; ?>&amp;sortitem=date">
                                    <span><?php _e('Date Notified','ct_waitlist');?></span>
                                </a>
                            </th>
                            <th scope="col" id="date" class="manage-column column-date sortable ">
                                <a href="<?php echo $activeTabAddress; ?>&amp;sort=<?php echo $sort = isset($_GET['sort']) ? $_GET['sort'] : 'desc'; if(isset($_GET['group'])) echo '&group='.$_GET['group']; ?>&amp;sortitem=date">
                                    <span><?php _e('Date Bought','ct_waitlist');?></span>
                                </a>
                            </th>
                        <?php
                        } elseif(!isset($_GET['group']) || $_GET['group'] == 'all')
                        {?>

                            <th scope="col" class="manage-column column-date sortable">
                            <a href="<?php echo $activeTabAddress; ?>&amp;sort=<?php echo $sort = isset($_GET['sort']) ? $_GET['sort'] : 'asc'; if(isset($_GET['group'])) echo '&group='.$_GET['group']; ?>&amp;sortitem=date">
                                <span><?php _e('Date','ct_waitlist');?></span>
                             </th>
                        <?php
                        }
                        ?>
                    </tr>
                    </tfoot> <?php
                    if ($this->getSortResults() != ''){
                        $loop = $this->getSortResults();
                    } elseif(isset($_GET['group']) && $_GET['group'] == 'mw') {
                        $limit = 20;
                        global $wpdb;
                        $loop = $wpdb->get_results("SELECT productId, variationId, grouped_parentId, count(*) AS cnt FROM ".$wpdb->prefix.$this->getPluginDomain()." WHERE notified = 0 GROUP BY productId ORDER BY cnt DESC LIMIT ".$limit);
                    }elseif(isset($_GET['group']) && $_GET['group'] == 'notified'){
                        $loop = $this->dbEntriesNotified();
                    }elseif(isset($_GET['group']) && $_GET['group'] == 'queued') {
                        $loop = $this->dbEntriesQueued();
                    }else {
                        $loop = $this->dbEntriesToNotify();
                    }
                    foreach( $loop as $results ) {
                        ?>
                        <tr>
                            <?php if (isset($_GET['group']) && $_GET['group'] == 'mw') {?>
                                <td class="post-title page-title column-title"><strong><p style="text-align:center; margin:auto;" class="row-title"><?php echo $results->cnt;?></p></strong>
                                </td>
                            <?Php } else {?>
                                <th scope="row" class="check-column">
                                    <input type="checkbox" name="cbarray[]" value="<?php echo $results->id;?>">
                                </th>
                                <td class="post-title page-title column-title"><strong><p style="margin-top:0" class="row-title"><?php echo $results->email;?></p></strong>
                                    <div class="row-actions">
                                        <?php if(isset($_GET['group']) && $_GET['group'] == 'queued'){ ?>
                                            <span class="edit">
                                            <a href="<?php echo $activeTabAddress; ?>&amp;remove=<?php echo $results->id; if(isset($_GET['group'])) echo '&group='.$_GET['group']; ?>" title="<?php _e('Remove from queue','ct_waitlist');?>"><?php _e('Remove','ct_waitlist');?></a>&nbsp|
                                        </span>
                                         <span class="edit">
                                            <a href="<?php echo $activeTabAddress; ?>&amp;send=<?php echo $results->id; if(isset($_GET['group'])) echo '&group='.$_GET['group']; ?>" title="<?php _e('Send this email notification','ct_waitlist');?>"><?php _e('Send','ct_waitlist');?></a>
                                        </span>
                                        <?php } else {?>
                                        <span class="delete">
                                            <a href="<?php echo $activeTabAddress; ?>&amp;delete=<?php echo $results->id; if(isset($_GET['group'])) echo '&group='.$_GET['group']; ?>" title="<?php _e('Delete this subscriber','ct_waitlist');?>"><?php _e('Delete','ct_waitlist');?></a>
                                        </span>
                                        <?php } ?>
                                    </div>
                                </td>
                               <?php
                            }?>
                            <td>
                                <a href="<?Php echo esc_url(admin_url('post.php?post='.$results->productId.'&action=edit'));?>">
                                    <?php
                                    if (has_post_thumbnail( $results->productId ) ) {
                                        $image = wp_get_attachment_image_src(get_post_thumbnail_id($results->productId), 'single-post-thumbnail');
                                        $src = $image[0];
                                    } else {
                                        $src = esc_url(plugins_url('../assets/images/placeholder.png',__FILE__));
                                    }
                                    ?>
                                    <img src="<?php echo $src;?>" alt="Placeholder" width="40" height="40" style="display:table; margin:0 auto;"class="woocommerce-placeholder wp-post-image">
                                </a>
                            </td>
                            <td class="post-title page-title column-title">
                                <strong><a class="row-title" href="<?Php echo esc_url(admin_url('post.php?post='.$results->productId.'&action=edit'));?>"><?php echo get_the_title($results->productId);?></a></strong>
                            </td>
                            <td class="post-title page-title column-title">
                                <strong><a class="row-title" href="<?Php echo esc_url(admin_url('post.php?post='.$results->grouped_parentId.'&action=edit'));?>"><?php echo get_the_title($results->grouped_parentId);?></a></strong>
                            </td>
                            <td class="post-title page-title column-title">
                                <strong><p style="margin-top:0" class="row-title"><?php  $public = ctWaitlist::getInstance(); echo $public->displayVariationName($results->variationId);?></p></strong>
                            </td>
                            <td class="post-title page-title column-title">
                                <strong><?php $this->displayTerms($results->productId);?></strong>
                            </td>
                            <td class="post-title page-title column-title">
                                <span class="<?php $this->getIcon($results)?>">
                                </span>
                            </td>
                            <?php
                            if(isset($_GET['group']) && $_GET['group'] == 'notified')
                            {
                                ?>
                                <td class="date column-date">
                                    <abbr title="<?php echo $results->notified;?>"><?php echo $results->notified;?></abbr>
                                    <br><?php _e('Notified','ct_waitlist');?>
                                </td>
                                <?php
                                if($results->bought == 0){?>
                                    <td class="date column-date">
                                        <abbr
                                            title=""><?php echo ''; ?></abbr>
                                        <br>
                                    </td>
                                    <?php
                                }else {
                                    ?>
                                    <td class="date column-date">
                                        <abbr
                                            title="<?php echo $results->bought; ?>"><?php echo $results->bought; ?></abbr>
                                        <br><?php _e('Bought','ct_waitlist');?>
                                    </td>
                                <?php
                                }
                            } elseif(!isset($_GET['group']) || $_GET['group'] == 'all' ) {
                            ?>
                            <td class="date column-date">
                                <abbr title="<?php echo $results->date;?>"><?php echo $results->date;?></abbr>
                            <br><?php _e('Added','ct_waitlist');?>
                            </td>
                            <?php
                            }
                            ?>
                        </tr>
                    <?php } ?>
                </table>
                <?php if(!isset($_GET['group']) || $_GET['group'] != 'mw'){ ?>
                    <p>
                        <select name="waitlistdataaction2">
                            <option value="actions"><?php _e('Actions','ct_waitlist')?></option>
                            <?php if (isset($_GET['group']) && $_GET['group'] == 'queued'){ ?>
                            <option value="send"><?php _e('Send','ct_waitlist');?></option>
                            <option value="remove"><?php _e('Remove','ct_waitlist')?></option>
                        </select>
                        <input type="submit" name="submitbtn" class="button-secondary" value="<?php  _e( 'Apply', 'ct_waitlist' )?>" />
                        <?php } else {?>
                        <option value="delete"><?php _e('Delete','ct_waitlist')?></option>
                        <option value="export"><?php _e('Export','ct_waitlist')?></option>
                    </select>
                    <input type="hidden" name="export-var" value="<?php if(isset($_GET['group']) && $_GET['group'] == 'notified') {echo '2';}else {echo '1';} ?>"/>
                    <input type="submit" name="submitbtn" class="button-secondary" value="<?php  _e( 'Apply', 'ct_waitlist' )?>" />
                    <?php } ?>
                    </p>
                <?php }?>

            </form>
            <?php
            break;
        case 'email':
            ?>
            <div style="position:relative;float:left">
                <form method="post" action="admin-post.php">
                    <input type="hidden" name="action" value="save_ctWaitlist_options" />
                    <input type="hidden" name="tab" value="email"/>
                    <?php wp_nonce_field( 'ctWaitlist' ); ?>
                    <table class="ct-waitlist-table-options">
                        <tr>
                            <td colspan="2"><h3><?php _e('Email From Options:','ct_waitlist');?></h3></td>
                        </tr>
                        <tr>
                            <td>
                                <label for="ct-waitlist-usewoocommercefrom"><?php _e('Use Custom "From" data','ct_waitlist');?></label>
                            </td>
                            <td>
                                <input type="hidden" value="0" name="ctWaitlist_use_custom_from"/>
                                <input type="checkbox" name="ctWaitlist_use_custom_from" id="ct-waitlist-usewoocommercefrom" <?php if (ctWaitlistOptions::getOption('ctWaitlist_use_custom_from') == 'on' ) echo ' checked="checked" ';?> />
                            </td>
                        </tr>
                        <tr class="tr1" <?php if (ctWaitlistOptions::getOption('ctWaitlist_use_custom_from') != 'on' ) echo 'hidden';?>>
                            <td>
                                <label for="ctWaitlist_mail_sender_from_name"><?php _e('From Name:','ct_waitlist');?></label></td>
                            <td>
                                <input type="text" id="ctWaitlist_mail_sender_from_name" class="input-waitlist" name="ctWaitlist_mail_sender_from_name" value="<?php echo ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_name') == '' ? get_option('woocommerce_email_from_name') : ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_name');?>"/>
                            </td>
                        </tr>
                        <tr class="tr2" <?php if (ctWaitlistOptions::getOption('ctWaitlist_use_custom_from') != 'on' ) echo 'hidden';?>>
                            <td>
                                <label for="ctWaitlist_mail_sender_from_address"><?php _e('From Email Address:','ct_waitlist');?></label>
                            </td>
                            <td>
                                <input type="text" id="ctWaitlist_mail_sender_from_address" class="input-waitlist" name="ctWaitlist_mail_sender_from_address" value="<?php echo ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_address') ? get_option('woocommerce_email_from_address') : ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_address');;?>"/>
                            </td>
                        </tr>

                        <tr>
                            <td><h3><?php _e('Email Content Options:','ct_waitlist');?></h3></td>
                        </tr>
                        <tr>
                            <td><label for="ctWaitlist_mail_subject"><?php _e( '"Back in stock" Email topic:' , 'ct_waitlist' ); ?></label></td>
                            <td><input type="text" id="ctWaitlist_mail_subject" class="input-waitlist" name="ctWaitlist_mail_subject" value="<?php echo ctWaitlistOptions::getOption('ctWaitlist_mail_subject');?>"/></td>
                        </tr>
                        <tr>
                            <td>
                                <label for="ctWaitlist_back_in_stock_email_content"><?php _e('"Back in stock" Email body:','ct_waitlist');?></label>
                            </td>
                            <td>
                                <textarea rows="5" id="ctWaitlist_back_in_stock_email_content" class="input-waitlist" name="ctWaitlist_back_in_stock_email_content"><?php echo ctWaitlistOptions::getOption('ctWaitlist_back_in_stock_email_content');?></textarea>
                            </td>
                        </tr>

                        <tr>
                            <td>
                                <label for="ct-waitlist-sendsubscriptionsuccessmessage"><?php _e('Send "subscription success" email','ct_waitlist');?></label>
                            </td>
                            <td>
                                <input type="hidden" value="0" name="ctWaitlist_send_subscription_success_email"/>
                                <input type="checkbox" id="ct-waitlist-sendsubscriptionsuccessmessage" name="ctWaitlist_send_subscription_success_email" <?php if (ctWaitlistOptions::getOption('ctWaitlist_send_subscription_success_email') =='on' ) echo ' checked="checked" ';?>/>
                            </td>
                        </tr>
                        <tr class="tr4" <?php if (ctWaitlistOptions::getOption('ctWaitlist_send_subscription_success_email') != 'on' ) echo 'hidden';?>>
                            <td>
                                <label for="ctWaitlist_added_to_waitlist_email_topic"><?php _e('"Subscription success" email topic:','ct_waitlist');?></label>
                            </td>
                            <td>
                                <input type="text" id="ctWaitlist_added_to_waitlist_email_topic" class="input-waitlist" name="ctWaitlist_added_to_waitlist_email_topic" value="<?php echo ctWaitlistOptions::getOption('ctWaitlist_added_to_waitlist_email_topic');?>"/>
                            </td>
                        </tr>
                        <tr class="tr5" <?php if (ctWaitlistOptions::getOption('ctWaitlist_send_subscription_success_email') != 'on' ) echo 'hidden';?>>
                            <td>
                                <label for="ctWaitlist_added_to_waitlist_email_body"><?php _e('"Subscription success" email body:','ct_waitlist');?></label>
                            </td>
                            <td>
                                <textarea rows="5" id="ctWaitlist_added_to_waitlist_email_body" class="input-waitlist" name="ctWaitlist_added_to_waitlist_email_body"><?php echo ctWaitlistOptions::getOption('ctWaitlist_added_to_waitlist_email_body');?></textarea>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2"><h3><?php _e('Admin email options','ct_waitlist');?></h3></td>
                        </tr>
                        <tr>
                            <td><label for="ctWaitlist_admin_notifications"><?php _e( 'Send admin notification email on new subscription:' , 'ct_waitlist' ); ?></label></td>
                            <td>
                                <input type="hidden" value="0" name="ctWaitlist_admin_notifications"/>
                                <input type="checkbox" id="ctWaitlist_admin_notifications" name ="ctWaitlist_admin_notifications" <?php if (
                                    ctWaitlistOptions::getOption('ctWaitlist_admin_notifications') == 'on' ) echo ' checked="checked" ';
                                ?>/>
                            </td>
                        </tr>
                        <tr class="tr7" <?php if (ctWaitlistOptions::getOption('ctWaitlist_admin_notifications') != 'on' ) echo 'hidden';?>>
                            <td>
                                <label for="ctWaitlist_admin_topic_on_add"><?php _e('"New subscription" email topic:','ct_waitlist');?></label>
                            </td>
                            <td>
                                <input type="text" id="ctWaitlist_admin_topic_on_add" class="input-waitlist" name="ctWaitlist_admin_topic_on_add" value="<?php echo ctWaitlistOptions::getOption('ctWaitlist_admin_topic_on_add');?>"/>
                            </td>
                        </tr>
                        <tr class="tr8" <?php if (ctWaitlistOptions::getOption('ctWaitlist_admin_notifications') != 'on' ) echo 'hidden';?>>
                            <td>
                                <label for="ctWaitlist_admin_body_on_add"><?php _e('"New subscription" email body:','ct_waitlist');?></label>
                            </td>
                            <td>
                                <textarea rows="5" id="ctWaitlist_admin_body_on_add" type="text" class="input-waitlist" name="ctWaitlist_admin_body_on_add"><?php echo ctWaitlistOptions::getOption('ctWaitlist_admin_body_on_add');?></textarea>
                            </td>
                        </tr>
                        <tr>
                            <td><label for="ctWaitlist_admin_send_on_buy"><?php _e( 'Send admin notification if subscribed item has been bought:' , 'ct_waitlist' ); ?></label></td>
                            <td>
                                <input type="hidden" value="0" name="ctWaitlist_admin_send_on_buy"/>
                                <input type="checkbox" id="ctWaitlist_admin_send_on_buy" name ="ctWaitlist_admin_send_on_buy" <?php if (ctWaitlistOptions::getOption('ctWaitlist_admin_send_on_buy') == 'on' ) echo ' checked="checked" ';?>/><br/>
                            </td>
                        </tr>
                        <tr class="tr9" <?php if (ctWaitlistOptions::getOption('ctWaitlist_admin_send_on_buy') != 'on' ) echo 'hidden';?>>
                            <td>
                                <label for="ctWaitlist_admin_topic_on_buy"><?php _e('"Subscribed item has been bough" email topic:','ct_waitlist');?></label>
                            </td>
                            <td>
                                <input type="text" id="ctWaitlist_admin_topic_on_buy" class="input-waitlist" name="ctWaitlist_admin_topic_on_buy" value="<?php echo ctWaitlistOptions::getOption('ctWaitlist_admin_topic_on_buy');?>"/>
                            </td>
                        </tr>

                        <tr class="tr10" <?php if (ctWaitlistOptions::getOption('ctWaitlist_admin_send_on_buy') != 'on' ) echo 'hidden';?>>
                            <td>
                                <label for="ctWaitlist_admin_body_on_buy"><?php _e('"Subscribed item has been bough" email body:','ct_waitlist');?></label>
                            </td>
                            <td>
                                <textarea rows="5" type="text" id="ctWaitlist_admin_body_on_buy" class="input-waitlist" name="ctWaitlist_admin_body_on_buy" ><?php echo ctWaitlistOptions::getOption('ctWaitlist_admin_body_on_buy');?></textarea>
                            </td>
                        </tr>
                        <tr>
                            <td><label for="ctWaitlist_admin_send_on_notify"><?php _e( 'Send admin notification when user is getting notified:' , 'ct_waitlist' ); ?></label></td>
                            <td>
                                <input type="hidden" value="0" name="ctWaitlist_admin_send_on_notify"/>
                                <input type="checkbox" id="ctWaitlist_admin_send_on_notify" name ="ctWaitlist_admin_send_on_notify" <?php if (
                                    ctWaitlistOptions::getOption('ctWaitlist_admin_send_on_notify') == 'on' ) echo ' checked="checked" ';
                                ?>/><br/></td>
                        </tr>
                        <tr class="tr11" <?php if (ctWaitlistOptions::getOption('ctWaitlist_admin_send_on_notify') != 'on' ) echo 'hidden';?>>
                            <td>
                                <label for="ctWaitlist_admin_topic_on_notify"><?php _e('"User is getting notified" email topic:','ct_waitlist');?></label>
                            </td>
                            <td>
                                <input type="text" id="ctWaitlist_admin_topic_on_notify" class="input-waitlist" name="ctWaitlist_admin_topic_on_notify" value="<?php echo ctWaitlistOptions::getOption('ctWaitlist_admin_topic_on_notify');?>"/>
                            </td>
                        </tr>
                        <tr class="tr12" <?php if (ctWaitlistOptions::getOption('ctWaitlist_admin_send_on_notify') != 'on' ) echo 'hidden';?>>
                            <td>
                                <label for="ctWaitlist_admin_body_on_notify"><?php _e('"User is getting notified" email body:','ct_waitlist');?></label>
                            </td>
                            <td>
                                <textarea rows="5" type="text" id="ctWaitlist_admin_body_on_notify" class="input-waitlist" name="ctWaitlist_admin_body_on_notify"><?php echo ctWaitlistOptions::getOption('ctWaitlist_admin_body_on_notify');?></textarea>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                <h3><?php _e('Template Options','ct_waitlist');?></h3>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <label for="ct-waitlist-usewootemplate"><?php _e('Use WooCommerce Template:','ct_waitlist');?></label>
                            </td>
                            <td>
                                <input type="hidden" value="0" name="ctWaitlist_use_woo_template"/>
                                <input type="checkbox" id="ct-waitlist-usewootemplate" name="ctWaitlist_use_woo_template" <?php if (ctWaitlistOptions::getOption('ctWaitlist_use_woo_template') == 'on' ) echo ' checked="checked" ';?>/>
                            </td>
                        </tr>
                        <tr class="tr3" <?php if (ctWaitlistOptions::getOption('ctWaitlist_use_woo_template') != 'on' ) echo 'hidden';?>>
                            <td>
                                <label for="preview"><?php _e('Preview:','ct_waitlist');?></label>
                            </td>
                            <td>
                                <a href="<?php echo wp_nonce_url(esc_url(admin_url('?preview_woocommerce_mail=true'), 'preview-mail'))?>" id="preview" target="_blank"><?php _e('Click here to preview WooCommerce email template','ct_waitlist');?></a><br/>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                <input type="submit" value="<?php _e('Submit changes','ct_waitlist'); ?>" class="button-primary"/>
                            </td>
                        </tr>
                    </table>
                </form>
            </div>
            <div style="position:relative;float:left;">
                <table>
                    <tr>
                        <td colspan="1"><h3><?php _e('Available shortcodes to use in emails:','ct_waitlist');?></h3></td>
                    </tr>
                    <tr>
                        <td><strong>$productName$</strong></td>
                        <td><?php _e('Subscribed product name','ct_waitlist');?></td>
                    </tr>
                    <tr>
                        <td><strong>$price$</strong></td>
                        <td><?php _e('Subscibed product price (including currency symbol)','ct_waitlist');?></td>
                    </tr>
                    <tr>
                        <td><strong>$siteTitle$</strong></td>
                        <td><?php _e('Your page title','ct_waitlist');?></td>
                    </tr>
                    <tr>
                        <td><strong>$stockAmount$</strong></td>
                        <td><?php _e('Available amount in stock','ct_waitlist');?></td>
                    </tr>
                    <tr>
                        <td><strong>$productPage$</strong></td>
                        <td><?php _e('Link to the product','ct_waitlist');?></td>
                    </tr>
                    <tr>
                        <td><strong>$thumbnail$</strong></td>
                        <td><?php _e('Featured image','ct_waitlist');?></td>
                    </tr>
                    <tr>
                        <td><strong>$variation$</strong></td>
                        <td><?php _e('Variation name(s)','ct_waitlist');?></td>
                    </tr>
                    <tr>
                        <td><strong>$userEmail$</strong></td>
                        <td><?php _e('Subscriber email (available in admin emails only).','ct_waitlist');?></td>
                    </tr>

                </table>
            </div>
            <?php
            break;
        case 'disabling':
            ?>
        <form method="post" action="admin-post.php">
            <input type="hidden" name="action" value="save_ctWaitlist_options" />
            <input type="hidden" name="tab" value="disabling"/>
            <?php wp_nonce_field( 'ctWaitlist' ); ?>
            <h3><?php _e('On this page you can disable/enable Waitlist for the whole groups of products','ct_waitlist');?></h3>
            <?php  $taxonomies = get_object_taxonomies( 'product', 'objects' );
            foreach ($taxonomies as $key=>$tax){?>
                <div class="forDisableGroup">
                    <h4 class="toggleable"><?php echo $tax->labels->name;?></h4>

                    <table>
                        <?php $myterms = get_terms($key, 'orderby=none&hide_empty');?>
                        <?php foreach($myterms as $term) {?>
                            <tr>
                                <td>

                                <input type="checkbox" name="toDisable[<?php echo $key;?>][]" value="<?php echo $term->name;?>"/></td>
                                <td>
                                    <p><?php echo $term->name;?></p>
                                </td>
                            </tr>
                            <?php }?>

                        </table>
                    </div>
                <?php }?>
            <select name="disableAction">
                <option value="disable"><?php _e('Disable Waitlist','ct_waitlist') ?></option>
                <option value="enable"><?php _e('Enable Waitlist','ct_waitlist') ?></option>
            </select><br/><br/>
            <input type="submit" value="<?php _e('Submit changes','ct_waitlist'); ?>" class="button-primary"/>

        </form>
<?php





break;
    }
    ?>
</div>