<?php

/**
 * Display functions
 * @author hugo
 */
class ctCatalogDisplay
{
    public function __construct()
    {
        add_action('init', array($this, 'init'));
        add_action('admin_init', array($this, 'wpmlRegister'));
        add_action('woocommerce_after_single_variation', array($this, 'importJS'));
    }

    /**
     * returns inline JS
     * @return string
     */
    public function importJS()
    {
        global $product;
        global $post;

        if ($product) {
            (get_post_meta(get_the_id(), 'wc_catalog_mode_product_enable', true)) ? $option = get_post_meta(get_the_id(), 'wc_catalog_mode_product_enable', true) : $option = 'ct-catalog-global';

            if ($option != 'ct-catalog-disable') {
                if($this->isCatalogEnabledForCatogries($post)==true){
                    if (get_option('wc_catalog_mode_disable_catalog') == 'no') {
                        wp_register_script('ct_variable', CT_CATALOG_ASSETS . '/js/variable.js', array('jquery'), false, true);
                        wp_enqueue_script('ct_variable');
                    }
                }
            }
        }

    }


    /**
     * Init
     */
    public function init()
    {

        add_filter(
            apply_filters('ct_catalog.get_price_html', 'woocommerce_get_price_html'),
            array(
                $this,
                'hidePrice'
            )
        );
        add_action(
            apply_filters('ct_catalog.single_product_summary', 'woocommerce_single_product_summary'),
            array(
                $this,
                'constructItemButton'
            ),
            30
        );
        add_action(
            apply_filters('ct_catalog.after_shop_loop_item', 'woocommerce_after_shop_loop_item'),
            array(
                $this,
                'constructShopButton'
            ),
            1
        );

        add_action('wp_head', array($this, 'customButtonStylesDefinition'));
    }

    /**
     * Registrate the custom wpml translations
     */
    public function wpmlRegister()
    {
        if (function_exists('icl_register_string')) {
            icl_register_string(
                'plugin ct-catalog',
                'Button Label Shop',
                $this->getOption('wc_catalog_mode_custom_button_shop_text_label')
            );
            icl_register_string(
                'plugin ct-catalog',
                'Button Label Item',
                $this->getOption('wc_catalog_mode_custom_button_item_text_label')
            );
        }
    }

    /**
     * Return the WPML translation
     *
     * @param $text
     *
     * @return bool
     */
    public function wpmlTranslation($text, $source)
    {
        if (function_exists('icl_register_string')) {
            if ($source == 'item') {
                return icl_t('plugin ct-catalog', 'Button Label Item', $text);
            } elseif ($source == 'shop') {
                return icl_t('plugin ct-catalog', 'Button Label Shop', $text);
            }
        }

        return $text;
    }

    /**
     * Get the parent category settings
     * @param $cat_id
     * @return bool|null
     */
    protected function getCategoryParent($cat_id)
    {
        //Check for parent
        $array = get_ancestors($cat_id, 'product_cat');
        if (count($array) != 0) {
            $parentSetting = get_woocommerce_term_meta($array[0], 'catalog_mode', true);

            switch ($parentSetting) {

                case 'ct-category-enable':
                    return true;
                    break;
                case 'ct-category-disable':
                    return false;
                    break;
            }
        }

        return null;
    }

    /**
     * Check the categories
     * @param $post
     * @return bool|null
     */
    protected function isCatalogEnabledForCatogries($post)
    {
        $term_list = wp_get_post_terms($post->ID, 'product_cat', array('fields' => 'ids'));

        if (count($term_list) != 0) {
            $enabled = null; //null - handle it later

            foreach ($term_list as $value) {
                $cat_id = (int)$value;
                $catalog_mode = get_woocommerce_term_meta($cat_id, 'catalog_mode', true);

                switch ($catalog_mode) {
                    case 'ct-category-enable':
                        $enabled = true;
                        break;
                    case 'ct-category-disable':
                        if (!$enabled) { //not already enabled
                            $enabled = false;
                        }
                        break;

                    default:
                        $enabled = $this->getCategoryParent($cat_id);
                        break;
                }
            }
            return $enabled;
        }

        //someone else needs to handle that
        return null;
    }

    /**
     * Logic of the multiple options of catalog mode per product,global settings and categories
     * @return bool
     */
    protected function isCatalogEnabled()
    {
        global $product;
        global $post;

        if ($product) {

            (get_post_meta(get_the_id(), 'wc_catalog_mode_product_enable', true)) ? $option = get_post_meta(
                get_the_id(),
                'wc_catalog_mode_product_enable',
                true
            ) : $option = 'ct-catalog-global';

            switch ($option) {
                case 'ct-catalog-enable':
                    $this->handleActions('remove');

                    return true;
                    break;
                case 'ct-catalog-disable':
                    $this->handleActions('add');

                    return false;
                    break;
                case 'ct-catalog-disable-login':
                    if (is_user_logged_in()) {
                        $this->handleActions('add');

                        return false;
                        break;
                    }

                    return true;
                    break;
                case 'ct-catalog-global':
                    $val = $this->isCatalogEnabledForCatogries($post);

                    if ($val !== null) {
                        if ($val) {
                            $this->handleActions('remove');
                        } else {
                            $this->handleActions('add');
                        }

                        return $val;
                    }
            }

            //rest of global logic

            ($this->getOption('wc_catalog_mode_disable_catalog')) ? $disableCatalog = $this->getOption(
                'wc_catalog_mode_disable_catalog'
            ) : $disableCatalog = 'no';
            ($this->getOption('wc_catalog_mode_user_only')) ? $toLoginUsers = $this->getOption(
                'wc_catalog_mode_user_only'
            ) : $toLoginUsers = 'no';

            if ($disableCatalog == 'yes') {
                $this->handleActions('add');

                return false;
            } elseif ($toLoginUsers == 'yes' && is_user_logged_in()) {
                $this->handleActions('add');

                return false;
            }
            $this->handleActions('remove');

            return true;

        }


    }

    /**
     * Handle hooks action
     *
     * @param $action
     *
     * @return mixed|void
     */

    protected function handleActions($action)
    {
        global $product;
        if ($action == 'add') {
            //change filter to custom one if we need it

            if (!apply_filters('ct_catalog.product.shop.action.add_to_cart', false)) {
                add_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
            }
            if (!apply_filters('ct_catalog.product.item.action.add_to_cart', false)) {
                add_action('woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30);
            }

        } elseif ($action == 'remove') {
            if (!$product->is_type('variable')) {
                ctCatalogPlugin::removeAddToCartButton();
            }
        }
    }

    /**
     * Get option
     *
     * @param $name
     *
     * @return mixed|void
     */

    protected function getOption($name)
    {
        $v = get_option($name);

        return apply_filters('ct_catalog.option.get', $v, $name);
    }

    /**
     * function to hide the price
     *
     * @param $price
     *
     * @return string
     */
    function hidePrice($price)
    {
        /** @var $product WC_Product */
        global $product;
        if (is_object($product)) {
            if ($product->is_type('variable') == true) {
                $this->handleActions('add');
            }
        }

        if (!$this->isCatalogEnabled()) {
            return $price;
        }

        //Check the Settings options
        $option = apply_filters('ct_catalog.price.enable', $this->getOption('wc_price_tag'), $price);
        ($option) ? $option = apply_filters(
            'ct_catalog.price.enable',
            $this->getOption('wc_price_tag'),
            $price
        ) : $option = 'yes';

        $optionUser = apply_filters('ct_catalog.price.enable.user', $this->getOption('wc_price_tag_user'), $price);
        ($optionUser) ? $optionUser = apply_filters(
            'ct_catalog.price.enable.user',
            $this->getOption('wc_price_tag_user'),
            $price
        ) : $optionnor = 'yes';

        if ($optionUser == 'yes' && !is_user_logged_in()) {
            return "";
        }

        if ($option == 'yes') {
            return "";
        }

        return $price;
    }

    /**
     * @echo string
     * construct the custom button on product summary with the user options
     *
     * @param string $html
     *
     * @return string
     */
    function constructItemButton($html = '')
    {
        if (!$this->isCatalogEnabled()) {
            return $html;
        }

        $id = "custom_button_item_";
        //Button Value
        $buttonEnabled = $this->getOption('wc_enable_' . $id);

        $buttonTextSetting = $this->getOption('wc_catalog_mode_' . $id . 'text_label');
        $buttonText = $this->wpmlTranslation($buttonTextSetting, 'item');


        $buttonLabelText = __("Default", "ct-cgm");
        if (isset($buttonText) && $buttonText != "" && $buttonText != null) {
            $buttonLabelText = $buttonText;
        }

        //Button URL Value
        $urlText = $this->getOption('wc_catalog_mode_' . $id . 'url_definition');

        ($this->getOption(
                'wc_catalog_mode_' . $id . 'url_new_tab'
            ) == 'yes') ? $urlTarget = 'target="_blank"' : $urlTarget = 'target="_self"';


        $urlTargetFinal = "";
        $urlFinal = '';
        if ($urlText != "") {

            /** @var $product WC_Product */
            global $product;

            $urlTargetFinal = $urlTarget;
            $urlFinal = $urlText;

            //parse custom attributes
            if ($product) {
                $urlFinal = strtr(
                    $urlFinal,
                    array(
                        '{PRODUCT_NAME}' => $product->get_formatted_name(),
                        '{PRODUCT_ID}' => $product->id,
                        '{PRODUCT_URL}' => $product->get_permalink(),
                        '{PRODUCT_PRICE}' => $product->get_price(),
                    )
                );
            }

            //custom URL filter
            $urlFinal = apply_filters('ct_catalog.button.url', $urlFinal, $product);
        }

        if ($buttonEnabled == "yes") {
            if ($this->getOption('wc_catalog_mode_' . $id . 'style') == 'ct-style-woo') {
                $chosenStyle = apply_filters(
                        'ct.catalog.wooclass.item',
                        'single_add_to_cart_button button alt wooDefault ' . $id
                    ) . ' ' . $this->getOption('wc_catalog_mode_' . $id . 'class');
            } else {
                $chosenStyle = "ct-custom-click click-link-btn " . $id . ' ' . $this->getOption(
                        'wc_catalog_mode_' . $id . 'class'
                    );

                if ($this->getOption('wc_catalog_mode_' . $id . 'style') != 'ct-style-none') {
                    $chosenStyle = $this->getOption('wc_catalog_mode_' . $id . 'style');
                    $chosenStyle .= ' ' . $id;
                    $chosenStyle .= ' ' . $this->getOption('wc_catalog_mode_' . $id . 'class');
                } else {

                }
            }

            $returnData = '<p class="cart"><a class="' . $chosenStyle . '" href="' . $urlFinal . '" ' . $urlTargetFinal . '>' .
                $buttonLabelText . '</a></p>';

            echo $returnData;
        }
    }

    /**
     * @echo string
     * construct the custom button on product summary with the user options
     *
     * @param string $html
     *
     * @return string
     */
    function constructShopButton($html = '')
    {
        if (!$this->isCatalogEnabled()) {
            return $html;
        }

        $id = "custom_button_shop_";
        //Button Value
        $buttonEnabled = $this->getOption('wc_enable_' . $id);

        $buttonTextSetting = $this->getOption('wc_catalog_mode_' . $id . 'text_label');

        $buttonText = $this->wpmlTranslation($buttonTextSetting, 'shop');


        $buttonLabelText = __("Default", "ct-cgm");
        if (isset($buttonText) && $buttonText != "" && $buttonText != null) {
            $buttonLabelText = $buttonText;
        }

        //Button URL Value
        $urlText = $this->getOption('wc_catalog_mode_' . $id . 'url_definition');

        ($this->getOption(
                'wc_catalog_mode_' . $id . 'url_new_tab'
            ) == 'yes') ? $urlTarget = 'target="_blank"' : $urlTarget = 'target="_self"';


        $urlTargetFinal = "";
        $urlFinal = '';
        if ($urlText != "") {

            /** @var $product WC_Product */
            global $product;

            $urlFinal = $urlText;

            //parse custom attributes
            if ($product) {
                $urlFinal = strtr(
                    $urlFinal,
                    array(
                        '{PRODUCT_NAME}' => $product->get_formatted_name(),
                        '{PRODUCT_ID}' => $product->id,
                        '{PRODUCT_URL}' => $product->get_permalink(),
                        '{PRODUCT_PRICE}' => $product->get_price(),
                    )
                );
            }

            //custom URL filter
            $urlFinal = apply_filters('ct_catalog.button.url', $urlFinal, $product);
        }


        if ($buttonEnabled == "yes") {

            if ($this->getOption('wc_catalog_mode_' . $id . 'style') == 'ct-style-woo') {
                $chosenStyle = apply_filters(
                        'ct.catalog.wooclass',
                        'button add_to_cart_button wooDefault small ' . $id
                    ) . ' ' . $this->getOption('wc_catalog_mode_' . $id . 'class');
            } else {
                $chosenStyle = "ct-custom-click click-link-btn small " . $id . ' ' . $this->getOption(
                        'wc_catalog_mode_' . $id . 'class'
                    );
                if ($this->getOption('wc_catalog_mode_' . $id . 'style') != 'ct-style-none') {
                    $chosenStyle = $this->getOption('wc_catalog_mode_' . $id . 'style');
                    $chosenStyle .= ' small ' . $id;
                    $chosenStyle .= ' ' . $this->getOption('wc_catalog_mode_' . $id . 'class');
                }
            }

            $returnData = '<a class="' . $chosenStyle . '"
                  href="' . $urlFinal . '" ' . $urlTargetFinal . '>' . $buttonLabelText . '</a>';

            echo $returnData;
        }

    }

    /**
     * add custom button styles
     */
    function customButtonStylesDefinition()
    {

        $idArray = array("custom_button_item_", "custom_button_shop_");

        foreach ($idArray as $value) {
            $buttonStatus = $this->getOption('wc_enable_' . $value);
            if ($buttonStatus == 'yes') {
                // Get margin settings
                $margins = array_map('esc_attr', (array)$this->getOption('wc_catalog_mode_' . $value . 'margins'));

                $btmTop = $margins[$value . 'mtop'];

                $btmBottom = $margins[$value . 'mbottom'];

                $btmRight = $margins[$value . 'mright'];

                $btmLeft = $margins[$value . 'mleft'];

                // Get paddings settings
                $paddings = array_map('esc_attr', (array)$this->getOption('wc_catalog_mode_' . $value . 'paddings'));

                $btpTop = $paddings[$value . 'ptop'];

                $btpBottom = $paddings[$value . 'pbottom'];

                $btpRight = $paddings[$value . 'pright'];

                $btpLeft = $paddings[$value . 'pleft'];

                // Get Border settings
                $customBorder = array_map('esc_attr', (array)$this->getOption('wc_catalog_mode_' . $value . 'border'));

                $btnThicknessValue = $customBorder[$value . 'borderThickness'];

                $btnRadiusValue = $customBorder[$value . 'borderRadius'];


                // Get Box Shadow settings
                $boxShadow = array_map('esc_attr', (array)$this->getOption('wc_catalog_mode_' . $value . 'box_shadow'));

                $hboxshadow = $boxShadow[$value . 'hboxshadow'];

                $vboxshadow = $boxShadow[$value . 'vboxshadow'];

                $bboxshadow = $boxShadow[$value . 'bboxshadow'];

                $sboxshadow = $boxShadow[$value . 'sboxshadow'];

                $cboxshadow = $boxShadow[$value . 'cboxshadow'];

                // Get color settings
                $colors = array_map('esc_attr', (array)$this->getOption('wc_catalog_mode_' . $value . 'button_colors'));

                //Background Color
                $btnBgClr = $colors[$value . 'backg'];

                //Background Color on Hover
                $btnBgClrHover = $colors[$value . 'mouse_ovr'];

                //Text Color
                $btnTxtClr = $colors[$value . 'text'];

                //Text Color on Hover
                $btnTxtClrHover = $colors[$value . 'text_mouse'];

                //Border Color
                $btnBorderClr = $colors[$value . 'border'];

                //Border Color on Hover
                $btnBorderClrHover = $colors[$value . 'border_mouse'];

                $this->makeStyle(
                    $btmTop,
                    $btmRight,
                    $btmBottom,
                    $btmLeft,
                    $btpTop,
                    $btpRight,
                    $btpBottom,
                    $btpLeft,
                    $hboxshadow,
                    $vboxshadow,
                    $bboxshadow,
                    $sboxshadow,
                    $cboxshadow,
                    $btnThicknessValue,
                    $btnBorderClr,
                    $btnRadiusValue,
                    $btnBgClr,
                    $btnTxtClr,
                    $btnBgClrHover,
                    $btnTxtClrHover,
                    $btnBorderClrHover,
                    $value
                );
            }
        }
    }

    /**
     * @param $btmTop
     * @param $btmRight
     * @param $btmBottom
     * @param $btmLeft
     * @param $btpTop
     * @param $btpRight
     * @param $btpBottom
     * @param $btpLeft
     * @param $hboxshadow
     * @param $vboxshadow
     * @param $bboxshadow
     * @param $sboxshadow
     * @param $cboxshadow
     * @param $btnThicknessValue
     * @param $btnBorderClr
     * @param $btnRadiusValue
     * @param $btnBgClr
     * @param $btnTxtClr
     * @param $btnBgClrHover
     * @param $btnTxtClrHover
     * @param $btnBorderClrHover
     * @param $value
     */
    function makeStyle(
        $btmTop,
        $btmRight,
        $btmBottom,
        $btmLeft,
        $btpTop,
        $btpRight,
        $btpBottom,
        $btpLeft,
        $hboxshadow,
        $vboxshadow,
        $bboxshadow,
        $sboxshadow,
        $cboxshadow,
        $btnThicknessValue,
        $btnBorderClr,
        $btnRadiusValue,
        $btnBgClr,
        $btnTxtClr,
        $btnBgClrHover,
        $btnTxtClrHover,
        $btnBorderClrHover,
        $value
    ) {

        $selectedStyle = $this->getOption('wc_catalog_mode_' . $value . 'style');

        //check if is custom button or defaults
        if ($template = $this->getTemplate($selectedStyle)) {
            ob_start();
            require $template;
            $content = ob_get_contents();
            ob_end_clean();
            echo $this->minify($content);

        } else {
            //apply default filter
            $default = apply_filters(
                'ct_catalog.css_template.default',
                dirname(__FILE__) . '/styles/custom.php',
                $selectedStyle
            );

            ob_start();
            require $default;
            $content = ob_get_contents();
            ob_end_clean();
            echo $this->minify($content);

        }
    }

    /**
     * Minify the Css inline output
     *
     * @param $content
     *
     * @return mixed
     */
    protected function minify($content)
    {
        if (apply_filters('ct_catalog.css.minify', true)) {


            //preg replaces
            // Remove comments
            $content = preg_replace('!/\*[^*]*\*+([^/][^*]*\*+)*/!', '', $content);

            // Remove space after colons
            $content = str_replace(': ', ':', $content);

            // Remove whitespace
            $content = str_replace(array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $content);
        }

        return $content;
    }


    /**
     * @param $t
     *
     * @return string Get the correct template
     */
    function getTemplate($t)
    {
        switch ($t) {

            case 'ct-style-woo':
                $template = dirname(__FILE__) . '/styles/woo.php';
                break;
            case 'ct-style-flat':
                $template = dirname(__FILE__) . '/styles/flat.php';
                break;
            case 'ct-style-slick':
                $template = dirname(__FILE__) . '/styles/slick.php';
                break;
            case 'ct-style-minimalistic':
                $template = dirname(__FILE__) . '/styles/minimalistic.php';
                break;
            case 'ct-style-volume':
                $template = dirname(__FILE__) . '/styles/volume.php';
                break;
            case 'ct-style-basic':
                $template = dirname(__FILE__) . '/styles/basic.php';
                break;
            case 'ct-style-solid':
                $template = dirname(__FILE__) . '/styles/solid.php';
                break;
            case 'ct-style-rounded':
                $template = dirname(__FILE__) . '/styles/rounded.php';
                break;
            default:
                $template = dirname(__FILE__) . '/styles/custom.php';
                break;
        }

        return apply_filters('ct_catalog.css_template', $template, $t);
    }


}

new ctCatalogDisplay();