<?php

/**
 * Plugin Name: createIT Catalog Plugin
 * Plugin URI: http://createit.pl
 * Description: Catalog mode for WooCommerce
 * Version: 1.6
 * Author: createIT
 * Author URI: http://createit.pl
 */
class ctCatalogPlugin
{

    public function __construct()
    {

        add_action('init', array($this, 'removeAddButton'));
        add_action('admin_init', array($this, 'activationWooCommerceCheck'));
        add_action('admin_enqueue_scripts', array($this, 'registerAdminAssets'));

        $this->setupConsts();
        $this->loadFiles();
    }


    /**
     * Remove the add to cart option
     */
    public function removeAddButton()
    {

        if (self::hasWooCommerce()) {
            (get_option('wc_catalog_mode_disable_catalog')) ? $disableCatalog = get_option(
                'wc_catalog_mode_disable_catalog'
            ) : $disableCatalog = 'no';
            (get_option('wc_catalog_mode_user_only')) ? $toLoginUsers = get_option(
                'wc_catalog_mode_user_only'
            ) : $toLoginUsers = 'no';

            if ($disableCatalog == 'no') {
                if ($toLoginUsers == 'no') {
                    $this->handleActions();
                } elseif (!is_user_logged_in()) {
                    $this->handleActions();
                }
            }
        }
    }

    public static function removeAddToCartButton()
    {
        if (!apply_filters('ct_catalog.product.shop.remove.add_to_cart', false)) {
            remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
        }
        if (!apply_filters('ct_catalog.product.item.remove.add_to_cart', false)) {
            remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30);
        }

    }

    /**
     * Handle hooks action
     *
     * @return mixed|void
     */

    protected function handleActions()
    {
        self::removeAddToCartButton();

        remove_action('woo_nav_after', 'wootique_cart_button', 10);
        remove_action('woo_nav_after', 'wootique_checkout_button', 20);
    }


    /**
     * WooCommmerce Active?
     * @return bool
     */

    public static function hasWooCommerce()
    {
        return class_exists('WooCommerce');
    }

    /**
     * Check if we have WooCommerce
     */

    public function activationWooCommerceCheck()
    {

        if (!self::hasWooCommerce()) {
            add_action('admin_notices', array($this, 'showWooCommerceNotice'));
        }
    }

    public function showWooCommerceNotice()
    {
        echo '<div class="ct-notice error">
                	<p><strong>' . __('createIT Catalog Plugin', 'ct-cgm') . '</strong> &#8211; ' . __(
                'WooCommerce Plugin must be installed and activated in order to use this plugin.',
                'ct-cgm'
            ) . '</p>
                </div>';
    }

    /**
     * Add assets for admin
     */

    public function registerAdminAssets($hook)
    {
        wp_enqueue_style('jquery_edittable_css', CT_CATALOG_ASSETS . 'css/jquery.edittable.min.css');
        wp_enqueue_script('jquery_edittable_js', CT_CATALOG_ASSETS . 'js/jquery.edittable.min.js', array('jquery'));
        wp_enqueue_style('ct_catalog_admin_style', CT_CATALOG_ASSETS . 'css/admin.css');
        wp_enqueue_script(
            'ct.cgm.admin.js',
            CT_CATALOG_ASSETS . 'js/ct.cgm.admin.js',
            array(
                'jquery'
            )
        );
    }

    /**
     * Load files
     */

    protected function loadFiles()
    {
        require_once dirname(__FILE__) . '/ctCatalogSettings.php';
        require_once dirname(__FILE__) . '/ctCatalogDisplay.php';
    }

    /**
     * Setup constants
     */
    protected function setupConsts()
    {
        define('CT_CATALOG_DIR', untrailingslashit(plugin_dir_path(__FILE__)));
        define('CT_CATALOG_URI', WP_PLUGIN_URL . '/' . basename(dirname(__FILE__)));
        define('CT_CATALOG_ASSETS', CT_CATALOG_URI . '/assets/');
    }
}

new ctCatalogPlugin();