<?php

/**
 * Adds the Woocommerce settings tab
 * @author hugo
 */
class ctCatalogSettings
{

    /**
     * Inits object
     */

    public function __construct()
    {
        add_filter('woocommerce_settings_tabs_array', array($this, 'addSettingsTab'), 91);
        add_action('woocommerce_settings_tabs_catalog_mode_tab', array($this, 'settingsTab'));
        add_action('woocommerce_update_options_catalog_mode_tab', array($this, 'updateSettings'));
        add_action('woocommerce_settings_save_catalog_mode_tab', array($this, 'save'));

        //Add catalog setting to wp - admin General tab
        add_action('woocommerce_product_options_general_product_data', array($this, 'addCustomGeneralFields'));
        add_action('woocommerce_process_product_meta', array($this, 'saveCustomGeneralFields'));

        //Add catalog setting to product categories
        add_action('product_cat_add_form_fields', array($this, 'ct_category_add_new_meta_field'));
        add_action('product_cat_edit_form_fields', array($this, 'ct_category_edit_meta_field'), 10, 2);
        add_action('edited_product_cat', array($this, 'ct_category_save_custom_meta'), 10, 3);
        add_action('create_product_cat', array($this, 'ct_category_save_custom_meta'), 10, 3);


        //Styles item Button
        add_action('woocommerce_admin_field_custom_button_item_margin', array(
            $this,
            'custom_button_item_margin_setting'
        ));
        add_action('woocommerce_admin_field_custom_button_item_paddings', array(
            $this,
            'custom_button_item_padding_setting'
        ));
        add_action('woocommerce_admin_field_custom_button_item_border', array(
            $this,
            'custom_button_item_border_setting'
        ));
        add_action('woocommerce_admin_field_custom_button_item_box_shadow', array(
            $this,
            'custom_button_item_box_shadow_setting'
        ));
        add_action('woocommerce_admin_field_custom_button_item_color', array(
            $this,
            'custom_button_item_color_setting'
        ));

        //TITLE
        add_action('woocommerce_admin_field_custom_button_item_title', array($this, 'setTheTitleItem'));
        add_action('woocommerce_admin_field_custom_button_shop_title', array($this, 'setTheTitleShop'));

        //Styles shop Button
        add_action('woocommerce_admin_field_custom_button_shop_margin', array(
            $this,
            'custom_button_shop_margin_setting'
        ));
        add_action('woocommerce_admin_field_custom_button_shop_paddings', array(
            $this,
            'custom_button_shop_padding_setting'
        ));
        add_action('woocommerce_admin_field_custom_button_shop_border', array(
            $this,
            'custom_button_shop_border_setting'
        ));
        add_action('woocommerce_admin_field_custom_button_shop_box_shadow', array(
            $this,
            'custom_button_shop_box_shadow_setting'
        ));
        add_action('woocommerce_admin_field_custom_button_shop_color', array(
            $this,
            'custom_button_shop_color_setting'
        ));


    }

    /**
     * Add custom fields to product general settings
     */
    function addCustomGeneralFields()
    {

        echo '<div class="options_group">';

        woocommerce_wp_select(
            array(
                'label' => __('Catalog Mode', 'ct-cgm'),
                'desc_tip' => 'true',
                'description' => __('Select the Catalog mode Option', 'ct-cgm'),
                'id' => 'wc_catalog_mode_product_enable',
                'default' => 'ct-catalog-global',
                'std' => 'ct-catalog-global',
                'options' => array(
                    'ct-catalog-global' => __('Use Global Settings', 'ct-cgm'),
                    'ct-catalog-enable' => __('Enable', 'ct-cgm'),
                    'ct-catalog-disable' => __('Disable', 'ct-cgm'),
                    'ct-catalog-disable-login' => __('Disable for logged in Users', 'ct-cgm')
                )
            )
        );

        echo '</div>';

    }

    /**
     * save custom fields to product general settings
     */
    function saveCustomGeneralFields($post_id)
    {
        $catalog_mode_select = $_POST['wc_catalog_mode_product_enable'];
        update_post_meta($post_id, 'wc_catalog_mode_product_enable', esc_attr($catalog_mode_select));
    }

    /**
     * Set the Title on item category
     */
    function setTheTitleItem()
    {

        echo '<td class="ct-title" colspan="2"><h3 class="custom_button_item_group">Item Button Styles</h3><p>This category will let you change the button styles of the single item area</p></td>';

    }

    /**
     * Set the Title on shop category
     */
    function setTheTitleShop()
    {

        echo '<td class="ct-title" colspan="2"><h3 class="custom_button_shop_group">Shop Button Styles</h3><p>This category will let you change the button styles of the shop area</p></td>';

    }

    /**
     * Add new field to Categories settings
     */
    function ct_category_add_new_meta_field()
    {
        ?>
        <div class="form-field">
            <label for="catalog_mode"><?php _e('Catalog Mode', 'ct-cgm'); ?></label>
            <select id="catalog_mode" name="catalog_mode" class="postform">
                <option value="ct-category-global"><?php _e('Use Global Settings', 'ct-cgm'); ?></option>
                <option value="ct-category-enable"><?php _e('Enable', 'ct-cgm'); ?></option>
                <option value="ct-category-disable"><?php _e('Disable', 'ct-cgm'); ?></option>
            </select>
        </div>
    <?php
    }

    /**
     * Edit new field in Categories settings
     * @param $term
     */
    function ct_category_edit_meta_field($term)
    {
        $catalog_mode = get_woocommerce_term_meta($term->term_id, 'catalog_mode', true);

        $parent = $term->parent;

        ?>
        <tr class="form-field">
            <th scope="row" valign="top"><label><?php _e('Catalog Mode', 'ct-cgm'); ?></label></th>
            <td>
                <select id="catalog_mode" name="catalog_mode" class="postform">

                    <?php if ($parent != 0) { ?>
                        <option
                            value="ct-category-global" <?php selected('ct-category-global', $catalog_mode); ?>><?php _e('Use Parent Settings', 'ct-cgm'); ?></option>
                    <?php } else { ?>
                        <option
                            value="ct-category-global" <?php selected('ct-category-global', $catalog_mode); ?>><?php _e('Use Global Settings', 'ct-cgm'); ?></option>
                    <?php } ?>
                    <option
                        value="ct-category-enable" <?php selected('ct-category-enable', $catalog_mode); ?>><?php _e('Enable', 'ct-cgm'); ?></option>
                    <option
                        value="ct-category-disable" <?php selected('ct-category-disable', $catalog_mode); ?>><?php _e('Disable', 'ct-cgm'); ?></option>
                </select>
            </td>
        </tr>
    <?php
    }

    /**
     * Save new field in Categories settings
     * @param $term_id
     */
    function ct_category_save_custom_meta($term_id)
    {
        if (isset($_POST['catalog_mode'])) {
            update_woocommerce_term_meta($term_id, 'catalog_mode', esc_attr($_POST['catalog_mode']));
        }
    }

    /**
     * Adds tab
     *
     * @param $settings_tabs
     *
     * @return mixed
     */

    public function addSettingsTab($settings_tabs)
    {
        $settings_tabs['catalog_mode_tab'] = __('Catalog Mode', 'ct-cgm');

        return $settings_tabs;
    }

    /**
     * Adds fields
     */

    function settingsTab()
    {
        woocommerce_admin_fields($this->getSettings());
    }

    protected function getButtonSettings($id)
    {

        return array(
            array(
                'id' => 'wc_catalog_mode_' . $id . 'styles_title',
                'type' => 'title',
            ),
            array(
                'id' => 'wc_catalog_mode_' . $id . '_title',
                'type' => $id . 'title'
            ),
            array(
                'name' => __('Text Label', 'ct-cgm'),
                'id' => 'wc_catalog_mode_' . $id . 'text_label',
                'type' => 'text',
                'desc' => __('Text label from custom button', 'ct-cgm'),
                'class' => '' . $id . 'group',
                'default' => 'Info'
            ),
            array(
                'name' => __('URL', 'ct-cgm'),
                'id' => 'wc_catalog_mode_' . $id . 'url_definition',
                'type' => 'text',
                'desc' => __('URL for the custom Button, please enter http:// if you want to link an external website (e.g, http://www.createit.pl)', 'ct-cgm'),
                'class' => '' . $id . 'group',
                'css' => 'min-width:400px',
                'default' => '{PRODUCT_URL}'
            ),
            array(
                'name' => __('Open in a New Tab', 'ct-cgm'),
                'id' => 'wc_catalog_mode_' . $id . 'url_new_tab',
                'type' => 'checkbox',
                'desc' => __('Check this field to open the defined URL in a new tab', 'ct-cgm'),
                'custom_attributes' => array('class' => '' . $id . 'group')
            ),
            array(
                'name' => __('Button Style', 'ct-cgm'),
                'desc' => __('Chose the style of the button, Note : Woocommerce Default only supports margins, paddings and custom class', 'ct-cgm'),
                'id' => 'wc_catalog_mode_' . $id . 'style',
                'type' => 'select',
                'class' => 'chosen_select ' . $id . 'group',
                'std' => 'ct-style-woo',
                'default' => 'ct-style-woo',
                //custom filter
                'options' => apply_filters('ct_catalog.css_template.styles', array(
                    'ct-style-woo' => __('Woocommerce Default', 'ct-cgm'),
                    'ct-style-none' => __('Custom Style', 'ct-cgm'),
                    'ct-style-flat' => __('Flat', 'ct-cgm'),
                    'ct-style-slick' => __('Slick', 'ct-cgm'),
                    'ct-style-minimalistic' => __('Minimalistic', 'ct-cgm'),
                    'ct-style-volume' => __('Volume', 'ct-cgm'),
                    'ct-style-solid' => __('Solid', 'ct-cgm'),
                    'ct-style-basic' => __('Basic', 'ct-cgm'),
                    'ct-style-rounded' => __('Rounded', 'ct-cgm')
                ), $id),
            ),
            array(
                'name' => __('Colors', 'ct-cgm'),
                'id' => 'wc_catalog_mode_' . $id . 'colors',
                'type' => '' . $id . 'color'
            ),
            array(
                'name' => __('Margins', 'ct-cgm'),
                'id' => 'wc_catalog_mode_' . $id . 'margins',
                'type' => '' . $id . 'margin'
            ),
            array(
                'name' => __('Paddings', 'ct-cgm'),
                'id' => 'wc_catalog_mode_' . $id . 'paddings',
                'type' => '' . $id . 'paddings'
            ),
            array(
                'name' => __('Border', 'ct-cgm'),
                'id' => 'wc_catalog_mode_' . $id . 'border',
                'type' => '' . $id . 'border'
            ),
            array(
                'name' => __('Box Shadow', 'ct-cgm'),
                'id' => 'wc_catalog_mode_' . $id . '_box_shadow',
                'type' => '' . $id . 'box_shadow'
            ),
            array(
                'name' => __('Custom Class', 'ct-cgm'),
                'id' => 'wc_catalog_mode_' . $id . 'class',
                'type' => 'text',
                'desc' => __('Insert a custom class', 'ct-cgm'),
                'class' => '' . $id . 'group',
                'css' => 'min-width:400px'
            ),
            array(
                'type' => 'sectionend',
                'id' => 'wc_catalog_mode_tab_' . $id . 'color_section_title'
            )

        );
    }

    function getSettings()
    {
        $settings = array(
            'section_title' => array(
                'name' => __('Basic Settings', 'ct-cgm'),
                'type' => 'title',
                'id' => 'wc_catalog_mode_tab_basic_section_title',
                'desc' => __('The following options affect the main settings used in the catalog mode', 'ct-cgm')
            ),
            array(
                'name' => __('Disable Catalog Mode', 'ct-cgm'),
                'desc' => __('Check this field if you want to keep catalog mode disabled.', 'ct-cgm'),
                'id' => 'wc_catalog_mode_disable_catalog',
                'type' => 'checkbox',
                'default' => 'no'
            ),
            array(
                'name' => __('Disable for logged in users', 'ct-cgm'),
                'desc' => __('Check this field if you want to disable catalog mode for logged in users.', 'ct-cgm'),
                'id' => 'wc_catalog_mode_user_only',
                'type' => 'checkbox',
                'default' => 'no'
            ),
            array(
                'name' => __('Remove price tag from site', 'ct-cgm'),
                'desc' => __('Check this field if you want to hide price tag from all products.', 'ct-cgm'),
                'id' => 'wc_price_tag',
                'type' => 'checkbox',
                'default' => 'yes'
            ),
            array(
                'name' => __('Remove price tag from not logged in users', 'ct-cgm'),
                'desc' => __('Check this field if you want to hide price tag from not logged in users.', 'ct-cgm'),
                'id' => 'wc_price_tag_user',
                'type' => 'checkbox',
                'default' => 'no'
            ),
            array(
                'name' => __('Create item list button', 'ct-cgm'),
                'desc' => __('Check this field if you want create a custom button.', 'ct-cgm'),
                'id' => 'wc_enable_custom_button_item_',
                'type' => 'checkbox',
                'custom_attributes' => array('data-toggle' => 'custom_button_item_group'),
                'default' => 'no'
            ),
            array(
                'name' => __('Create shop button', 'ct-cgm'),
                'desc' => __('Check this field if you want create a custom button.', 'ct-cgm'),
                'id' => 'wc_enable_custom_button_shop_',
                'type' => 'checkbox',
                'custom_attributes' => array('data-toggle' => 'custom_button_shop_group'),
                'default' => 'no'
            ),
            'section_end' => array(
                'type' => 'sectionend',
                'id' => 'wc_catalog_tab_custom_button_item_basic_section_end'
            ),
        );

        $settings = array_merge($settings, $this->getButtonSettings('custom_button_item_'));
        $settings = array_merge($settings, $this->getButtonSettings('custom_button_shop_'));

        return apply_filters('wc_size_guide_tab_settings', $settings);
    }

    function updateSettings()
    {
        woocommerce_update_options($this->getSettings());
    }

    //************************************
    //ITEM LIST BUTTON STYLES
    //************************************
    /**
     * Output the frontend box shadow settings.
     */
    public function custom_button_item_box_shadow_setting()
    {
        $id = 'custom_button_item_';
        ?>
        <tr valign="top" class="ct_custom_box_shadow">
        <th scope="row" class="titledesc">
            <?php _e('Box Shadow', 'ct-cgm'); ?>
        </th>
        <td class="forminp"><?php

            // Get settings
            $boxShadow = array_map('esc_attr', (array)get_option('wc_catalog_mode_' . $id . 'box_shadow'));

            // Defaults
            if (empty($boxShadow[$id . 'hboxshadow'])) {
                $boxShadow[$id . 'hboxshadow'] = '0';
            }
            if (empty($boxShadow[$id . 'vboxshadow'])) {
                $boxShadow[$id . 'vboxshadow'] = '0';
            }
            if (empty($boxShadow[$id . 'bboxshadow'])) {
                $boxShadow[$id . 'bboxshadow'] = '0';
            }
            if (empty($boxShadow[$id . 'sboxshadow'])) {
                $boxShadow[$id . 'sboxshadow'] = '0';
            }
            if (empty($boxShadow[$id . 'cboxshadow'])) {
                $boxShadow[$id . 'cboxshadow'] = '';
            }

            // Show inputs
            $this->style_picker(__('H. Shadow', 'ct-cgm'), 'ct_css_' . $id . 'hboxshadow', $boxShadow[$id . 'hboxshadow'], __('The position of the horizontal shadow.', 'ct-cgm'), 'custom_button_item_');
            $this->style_picker(__('V. Shadow', 'ct-cgm'), 'ct_css_' . $id . 'vboxshadow', $boxShadow[$id . 'vboxshadow'], __('The position of the vertical shadow.', 'ct-cgm'), 'custom_button_item_');
            $this->style_picker(__('Blur', 'ct-cgm'), 'ct_css_' . $id . 'bboxshadow', $boxShadow[$id . 'bboxshadow'], __('The blur distance', 'ct-cgm'), 'custom_button_item_');
            $this->style_picker(__('Spread', 'ct-cgm'), 'ct_css_' . $id . 'sboxshadow', $boxShadow[$id . 'sboxshadow'], __('The size of shadow', 'ct-cgm'), 'custom_button_item_');
            $this->color_picker(__('Color', 'ct-cgm'), 'ct_css_' . $id . 'cboxshadow', $boxShadow[$id . 'cboxshadow'], __('The color of the shadow', 'ct-cgm'), 'custom_button_item_');

            ?></td>
        </tr><?php
    }

    /**
     * Output the frontend border settings.
     */
    public function custom_button_item_border_setting()
    {
        $id = 'custom_button_item_';
        ?>
        <tr valign="top" class="ct_custom_border">
        <th scope="row" class="titledesc">
            <?php _e('Border', 'ct-cgm'); ?>
        </th>
        <td class="forminp"><?php

            // Get settings
            $customBorder = array_map('esc_attr', (array)get_option('wc_catalog_mode_' . $id . 'border'));

            // Defaults
            if (empty($customBorder[$id . 'borderThickness'])) {
                $customBorder[$id . 'borderThickness'] = '';
            }
            if (empty($customBorder[$id . 'borderRadius'])) {
                $customBorder[$id . 'borderRadius'] = '';
            }

            // Show inputs
            $this->style_picker(__('Border Thickness', 'ct-cgm'), 'ct_css_' . $id . 'border_thickness', $customBorder[$id . 'borderThickness'], __('The thickness of the border', 'ct-cgm'), 'custom_button_item_');
            $this->style_picker(__('Border Radius', 'ct-cgm'), 'ct_css_' . $id . 'border_radius', $customBorder[$id . 'borderRadius'], __('The radius of the border', 'ct-cgm'), 'custom_button_item_');
            ?></td>
        </tr><?php
    }

    /**
     * Output the frontend margin settings.
     */
    public function custom_button_item_margin_setting()
    {
        $id = 'custom_button_item_';
        ?>
        <tr valign="top" class="ct_custom_margins">
        <th scope="row" class="titledesc">
            <?php _e('Margins', 'ct-cgm'); ?>
        </th>
        <td class="forminp"><?php

            // Get settings
            $margins = array_map('esc_attr', (array)get_option('wc_catalog_mode_' . $id . 'margins'));

            // Defaults
            if (empty($margins[$id . 'mtop'])) {
                $margins[$id . 'mtop'] = '0';
            }
            if (empty($margins[$id . 'mbottom'])) {
                $margins[$id . 'mbottom'] = '0';
            }
            if (empty($margins[$id . 'mright'])) {
                $margins[$id . 'mright'] = '0';
            }
            if (empty($margins[$id . 'mleft'])) {
                $margins[$id . 'mleft'] = '0';
            }

            // Show inputs
            $this->style_picker(__('Margin Top', 'ct-cgm'), 'ct_css_' . $id . 'mtop', $margins[$id . 'mtop'], __('Margin Top', 'ct-cgm'), 'custom_button_item_');
            $this->style_picker(__('Margin Bottom', 'ct-cgm'), 'ct_css_' . $id . 'mbottom', $margins[$id . 'mbottom'], __('Margin Bottom', 'ct-cgm'), 'custom_button_item_');
            $this->style_picker(__('Margin Right', 'ct-cgm'), 'ct_css_' . $id . 'mright', $margins[$id . 'mright'], __('Margin Right', 'ct-cgm'), 'custom_button_item_');
            $this->style_picker(__('Margin Left', 'ct-cgm'), 'ct_css_' . $id . 'mleft', $margins[$id . 'mleft'], __('Margin Left', 'ct-cgm'), 'custom_button_item_');

            ?></td>
        </tr><?php
    }

    /**
     * Output the frontend margin settings.
     */
    public function custom_button_item_padding_setting()
    {
        $id = 'custom_button_item_';
        ?>
        <tr valign="top" class="ct_custom_padding">
        <th scope="row" class="titledesc">
            <?php _e('Paddings', 'ct-cgm'); ?>
        </th>
        <td class="forminp"><?php

            // Get settings
            $paddings = array_map('esc_attr', (array)get_option('wc_catalog_mode_' . $id . 'paddings'));

            // Defaults
            if (empty($paddings[$id . 'ptop'])) {
                $paddings[$id . 'ptop'] = '';
            }
            if (empty($paddings[$id . 'pbottom'])) {
                $paddings[$id . 'pbottom'] = '';
            }
            if (empty($paddings[$id . 'pright'])) {
                $paddings[$id . 'pright'] = '';
            }
            if (empty($paddings[$id . 'pleft'])) {
                $paddings[$id . 'pleft'] = '';
            }

            // Show inputs
            $this->style_picker(__('Padding Top', 'ct-cgm'), 'ct_css_' . $id . 'ptop', $paddings[$id . 'ptop'], __('Padding Top', 'ct-cgm'), 'custom_button_item_');
            $this->style_picker(__('Padding Bottom', 'ct-cgm'), 'ct_css_' . $id . 'pbottom', $paddings[$id . 'pbottom'], __('Padding Bottom', 'ct-cgm'), 'custom_button_item_');
            $this->style_picker(__('Padding Right', 'ct-cgm'), 'ct_css_' . $id . 'pright', $paddings[$id . 'pright'], __('Padding Right', 'ct-cgm'), 'custom_button_item_');
            $this->style_picker(__('Padding Left', 'ct-cgm'), 'ct_css_' . $id . 'pleft', $paddings[$id . 'pleft'], __('Padding Left', 'ct-cgm'), 'custom_button_item_');

            ?></td>
        </tr><?php
    }

    /**
     * Output the frontend color settings.
     */
    public function custom_button_item_color_setting()
    {
        $id = 'custom_button_item_';
        ?>
        <tr valign="top" class="ct_button_colors">
        <th scope="row" class="titledesc">
            <?php _e('Button Colors', 'ct-cgm'); ?>
        </th>
        <td class="forminp"><?php

            // Get settings
            $colors = array_map('esc_attr', (array)get_option('wc_catalog_mode_' . $id . 'button_colors'));

            // Defaults
            if (empty($colors[$id . 'backg'])) {
                $colors[$id . 'backg'] = '';
            }
            if (empty($colors[$id . 'mouse_ovr'])) {
                $colors[$id . 'mouse_ovr'] = '';
            }
            if (empty($colors[$id . 'text'])) {
                $colors[$id . 'text'] = '';
            }
            if (empty($colors[$id . 'text_mouse'])) {
                $colors[$id . 'text_mouse'] = '';
            }
            if (empty($colors[$id . 'border'])) {
                $colors[$id . 'border'] = '';
            }
            if (empty($colors[$id . 'border_mouse'])) {
                $colors[$id . 'border_mouse'] = '';
            }

            // Show inputs
            $this->color_picker(__('Background Color', 'ct-cgm'), 'ct_css_' . $id . 'background', $colors[$id . 'backg'], __('Background color of custom button.', 'ct-cgm'), 'custom_button_item_');
            $this->color_picker(__('Mouse Over Background Color', 'ct-cgm'), 'ct_css_' . $id . 'mouse_ovr', $colors[$id . 'mouse_ovr'], __('Background color of button on mouse over.', 'ct-cgm'), 'custom_button_item_');
            $this->color_picker(__('Text Color', 'ct-cgm'), 'ct_css_' . $id . 'text', $colors[$id . 'text'], __('Text color of button in normal state.', 'ct-cgm'), 'custom_button_item_');
            $this->color_picker(__('Mouse Over Text Color', 'ct-cgm'), 'ct_css_' . $id . 'text_mouse', $colors[$id . 'text_mouse'], __('Text color of button in mouse over state.', 'ct-cgm'), 'custom_button_item_');
            $this->color_picker(__('Border Color', 'ct-cgm'), 'ct_css_' . $id . 'border', $colors[$id . 'border'], __('Border color of button in normal state.', 'ct-cgm'), 'custom_button_item_');
            $this->color_picker(__('Mouse Over Border Color', 'ct-cgm'), 'ct_css_' . $id . 'border_mouse', $colors[$id . 'border_mouse'], __('Border color of button in mouseover state.', 'ct-cgm'), 'custom_button_item_');

            ?></td>
        </tr><?php
    }

    //************************************
    //SHOP LIST BUTTON STYLES
    //************************************
    /**
     * Output the frontend box shadow settings.
     */
    public function custom_button_shop_box_shadow_setting()
    {
        $id = 'custom_button_shop_';
        ?>
        <tr valign="top" class="ct_custom_box_shadow">
        <th scope="row" class="titledesc">
            <?php _e('Box Shadow', 'ct-cgm'); ?>
        </th>
        <td class="forminp"><?php

            // Get settings
            $boxShadow = array_map('esc_attr', (array)get_option('wc_catalog_mode_' . $id . 'box_shadow'));

            // Defaults
            if (empty($boxShadow[$id . 'hboxshadow'])) {
                $boxShadow[$id . 'hboxshadow'] = '0';
            }
            if (empty($boxShadow[$id . 'vboxshadow'])) {
                $boxShadow[$id . 'vboxshadow'] = '0';
            }
            if (empty($boxShadow[$id . 'bboxshadow'])) {
                $boxShadow[$id . 'bboxshadow'] = '0';
            }
            if (empty($boxShadow[$id . 'sboxshadow'])) {
                $boxShadow[$id . 'sboxshadow'] = '0';
            }
            if (empty($boxShadow[$id . 'cboxshadow'])) {
                $boxShadow[$id . 'cboxshadow'] = '';
            }

            // Show inputs
            $this->style_picker(__('H. Shadow', 'ct-cgm'), 'ct_css_' . $id . 'hboxshadow', $boxShadow[$id . 'hboxshadow'], __('The position of the horizontal shadow. Negative values are allowed', 'ct-cgm'), 'custom_button_shop_');
            $this->style_picker(__('V. Shadow', 'ct-cgm'), 'ct_css_' . $id . 'vboxshadow', $boxShadow[$id . 'vboxshadow'], __('The position of the vertical shadow. Negative values are allowed', 'ct-cgm'), 'custom_button_shop_');
            $this->style_picker(__('Blur', 'ct-cgm'), 'ct_css_' . $id . 'bboxshadow', $boxShadow[$id . 'bboxshadow'], __('The blur distance', 'ct-cgm'), 'custom_button_shop_');
            $this->style_picker(__('Spread', 'ct-cgm'), 'ct_css_' . $id . 'sboxshadow', $boxShadow[$id . 'sboxshadow'], __('The size of shadow', 'ct-cgm'), 'custom_button_shop_');
            $this->color_picker(__('Color', 'ct-cgm'), 'ct_css_' . $id . 'cboxshadow', $boxShadow[$id . 'cboxshadow'], __('The color of the shadow', 'ct-cgm'), 'custom_button_shop_');

            ?></td>
        </tr><?php
    }

    /**
     * Output the frontend border settings.
     */
    public function custom_button_shop_border_setting()
    {
        $id = 'custom_button_shop_';
        ?>
        <tr valign="top" class="ct_custom_border">
        <th scope="row" class="titledesc">
            <?php _e('Border', 'ct-cgm'); ?>
        </th>
        <td class="forminp"><?php

            // Get settings
            $customBorder = array_map('esc_attr', (array)get_option('wc_catalog_mode_' . $id . 'border'));

            // Defaults
            if (empty($customBorder[$id . 'borderThickness'])) {
                $customBorder[$id . 'borderThickness'] = '';
            }
            if (empty($customBorder[$id . 'borderRadius'])) {
                $customBorder[$id . 'borderRadius'] = '';
            }

            // Show inputs
            $this->style_picker(__('Border Thickness', 'ct-cgm'), 'ct_css_' . $id . 'border_thickness', $customBorder[$id . 'borderThickness'], __('The thickness of the border', 'ct-cgm'), 'custom_button_shop_');
            $this->style_picker(__('Border Radius', 'ct-cgm'), 'ct_css_' . $id . 'border_radius', $customBorder[$id . 'borderRadius'], __('The radius of the border', 'ct-cgm'), 'custom_button_shop_');
            ?></td>
        </tr><?php
    }

    /**
     * Output the frontend margin settings.
     */
    public function custom_button_shop_margin_setting()
    {
        $id = 'custom_button_shop_';
        ?>
        <tr valign="top" class="ct_custom_margins">
        <th scope="row" class="titledesc">
            <?php _e('Margins', 'ct-cgm'); ?>
        </th>
        <td class="forminp"><?php

            // Get settings
            $margins = array_map('esc_attr', (array)get_option('wc_catalog_mode_' . $id . 'margins'));

            // Defaults
            if (empty($margins[$id . 'mtop'])) {
                $margins[$id . 'mtop'] = '0';
            }
            if (empty($margins[$id . 'mbottom'])) {
                $margins[$id . 'mbottom'] = '0';
            }
            if (empty($margins[$id . 'mright'])) {
                $margins[$id . 'mright'] = '0';
            }
            if (empty($margins[$id . 'mleft'])) {
                $margins[$id . 'mleft'] = '0';
            }

            // Show inputs
            $this->style_picker(__('Margin Top', 'ct-cgm'), 'ct_css_' . $id . 'mtop', $margins[$id . 'mtop'], __('Margin Top', 'ct-cgm'), 'custom_button_shop_');
            $this->style_picker(__('Margin Bottom', 'ct-cgm'), 'ct_css_' . $id . 'mbottom', $margins[$id . 'mbottom'], __('Margin Bottom', 'ct-cgm'), 'custom_button_shop_');
            $this->style_picker(__('Margin Right', 'ct-cgm'), 'ct_css_' . $id . 'mright', $margins[$id . 'mright'], __('Margin Right', 'ct-cgm'), 'custom_button_shop_');
            $this->style_picker(__('Margin Left', 'ct-cgm'), 'ct_css_' . $id . 'mleft', $margins[$id . 'mleft'], __('Margin Left', 'ct-cgm'), 'custom_button_shop_');

            ?></td>
        </tr><?php
    }

    /**
     * Output the frontend margin settings.
     */
    public function custom_button_shop_padding_setting()
    {
        $id = 'custom_button_shop_';
        ?>
        <tr valign="top" class="ct_custom_padding">
        <th scope="row" class="titledesc">
            <?php _e('Paddings', 'ct-cgm'); ?>
        </th>
        <td class="forminp"><?php

            // Get settings
            $paddings = array_map('esc_attr', (array)get_option('wc_catalog_mode_' . $id . 'paddings'));

            // Defaults
            if (empty($paddings[$id . 'ptop'])) {
                $paddings[$id . 'ptop'] = '';
            }
            if (empty($paddings[$id . 'pbottom'])) {
                $paddings[$id . 'pbottom'] = '';
            }
            if (empty($paddings[$id . 'pright'])) {
                $paddings[$id . 'pright'] = '';
            }
            if (empty($paddings[$id . 'pleft'])) {
                $paddings[$id . 'pleft'] = '';
            }

            // Show inputs
            $this->style_picker(__('Padding Top', 'ct-cgm'), 'ct_css_' . $id . 'ptop', $paddings[$id . 'ptop'], __('Padding Top', 'ct-cgm'), 'custom_button_shop_');
            $this->style_picker(__('Padding Bottom', 'ct-cgm'), 'ct_css_' . $id . 'pbottom', $paddings[$id . 'pbottom'], __('Padding Bottom', 'ct-cgm'), 'custom_button_shop_');
            $this->style_picker(__('Padding Right', 'ct-cgm'), 'ct_css_' . $id . 'pright', $paddings[$id . 'pright'], __('Padding Right', 'ct-cgm'), 'custom_button_shop_');
            $this->style_picker(__('Padding Left', 'ct-cgm'), 'ct_css_' . $id . 'pleft', $paddings[$id . 'pleft'], __('Padding Left', 'ct-cgm'), 'custom_button_shop_');

            ?></td>
        </tr><?php
    }

    /**
     * Output the frontend color settings.
     */
    public function custom_button_shop_color_setting()
    {
        $id = 'custom_button_shop_';
        ?>
        <tr valign="top" class="ct_button_colors">
        <th scope="row" class="titledesc">
            <?php _e('Button Colors', 'ct-cgm'); ?>
        </th>
        <td class="forminp"><?php

            // Get settings
            $colors = array_map('esc_attr', (array)get_option('wc_catalog_mode_' . $id . 'button_colors'));

            // Defaults
            if (empty($colors[$id . 'backg'])) {
                $colors[$id . 'backg'] = '';
            }
            if (empty($colors[$id . 'mouse_ovr'])) {
                $colors[$id . 'mouse_ovr'] = '';
            }
            if (empty($colors[$id . 'text'])) {
                $colors[$id . 'text'] = '';
            }
            if (empty($colors[$id . 'text_mouse'])) {
                $colors[$id . 'text_mouse'] = '';
            }
            if (empty($colors[$id . 'border'])) {
                $colors[$id . 'border'] = '';
            }
            if (empty($colors[$id . 'border_mouse'])) {
                $colors[$id . 'border_mouse'] = '';
            }

            // Show inputs
            $this->color_picker(__('Background Color', 'ct-cgm'), 'ct_css_' . $id . 'background', $colors[$id . 'backg'], __('Background color of custom button.', 'ct-cgm'), 'custom_button_shop_');
            $this->color_picker(__('Mouse Over Background Color', 'ct-cgm'), 'ct_css_' . $id . 'mouse_ovr', $colors[$id . 'mouse_ovr'], __('Background color of button on mouse over.', 'ct-cgm'), 'custom_button_shop_');
            $this->color_picker(__('Text Color', 'ct-cgm'), 'ct_css_' . $id . 'text', $colors[$id . 'text'], __('Text color of button in normal state.', 'ct-cgm'), 'custom_button_shop_');
            $this->color_picker(__('Mouse Over Text Color', 'ct-cgm'), 'ct_css_' . $id . 'text_mouse', $colors[$id . 'text_mouse'], __('Text color of button in mouse over state.', 'ct-cgm'), 'custom_button_shop_');
            $this->color_picker(__('Border Color', 'ct-cgm'), 'ct_css_' . $id . 'border', $colors[$id . 'border'], __('Border color of button in normal state.', 'ct-cgm'), 'custom_button_shop_');
            $this->color_picker(__('Mouse Over Border Color', 'ct-cgm'), 'ct_css_' . $id . 'border_mouse', $colors[$id . 'border_mouse'], __('Border color of button in mouseover state.', 'ct-cgm'), 'custom_button_shop_');

            ?></td>
        </tr><?php
    }

    /**
     * Output a picker input box.
     *
     * @param mixed $name
     * @param string $id
     * @param mixed $value
     * @param string $desc (default: '')
     * @param string $group
     */
    public function style_picker($name, $id, $value, $desc = '', $group)
    {
        echo '<div class="color_box ct_style_box ' . $group . 'group">
                 <strong>
                    <img class="help_tip" data-tip="' . esc_attr($desc) . '" src="' . CT_CATALOG_ASSETS . 'images/help.png" height="16" width="16" /> ' . esc_html($name) . '
                </strong>
			   <input name="' . esc_attr($id) . '" id="' . esc_attr($id) . '" type="number" value="' . esc_attr($value) . '" class="ct_input_number" min="0"/> </div>
		    </div>';
    }

    /**
     * Output a colour picker input box.
     *
     * @param mixed $name
     * @param string $id
     * @param mixed $value
     * @param string $desc (default: '')
     * @param string $group
     */
    public function color_picker($name, $id, $value, $desc = '', $group)
    {
        echo '<div class="color_box ct_color_box ' . $group . 'group"><strong><img class="help_tip" data-tip="' . esc_attr($desc) . '" src="' . CT_CATALOG_ASSETS . 'images/help.png" height="16" width="16" /> ' . esc_html($name) . '</strong>
			<input name="' . esc_attr($id) . '" id="' . esc_attr($id) . '" type="text" value="' . esc_attr($value) . '" class="colorpick" /> <div id="colorPickerDiv_' . esc_attr($id) . '" class="colorpickdiv"></div>
		</div>';

    }

    /**
     * Save Button styles settings
     */
    public function save()
    {
        $idArray = array("custom_button_item_", "custom_button_shop_");

        foreach ($idArray as $value) {
            //Margins
            $mtop = $_POST['ct_css_' . $value . 'mtop'];
            $mbottom = $_POST['ct_css_' . $value . 'mbottom'];
            $mright = $_POST['ct_css_' . $value . 'mright'];
            $mleft = $_POST['ct_css_' . $value . 'mleft'];


            //Paddings
            $ptop = $_POST['ct_css_' . $value . 'ptop'];
            $pbottom = $_POST['ct_css_' . $value . 'pbottom'];
            $pright = $_POST['ct_css_' . $value . 'pright'];
            $pleft = $_POST['ct_css_' . $value . 'pleft'];

            //Box Shadow
            $hboxshadow = $_POST['ct_css_' . $value . 'hboxshadow'];
            $vboxshadow = $_POST['ct_css_' . $value . 'vboxshadow'];
            $bboxshadow = $_POST['ct_css_' . $value . 'bboxshadow'];
            $sboxshadow = $_POST['ct_css_' . $value . 'sboxshadow'];
            $cboxshadow = wc_format_hex($_POST['ct_css_' . $value . 'cboxshadow']);

            //Border

            $borderThickness = $_POST['ct_css_' . $value . 'border_thickness'];
            $borderRadius = $_POST['ct_css_' . $value . 'border_radius'];

            //Colors
            $backg = (!empty($_POST['ct_css_' . $value . 'background'])) ? wc_format_hex($_POST['ct_css_' . $value . 'background']) : '';
            $mouse_ovr = (!empty($_POST['ct_css_' . $value . 'mouse_ovr'])) ? wc_format_hex($_POST['ct_css_' . $value . 'mouse_ovr']) : '';
            $text = (!empty($_POST['ct_css_' . $value . 'text'])) ? wc_format_hex($_POST['ct_css_' . $value . 'text']) : '';
            $text_mouse = (!empty($_POST['ct_css_' . $value . 'text_mouse'])) ? wc_format_hex($_POST['ct_css_' . $value . 'text_mouse']) : '';
            $border = (!empty($_POST['ct_css_' . $value . 'border'])) ? wc_format_hex($_POST['ct_css_' . $value . 'border']) : '';
            $border_mouse = (!empty($_POST['ct_css_' . $value . 'border_mouse'])) ? wc_format_hex($_POST['ct_css_' . $value . 'border_mouse']) : '';

            $margins = array(
                $value . 'mtop' => $mtop,
                $value . 'mbottom' => $mbottom,
                $value . 'mright' => $mright,
                $value . 'mleft' => $mleft

            );
            $paddings = array(
                $value . 'ptop' => $ptop,
                $value . 'pbottom' => $pbottom,
                $value . 'pright' => $pright,
                $value . 'pleft' => $pleft
            );
            $boxShadow = array(
                $value . 'hboxshadow' => $hboxshadow,
                $value . 'vboxshadow' => $vboxshadow,
                $value . 'bboxshadow' => $bboxshadow,
                $value . 'sboxshadow' => $sboxshadow,
                $value . 'cboxshadow' => $cboxshadow
            );
            $customBorder = array(
                $value . 'borderThickness' => $borderThickness,
                $value . 'borderRadius' => $borderRadius
            );
            $colors = array(
                $value . 'backg' => $backg,
                $value . 'mouse_ovr' => $mouse_ovr,
                $value . 'text' => $text,
                $value . 'text_mouse' => $text_mouse,
                $value . 'border' => $border,
                $value . 'border_mouse' => $border_mouse
            );

            update_option('wc_catalog_mode_' . $value . 'margins', $margins);
            update_option('wc_catalog_mode_' . $value . 'paddings', $paddings);
            update_option('wc_catalog_mode_' . $value . 'box_shadow', $boxShadow);
            update_option('wc_catalog_mode_' . $value . 'border', $customBorder);
            update_option('wc_catalog_mode_' . $value . 'button_colors', $colors);

        }
    }
}

new ctCatalogSettings;
