<?php

/**
 * adds the 'edit table' meta box
 * @author jacek
 */
class ctSizeGuideTable {
	/**
	 * Init object
	 */

	public function __construct() {
		add_action( 'add_meta_boxes', array( $this, 'editSizeGuideTable' ) );
		add_action( 'add_meta_boxes', array( $this, 'editSizeGuideSettings' ) );
		add_action( 'save_post_ct_size_guide', array( $this, 'saveSizeGuideTable' ) );
        add_action( 'edit_post_ct_size_guide', array( $this, 'saveSizeGuideTable' ) );

	}

	/**
	 * Add meta box for size guide
	 */

	public function editSizeGuideTable() {
		add_meta_box( 'ct_sizeguidetable', __( 'Create/modify size guide table', 'ct_sgp' ), array(
			$this,
			'renderSizeGuideTableMetaBox'
		), 'ct_size_guide', 'normal', 'high' );
	}

	/**
	 * Size Guide Meta box
	 *
	 * @param $post
	 */

	public function renderSizeGuideTableMetaBox( $post ) {
		wp_nonce_field( 'size_guide_meta_box', 'size_guide_meta_box_nonce' );

		$current = get_current_screen()->action;

		$newpost = ( $current == 'add' );

		$defaultTable   = array(
			array( __('Size','ct_sgp'), __('Bust','ct_sgp'), __('Waist','ct_sgp'), __('Hips','ct_sgp') ),
			array( '8', '32', '25', '35' ),
			array( '10', '34', '27', '37' ),
			array( '12', '36', '29', '39' ),
		);
		$defaultTitle   = __('Table title','ct_sgp');
		$defaultCaption = __('Table caption','ct_sgp');

		if ( ! $newpost ) {
			$post_id    = $post->ID;
			$meta_table = get_post_meta( $post_id, '_ct_sizeguide' );
			$meta_table = $meta_table[0];
		} else {
			$meta_table[0] = array(
				'title'   => $defaultTitle,
				'table'   => $defaultTable,
				'caption' => $defaultCaption
			);
		}

		foreach ( $meta_table as $key => $table ) {

			$this->sizeGuideTableTemplate( $table, $key, '' );

		}
	}

	/**
	 * Render table
	 *
	 * @param $table
	 * @param $key
	 * @param string $class
	 */

	public function sizeGuideTableTemplate( $table, $key, $class = '' ) {
		echo '<div class="ct_single_size_table' . ( $class ? ' ' . $class : '' ) . '">';
		echo '<p><strong>' . __( 'Text above table', 'ct-sgp' ) . '</strong></p>';

		$args_title = array(
			'textarea_name' => 'ct_size_guide[' . $key . '][title]',
			'textarea_rows' => 2
		);

		wp_editor( $table['title'], 'size_table_caption' . $key, $args_title );

		echo '<br>';

		echo '<textarea class="ct_edit_table" name="ct_size_guide[' . $key . '][table]" style="display:none">';
		$table_array = json_encode( $table['table'] );
		echo $table_array;
		echo '</textarea>';

		echo '<p><strong>' . __( 'Table caption', 'ct-sgp' ) . '</strong></p>';

		$args_caption = array(
			'textarea_name' => 'ct_size_guide[' . $key . '][caption]',
			'textarea_rows' => 2
		);

		wp_editor( $table['caption'], 'size_table_title' . $key, $args_caption );
		echo '</div>';

	}

	/**
	 * Add size guide metabox settings
	 */

	public function editSizeGuideSettings() {
		add_meta_box( 'ct_sizeguidesettings', __( 'Size guide settings', 'ct_sgp' ), array(
			$this,
			'renderSizeGuideSettingsMetaBox'
		), 'ct_size_guide', 'normal', 'high' );
	}

	/**
	 * Meta box
	 *
	 * @param $post
	 */

	public function renderSizeGuideSettingsMetaBox( $post ) {

		$current = get_current_screen()->action;

		$newpost = ( $current == 'add' );

		if ( ! $newpost ) {
			$post_id = $post->ID;
		} else {
			$post_id = 'new';
		}

		wp_nonce_field( 'size_guide_settings_meta_box', 'size_guide_settings_meta_box_nonce' );

		echo '<div class="sg-single-setting"><label>' . __( 'Open guide with:', 'ct-sgp' ) . '</label> <select name="size_guide_settings[wc_size_guide_button_style]" class="chosen_select">
                    <option value="global" ' . $this->getSelected( $post_id, 'wc_size_guide_button_style', 'global' ) . '>' . __( 'Use global settings', 'ct-sgp' ) . '</option>
                    <option value="ct-trigger-link" ' . $this->getSelected( $post_id, 'wc_size_guide_button_style', 'ct-trigger-link' ) . '>' . __( 'Link', 'ct-sgp' ) . '</option>
                    <option value="ct-trigger-button" ' . $this->getSelected( $post_id, 'wc_size_guide_button_style', 'ct-trigger-button' ) . '>' . __( 'Button', 'ct-sgp' ) . '</option>
               </select><small>   ' . __( 'Chose whether to display a simple link or a button to open the size guide.', 'ct-sgp' ) . '</small></div>';

		echo '<div class="sg-single-setting"><label>' . __( 'Button/link position:', 'ct-sgp' ) . '</label> <select name="size_guide_settings[wc_size_guide_button_position]" class="chosen_select">
                    <option value="global" ' . $this->getSelected( $post_id, 'wc_size_guide_button_position', 'global' ) . '>' . __( 'Use global settings', 'ct-sgp' ) . '</option>
                    <option value="ct-position-price" ' . $this->getSelected( $post_id, 'wc_size_guide_button_position', 'ct-position-price' ) . '>' . __( 'Under Price', 'ct-sgp' ) . '</option>
                    <option value="ct-position-summary" ' . $this->getSelected( $post_id, 'wc_size_guide_button_position', 'ct-position-summary' ) . '>' . __( 'Above the product summary tabs', 'ct-sgp' ) . '</option>
                    <option value="ct-position-add-to-cart" ' . $this->getSelected( $post_id, 'wc_size_guide_button_position', 'ct-position-add-to-cart' ) . '>' . __( 'After Add To Cart button', 'ct-sgp' ) . '</option>
				    <option value="ct-position-info" ' . $this->getSelected( $post_id, 'wc_size_guide_button_position', 'ct-position-info' ) . '>' . __( 'After Product Info', 'ct-sgp' ) . '</option>
                    <option value="ct-position-tab" ' . $this->getSelected( $post_id, 'wc_size_guide_button_position', 'ct-position-tab' ) . '>' . __( 'Make it a tab', 'ct-sgp' ) . '</option>
                    <option value="ct-position-shortcode" ' . $this->getSelected( $post_id, 'wc_size_guide_button_position', 'ct-position-shortcode' ) . '>' . __('Embed manually (shortcode)','ct_sgp') . '</option>
               </select><small>   ' . __( 'For manual embed, [ct_size_guide] shortcode can be placed anywhere you want. More info can be found <a href="http://createit.support/documentation/size-guide/#doc-7007" target="_blank">here</a>', 'ct-sgp' ) . '</small></div>';

        echo '<div class="sg-single-setting"><label id="sg-priority">' . __( 'Button/link hook priority:', 'ct-sgp' ) . '</label> <input name="size_guide_settings[wc_size_guide_button_priority]" value="' . $this->getNumberValue( $post_id, 'wc_size_guide_button_priority', '60' ) . '" class="chosen_input">
        <small>'.__( 'Priority of the action that outputs the button/link. Using this you can adjust the position - check the <a href="http://createit.support/documentation/size-guide/#button-priority">documentation</a> for more information.', 'ct-sgp' ).'</small></div>';

		echo '<div class="sg-single-setting"><label>' . __( 'Button/link label:', 'ct-sgp' ) . '</label> <input name="size_guide_settings[wc_size_guide_button_label]" value="' . $this->getNumberValue( $post_id, 'wc_size_guide_button_label', 'Size Guide' ) . '" class="chosen_input"></div>';

		echo '<div class="sg-single-setting"><label>' . __( 'Button/link align:', 'ct-sgp' ) . '</label> <select name="size_guide_settings[wc_size_guide_button_align]" class="chosen_select">
                    <option value="global" ' . $this->getSelected( $post_id, 'wc_size_guide_button_align', 'global' ) . '>' . __( 'Use global settings', 'ct-sgp' ) . '</option>
                    <option value="left" ' . $this->getSelected( $post_id, 'wc_size_guide_button_align', 'left' ) . '>' . __( 'Left', 'ct-sgp' ) . '</option>
                    <option value="right" ' . $this->getSelected( $post_id, 'wc_size_guide_button_align', 'right' ) . '>' . __( 'Right', 'ct-sgp' ) . '</option>
               </select></div>';

		echo '<div class="sg-single-setting"><label>' . __( 'Button/link clearing:', 'ct-sgp' ) . '</label> <select name="size_guide_settings[wc_size_guide_button_clear]" class="chosen_select">
                    <option value="global" ' . $this->getSelected( $post_id, 'wc_size_guide_button_clear', 'global' ) . '>' . __( 'Use global settings', 'ct-sgp' ) . '</option>
                    <option value="yes" ' . $this->getSelected( $post_id, 'wc_size_guide_button_clear', 'yes' ) . '>' . __( 'Yes', 'ct-sgp' ) . '</option>
                    <option value="no" ' . $this->getSelected( $post_id, 'wc_size_guide_button_clear', 'no' ) . '>' . __( 'No', 'ct-sgp' ) . '</option>
               </select><small>   ' . __( 'Allow floating elements on the sides of the link/button?', 'ct-sgp' ) . '</small></div>';

        echo '<div class="sg-single-setting"><label>' . __( 'Button class:', 'ct-sgp' ) . '</label> <input name="size_guide_settings[wc_size_guide_button_class]" value="' . $this->getNumberValue( $post_id, 'wc_size_guide_button_class', 'button_sg' ) . '" class="chosen_input"></div>';

		echo '<div class="sg-single-setting"><label>' . __( 'Button/link margins:', 'ct-sgp' ) . '</label>
        <div class="ct-number-input"><input type="text" value="' . $this->getNumberValue( $post_id, 'wc_size_guide_button_margin_left', '0' ) . '" name="size_guide_settings[wc_size_guide_button_margin_left]"><span>' . __( 'Margin left', 'ct-sgp' ) . '</span></div>
        <div class="ct-number-input"><input type="text" value="' . $this->getNumberValue( $post_id, 'wc_size_guide_button_margin_top', '0' ) . '" name="size_guide_settings[wc_size_guide_button_margin_top]"><span>' . __( 'Margin top', 'ct-sgp' ) . '</span></div>
        <div class="ct-number-input"><input type="text" value="' . $this->getNumberValue( $post_id, 'wc_size_guide_button_margin_right', '0' ) . '" name="size_guide_settings[wc_size_guide_button_margin_right]"><span>' . __( 'Margin right', 'ct-sgp' ) . '</span></div>
        <div class="ct-number-input"><input type="text" value="' . $this->getNumberValue( $post_id, 'wc_size_guide_button_margin_bottom', '0' ) . '" name="size_guide_settings[wc_size_guide_button_margin_bottom]"><span>' . __( 'Margin bottom', 'ct-sgp' ) . '</span></div>
        <div>&nbsp;</div></div>';

		echo '<div class="sg-single-setting"><label>' . __( 'Popup overlay color:', 'ct-sgp' ) . '' . '</label><input type="text" name="size_guide_settings[wc_size_guide_overlay_color]" class="ct-sg-color" value="' . $this->getNumberValue( $post_id, 'wc_size_guide_overlay_color', '#0000000' ) . '"><small>'.__('Click to pick the color of the popup background overlay','ct_sgp') . '</small></div>';

		echo '<div class="sg-single-setting"><label>' . __( 'Popup window content paddings:', 'ct-sgp' ) . '</label>
        <div class="ct-number-input"><input type="text" value="' . $this->getNumberValue( $post_id, 'wc_size_guide_modal_padding_left', '40' ) . '" name="size_guide_settings[wc_size_guide_modal_padding_left]"><span>' . __( 'Padding left', 'ct-sgp' ) . '</span></div>
        <div class="ct-number-input"><input type="text" value="' . $this->getNumberValue( $post_id, 'wc_size_guide_modal_padding_top', '40' ) . '" name="size_guide_settings[wc_size_guide_modal_padding_top]"><span>' . __( 'Padding top', 'ct-sgp' ) . '</span></div>
        <div class="ct-number-input"><input type="text" value="' . $this->getNumberValue( $post_id, 'wc_size_guide_modal_padding_right', '40' ) . '" name="size_guide_settings[wc_size_guide_modal_padding_right]"><span>' . __( 'Padding right', 'ct-sgp' ) . '</span></div>
        <div class="ct-number-input"><input type="text" value="' . $this->getNumberValue( $post_id, 'wc_size_guide_modal_padding_bottom', '40' ) . '" name="size_guide_settings[wc_size_guide_modal_padding_bottom]"><span>' . __( 'Padding bottom', 'ct-sgp' ) . '</span></div>
        <div>&nbsp;</div></div>';
	}

	protected function getNumberValue( $id, $opt, $default = 'null' ) {
		if ( $id != 'new' ) {
			$val = get_post_meta( $id, '_ct_sizeguidesettings' );
			if ( $val === '' || ! isset( $val[0] ) ) {
				$val = get_option( $opt, $default );
			} else {
				$val = $val[0];
				$val = $val[ $opt ];
				if ( ! $val ) {
					$val = $default;
				}
			}
		} else {
			$val = get_option( $opt, $default );
		}

		return $val;
	}

	protected function getSelected( $id, $opt, $val ) {
		$selected = '';
		if ( $id != 'new' ) {
			$a = get_post_meta( $id, '_ct_sizeguidesettings' );
			if ( ! isset( $a[0] ) ) {
				return '';
			}
			$a = $a[0];
			$a = $a[ $opt ];

			if ( $a == $val ) {
				$selected = 'selected="selected"';
			}

		} else {
			if ( $val == 'global' ) {
				$selected = 'selected="selected"';
			}
		}

		return $selected;
	}

	/**
	 * Store data
	 *
	 * @param $post_id
	 */

	public function saveSizeGuideTable( $post_id ) {

		if ( ! isset( $_POST['size_guide_meta_box_nonce'] ) || ! isset( $_POST['size_guide_settings_meta_box_nonce'] ) ) {
			return;
		}

		if ( ! wp_verify_nonce( $_POST['size_guide_meta_box_nonce'], 'size_guide_meta_box' ) || ! wp_verify_nonce( $_POST['size_guide_settings_meta_box_nonce'], 'size_guide_settings_meta_box' ) ) {
			return;
		}

		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}

		if ( isset( $_POST['size_guide'] ) && 'page' == $_POST['size_guide'] ) {

			if ( ! current_user_can( 'edit_page', $post_id ) ) {
				return;
			}

		} else {

			if ( ! current_user_can( 'edit_post', $post_id ) ) {
				return;
			}
		}

		if ( ! isset( $_POST['ct_size_guide'] ) ) {
			return;
		}

		$sizeguide  = $_POST['ct_size_guide'];
		$sgsettings = $_POST['size_guide_settings'];

		$sizeguide[0]['table'] = json_decode( stripslashes( $sizeguide[0]['table'] ) );

		update_post_meta( $post_id, '_ct_sizeguide', $sizeguide );
		update_post_meta( $post_id, '_ct_sizeguidesettings', $sgsettings );

	}

}

new ctSizeGuideTable();