(function ($) {
    var variationGlobal;
    "use strict";
    $(function () {

        $('.ct-waitlist-add-button').live('click', function () {
            if($('#ct-waitlist-out-of-stock-type').val() == 'variation'){
                email = $('#ct-waitlist-email').val();
            }else{
                email = $(this).closest('div').find('#ct-waitlist-email').val();
            }
            if (validateForm(email) == false ) {
                $(this).blur();
                if($('#ct-waitlist-out-of-stock-type').val() != 'variation'){
                    $(this).closest('div').find('#ct-waitlist-email').focus();
                } else {
                    $('.ct-waitlist-content').find('#ct-waitlist-email').focus();
                }
            }
            else {
                var productId, email, outOfStockType, outOfStockParent;
                outOfStockType = $('#ct-waitlist-out-of-stock-type').val();
                outOfStockParent = $('#ct-waitlist-out-of-stock-parent-id').length ? $('#ct-waitlist-out-of-stock-parent-id').val() : false;
                if ($(this).parents('tr').length) {
                    productId = $(this).parents('tr').find('#ct-waitlist-productid').val();
                    email = $.trim($(this).parents('tr').find('#ct-waitlist-email').val());
                }
                else {
                    productId = $('#ct-waitlist-productid').val();
                    email = $.trim($('#ct-waitlist-email').val());
                }
                $.ajax({
                    url: ctAjax.adminAjaxUrl,
                    dataType: 'json',
                    type: 'POST',
                    context: '.ct-waitlist-add-button',
                    data: {
                        action: 'ctWaitlist_add_to_database',
                        prodid: productId,
                        email: email,
                        parentid: outOfStockParent,
                        is_grouped: outOfStockType == "grouped" ? 1 : 0,
                        is_variation: outOfStockType == "variation" ? 1 : 0,
                        variationid: outOfStockType == "variation" ? parseInt($('input[name="variation_id"]').val()) : 0
                    },
                    success: function () {
                        if (outOfStockType == "variation") {
                            $('#subbed').append('<input type="hidden" value="' + parseInt($('input[name="variation_id"]').val()) + '"/>');
                        }
                    },
                    error: function () {
                    }
                });
                var subscriptionSuccess = $.trim($('#ct-waitlist-subscriptionsuccess').val());
                $(this).parent().html(subscriptionSuccess);
            }
        });

        $('.ct-waitlist-remove-button').on('click', function () {
            var entryId, removedNotification;
            removedNotification = $.trim($('#ct-waitlist-removed-message').val());
            entryId = $(this).closest('div').find('input[name="ct-waitlist-to-remove-id"]').val();
            $.ajax({
                url: ctAjax.adminAjaxUrl,
                dataType: 'json',
                type: 'POST',
                data: {
                    action: 'ctWaitlist_remove_subscription',
                    id: entryId
                },
                success: function () {},
                error: function () {}
            });

            $(this).parent().html( removedNotification );
            $(this).remove();
        });

        $('.ct-waitlist-remove-my-account-button').on('click', function () {
            var entryId;
            entryId = $(this).parent().find('input').val();

            $.ajax({
                url: ctAjax.adminAjaxUrl,
                dataType: 'json',
                type: 'POST',
                data: {
                    action: 'ctWaitlist_remove_subscription',
                    id: entryId
                },
                success: function () {
                },
                error: function () {
                }
            });
            $(this).parent().html($('#ct-waitlist-removed-message').val());

        });

        $('.ct-waitlist-remove-variation').live('click', function () {
            var entryId, mail, removedNotification;
            mail = $.trim($('#ct-waitlist-email').val());
            entryId = variationGlobal;
            removedNotification = $.trim($('#ct-waitlist-removed-message').val());
            $.ajax({
                url: ctAjax.adminAjaxUrl,
                dataType: 'json',
                type: 'POST',
                data: {
                    action: 'ctWaitlist_remove_subscription',
                    id: entryId,
                    email: mail
                },
                success: function () {
                    $('.ct-waitlist-content.variations').html('<p class="ct-waitlist-notification">' + removedNotification + '</p>');
                    $('#subbed').children().each(function () {
                        if ($(this).val() == entryId) {
                            $(this).remove();
                        }
                    });
                },
                error: function () {
                }
            });
        });

        if ($('.variations_form').length) {
            var productVariations;
            productVariations = $('.variations_form').data('product_variations');
            $('input[name="variation_id"]').on('change', function () {
                var counter, inStock, selectedVariation;
                selectedVariation = parseInt($(this).val()) > 0 ? parseInt($(this).val()) : false;
                if (selectedVariation) {
                    for (counter = 0; counter < productVariations.length; counter++) {
                        if (parseInt(productVariations[counter].variation_id) === selectedVariation) {
                            inStock = productVariations[counter].is_in_stock;
                            if (inStock !== true) {
                                updateDiv(false);
                            }
                        }
                    }
                } else {
                    updateDiv(false);
                }
            });
        }
    });


    function updateDiv(par) {
        "use strict";

        var productId, isLoggedIn, waitlistDiv, buttonText, unsubscribeText, varAlreadySubscribed, notifymessage, unsubPage, placeholder, style;
        productId = $('#ct-waitlist-productid').val();
        isLoggedIn = $('#ct-waitlist-user-logged-in').val();
        unsubscribeText = $.trim($('#ct-waitlist-unsubscribe-button').val());
        varAlreadySubscribed = $.trim($('#ct-waitlist-variable-subscribed').val());
        notifymessage = $.trim($('#ct-waitlist-notify-message').val());
        buttonText = $.trim($('#ct-waitlist-subscribe-button').val());
        unsubPage = parseInt($('#ct-waitlist-unsubscribe-page').val());
        placeholder = $.trim($('#ct-waitlist-placeholder-text').val());
        style = parseInt($('#ct-waitlist-style').val());

        if (par) {
            $('.ct-waitlist-content.variations').html('');
        }
        else {
            if (isLoggedIn == 1) {
                if (style !=1) {
                    waitlistDiv = '<p class="ct-waitlist-notification">' + notifymessage + '</p>';
                    waitlistDiv += '<button type="button" class="single_add_to_cart_button button btn btn-primary ct-waitlist-add-button">' + buttonText + '</button>';
                } else {
                    waitlistDiv = '<button type="button" class="single_add_to_cart_button button btn btn-primary ct-waitlist-add-button">' + buttonText + '</button>';
                }
                $('#subbed').children().each(function () {
                    if (parseInt($('input[name="variation_id"]').val()) == this.value) {
                        variationGlobal = parseInt(this.value);
                        if(style!=1)
                        {
                            waitlistDiv = '<p class="ct-waitlist-notification">' + varAlreadySubscribed + '</p>';
                            if (unsubPage === 2 || unsubPage === 3) {
                                waitlistDiv += '<button type="button" class="single_add_to_cart_button button btn btn-primary ct-waitlist-remove-variation">' + unsubscribeText + '</button>';
                            }
                        } else {
                            waitlistDiv = '<p class="ct-waitlist-notification">' + varAlreadySubscribed + '</p>';
                            if (unsubPage === 2 || unsubPage === 3) {
                                waitlistDiv += '<button type="button" class="single_add_to_cart_button button btn btn-primary ct-waitlist-remove-variation">' + unsubscribeText + '</button>';
                            }
                        }
                        return false;
                    }
                });
            }
            else {
                if (style != 1) {
                    waitlistDiv = '<p class="ct-waitlist-notification">' + notifymessage + '</p>';
                    waitlistDiv += '<p><input type="text" class="ct-waitlist-input-email form-control" id="ct-waitlist-email" placeholder="'+ placeholder + '" /></p>';
                    waitlistDiv += '<button class="single_add_to_cart_button button btn btn-primary ct-waitlist-add-button" type="button">' + buttonText + '</button>';
                    waitlistDiv += '<input type="hidden" id="ct-waitlist-productid" value="' + productId + '" />';
                } else {
                    waitlistDiv = '<input type="text" style="width:70%; display:inline; float:left;" class="ct-waitlist-input-email form-control" placeholder="'+placeholder+'" id="ct-waitlist-email"/>';
                    waitlistDiv += '<button type="button" style="width:30%; display:inline " class="single_add_to_cart_button button btn btn-primary ct-waitlist-add-button">' + buttonText + '</button>';

                }
            }
            setTimeout(function () {
                $('.ct-waitlist-content.variations').html( waitlistDiv );
            }, 200);
        }
    }

    function validateForm(email) {
        var x = email;
        var atpos = x.indexOf("@");
        var dotpos = x.lastIndexOf(".");
        if (atpos < 1 || dotpos < atpos + 2 || dotpos + 2 >= x.length) {
            return false;
        }
    }

}(jQuery));
