<?php
/**
 * Plugin Name: createIT Waitlist Plugin
 * Plugin URI: http://waitlist.createit.pl/
 * Description: Waitlist for WooCommerce
 * Version: 1.5
 * Author: createIT
 * Author URI: http://createit.pl
 */

class ctWaitlist {
	protected $pluginDomain;
	protected $counter;
	protected $header;
	protected $senderFromName;
	protected $senderFromAddress;
	protected $optionTable = array();
	protected static $instance = null;
	public function setPluginDomain($value){
		$this->pluginDomain = $value;
	}
	public function getPluginDomain(){
		return $this->pluginDomain;
	}
	public function setHeader($value){
		$this->header = $value;
	}
	public function getHeader(){
		return $this->header;
	}
	public function setSenderFromName($value){
		$this->senderFromName = $value;
	}
	public function setSenderFromAddress($value){
		$this->senderFromAddress = $value;
	}
	public function getSenderFromName(){
		return $this->senderFromName;
	}
	public function getSenderFromAddress(){
		return $this->senderFromAddress;
	}
	public function setOptionTable($value){
		$this->optionTable = ($value);
	}
	public function setCounter($value){
		$this->counter = $value;
	}
	public function getCounter(){
		return $this->counter;
	}
	public static function getInstance() {
		if ( null == self::$instance ) {
			self::$instance = new self;
		}
		return self::$instance;
	}
	public function __construct(){
			$this->setOptionTable('ctWaitlist_options');
			$this->setPluginDomain('ct_waitlist');
			$this->setOptionTable('');
			$this->setCounter(0);
			$this->setHeader('');
			register_activation_hook(__FILE__, array($this, 'onPluginActivate'));
			add_action('plugins_loaded', array($this, 'adminLoad'));
			add_filter('woocommerce_get_availability', array($this, 'checkAvailability'), 2, 2);
			add_action('wp_ajax_ctWaitlist_add_to_database', array($this, 'addToDatabase'));
			add_action('wp_ajax_nopriv_ctWaitlist_add_to_database', array($this, 'addToDatabase'));
			add_action('wp_ajax_ctWaitlist_remove_subscription', array($this, 'removeSubscription'));
			add_action('wp_ajax_nopriv_ctWaitlist_remove_subscription', array($this, 'removeSubscription'));
			add_action('wp_enqueue_scripts', array($this, 'enqueueAjaxScript'));
			add_action('woocommerce_after_my_account', array($this, 'unsubscribeAfterMyAccount'));
			add_filter('wp_mail_from_name', array($this, 'changeWpFromName'));
			add_filter('wp_mail_from', array($this, 'changeWpFromAddress'));
			add_action('woocommerce_thankyou', array($this, 'userBoughtSubscibed'));
			add_action('wp_head', array($this, 'customCss'));
			add_shortcode('ctwaitlist_subscriptions',array($this,'ctWaitlistShortcode'));


	}
	public function ctWaitlistShortcode(){
		if(class_exists('WooCommerce')) {
			if (is_user_logged_in()) {
				$unsubscribeButtonText = ctWaitlistOptions::getOption('ctWaitlist_unsubscribe_button_text');
				$removedMessage = ctWaitlistOptions::getOption('ctWaitlist_remove_from_waitlist');
				global $wpdb, $current_user;
				$results = $wpdb->get_results($wpdb->prepare("SELECT * FROM " . $wpdb->prefix . $this->getPluginDomain() . " WHERE email=%s AND notified = %d", $current_user->user_email, 0));
				if ($results) {
					echo '<div class="container">';
					echo '<div class="ct-waitlist-aftermyaccount table-responsive" style="padding-top:40px;padding-bottom:40px"><h3 class="ct-waitlist-header">';
					echo '<input type="hidden" id="ct-waitlist-unsubscribe-button" value="' . $unsubscribeButtonText . '"/>';
					echo '<input type="hidden" id="ct-waitlist-removed-message" value="' . $removedMessage . '"/>';
					_e('My Waitlist Subscriptions', 'ct_waitlist');
					echo '</h3>';
					?>
					<table class="shop-table my-account-orders" style="margin-bottom:20px; width:100%;">
						<thead>
						<tr>
							<th class="order-number">
								<span class="nobr"><?php _e('Product Name', 'ct_waitlist'); ?></span>
							</th>
							<th class="order-number">
								<span class="nobr"><?php _e('Price', 'ct_waitlist'); ?></span>
							</th>
							<th class="order-number">
								<span class="nobr"><?php _e('Picture', 'ct_waitlist'); ?></span>
							</th>
							<th class="order-number">
								<span class="nobr"><?php _e('Subscription date', 'ct_waitlist'); ?></span>
							</th>
							<th class="order-number">
							</th>
						</tr>
						</thead>
						<tbody>
						<?php foreach ($results as $result) { ?>

							<tr class="order">
								<td>
									<a href="<?php echo esc_url(get_permalink($result->productId)); ?>">
										<?php
										if ($result->variationId != 0) {
											echo get_the_title($result->productId) . '&nbsp' . __('with variation: ', 'ct_waitlist') . $this->displayVariationName($result->variationId);
										} else {
											echo get_the_title($result->productId);
										}
										?>
									</a>
								</td>

								<td>
									<?php
									if ($result->variationId != 0) {
										echo get_post_meta($result->variationId, '_price', true) . get_woocommerce_currency_symbol();
									} else {
										echo get_post_meta($result->productId, '_price', true) . get_woocommerce_currency_symbol();
									}
									?>
								</td>
								<td>

									<a href="<?php echo esc_url(get_permalink($result->productId)); ?>">
										<?php
										if (has_post_thumbnail($result->productId)) {
											$image = wp_get_attachment_image_src(get_post_thumbnail_id($result->productId), 'single-post-thumbnail');
											$src = $image[0];
										} else {
											$src = esc_url(plugins_url('/assets/images/placeholder.png', __FILE__));
										}
										?>
										<img src="<?php echo $src; ?>" alt="Placeholder" width="40" height="40"
											 style="display:table; margin:0 auto;"
											 class="woocommerce-placeholder wp-post-image">
									</a>

								</td>

								<td>
									<?php
									echo _e('Added: ', 'ct_waitlist') . $result->date;
									?>
								</td>

								<td>
									<input type="hidden" value="<?php echo $result->id ?>"/>
									<button style="float:right;"
											class="single_add_to_cart_button button btn btn-primary ct-waitlist-remove-my-account-button"><?php echo ctWaitlistOptions::getOption('ctWaitlist_unsubscribe_button_text'); ?></button>
								</td>
							</tr>
						<?php } ?>
						</tbody>
					</table>
					<?php
					echo '</div>';
					echo '</div>';
				} else {
					echo '<div class="container">';
					echo '<div class="ct-waitlist-aftermyaccount table-responsive" style="padding-top:40px;padding-bottom:40px"><h3>';
					echo '<h3 class="ct-waitlist-header">' . _e('You have no active waitlist subscriptions', 'ct_waitlist') . '</h3>';
					echo '</div>';
					echo '</div>';
				}
			} else {
				echo '<div class="container">';
				echo '<div class="ct-waitlist-aftermyaccount table-responsive" style="padding-top:40px;padding-bottom:40px"><h3 class="ct-waitlist-header">';
				echo '<a href="' . wp_login_url() . '">' . __('Log in', 'ct_waitlist') . '</a>' . __(' to view your waitlist subscriptions', 'ct_waitlist');
				echo '</h3>';
				echo '</div>';
				echo '</div>';
			}
		}

	}
	/**
	 * Adding custom css
	 */
	public function customCss(){
		if (class_exists('WooCommerce')){
			if (is_product()) {
				$customCss = ctWaitlistOptions::getOption('ctWaitlist_custom_css') ? trim(ctWaitlistOptions::getOption('ctWaitlist_custom_css')) : '';
				if ($customCss != "") {
					$display = "<style type='text/css'>" . $customCss . "</style>";
					echo $display;
				}
			}
		}
	}

    /**
     * @param $userEmail
     * @param $productId
     * @param $varId
     */
	public function sendAdminNotification($userEmail,$productId,$varId = null){
		$adminMail = get_option('woocommerce_email_from_address');
		$confirmSubject = ctWaitlistOptions::getOption('ctWaitlist_admin_topic_on_add');
		$confirmSubject = $this->replaceShortcodes($confirmSubject, $productId, $userEmail,$varId);
		$confirmBody = ctWaitlistOptions::getOption('ctWaitlist_admin_body_on_add');
		$confirmBody = $this->replaceShortcodes($confirmBody, $productId, $userEmail,$varId);
		$this->setHeader($confirmSubject);
		$useWooTemplate = ctWaitlistOptions::getOption('ctWaitlist_use_woo_template');
		$this->setSenderFromName($this->replaceShortcodes(ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_name') == '' ? get_option('woocommerce_email_from_name') : ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_name'), $productId));
		$this->setSenderFromAddress($this->replaceShortcodes(ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_address') == '' ? get_option('woocommerce_email_from_address') : ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_address') ,$productId ));
		$message = $useWooTemplate ? $this->getMailTemplate($confirmBody, $type = 'confirm') : $confirmBody;
		$headers = $this->getHeaders();
		wp_mail( $adminMail, $confirmSubject, $message, $headers, $attachments = null );
	}

    /**
     * @param $userEmail
     * @param $productId
     * @param null $varId
     */
	public function sendAdminNotificationOnSubscribedBuy($userEmail,$productId,$varId = null){
		$adminMail = get_option('woocommerce_email_from_address');
		$confirmSubject = ctWaitlistOptions::getOption('ctWaitlist_admin_topic_on_buy');
		$confirmSubject = $this->replaceShortcodes($confirmSubject, $productId, $userEmail,$varId);
		$confirmBody = ctWaitlistOptions::getOption('ctWaitlist_admin_body_on_buy');
		$confirmBody = $this->replaceShortcodes($confirmBody, $productId, $userEmail,$varId);
		$this->setHeader($confirmSubject);
		$useWooTemplate = ctWaitlistOptions::getOption('ctWaitlist_use_woo_template');
		$this->setSenderFromName($this->replaceShortcodes(ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_name') == '' ? get_option('woocommerce_email_from_name') : ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_name'), $productId));
		$this->setSenderFromAddress($this->replaceShortcodes(ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_address') == '' ? get_option('woocommerce_email_from_address') : ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_address') ,$productId ));
		$message = $useWooTemplate ? $this->getMailTemplate($confirmBody, $type = 'confirm') : $confirmBody;
		$headers = $this->getHeaders();
		wp_mail( $adminMail, $confirmSubject, $message, $headers, $attachments = null );
	}

    /**
     * @param $userEmail
     * @param $productId
     * @param null $varId
     */
	public function sendAdminNotificationOnSubscriberNotify($userEmail, $productId, $varId = null){
		$adminMail = get_option('woocommerce_email_from_address');
		$confirmSubject = ctWaitlistOptions::getOption('ctWaitlist_admin_topic_on_notify');
		$confirmSubject = $this->replaceShortcodes($confirmSubject, $productId, $userEmail, $varId);
		$confirmBody = ctWaitlistOptions::getOption('ctWaitlist_admin_body_on_notify');
		$confirmBody = $this->replaceShortcodes($confirmBody, $productId, $userEmail, $varId);
		$this->setHeader($confirmSubject);
		$useWooTemplate = ctWaitlistOptions::getOption('ctWaitlist_use_woo_template');
		$this->setSenderFromName($this->replaceShortcodes(ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_name') == '' ? get_option('woocommerce_email_from_name') : ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_name'), $productId));
		$this->setSenderFromAddress($this->replaceShortcodes(ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_address') == '' ? get_option('woocommerce_email_from_address') : ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_address') ,$productId ));
		$message = $useWooTemplate ? $this->getMailTemplate($confirmBody, $type = 'confirm') : $confirmBody;
		$headers = $this->getHeaders();
		wp_mail( $adminMail, $confirmSubject, $message, $headers, $attachments = null );
	}
	/**
	 * Updates database bought column and sends admin mail
	 * @param $pid
	 * @param $email
	 */
	public function updateBought($pid,$email){
		global $wpdb;
		$tableName = $wpdb->prefix . $this->getPluginDomain();
		$results = $wpdb->get_results("SELECT * FROM " . $tableName . " WHERE email='" . $email . "' AND notified <> 0 AND bought = 0");
		foreach ($results as $res) {
			if ($res->productId == $pid) {
				$wpdb->update($tableName,
					array('bought' => current_time('mysql', 1)),
					array('email' => $email,
						'productId' => $pid),
					array('%s'),
					array('%d',
						'%d'));
					if(ctWaitlistOptions::getOption('ctWaitlist_admin_send_on_buy')) {
						$this->sendAdminNotificationOnSubscribedBuy($email, $res->productId);
					}
				} elseif (($res->variationId == $pid)) {
					$wpdb->update($tableName,
					array('bought' => current_time('mysql', 1)),
					array('email' => $email,
						'variationId' => $pid),
					array('%s'),
					array('%d',
						'%d'));
					if(ctWaitlistOptions::getOption('ctWaitlist_admin_send_on_buy')) {
						$this->sendAdminNotificationOnSubscribedBuy($email, $res->productId,$res->variationId);
					}
				}
		}
	}
	/**
	 *
	 * Woocommerce after thank you hook
	 * @param $order
	 */
	public function userBoughtSubscibed($order)	{
		$order = new WC_Order($order);
		$items = $order ? $order->get_items() : '';
		$user = $order->get_user();
		$email = $user ? $user->user_email : '';
		foreach ($items as $item) {
			if ($item['variation_id'] != '0') {
				$pid = $item['variation_id'];
				$this->updateBought($pid,$email);

			} else {
				$pid = $item['product_id'];
				$this->updateBought($pid,$email);

			}
		}
	}
	/**
	 * Ajax call - remove subscription
	 */
	public function removeSubscription(){
		$id = isset($_POST['id']) ? $_POST['id'] : '';
		$email = !empty($_POST['email']) ? $_POST['email'] : '' ;
		global $wpdb;
		if($id === 'all')
		{
			global $current_user;
			$wpdb->delete($wpdb->prefix . $this->getPluginDomain(), array('email' => $current_user->user_email,
				'notified' => 0),
				array('%d','%d')
			);
		} elseif($id != '') {
			if ((!empty($email)) && $email != '') {
				$wpdb->delete($wpdb->prefix . $this->getPluginDomain(), array( 'variationId' => $id, 'email' => $email, 'notified' => 0),
					array('%d','%s','%d'));
			} else {
				$wpdb->delete($wpdb->prefix . $this->getPluginDomain(), array('id' => $id, 'notified' => 0),
					array('%d','%d'));
			}
		}
	}

    /**
     * @param $string
     * @param $post_ID
     * @param null $userEmail
     * @param null $varId
     * @return string
     */
	public function replaceShortcodes($string, $post_ID, $userEmail = null, $varId = null){

        if($varId) {
            $variation = $this->displayVariationName($varId);
        } else {
            $variation = '';
        }

		$src = wp_get_attachment_image_src( get_post_thumbnail_id ( $post_ID ) );
		$productPageLink = '<a href="' . esc_url( get_permalink( $post_ID ) ) .'">' . esc_html( get_the_title( $post_ID ) ) . '</a>';
		$thumbnail = $src ? '<img src="' . esc_url($src[0])  .'"/>' : '';
		$userEmail = $userEmail != '' ? $userEmail : '';
		$price = get_post_meta($post_ID,'_price',true).get_woocommerce_currency_symbol() != '' ? get_post_meta($post_ID,'_price',true).get_woocommerce_currency_symbol() : '';
		$productName = get_the_title( $post_ID,true) != '' ? get_the_title( $post_ID,true) : '';
		$string = strtr($string, array(
			'$productName$' =>  $productName ,
			'$price$' => $price,
			'$siteTitle$' => get_bloginfo('name'),
			'$stockAmount$' => intval(get_post_meta($post_ID,'_stock',true)),
			'$productPage$' => $productPageLink,
			'$thumbnail$' => $thumbnail,
			'$userEmail$' => $userEmail,
            '$variation$' => $variation
		));
		return ucfirst($string);
	}

	/**
	 * wp from options
	 *
	 * @return mixed|void
	 */
	public function changeWpFromName(){
		if(ctWaitlistOptions::getOption('ctWaitlist_use_custom_from') == 'on'){
			return $this->getSenderFromName();
		} else {
			return get_option('woocommerce_email_from_name');
		}
	}
	public function changeWpFromAddress()	{
		if( ctWaitlistOptions::getOption( 'ctWaitlist_use_custom_from' ) == 'on' ) {
			return $this->getSenderFromAddress();
		} else {
			return get_option('woocommerce_email_from_address');
		}
	}
	/**
	 * MyAccount Page display
	 */
	public function unsubscribeAfterMyAccount(){
		if( ctWaitlistOptions::getOption('ctWaitlist_select_unsubscribe_page') == 1 ||  ctWaitlistOptions::getOption('ctWaitlist_select_unsubscribe_page') == 3) {
			$unsubscribeButtonText = ctWaitlistOptions::getOption('ctWaitlist_unsubscribe_button_text');
			$removedMessage = ctWaitlistOptions::getOption('ctWaitlist_remove_from_waitlist');
			global $wpdb, $current_user;
			$results = $wpdb->get_results("SELECT * FROM " . $wpdb->prefix . $this->getPluginDomain() . " WHERE email='" . $current_user->user_email . "' AND notified = 0");
			if ($results) {
				echo '<div class="ct-waitlist-aftermyaccount table-responsive"><h3>';
				echo '<input type="hidden" id="ct-waitlist-unsubscribe-button" value="'.$unsubscribeButtonText.'"/>';
				echo '<input type="hidden" id="ct-waitlist-removed-message" value="'.$removedMessage.'"/>';
				_e('My Waitlist Subscriptions', 'ct_waitlist');
				echo '</h3>';
				?>
				<table class="shop-table my-account-orders" style="margin-bottom:20px; width:100%;">
					<thead>
						<tr>
							<th class="order-number">
								<span class="nobr"><?php _e('Product Name','ct_waitlist');?></span>
							</th>

							<th class="order-number">
								<span class="nobr"><?php _e('Price','ct_waitlist');?></span>
							</th>
                            <th class="order-number">
                                <span class="nobr"><?php _e('Picture','ct_waitlist');?></span>
                            </th>
							<th class="order-number">
								<span class="nobr"><?php _e('Subscription date','ct_waitlist');?></span>
							</th>

                            <th class="order-number">

                            </th>
						</tr>
					</thead>
					<tbody>
						<?php foreach($results as $result){ ?>

						<tr class="order">
							<td>
                                <a href="<?php echo esc_url(get_permalink($result->productId));?>">
								<?php
								if ($result->variationId != 0) {
									echo get_the_title($result->productId) . '&nbsp' . __('with variation: ', 'ct_waitlist') . $this->displayVariationName($result->variationId);
								} else {
									echo get_the_title($result->productId);
								}
								?>
                                </a>
							</td>

							<td>
								<?php
								if ($result->variationId != 0) {
									echo get_post_meta($result->variationId,'_price',true).get_woocommerce_currency_symbol();
								} else {
									echo get_post_meta($result->productId,'_price',true).get_woocommerce_currency_symbol();
								}
								?>
							</td>
                            <td>

                                <a href="<?php echo esc_url(get_permalink($result->productId));?>">
                                    <?php
                                    if (has_post_thumbnail( $result->productId ) ) {
                                        $image = wp_get_attachment_image_src(get_post_thumbnail_id($result->productId), 'single-post-thumbnail');
                                        $src = $image[0];
                                    } else {
                                        $src = esc_url(plugins_url('/assets/images/placeholder.png',__FILE__));
                                    }
                                    ?>
                                    <img src="<?php echo $src;?>" alt="Placeholder" width="40" height="40" style="display:table; margin:0 auto;"class="woocommerce-placeholder wp-post-image">
                                </a>

                            </td>

							<td>
								<?php
								echo _e('Added: ','ct_waitlist').$result->date;
								?>
							</td>

                            <td>
                                <input type="hidden" value="<?php echo $result->id ?>"/>
                                <button style="float:right;" class="single_add_to_cart_button button btn btn-primary ct-waitlist-remove-my-account-button"><?php echo ctWaitlistOptions::getOption('ctWaitlist_unsubscribe_button_text'); ?></button>
                            </td>
						</tr>
						<?php } ?>
					</tbody>
				</table>
				<?php
				echo '</div>';
			}
		}
	}

	/**
	 * Returns html email with body
	 * @param $body
	 * @param $type
	 * @return string
	 */
	public function getMailTemplate($body, $type){
		return $this->getContentHtml($type) . $body . $this->getContentHtmlFooter();
	}

	/**
	 * Sets header to content html
	 * @return array
	 */
	public function getHeaders(){
		return $headers = array('Content-Type: text/html; charset=UTF-8');
	}

	/**
	 * WooCommerce email header
	 * @param $type
	 * @return string
	 */
	public function getContentHtml($type) {
		if($type === 'confirm'){
			($this->getHeader() == '') ? $this->setHeader(ctWaitlistOptions::getOption('ctWaitlist_added_to_waitlist_email_topic')) : '' ;
		}
		else {
			($this->getHeader() == '') ? $this->setHeader(ctWaitlistOptions::getOption('ctWaitlist_mail_subject')) : '' ;
		}
		ob_start();
		wc_get_template( 'emails/email-header.php', array(
			'order' 		=> '',
			'email_heading' => $this->getHeader(),
			'sent_to_admin' => false,
			'plain_text'    => false
		) );
		return ob_get_clean();
	}

	/**
	 * WooCommerce email footer
	 * @return string
	 */
	public function getContentHtmlFooter() {
		ob_start();
		wc_get_template( 'emails/email-footer.php', array(
			'order' 		=> '',
			'email_heading' => '',
			'sent_to_admin' => false,
			'plain_text'    => false

		) );
		return ob_get_clean();
	}

	/**
	 * Return variations attributes
	 * @param $id
	 * @return string
	 */
	public function displayVariationName($id)
	{
		$variationsDisplay = array();
		$variationsMeta = get_post_meta($id);
		if($variationsMeta){
			foreach($variationsMeta as $x => $y) {
				if (strpos($x, "attribute_") === 0) {
					$variationsDisplay[] = ucfirst($y[0]);
				}
			}
			$returnData = implode(',  ', $variationsDisplay);
			return $returnData;
		}
		return '';
	}



	public function doEntry($email, $productId, $variationId, $groupedId){
		global $wpdb;
		$tableName = $wpdb->prefix.$this->getPluginDomain();
		$sql = $wpdb->prepare(
			" INSERT INTO $tableName
 						(email, productId, variationId, grouped_parentId, date)
 						VALUES (%s, %d, %d, %d, %s )",
			$email, $productId, $variationId, $groupedId, current_time('mysql', 1));
		$wpdb->query($sql);


	}
	public function sendSuccessEmail($email, $productId, $varId = null){
		$confirmSubject = ctWaitlistOptions::getOption('ctWaitlist_added_to_waitlist_email_topic');
		$confirmSubject = $this->replaceShortcodes($confirmSubject, $productId,null, $varId);
		$confirmBody = ctWaitlistOptions::getOption('ctWaitlist_added_to_waitlist_email_body');
		$confirmBody = $this->replaceShortcodes($confirmBody, $productId, null,$varId);
		$this->setHeader($confirmSubject);
		$useWooTemplate = ctWaitlistOptions::getOption('ctWaitlist_use_woo_template');
		$this->setSenderFromName($this->replaceShortcodes(ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_name') == '' ? get_option('woocommerce_email_from_name') : ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_name'), $productId));
		$this->setSenderFromAddress($this->replaceShortcodes(ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_address') == '' ? get_option('woocommerce_email_from_address') : ctWaitlistOptions::getOption('ctWaitlist_mail_sender_from_address') ,$productId ));
		$message = $useWooTemplate ? $this->getMailTemplate($confirmBody, $type = 'confirm') : $confirmBody;
		$headers = $this->getHeaders();
		wp_mail( $email, $confirmSubject, $message, $headers, $attachments = null );
	}

	/**
	 * Ajax call for subscriptions
	 */
	public function addToDatabase(){
		$productId = isset($_POST['prodid']) ? $_POST['prodid'] : '';
		$variationId = isset($_POST['variationid']) ? $_POST['variationid'] : '';
		$groupedId = isset($_POST['parentid']) ? $_POST['parentid'] : '';
		$email = isset($_POST['email']) ? strtolower($_POST['email'])  : '';

		$sendSubscriptionSuccessEmail = ctWaitlistOptions::getOption('ctWaitlist_send_subscription_success_email');
		$notifyAdmin = ctWaitlistOptions::getOption('ctWaitlist_admin_notifications') == 'on' ? 1 : 0;

		if(!filter_var($email,FILTER_VALIDATE_EMAIL) === false) {
			global $wpdb;
			if (empty($variationId)) {

				$result = $wpdb->get_results("SELECT * FROM " . $wpdb->prefix . $this->getPluginDomain() . " WHERE email = '" . $email . "' AND productId = '" . $productId . "' AND notified = 0");
				if (count($result) == 0) {

					$this->doEntry($email, $productId, $variationId, $groupedId);

					if ($sendSubscriptionSuccessEmail) {

						$this->sendSuccessEmail($email,$productId);

						}
					if ($notifyAdmin == 1) {

						$this->sendAdminNotification($email,$productId);

					}
				}
			} elseif ($groupedId != 0) {

				$result = $wpdb->get_results("SELECT * FROM " . $wpdb->prefix . $this->getPluginDomain() . " WHERE email = '" . $email . "' AND productId = '" . $productId . "' AND grouped_parentId = '" . $groupedId . "'  AND notified = 0");
				if (count($result) == 0) {

					$this->doEntry($email, $productId, $variationId, $groupedId);

					if ($sendSubscriptionSuccessEmail) {
						$this->sendSuccessEmail($email, $productId);
					}
					if ($notifyAdmin == 1) {
						$this->sendAdminNotification($email,$productId);
					}
				}
			} else {

				$result = $wpdb->get_results("SELECT * FROM " . $wpdb->prefix . $this->getPluginDomain() . " WHERE email = '" . $email . "' AND productId = '" . $productId . "' AND variationId = '" . $variationId . "'  AND notified = 0");
				if (count($result) == 0) {

					$this->doEntry($email, $productId, $variationId, $groupedId);

					if ($sendSubscriptionSuccessEmail) {

						$this->sendSuccessEmail($email,$productId,$variationId);

					}
					if ($notifyAdmin == 1) {

						$this->sendAdminNotification($email,$productId,$variationId);

					}
				}
			}
		}

	}

	/**
	 * Sends back in stock email
	 * @param $to
	 * @param $subject
	 * @param $message
	 * @param $headers
	 * @param $attachments
	 * @return bool
	 */
	public function sendConfirmMail($to, $subject, $message, $headers, $attachments){
		return wp_mail( $to, $subject, $message, $headers, $attachments );
	}

	/**
	 * WooCommerce hook
	 *
	 * @param $availability
	 * @param $_product
	 */
	public function checkAvailability( $availability, $_product ){
		global $product,$wp_query;
		$isGrouped = false;
		$isDisabledSubscription = false;
		if(get_post_meta( $_product->id , '_disabled_subscription' , true ) == "on" ) {
			$isDisabledSubscription = true;
		}
		if($isDisabledSubscription){
			return $availability;
		}
		if (!$_product->is_in_stock()) {
			$unsubPage = intval(ctWaitlistOptions::getOption('ctWaitlist_select_unsubscribe_page'));
			$subscribeMessage = ctWaitlistOptions::getOption('ctWaitlist_subscribe_message') != '' ?  ctWaitlistOptions::getOption('ctWaitlist_subscribe_message') : '';
			$simpleAlreadySubscribed = ctWaitlistOptions::getOption('ctWaitlist_already_subscribed_message') != '' ? ctWaitlistOptions::getOption('ctWaitlist_already_subscribed_message') : '' ;
			$variableAlreadySubscribed = ctWaitlistOptions::getOption('ctWaitlist_var_already_subscribed_message') != '' ? ctWaitlistOptions::getOption('ctWaitlist_var_already_subscribed_message') : '' ;
			$productOosmessage = ctWaitlistOptions::getOption('ctWaitlist_oos_message');
			$variableOosMessage = ctWaitlistOptions::getOption('ctWaitlist_var_oos_message');
			$buttonText = ctWaitlistOptions::getOption('ctWaitlist_button_text');
			$unsubButtonText = ctWaitlistOptions::getOption('ctWaitlist_unsubscribe_button_text');
			$isVariable = $product->is_type('variable');
			$isSimple = $product->is_type('simple');
			$removedFromWaitlistNotification = ctWaitlistOptions::getOption('ctWaitlist_remove_from_waitlist');
			$subscriptionSuccessMessage = ctWaitlistOptions::getOption('ctWaitlist_subscription_succes_message');
            $style = ctWaitlistOptions::getOption('ctWaitlist_front_style');
            $placeholder = ctWaitlistOptions::getOption('ctWaitlist_placeholder_email');



			if($_product->post->post_parent == $wp_query->queried_object->ID){
				$isGrouped = true;
			}
			if($isSimple && !$isGrouped){
				$frontForm = '<div class="ct-waitlist-content">';
				?>
				<input type="hidden" id="ct-waitlist-productid" value="<?php echo $_product->id; ?>" name="productid" />
				<input type="hidden" id="ct-waitlist-user-logged-in" value="<?php echo is_user_logged_in();?>"/>
				<input type="hidden" id="ct-waitlist-subscriptionsuccess" value="<?php echo $subscriptionSuccessMessage;?>"/>
				<input type="hidden" id="ct-waitlist-removed-message" value="<?php echo $removedFromWaitlistNotification ;?>"/>
				<?php
				if ($_product->post->post_parent) {
					?>
					<input type="hidden" id="ct-waitlist-out-of-stock-parent-id" value="<?php echo $_product->post->post_parent; ?>"/>
					<?php
				}
				$frontForm .= '<p class="stock out-of-stock">' . $productOosmessage . '</p>';
				$frontForm .= '<div>';
				if (is_user_logged_in()) {
					global $current_user, $wpdb;
					$frontForm .= '<input type="hidden" value="' . $current_user->user_email . '" name="waitlistemail" id="ct-waitlist-email"/>';
					$sql = "SELECT id FROM " . $wpdb->prefix . $this->getPluginDomain() . " WHERE email = '" . $current_user->user_email . "' AND productId = '" . get_the_ID() . "' AND notified = 0";
					$res = $wpdb->get_row($sql);
					if ($res) {
                        if($style != 1) {
                            $frontForm .= '<p class="ct-waitlist-notification">' . $simpleAlreadySubscribed . '</p>';
                            if ($unsubPage == 2 || $unsubPage == 3) {
                                $frontForm .= '<button type="button" class="single_add_to_cart_button btn btn-primary button ct-waitlist-remove-button">' . $unsubButtonText . '</button>';
                                $frontForm .= '<input type="hidden" name="ct-waitlist-to-remove-id"  value="' . $res->id . '">';
                            }
                        } else {
                            if ($unsubPage == 2 || $unsubPage == 3) {
                                $frontForm .= '<button type="button" class="single_add_to_cart_button btn btn-primary button ct-waitlist-remove-button">' . $unsubButtonText . '</button>';
                                $frontForm .= '<input type="hidden" name="ct-waitlist-to-remove-id"  value="' . $res->id . '">';
                            }
                        }
					}else {
                        if ($style != 1){
                            $frontForm .= '<p class="ct-waitlist-notification">' . $subscribeMessage . '</p>';
                            $frontForm .= '<button type="button" class="single_add_to_cart_button btn btn-primary button ct-waitlist-add-button">' . $buttonText . '</button>';
                        } else {
                            $frontForm .= '<button type="button" class="single_add_to_cart_button btn btn-primary button ct-waitlist-add-button">' . $buttonText . '</button>';
                        }
					}
				} else {
                    if($style != 1) {
                        $frontForm .= '<p class="ct-waitlist-notification">' . $subscribeMessage . '</p>';
                        $frontForm .= '<p><input type="text" class="ct-waitlist-input-email form-control" placeholder="'.$placeholder.'" id="ct-waitlist-email"/></p>';
                        $frontForm .= '<button type="button" class="single_add_to_cart_button button btn btn-primary ct-waitlist-add-button">' . $buttonText . '</button>';
                    } elseif($style == 1 ) {
                        $frontForm .= '<input type="text" style="width:70%; display:inline; float:left; " class="ct-waitlist-input-email form-control" placeholder="'.$placeholder.'" id="ct-waitlist-email"/>';
                        $frontForm .= '<button type="button" style="width:30%; display:inline " class="single_add_to_cart_button button btn btn-primary ct-waitlist-add-button">' . $buttonText . '</button>';

                    }
				}
				$frontForm .= '</div>';
				$frontForm .= '</div>';
				echo $frontForm;
				$this->setCounter(intval($this->getCounter()) + 1);
				remove_filter('woocommerce_get_availability', array($this, 'checkAvailability'));
				return;

			} elseif ($isVariable){

				$frontForm = $variableOosMessage;
					if ($this->getCounter() == 0) {
						$outOfStockType = 'variation';
						?>
						<input type="hidden" id="ct-waitlist-out-of-stock-type" value="<?php echo $outOfStockType;?>"/>
						<input type="hidden" id="ct-waitlist-productid" value="<?php echo $_product->post->ID;?>"/>
						<input type="hidden" id="ct-waitlist-user-logged-in" value="<?php echo is_user_logged_in();?>"/>
						<input type="hidden" id="ct-waitlist-subscriptionsuccess" value="<?php echo $subscriptionSuccessMessage;?>"/>
						<input type="hidden" id="ct-waitlist-subscribe-button" value="<?php echo $buttonText;?>"/>
						<input type="hidden" id="ct-waitlist-unsubscribe-button" value="<?php echo $unsubButtonText ;?>"/>
						<input type="hidden" id="ct-waitlist-variable-subscribed" value="<?php echo $variableAlreadySubscribed ;?>"/>
						<input type="hidden" id="ct-waitlist-notify-message" value="<?php echo $subscribeMessage ;?>"/>
						<input type="hidden" id="ct-waitlist-removed-message" value="<?php echo $removedFromWaitlistNotification ;?>"/>
						<input type="hidden" id="ct-waitlist-unsubscribe-page" value="<?php echo $unsubPage ;?>"/>
                        <input type="hidden" id="ct-waitlist-placeholder-text" value="<?php echo $placeholder;?>"/>
                        <input type="hidden" id="ct-waitlist-style" value="<?php echo $style;?>"/>
						<?php
						if (is_user_logged_in()) {
							global $current_user, $wpdb;
							?>
							<input type="hidden" id="ct-waitlist-email" value="<?php echo $current_user->user_email; ?>"/>
							<?php
							$sql = "SELECT * FROM " . $wpdb->prefix . $this->getPluginDomain() . " WHERE email = '" . $current_user->user_email . "' AND productId = '" . get_the_ID() . "' AND notified = 0";
							$res = $wpdb->get_results($sql);
							?>
							<div id="subbed"> <?php
							if ($res) {
									foreach ($res as $result) { ?>
										<input type="hidden" value="<?php echo $result->variationId; ?>"/>
									<?php }
							}?>
							</div>
							<?php
						} else {
							$frontForm = $variableOosMessage;
						}
					}
					$frontForm .= '<div class="ct-waitlist-content variations">';
					$frontForm .= '</div>';
				    ?>
					<?php
			} elseif ( $isGrouped ) {

				$outOfStockType = 'grouped';
				$frontForm = '<div class="ct-waitlist-content">';
				?>
				<input type="hidden" id="ct-waitlist-productid" value="<?php echo $_product->id; ?>"/>
				<input type="hidden" id="ct-waitlist-out-of-stock-parent-id" value="<?php echo $_product->post->post_parent; ?>"/>
				<input type="hidden" id="ct-waitlist-out-of-stock-type" value="<?php echo $outOfStockType; ?>"/>
				<input type="hidden" id="ct-waitlist-subscriptionsuccess" value="<?php echo $subscriptionSuccessMessage;?>"/>
				<input type="hidden" id="ct-waitlist-removed-message" value="<?php echo $removedFromWaitlistNotification ;?>"/>
				<?php
				$frontForm .= '<p class="stock out-of-stock">' . $productOosmessage . '</p><div>';
				if (is_user_logged_in()) {
					global $current_user, $wpdb;
					$sql = "SELECT * FROM " . $wpdb->prefix . $this->getPluginDomain() . " WHERE email = '" . $current_user->user_email . "' AND productId = '" . get_the_ID() . "' AND notified = 0";
					$res = $wpdb->get_results($sql);
					if ($res) {
                        if($style != 1) {
                            $frontForm .= '<p class="ct-waitlist-notification">' . $simpleAlreadySubscribed . '</p>';
                            if ($unsubPage == 2 || $unsubPage == 3) {
                                $frontForm .= '<button type="button" class="single_add_to_cart_button button btn btn-primary ct-waitlist-remove-button ct-waitlist-grouped-items">' . $unsubButtonText . '</button>';
                                $frontForm .= '<input type="hidden" name="ct-waitlist-to-remove-id"  value="' . $res[0]->id . '">';

                            }
                        } else {
                            if ($unsubPage == 2 || $unsubPage == 3) {
                                $frontForm .= '<button type="button" class="single_add_to_cart_button button btn btn-primary ct-waitlist-remove-button ct-waitlist-grouped-items">' . $unsubButtonText . '</button>';
                                $frontForm .= '<input type="hidden" name="ct-waitlist-to-remove-id"  value="' . $res[0]->id . '">';
                            }
                        }
					} else {
                        if($style != 1) {
                            $frontForm .= '<p class="ct-waitlist-notification">' . $subscribeMessage . '</p>';
                            $frontForm .= '<button type="button" class="single_add_to_cart_button button btn btn-primary ct-waitlist-add-button ct-waitlist-grouped-items" >' . $buttonText . '</button>';
                        } else {
                            $frontForm .= '<button type="button" class="single_add_to_cart_button button btn btn-primary ct-waitlist-grouped-items ct-waitlist-add-button" >' . $buttonText . '</button>';
                        }
					}
					$frontForm .= '<input type="hidden" value="' . $current_user->user_email . '" name="waitlistemail" id="ct-waitlist-email"/>';
				} else {

                    if($style != 1) {
                        $frontForm .= '<p class="notification" id="ct-waitlist-notification">' . $subscribeMessage . '</p>';
                        $frontForm .= '<p><input type="text" class="ct-waitlist-input-email form-control" placeholder="'.$placeholder.'" id="ct-waitlist-email"/></p>';
                        $frontForm .= '<button type="button" class="single_add_to_cart_button button btn btn-primary ct-waitlist-add-button">' . $buttonText . '</button>';
                    } elseif($style == 1 ) {
                        $frontForm .= '<input type="text" style="width:62%; display:inline; float:left;" class="ct-waitlist-input-email form-control" placeholder="'.$placeholder.'" id="ct-waitlist-email"/>';
                        $frontForm .= '<button type="button" style="width:38%; display:inline " class="single_add_to_cart_button button btn btn-primary ct-waitlist-add-button">' . $buttonText . '</button>';

                    }


				}
				$frontForm .= '</div></div>';
				echo $frontForm;
				$this->setCounter(intval($this->getCounter()) + 1);
				remove_filter('woocommerce_get_availability', array($this, 'checkAvailability'));
				return;
			}
			$availability['availability'] = $frontForm;
			$this->setCounter( intval( $this->getCounter() ) + 1 );
		}
		remove_filter( 'woocommerce_get_availability', array( $this, 'checkAvailability' ) );
		return $availability;
	}

	/**
	 * Scripts
	 */
	public function enqueueAjaxScript(){
        wp_enqueue_style( 'frontStyles' ,plugins_url('assets/css/front.css' ,  __FILE__ ) );
		wp_enqueue_script( 'jquery' );
		wp_enqueue_script( 'ajax-main' , plugins_url( 'assets/js/script.js' , __FILE__ ) );
		wp_localize_script( 'ajax-main', 'ctAjax',	array( 'adminAjaxUrl' => admin_url( 'admin-ajax.php' ) , 'text'  => array()));
	}

	/**
	 * Loading admin based on canView
	 */
	public function adminLoad(){

		if($this->canView()) {


			require_once(plugin_dir_path(__FILE__) . 'ctWaitlistAdmin.php');

		}

	}

	/**
	 * Activation callback
	 */
	public function onPluginActivate(){

			require_once(plugin_dir_path(__FILE__) . 'ctWaitlistActivate.php');

	}

	/**
	 * If shop manager can View
	 * @return bool
	 */
	public function canView(){

		$canView = false;
		if(is_user_logged_in()){
			global $current_user, $wpdb;
			$allowedSettings = array( "administrator" );
			$enableToManager = ctWaitlistOptions::getOption('ctWaitlist_enable_shop_manager') == 'on' ? true : false ;
			if( $enableToManager ){
				$allowedSettings[] = "shop_manager";
			}
			$user = get_userdata( $current_user->ID );
			$capabilities = $user->{$wpdb->prefix . 'capabilities'};
			if ( !isset( $wp_roles ) ){
				$wp_roles = new WP_Roles();
			}
			foreach ( $wp_roles->role_names as $role => $name ){
				if(is_array($capabilities)) {
					if (array_key_exists($role, $capabilities)) {

						if (!$canView && in_array($role, $allowedSettings)) {
							$canView = true;
							return $canView;
						}
					}
				}
			}
		}
	}
}


new ctWaitlist();

class ctWaitlistOptions{
	protected static $optionTableName = 'ctWaitlist_options';
	protected static $options = array(
		'ctWaitlist_subscribe_message' => 'Subscribe to waitlist',
		'ctWaitlist_button_text' => 'Add to waitlist',
		'ctWaitlist_unsubscribe_button_text' => 'Remove from waitlist',
		'ctWaitlist_oos_message' => 'Item out of stock',
		'ctWaitlist_remove_from_waitlist' => 'Removed from waitlist',
		'ctWaitlist_var_oos_message' => 'Variable items variation out of stock',
		'ctWaitlist_subscription_succes_message' => 'Subscription success!',
		'ctWaitlist_subscription_var_succes_message' => 'Variable item subscription success',
		'ctWaitlist_already_subscribed_message' => 'You have subscirbed this product already',
		'ctWaitlist_var_already_subscribed_message' => 'You have subscirbed this variable product already',
		'ctWaitlist_amount_to_send_back_in_stock_email' => '0',
		'ctWaitlist_select_unsubscribe_page' => '0',
		'ctWaitlist_enable_shop_manager' => '0',
		'ctWaitlist_remove_data_on_delete' => '0',
		'ctWaitlist_use_custom_from' => '0',
		'ctWaitlist_mail_sender_from_name' => '',
		'ctWaitlist_mail_sender_from_address' => '',
		'ctWaitlist_mail_subject' => 'Your product is back',
		'ctWaitlist_back_in_stock_email_content' => 'Product you are awaitin is in stock again',
		'ctWaitlist_send_subscription_success_email' => '0',
		'ctWaitlist_added_to_waitlist_email_body' => 'You have added $productName$ to your waitlist',
		'ctWaitlist_added_to_waitlist_email_topic' => 'You have added $productName$ to your waitlist',
		'ctWaitlist_use_woo_template' => 'on',
		'ctWaitlist_add_disable_option_to_product_page' => 'on',
		'ctWaitlist_custom_css' => '.ct-waitlist-content p{ }',
		'ctWaitlist_use_custom_css' => '0',
		'ctWaitlist_admin_send_on_notify' => 'on',
		'ctWaitlist_admin_topic_on_notify' => 'Subscriber notified',
		'ctWaitlist_admin_body_on_notify' => 'Subscriber notified',
		'ctWaitlist_admin_send_on_buy' => 'on',
		'ctWaitlist_admin_topic_on_buy' => 'Subscribed item bought',
		'ctWaitlist_admin_body_on_buy' => 'Subscribed item bought',
		'ctWaitlist_admin_notifications' => 'on',
		'ctWaitlist_admin_topic_on_add' => 'Sbubscriber added to db',
		'ctWaitlist_admin_body_on_add' => 'Sbubscriber added to db',
        'ctWaitlist_use_postpone' => 'on',
        'ctWaitlist_front_style' => '1',
        'ctWaitlist_placeholder_email' => 'Email to notify...'
	);

	public static function getOption( $name, $default = null ){
		$optionsTable = get_option( self::$optionTableName );
		$optionsTable = shortcode_atts ( self::$options , $optionsTable );
		return isset( $optionsTable[$name] ) ? $optionsTable[$name] : $default;
	}

}

