<?php

/**
 * ctWaitlistActivate.php
 *
 * Class ctWaitlistActivate
 */

class ctWaitlistActivate{
    protected $pluginDomain;
    public function getPluginDomain(){
        return $this->pluginDomain;
    }
    public function setPluginDomain($value){
        $this->pluginDomain = $value;
    }
    public function __construct(){
        $this->setPluginDomain('ct_waitlist');
        $this->createDbTable();
        $this->optionsDefault();
        add_filter( 'plugin_action_links_' . plugin_basename(__FILE__), array($this,'addActionLinks'));
    }
    /**
     * Action Links
     * @param $links
     * @return array
     */
    public function addActionLinks($links){
        $waitlistActionLinks = array(
            '<a href="'.admin_url('options-general.php?page='.$this->getPluginDomain()).'">Settings</a>',
            '<a href="'.esc_url('www.createit.pl').'">'.__('More!','ct_waitlist').'</a>'
        );
        return array_merge($links,$waitlistActionLinks);
    }

    /**
     * Creating DB table on plugin activation
     */
    function createDbTable(){
        global $wpdb;
        require_once(ABSPATH.'wp-admin/includes/upgrade.php');

        $sql = "CREATE TABLE IF NOT EXISTS " . $wpdb->prefix .$this->getPluginDomain() . " (
						`id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
						`email` VARCHAR(80) NOT NULL,
						`productId` BIGINT(20) NOT NULL,
						`variationId`  BIGINT(20) NOT NULL DEFAULT 0,
						`grouped_parentId`  BIGINT(20) NOT NULL DEFAULT 0,
						`date` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
						`notified` TIMESTAMP NOT NULL DEFAULT 0,
                        `bought` TIMESTAMP NOT NULL DEFAULT 0,
                        `queued` TINYINT(1) DEFAULT 0,
						PRIMARY KEY (`id`)
					)";
        dbDelta( $sql );
    }

    /**
     * Setting default options on plugin activation
     */
    public function optionsDefault()
    {
        if (!get_option('ctWaitlist_options')) {
            $newOptions = array(
                'ctWaitlist_subscribe_message' => __('Notify me when this product is back.','ct_waitlist'),
                'ctWaitlist_button_text' => __('Subscribe','ct_waitlist'),
                'ctWaitlist_unsubscribe_button_text' => __('Remove from waitlist','ct_waitlist'),
                'ctWaitlist_remove_from_waitlist' => __('Removed from waitlist','ct_waitlist'),
                'ctWaitlist_oos_message' => __('Product is out of stock','ct_waitlist'),
                'ctWaitlist_var_oos_message' => __('This variation is out of stock','ct_waitlist'),
                'ctWaitlist_subscription_succes_message' => __('Subscription success!','ct_waitlist'),
                'ctWaitlist_subscription_var_succes_message' => __('Variation subscription success','ct_waitlist'),
                'ctWaitlist_already_subscribed_message' => __('You have already subscribed this product!','ct_waitlist'),
                'ctWaitlist_var_already_subscribed_message' => __('You have already subscribed this variation!','ct_waitlist'),
                'ctWaitlist_amount_to_send_back_in_stock_email' => '0',
                'ctWaitlist_select_unsubscribe_page' => '0',
                'ctWaitlist_enable_shop_manager' => 'on',
                'ctWaitlist_remove_data_on_delete' => '0',
                'ctWaitlist_use_custom_from' => '0',
                'ctWaitlist_mail_sender_from_name' => get_option('woocommerce_email_from_name'),
                'ctWaitlist_mail_sender_from_address' => get_option('woocommerce_email_from_address '),
                'ctWaitlist_mail_subject' => __('Subscribed product is back in stock!','ct_waitlist'),
                'ctWaitlist_back_in_stock_email_content' => __('$productName$ is in stock again!','ct_waitlist'),
                'ctWaitlist_send_subscription_success_email' => 'on',
                'ctWaitlist_added_to_waitlist_email_body' => __('$productName$ added to waitlist!','ct_waitlist'),
                'ctWaitlist_added_to_waitlist_email_topic' => __( 'You have added $productName$ to your waitlist. We will notify you when product will be back.','ct_waitlist'),
                'ctWaitlist_use_woo_template' => 'on',
                'ctWaitlist_add_disable_option_to_product_page' => 'on',
                'ctWaitlist_custom_css' => '.ct-waitlist-content p{ }',
                'ctWaitlist_use_custom_css' => '0',
                'ctWaitlist_admin_send_on_notify' => 'on',
                'ctWaitlist_admin_topic_on_notify' => __('$userEmail$ notified.','ct_waitlist'),
                'ctWaitlist_admin_body_on_notify' => __('Subscriber $userEmail$ notified about $productPage$ availability.','ct_waitlist'),
                'ctWaitlist_admin_send_on_buy' => 'on',
                'ctWaitlist_admin_topic_on_buy' => __('$userEmail$ bought subscribed item.','ct_waitlist'),
                'ctWaitlist_admin_body_on_buy' => __('$userEmail$ has bought subscribed $productName$. <br/> $productPage$ ','ct_waitlist'),
                'ctWaitlist_admin_notifications' => 'on',
                'ctWaitlist_admin_topic_on_add' => __('New subscription for $productName$!','ct_waitlist'),
                'ctWaitlist_admin_body_on_add' => __('$userEmail$ has added $productName$ to waitlist.','ct_waitlist'),
                'ctWaitlist_use_postpone' => 'on',
                'ctWaitlist_front_style' => 1,
                'ctWaitlist_placeholder_email' => 'Email to notify...'
                            );
            update_option('ctWaitlist_options', $newOptions);
        }
    }
}
new ctWaitlistActivate();