
<?php

wp_nonce_field( 'widget_area_manager_meta_nonce', 'widget_area_manager_meta_nonce' );

$this->_process_layout_areas();
$current_page_id = $this->get_current_page_id();

foreach ($this->layout_areas as $layout_area_id => $widget_area_area) {

    if (!$widget_area_area || !isset($widget_area_area['name'])) continue;

    $menu_id = 'sm' . $layout_area_id;
    $page_type = ucwords($this->get_current_page_type());

    $current_text = '';
    foreach ($widget_area_area['positions'] as $position_id => $position_data) {
        if($position_id == $widget_area_area['position']){
            $current_text = htmlspecialchars($position_data['name']);
        }
    }
    ?>

    <p><strong><?php echo htmlspecialchars($widget_area_area['name']);?></strong></p>
    <label class="screen-reader-text" for="widget_area_manager_<?php echo $layout_area_id;?>"><?php echo htmlspecialchars($widget_area_area['name']);?></label>
    <select name="widget_area_manager[<?php echo $layout_area_id;?>][position]" id="widget_area_manager_<?php echo $layout_area_id;?>">
        <optgroup label="Current setting:">
            <option value=""><?php echo $current_text;?></option>
        </optgroup>
    <?php
    // which positions this widget_area can be in?
    if (isset($widget_area_area['positions'])) {
        ?>
        <optgroup label="Change this page only">
        <?php
        foreach ($widget_area_area['positions'] as $position_id => $position_data) {
            ?>
            <option value="this:<?php echo $position_id;?>"><?php echo htmlspecialchars($position_data['name']);?> <?php echo $position_id == $widget_area_area['position'] ? ' (current)':'';?></option>
            <?php
        }
        ?>
        </optgroup>
        <optgroup label="Or change <?php echo htmlspecialchars($page_type);?> default">
        <?php
        foreach ($widget_area_area['positions'] as $position_id => $position_data) {
            // these are the default positions.
            ?>
            <option value="default:<?php echo $position_id;?>"><?php echo htmlspecialchars($position_data['name']);?> <?php echo $position_id == $widget_area_area['default_position'] ? ' (default)':'';?></option>
            <?php
        }
        ?>
        </optgroup>
        <?php
    }
    ?>
    </select>
    <?php
    // which widget_area to display on this page?
    if (count($this->widget_areas) > 1 && (!isset($widget_area_area['enable_widgets']) || $widget_area_area['enable_widgets'])) {
        $current_text = '';
        foreach ($this->widget_areas as $widget_area_id => $widget_area) {
            if($widget_area_id == $widget_area_area['widget_area']){
                $current_text = htmlspecialchars($widget_area['name']);
            }
        }
        ?>
        <select name="widget_area_manager[<?php echo $layout_area_id;?>][widgets]" id="widget_area_manager_<?php echo $layout_area_id;?>_w">
        <optgroup label="Current widget area:">
            <option value=""><?php echo $current_text;?></option>
        </optgroup>
        <?php
        ?>
        <optgroup label="Change this page only">
            <?php
            foreach ($this->widget_areas as $widget_area_id => $widget_area) {
                ?>
                <option value="this:<?php echo $widget_area_id;?>"><?php echo htmlspecialchars($widget_area['name']);?> <?php echo $widget_area_id == $widget_area_area['widget_area'] ? ' (current)':'';?></option>
                <?php
            }
            ?>
        </optgroup>
        <optgroup label="Or change <?php echo htmlspecialchars($page_type);?> default">
            <?php
            foreach ($this->widget_areas as $widget_area_id => $widget_area) {
                // these are the default positions.
                ?>
                <option value="default:<?php echo $widget_area_id;?>"><?php echo htmlspecialchars($widget_area['name']);?> <?php echo $widget_area_id == $widget_area_area['default_widget_area'] ? ' (default)':'';?></option>
                <?php
            }
            ?>
        </optgroup>
        <?php
    }
    ?>
    </select>
    <?php


}
?>