<?php
/*
	Plugin Name: Widget Area Manager
	Plugin URI: http://widget-area-manager-wordpress-plugin.dtbaker.net/
	Description: Allow a customer to select which widget_areas to display (or not) on a page
	Version: 1.55
	Author:  dtbaker
	Author URI: http://dtbaker.net
    Support: For all support please use http://dtbaker.net
    Date: April 1st 2013
    Text Domain: widget_area_manager

1.54 - fix for unserialize error when server returns 'no updates'
1.55 - added enable_widgets option
*/

define('_WIDGET_AREA_MANAGER_DEMO_MODE',false);
define('_WIDGET_AREA_MANAGER_DEMO_MODE_USER','demo');
define('_WIDGET_AREA_MANAGER_DEMO_MODE_PASS','demo1214');

load_plugin_textdomain('widget_area_manager', false, dirname( plugin_basename( __FILE__ ) ).'/i8n/');

if(_WIDGET_AREA_MANAGER_DEMO_MODE){
    add_filter('show_password_fields','dtbaker_show_password_fields');
    function dtbaker_show_password_fields(){
        return false;
    }
}

class widget_area_manager{

    public $widget_areas = array();
    public $layout_areas = array();
    private $_generate_string = '{WIDGETS}';
    private $_hook_string = 'HOOK'; // we can run a sidebar hook within a hook. tricky!
    private $_completed_hooks = array(); // stops infinite loops :)
    private $_current_string =  '';
    private $_group_widget_areas = false;
    private $_display_widget_area_string = false;

    /**
     * Constructor.
     * This sets up a list of our default values.
     *  - all the layout areas (ie: something that can hold widgets)
     *  - the options for those layout areas (position & which widget area to display
     *  - a list of available widget areas in the system.
     */
    function widget_area_manager() {
        $this->_current_string = '<strong>'.__( '(current)' , 'widget_area_manager').'</strong>';
        // todo: layout areas are restricted to different templates as well.
        $this->layout_areas = array();
        $this->widget_areas = array();
    }


    /**
     * Runs in the wordpress init hook
     * Sets up the admin bar at the top along with some javascript.
     * Only does this in the front end, not in the backend admin bar (new in 3.3)
     */
    function init(){

        /*register_post_type( 'widget_area_manager_layouts',
            array(
                'labels' => array(
                    'name' => __( 'Layout Areas' ),
                    'singular_name' => __( 'Layout Area' )
                ),
                'public' => true,
                'has_archive' => true,
            )
        );
        function change_columns( $cols ) {
            $cols = array(
                'cb'       => '<input type="checkbox" />',
                'url'      => __( 'Post Type',      'trans' ),
                'referrer' => __( 'Referrer', 'trans' ),
                'host'     => __( 'Host', 'trans' ),
            );
            return $cols;
        }
        add_filter( "manage_widget_area_manager_layouts_posts_columns", "change_columns" );*/



        if( !is_admin() ){ // if we're not in the admin area.
            if(_WIDGET_AREA_MANAGER_DEMO_MODE){
                if(!is_user_logged_in()){
                    if(isset($_REQUEST['demo_login'])){
                        $user = wp_authenticate(_WIDGET_AREA_MANAGER_DEMO_MODE_USER, _WIDGET_AREA_MANAGER_DEMO_MODE_PASS); // todo: change credentials to match demo user.
                        if(!isset($user->errors)){
                            $secure_cookie = '';
                            wp_set_auth_cookie($user->ID, true, $secure_cookie);
                            do_action('wp_login', _WIDGET_AREA_MANAGER_DEMO_MODE_USER);
                            $_SESSION['_wamanagerdemo_true']=$user->ID;
                            $_SESSION['_wamanagerdemo'] = array(
                                '_widget_area_manager_position_17_header' => 'pos_large',
                                    '_widget_area_manager_position_17_main' => 'pos_right',
                                    '_widget_area_manager_position_17_footer' => 'pos_content',
                                    '_widget_area_manager_area_17_footer' => 'homepage',
                                );
                            wp_redirect(get_home_url());
                        }
                    }
                }else{
                    show_admin_bar(true);
                }
            }
            // we check for a post back by this plugin
            $this->handle_postback();
            add_action('wp_before_admin_bar_render', array($this, "widget_area_manager_links"));
            wp_register_script( 'widget_area_manager_js', plugin_dir_url(__FILE__).'javascript.js?ver=2');
            wp_enqueue_script( 'jquery' );
            wp_enqueue_script( 'widget_area_manager_js' );
        }else{
            add_action( 'add_meta_boxes', array( $this, 'add_meta_box' ) );
            add_action( 'save_post', array($this, 'save_meta_box'));

        }


    }

    function add_meta_box() {

        $screens = array( 'post', 'page' );

        foreach ( $screens as $screen ) {
            add_meta_box(
                'widget_area_meta',
                __( 'Page Settings', 'widget_area_manager' ),
                array($this,'meta_box_callback'),
                $screen,
                'side'
            );
        }
    }

    function save_meta_box($post_id) {
        // Check if our nonce is set.
        if ( ! isset( $_POST['widget_area_manager_meta_nonce'] ) ) {
            return;
        }

        // Verify that the nonce is valid.
        if ( ! wp_verify_nonce( $_POST['widget_area_manager_meta_nonce'], 'widget_area_manager_meta_nonce' ) ) {
            return;
        }

        // If this is an autosave, our form has not been submitted, so we don't want to do anything.
        if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
            return;
        }
        if(isset($_POST['widget_area_manager']) && is_array($_POST['widget_area_manager'])){
            foreach($_POST['widget_area_manager'] as $layout_area_id => $layout_options){
                if(!empty($layout_options['position'])){
                    $position = explode(':',$layout_options['position']);
                    //print_r($layout_options);print_r($position);exit;
                    if(!empty($position[0]) && !empty($position[1])){
                        $valid_layout_options = $this->layout_areas[$layout_area_id];
                        $current_page_id = $post_id; //$this->get_current_page_id();
                        switch ($position[0]) {
                            case 'this':
                                if (isset($valid_layout_options['positions'][$position[1]])) {
                                    //echo $current_page_id; echo $layout_area_id; echo $position[1];print_r($valid_layout_options);exit;
                                    $current_option = $this->_get_option('_widget_area_manager_position_' . $current_page_id . '_' . $layout_area_id);
                                    if ($current_option && $current_option == $position[1]) {
                                        // remove it, revert to default.
                                        $this->_delete_option('_widget_area_manager_position_' . $current_page_id . '_' . $layout_area_id);
                                    } else {
                                        $this->_update_option('_widget_area_manager_position_' . $current_page_id . '_' . $layout_area_id, $position[1]);
                                    }
                                }
                                break;
                            case 'default':
                                $page_type = $this->get_current_page_type();
                                //echo $position[1]; print_r($valid_layout_options);exit;
                                if (isset($valid_layout_options['positions'][$position[1]])) {
                                    $this->_update_option('_widget_area_manager_default_position_' . $page_type . '_' . $layout_area_id, $position[1]);
                                }
                                break;
                        }
                    }
                }
                if(!empty($layout_options['widgets'])){
                    $widget = explode(':',$layout_options['widgets']);
                    if(!empty($widget[0]) && !empty($widget[1])){
                        $current_page_id = $post_id; //$this->get_current_page_id();
                        switch ($widget[0]) {
                            case 'this':
                                if (isset($this->widget_areas[$widget[1]])) {
                                    $current_option = $this->_get_option('_widget_area_manager_area_'.$current_page_id.'_'.$layout_area_id);
                                    if($current_option && $current_option == $widget[1]){
                                        // remove it, revert to default.
                                        $this->_delete_option('_widget_area_manager_area_'.$current_page_id.'_'.$layout_area_id);
                                    }else{
                                        $this->_update_option('_widget_area_manager_area_'.$current_page_id.'_'.$layout_area_id,$widget[1]);
                                    }
                                }
                                break;
                            case 'default':
                                $page_type = $this->get_current_page_type();
                                if (isset($this->widget_areas[$widget[1]])) {
                                    $this->_update_option('_widget_area_manager_default_widget_' . $page_type . '_' . $layout_area_id, $widget[1]);
                                }
                                break;
                        }
                    }
                }
            }
        }
    }

    function meta_box_callback( $post ) {
        include( trailingslashit( __DIR__ ) . 'templates/metabox.php');

    }

    private function _key_name($key){
        // we want to use shorter key names so custom taxonomys dont get truncaked in the option db
        $old_key_string = '_widget_area_manager';
        $new_key_string = 'wam_';
        $new_key = str_replace($old_key_string,$new_key_string,$key);
        // if the old option exists in the database, remove it and resave it under the new key.
        if($existing_value = get_option($key)){
            delete_option($key);
            update_option($new_key, $existing_value);
        }
        return $new_key;
    }
    private function _get_option($key,$default=''){
        if(_WIDGET_AREA_MANAGER_DEMO_MODE && !current_user_can( 'administrator' )){
            $val = (isset($_SESSION['_wamanagerdemo']) && isset($_SESSION['_wamanagerdemo'][$key])) ? $_SESSION['_wamanagerdemo'][$key] : get_option($key);
            if(!$val)$val = $default; // do this instead of get_option
        }else{
            $key = $this->_key_name($key);
            $val = get_option($key);
            if(!$val)$val = $default; // do this instead of get_option
        }
        return $val;
    }
    private function _update_option($key,$val){
        if(_WIDGET_AREA_MANAGER_DEMO_MODE && !current_user_can( 'administrator' )){
            if(!isset($_SESSION['_wamanagerdemo'])) $_SESSION['_wamanagerdemo'] = array();
            $_SESSION['_wamanagerdemo'][$key] = $val;
        }else{
            $key = $this->_key_name($key);
            update_option($key,$val);
        }
    }
    private function _delete_option($option_name){
        if(_WIDGET_AREA_MANAGER_DEMO_MODE && !current_user_can( 'administrator' )){
            if(isset($_SESSION['_wamanagerdemo']) && isset($_SESSION['_wamanagerdemo'][$option_name])){
                unset($_SESSION['_wamanagerdemo'][$option_name]);
            }
        }else{
            $key = $this->_key_name($option_name);
           delete_option($option_name);
        }
    }

    /**
     * @param $hook_name
     * This is called from our wordpress theme.
     * You can put this in your header or footer file
     * or wherever  - this displays our sidebar with surrounding html markup
     *   do_action('widget_area_manager_hook','after_content');
     * where 'after_content' is a hook area defined above in $this->layout_areas
     */
    public function run_hook($hook_name){
        $this->_completed_hooks=array();
        $this->_run_hook($hook_name);
    }
    // recurisve version with infinite loop block
    private function _run_hook($hook_name){
        if(isset($this->_completed_hooks[$hook_name]))return;
        $this->_completed_hooks[$hook_name]=true;
        // iterate over all layout areas, and run any hooks we find.
        $this->_process_layout_areas();
        foreach($this->layout_areas as $layout_area_id => $layout_area){
            if($layout_area['position'] && isset($layout_area['positions'][$layout_area['position']])){
                $current_position = $layout_area['positions'][$layout_area['position']];
                // check this position handles this hook
                if(isset($current_position[$hook_name])){
                    // we're ready to run this hook! yay!
                    // does this have our special generate string in it?
                    if(strpos($current_position[$hook_name],$this->_generate_string)!==false){
                        $widget_area_generate = "";
                        ob_start();
                        dynamic_sidebar( $layout_area['widget_area'] );
                        $widget_area_generate = ob_get_clean();
                        $current_position[$hook_name] = str_replace($this->_generate_string,$widget_area_generate,$current_position[$hook_name]);
                    }
                    if(preg_match('#\{'.$this->_hook_string.':([^\}]+)\}#',$current_position[$hook_name],$matches)){
                        // call this hook and place it's contents in this spot.
                        ob_start();
                        $this->_run_hook($matches[1]);
                        $hook_content = ob_get_clean();
                        $current_position[$hook_name] = str_replace($matches[0],$hook_content,$current_position[$hook_name]);
                    }
                    // easy - output the html.
                    echo '<!-- outputing hook "'.$hook_name.'" for page id '.$this->get_current_page_id().'-->';
                    echo $current_position[$hook_name];
                    echo '<!-- end hook "'.$hook_name.'" -->';
                }
            }
        }
    }

    /**
     * This grabs the >layout_areas array
     * and finds out if the user has given any values
     * to the options yet. (eg: which widget_area to display in this layout
     * area or which position this widget_area should be in)
     */
    private $_process_layout_areas_done = false;
    private function _process_layout_areas(){
        //if($this->_process_layout_areas_done)return;
        $this->_process_layout_areas_done = true;
        $current_page_id = $this->get_current_page_id();
        $current_page_type = $this->get_current_page_type();

        foreach($this->layout_areas as $layout_area_id => $layout_area){
            // which widget_area to display in this layout area?
            $default_layout_area = isset($layout_area['default_widget_area']) ? $layout_area['default_widget_area'] : false;
            $default_position = isset($layout_area['default_position']) ? $layout_area['default_position'] : false;
            if(is_array($default_layout_area)){
                // hack to support multiple defaults.
                if($current_page_type && isset($default_layout_area[$current_page_type])){
                    $default_layout_area = $default_layout_area[$current_page_type];
                }else{
                    $default_layout_area = array_shift($default_layout_area);
                }
            }
            if(is_array($default_position)){
                // hack to support multiple defaults.
                if($current_page_type && isset($default_position[$current_page_type])){
                    $default_position = $default_position[$current_page_type];
                }else{
                    $default_position = array_shift($default_position);
                }
            }
            if($current_page_type && $this->_get_option('_widget_area_manager_default_position_'.$current_page_type.'_'.$layout_area_id,false)){
                $default_position = $this->_get_option('_widget_area_manager_default_position_'.$current_page_type.'_'.$layout_area_id,false);
            }
            if($current_page_type && $this->_get_option('_widget_area_manager_default_widget_'.$current_page_type.'_'.$layout_area_id,false)){
                $default_layout_area = $this->_get_option('_widget_area_manager_default_widget_'.$current_page_type.'_'.$layout_area_id,false);
            }
            $this->layout_areas[$layout_area_id]['default_widget_area'] = $default_layout_area;
            $this->layout_areas[$layout_area_id]['default_position'] = $default_position;

            $selected_widget_area = $this->_get_option('_widget_area_manager_area_'.$current_page_id.'_'.$layout_area_id,$default_layout_area);
            $this->layout_areas[$layout_area_id]['widget_area'] = $selected_widget_area;
            // which position this layout area is in?
            $selected_position = $this->_get_option('_widget_area_manager_position_'.$current_page_id.'_'.$layout_area_id,$default_position);
            $this->layout_areas[$layout_area_id]['position'] = $selected_position;
        }
    }


    /**
     * This registeres our sidebars in wordpress so the user
     * has somewhere to group their widgets together.
     */
    function init_widget_areas(){
        global $wp_registered_sidebars;
        $existing_sidebars = $wp_registered_sidebars;

        if(!$existing_sidebars){

            // add our own.
            $layout_area_count = get_option('widget_area_manager_layout_area_count',3);
            for($x=0;$x<$layout_area_count;$x++){

            }
        }


        foreach($this->widget_areas as $widget_area){
            // do we have to register this sidebar or not?
            if(isset($widget_area['id']) && isset($existing_sidebars[$widget_area['id']])){
                // already exists as a sidebar, don't register it in wp
            }else{
                // doesn't exist, add it to the list.
                register_sidebar( $widget_area );
            }
        }
        // now we have to grab a list of our registered sidebars and add them to the local widget_areas array
        foreach($existing_sidebars as $existing_sidebar){
            if(isset($existing_sidebar['id']) && !isset($this->widget_areas[$existing_sidebar['id']])){
                $this->widget_areas[$existing_sidebar['id']] = $existing_sidebar;
            }
        }
    }

    /**
     * @return bool
     * checks if the current user can edit widgets, if we should give them the menu and allow postbacks.
     */
    function can_edit_widget_positions(){
        if(_WIDGET_AREA_MANAGER_DEMO_MODE && is_user_logged_in())return true;
        if(is_super_admin() && is_admin_bar_showing())return true;
        return false;
    }

    /**
     * This is called when the user changes a configuration option using
     * the wordpress admin menu bar area.
     * It checks permissions and saves this option in the database for later.
     *
     */
    function handle_postback() {
        if(!$this->can_edit_widget_positions())return;
        if(isset($_REQUEST['widget_area_manager_hook'])){
            // handle ajax request, pass back javascript to be evaulatated.
            header("Content-type: text/javascript");
            if(
                isset($_REQUEST['layout_area_id']) &&
                isset($_REQUEST['page_id']) &&
                isset($_REQUEST['current_url'])
            ){
                $current_page_id = $_REQUEST['page_id'];
                $layout_area_id = trim($_REQUEST['layout_area_id']);
                if($layout_area_id && isset($this->layout_areas[$layout_area_id])){
                    $layout_options = $this->layout_areas[$layout_area_id];
                    // what are we doing? setting the position or changing the widget area?
                    if(isset($_REQUEST['set_default_position_id'])){
                        $page_type = $_REQUEST['page_type'];
                        if(isset($layout_options['positions'][$_REQUEST['set_default_position_id']])){
                            // save to WP db:
                            $this->_update_option('_widget_area_manager_default_position_'.$page_type.'_'.$layout_area_id,$_REQUEST['set_default_position_id']);
                            // look for any '_widget_area_manager_position_*' wordpress options and remove them.
                            /*$all_options = wp_load_alloptions();
                            if(_WIDGET_AREA_MANAGER_DEMO_MODE && isset($_SESSION['_wamanagerdemo'])){
                                $all_options = array_merge($all_options,$_SESSION['_wamanagerdemo']);
                            }
                            foreach($all_options as $option_name => $option_value){
                                // todo - this removes all custom configurations! bad!
                                if(strpos($option_name,'_widget_area_manager_position_')!==false){
                                    // delete this option!
                                    if(_WIDGET_AREA_MANAGER_DEMO_MODE && isset($_SESSION['_wamanagerdemo']) && isset($_SESSION['_wamanagerdemo'][$option_name])){
                                        unset($_SESSION['_wamanagerdemo'][$option_name]);
                                    }
                                    delete_option($option_name);
                                }
                            }*/
                        }
                    }else if(isset($_REQUEST['set_default_widget_id'])){
                        $page_type = $_REQUEST['page_type'];
                        if(isset($this->widget_areas[$_REQUEST['set_default_widget_id']])){
                            // save to WP db:
                            $this->_update_option('_widget_area_manager_default_widget_'.$page_type.'_'.$layout_area_id,$_REQUEST['set_default_widget_id']);
                            // look for any '_widget_area_manager_area_*' wordpress options and remove them.
                            /*$all_options = wp_load_alloptions();
                            if(_WIDGET_AREA_MANAGER_DEMO_MODE && isset($_SESSION['_wamanagerdemo'])){
                                $all_options = array_merge($all_options,$_SESSION['_wamanagerdemo']);
                            }
                            foreach($all_options as $option_name => $option_value){
                                // todo - this removes all custom configurations! bad!
                                if(strpos($option_name,'_widget_area_manager_area_')!==false){
                                    // delete this option!
                                    if(_WIDGET_AREA_MANAGER_DEMO_MODE && isset($_SESSION['_wamanagerdemo']) && isset($_SESSION['_wamanagerdemo'][$option_name])){
                                        unset($_SESSION['_wamanagerdemo'][$option_name]);
                                    }
                                    delete_option($option_name);
                                }
                            }*/
                        }
                    }else if(isset($_REQUEST['set_widget_area_id'])){
                        // save the widget group to this layout area.
                        // check gorup exists.
                        if(isset($this->widget_areas[$_REQUEST['set_widget_area_id']])){
                            $new_widget_area_id = $_REQUEST['set_widget_area_id'];
                            // save to WP db:
                            $current_option = $this->_get_option('_widget_area_manager_area_'.$current_page_id.'_'.$layout_area_id);
                            if($current_option && $current_option == $new_widget_area_id){
                                // remove it, revert to default.
                                $this->_delete_option('_widget_area_manager_area_'.$current_page_id.'_'.$layout_area_id);
                            }else{
                                $this->_update_option('_widget_area_manager_area_'.$current_page_id.'_'.$layout_area_id,$new_widget_area_id);
                            }
                        }

                    }else if(isset($_REQUEST['set_position_id'])){
                        // check this position exists.
                        if(isset($layout_options['positions'][$_REQUEST['set_position_id']])){
                            $new_position_id = $_REQUEST['set_position_id'];
                            // save to WP db:
                            // if it's already in the db, then we remove this option
                            $current_option = $this->_get_option('_widget_area_manager_position_'.$current_page_id.'_'.$layout_area_id);
                            if($current_option && $current_option == $new_position_id){
                                // remove it, revert to default.
                                $this->_delete_option('_widget_area_manager_position_'.$current_page_id.'_'.$layout_area_id);
                            }else{
                                $this->_update_option('_widget_area_manager_position_'.$current_page_id.'_'.$layout_area_id,$new_position_id);
                            }
                        }
                    }
                }
                echo 'window.location.href="'.htmlspecialchars($_REQUEST['current_url']).'";';
            }
            exit;
        }
    }

    /**
     * @param $name
     * @param $id
     * @param bool $href
     * @return mixed
     * helper function to add a menu to WP header bar
     * adapted from demo on wp codex
     */
    function add_root_menu($name, $id, $href = FALSE) {
        global $wp_admin_bar;
        if(!$this->can_edit_widget_positions())return;

        $wp_admin_bar->add_menu( array(
            'id' => $id,
            'title' => $name,
            'href' => $href ) );
    }
    /**
     * @param $name
     * @param $id
     * @param $link
     * @param $root_menu
     * @param bool $meta
     * @return mixed
     * helper function to add a menu to WP header bar
     * adapted from demo on wp codex
     */
    function add_sub_menu($name, $id, $link, $root_menu, $meta = FALSE) {
        global $wp_admin_bar;
        if(!$this->can_edit_widget_positions())return;

        $wp_admin_bar->add_menu( array(
            'parent' => $root_menu,
            'id' => $id,
            'title' => $name,
            'href' => $link,
            'meta' => $meta) );

    }

    /**
     * Called to generate our links in the header area.
     */
    function widget_area_manager_links() {

        if(_WIDGET_AREA_MANAGER_DEMO_MODE && !current_user_can('administrator')){
            $parent_menu = 'demothing';
            $this->add_root_menu(__( 'WIDGET AREA DEMO:' , 'widget_area_manager'), $parent_menu);
            $this->add_sub_menu(__("Use these menus to easily change the page layout. Choose which widgets to display on each page. Choose the position of widgets on the page.", 'widget_area_manager'), $parent_menu.'w', false, $parent_menu);
        }

        $this->_process_layout_areas();
        $current_page_id = $this->get_current_page_id();
        if($this->_group_widget_areas && count($this->layout_areas) > 1){
            // combine into a single parent menu
            $parent_menu = "widget_area_mng";
            $this->add_root_menu(sprintf(__( 'Widget Areas (%s)' , 'widget_area_manager'),count($this->layout_areas)), $parent_menu);
            if(is_super_admin()){
                $this->add_sub_menu(__("Manage Widgets", 'widget_area_manager'), $parent_menu.'w', admin_url('widgets.php'), $parent_menu);
            }
        }else{
            $parent_menu = false;
        }
        foreach($this->layout_areas as $layout_area_id => $widget_area_area){

            if(!$widget_area_area || !isset($widget_area_area['name']))continue;

            $menu_id = 'sm'.$layout_area_id;




            if($parent_menu){
                if($this->_display_widget_area_string){
                    $this->add_sub_menu(sprintf(__( 'Widget Area: %s' , 'widget_area_manager'),$widget_area_area['name']), $menu_id, false, $parent_menu);
                }else{
                    $this->add_sub_menu($widget_area_area['name'], $menu_id, false, $parent_menu);
                }
            }else{
                if($this->_display_widget_area_string){
                    $this->add_root_menu(sprintf(__( 'Widget Area: %s' , 'widget_area_manager'),$widget_area_area['name']), $menu_id);                  }else{
                    $this->add_root_menu($widget_area_area['name'], $menu_id);
                }
            }


            // display a link with a summary of the widget type and location.
            $layout_area_summary =  "";
            if(count($this->widget_areas) > 1){
                foreach($this->widget_areas as $widget_area_id => $widget_area){
                    if($widget_area_id == $widget_area_area['widget_area']){
                        // this is the area we have selected
                        $layout_area_summary .= $widget_area['name'];
                    }
                }
                foreach($widget_area_area['positions'] as $position_id => $position_data){
                    if( $position_id == $widget_area_area['position']){
                        if($layout_area_summary){
                            $layout_area_summary .= ", ";
                        }
                        $layout_area_summary .= $position_data['name'];
                    }
                }
            }
            /*if($layout_area_summary){
                $this->add_sub_menu('<em>'.$layout_area_summary.'</em>', 'summary'.$menu_id, false, $menu_id);
            }*/
            $page_type = ucwords($this->get_current_page_type());

            // which positions this widget_area can be in?
            if(isset($widget_area_area['positions'])){
                $position_sub_menu_id = 'smp'.$layout_area_id;
                $current_string = '';
                foreach($widget_area_area['positions'] as $position_id => $position_data){
                    if($position_id == $widget_area_area['position']){
                        $current_string = ' ('.$position_data['name'].')';
                    }
                }
                $this->add_sub_menu(
                    sprintf(__("Position%s", 'widget_area_manager'),$current_string),
                    $position_sub_menu_id,
                    false,
                    $menu_id
                );
                // an option to change the default, and an option to just change this page.
                // change the default:
                /*$default = $widget_area_area['default_position']; // . ' '.$widget_area_area['default_widget_area'];
                foreach($widget_area_area['positions'] as $position_id => $position_data){
                    if($position_id==$widget_area_area['default_position']){
                        $default = $position_data['name'];
                    }
                }*/
                $this->add_sub_menu(
                    __("Change this page position only:", 'widget_area_manager'),
                    't'.$position_sub_menu_id,
                    false,
                    $position_sub_menu_id
                );

                foreach($widget_area_area['positions'] as $position_id => $position_data){
                    $this->add_sub_menu(
                        $position_data['name'] . ($position_id == $widget_area_area['position'] ? ' '.$this->_current_string : ''),
                        'thisp' . $layout_area_id.$position_id,
                        "#",
                        $position_sub_menu_id,
                        array(
                            'onclick' => 'return widget_area_manager_set_position("'.$layout_area_id.'","'.$position_id.'","'.$current_page_id.'");',
                            'class' => 'widget_area_manager_position',
                        )
                    );
                }

                $default_position_sub_menu_id = 'd'.$position_sub_menu_id;
                $this->add_sub_menu(
                    sprintf(__("Or change '%s' default", 'widget_area_manager'),$page_type), // $default)
                    $default_position_sub_menu_id,
                    false,
                    $position_sub_menu_id
                );
                foreach($widget_area_area['positions'] as $position_id => $position_data){
                    // these are the default positions.
                    $this->add_sub_menu(
                        $position_data['name'] . ($position_id == $widget_area_area['default_position'] ? ' '.$this->_current_string : ''),
                        'defap' . $layout_area_id.$position_id,
                        "#",
                        $default_position_sub_menu_id,
                        array(
                            'onclick' => 'return widget_area_manager_set_position_default("'.$layout_area_id.'","'.$position_id.'","'.$current_page_id.'","'.$this->get_current_page_type().'");',
                            'class' => 'widget_area_manager_position',
                        )
                    );
                }
                //$this->add_sub_menu(sprintf(__("(%s default is: %s)", 'widget_area_manager'),$page_type,$default), "defaultpos".$layout_area_id, false, $sub_menu_id);
            }
            // which widget_area to display on this page?
            if(count($this->widget_areas) > 1 && (!isset($widget_area_area['enable_widgets']) || $widget_area_area['enable_widgets'])){
                $widget_area_sub_menu_id = 'sms'.$layout_area_id;
                $current_string = '';
                foreach($this->widget_areas as $widget_area_id => $widget_area){
                    if($widget_area_id == $widget_area_area['widget_area']){
                        $current_string = ' ('.$widget_area['name'].')';
                    }
                }
                $this->add_sub_menu(
                    sprintf(__("Widgets%s", 'widget_area_manager'),$current_string),
                    $widget_area_sub_menu_id,
                    false,
                    $menu_id
                );
                //$default = $widget_area_area['default_widget_area']; // . ' '.$widget_area_area['default_position'];
                $this->add_sub_menu(
                    __("Change this page widget only:", 'widget_area_manager'),
                    't'.$widget_area_sub_menu_id,
                    false,
                    $widget_area_sub_menu_id
                );

                foreach($this->widget_areas as $widget_area_id => $widget_area){
//                    if($widget_area_id==$widget_area_area['default_widget_area']){
//                        $default = $widget_area['name'];
//                    }
                    $this->add_sub_menu(
                        $widget_area['name']
                        // is it currently selected?
                        . ( $widget_area_id == $widget_area_area['widget_area'] ? ' '. $this->_current_string : ''),
                        $widget_area_sub_menu_id.$widget_area_id,
                        "#",
                        $widget_area_sub_menu_id,
                        array(
                            'onclick' => 'return widget_area_manager_set_area("'.$layout_area_id.'","'.$widget_area_id.'","'.$current_page_id.'");',
                            'class' => 'widget_area_manager_area',
                        )
                    );
                }
                /*if(!$parent_menu && is_super_admin()){
                    $this->add_sub_menu(__("(Manage Widgets)", 'widget_area_manager'), "widgets".$layout_area_id, admin_url('widgets.php'), $sub_menu_id);
                }*/
                //$this->add_sub_menu(sprintf(__("(%s default is: %s)", 'widget_area_manager'),$page_type,$default), "default".$layout_area_id, false, $widget_area_sub_menu_id);
                $default_widget_sub_menu_id = 'd'.$widget_area_sub_menu_id;
                $this->add_sub_menu(
                    sprintf(__("Or change '%s' default", 'widget_area_manager'),$page_type), // $default)
                    $default_widget_sub_menu_id,
                    false,
                    $widget_area_sub_menu_id
                );
                foreach($this->widget_areas as $widget_area_id => $widget_area){
                    // these are the default positions.
                    $this->add_sub_menu(
                        $widget_area['name'] . ($widget_area_id == $widget_area_area['default_widget_area'] ? ' '.$this->_current_string : ''),
                        'defw' . $widget_area_sub_menu_id.$widget_area_id,
                        "#",
                        $default_widget_sub_menu_id,
                        array(
                            'onclick' => 'return widget_area_manager_set_widget_default("'.$layout_area_id.'","'.$widget_area_id.'","'.$current_page_id.'","'.$this->get_current_page_type().'");',
                            'class' => 'widget_area_manager_area',
                        )
                    );
                }
            }



        }
    }

    function add_customizer($wp_customize){


    }
    function get_current_page_type(){
        global $wp_query;
        //print_r($wp_query);
        if(is_search()){
            return 'search';
        }else if (is_404()){
            return '404';
        }else if(function_exists('is_product') && is_product()){
            return 'product';
        }else if(function_exists('is_product_category') && is_product_category()){
            return 'product_category';
        }else if(is_category()){
            return 'category';
        }else if(isset($wp_query->query_vars) && isset($wp_query->query_vars['post_type']) && $wp_query->query_vars['post_type']){
            return $wp_query->query_vars['post_type'] . (is_singular()?'':'s');
        }else if(isset($wp_query->query_vars['taxonomy']) && $wp_query->query_vars['taxonomy']){
            $current_page_id = $wp_query->query_vars['taxonomy'];
            $value    = get_query_var($wp_query->query_vars['taxonomy']);
            if($value){
                $current_page_id .= '_'.$value;
            }
            return $current_page_id;
        }else if(isset($wp_query->is_posts_page) && $wp_query->is_posts_page){
            return 'archive';
        }else if(is_archive()){
            return 'archive';
        }else if(is_front_page()){
            return 'front_page';
        }else if(is_page()){
            return 'page';
        }else if(is_single()){
            return 'post';
        }
        // todo -l ook for custom taxonomys
        return 'post';
    }
    /**
     * @return int
     * Helper function to get the current page id. Can be tricky!
     * If the global variable $widget_area_manager_current_page_id is set
     * then we use that instead.
     * This is so custom scripts can set this id if they need to display
     * some complicated page that we cannot determine the current page id from.
     */
    function get_current_page_id(){
        global $wp_query, $widget_area_manager_current_page_id;
        $current_page_id = false;
        if(is_search()){
            $current_page_id = 'search';
        }else if (is_404()){
            $current_page_id = '404';
        }else if(is_category()){
            $cat = get_query_var('cat');
            $yourcat = get_category($cat);
            $current_page_id = $yourcat->slug;
        }else if(isset($wp_query->post_type) && $wp_query->post_type){
            $current_page_id = 'post_type'.$wp_query->post_type;
        }else if(isset($wp_query->query_vars) && isset($wp_query->query_vars['post_type']) && $wp_query->query_vars['post_type']){
            $current_page_id = 'post_type'.$wp_query->query_vars['post_type'] . (is_singular()?'':'s');
        }else if(isset($wp_query->query_vars['taxonomy']) && $wp_query->query_vars['taxonomy']){
            $current_page_id = $wp_query->query_vars['taxonomy'];
            $value    = get_query_var($wp_query->query_vars['taxonomy']);
            if($value){
                $current_page_id .= '_'.$value;
            }
        }
        if(isset($widget_area_manager_current_page_id) && $widget_area_manager_current_page_id != false){
            return $widget_area_manager_current_page_id;
        }
        if($current_page_id){
            return $current_page_id;
        }
        $current_page_id = isset($wp_query->post) && isset($wp_query->post->ID) ? $wp_query->post->ID : false;
        if(is_home()){
            if('page' == get_option('show_on_front')){
                if(is_front_page()){
                    $current_page_id = get_option('page_on_front');
                }else{
                    $current_page_id = get_option('page_for_posts');
                }
            }
        }
        if(!$current_page_id){
            global $post;
            if(isset($post->ID)){
                return $post->ID;
            }
        }
        return $current_page_id;
    }


}

function widget_area_manager_start() {
    global $widget_area_manager;
    if(!isset($widget_area_manager) || !$widget_area_manager){
        $widget_area_manager = new widget_area_manager();
    }
}

add_action("init", "widget_area_manager_init");
function widget_area_manager_init() {
    global $widget_area_manager;
    widget_area_manager_start();
    $widget_area_manager->init();
}
add_action("widget_area_manager_start_settings_page", "widget_area_manager_start_settings_page");
function widget_area_manager_start_settings_page() {
    widget_area_manager_start();
    // add a settings page to allow users to control widget areas in this theme.
    add_theme_page(__('Options: Page Layout'), __('Options: Page Layout'), 'edit_themes', __FILE__, 'widget_area_manager_settings_page');
}
function widget_area_manager_settings_page(){
    ?> settinsg page here <?php
}
add_action("widget_area_add_layouts", "widget_area_add_layouts", 10, 1);
function widget_area_add_layouts($layouts) {
    global $widget_area_manager;
    widget_area_manager_start();
    $widget_area_manager->layout_areas = $layouts;
}
// for a page by page load default, eg: if in shop page,change global default to none.
add_action("widget_area_set_default_position", "widget_area_set_default_position", 10, 2);
function widget_area_set_default_position($widget_area_id,$default_position) {
    global $widget_area_manager;
    widget_area_manager_start();
    $widget_area_manager->layout_areas[$widget_area_id]['default_position'] = $default_position;
}
add_action("widget_area_set_default_widget", "widget_area_set_default_widget", 10, 2);
function widget_area_set_default_widget($widget_area_id,$default_widget) {
    global $widget_area_manager;
    widget_area_manager_start();
    $widget_area_manager->layout_areas[$widget_area_id]['default_widget_area'] = $default_widget;
}

add_action("widget_area_add_sidebars", "widget_area_add_sidebars", 10, 1);
function widget_area_add_sidebars($sidebars) {
    global $widget_area_manager;
    widget_area_manager_start();
    $widget_area_manager->widget_areas = $sidebars;
}
add_action( 'widgets_init', 'widget_area_manager_widgets_init', 60, 0);
function widget_area_manager_widgets_init(){
    global $widget_area_manager;
    widget_area_manager_start();
    $widget_area_manager -> init_widget_areas();
}
add_action('widget_area_manager_hook','widget_area_manager_hook_run',10,1);
function widget_area_manager_hook_run($hook_name){
    global $widget_area_manager;
    widget_area_manager_start();
    $widget_area_manager->run_hook($hook_name);
}
add_action('widget_area_manager_set_page_id','widget_area_manager_set_page_id',10,1);
function widget_area_manager_set_page_id($page_id){
    global $widget_area_manager_current_page_id;
    $widget_area_manager_current_page_id = $page_id;
}

if(_WIDGET_AREA_MANAGER_DEMO_MODE){
    add_action( 'wp_before_admin_bar_render', 'dtbaker_remove_admin_bar_items' );
    function dtbaker_remove_admin_bar_items(){
        if(_WIDGET_AREA_MANAGER_DEMO_MODE && !current_user_can( 'administrator' )){
            global $wp_admin_bar;
            $wp_admin_bar->remove_menu('site-name');
            $wp_admin_bar->remove_menu('wp-logo');
            $wp_admin_bar->remove_menu('my-account');
            $wp_admin_bar->remove_menu('search');
        }
    }
}

/*
function widget_area_manager_customize_register( $wp_customize )
{
    global $widget_area_manager;
    widget_area_manager_start();
    $widget_area_manager -> init_widget_areas();
    $widget_area_manager -> add_customizer( $wp_customize );
}
add_action( 'customize_register', 'widget_area_manager_customize_register' );
*/
include_once('plugin_update.php');



if(_WIDGET_AREA_MANAGER_DEMO_MODE){
    class dtbaker_tf_demo extends WP_Widget {

        /** constructor */
        function dtbaker_tf_demo() {
            $widget_ops = array(
                'description' => 'bar',
            );

            parent::WP_Widget(false,'TF DEMO', $widget_ops );
        }

        /** @see WP_Widget::widget */
        function widget($args, $instance) {
            ?>
            <div class="widget">
                <h3 class="widget-title">Welcome to the Demo</h3>
                <p>Welcome to the Demo of the <strong>Mommy Blog</strong> premium WordPress theme.</p>
                <p>Please <a href="?demo_login">click here</a> to activate the <em>demo options</em>. Once activated you can change the layout of the header, sidebars, footer etc..</p>
                <p>More information about this theme available on <a href="http://themeforest.net/user/dtbaker?ref=dtbaker">ThemeForest</a>.</p>
                <p align="center"><a href="http://themeforest.net/user/dtbaker?ref=dtbaker"><img src="http://envato.s3.amazonaws.com/referrer_adverts/tf_180x100_v4.gif" border="0" title="" alt="Premium Mummy WordPress blog theme"></a></p>
            </div>
            <?php
        }

        /** @see WP_Widget::update */
        function update($new_instance, $old_instance) {
            $instance = $old_instance;
            return $instance;
        }

        /** @see WP_Widget::form */
        function form($instance) {
            ?>
        demo
        <?php
        }

    }

    add_action('widgets_init', create_function('', 'return register_widget("dtbaker_tf_demo");'));
}
