<?php if ($disabled) { ?>
	<section id="support-disabled">
		<section class="contents clearfix">
			<section class="layer" id="support-layer">
				<section class="promotional">
					<span class="tag-upgrade"></span>
					<h3 class="support-msg"><span class="wpmudev-logo-small"></span>&nbsp; <?php _e('members get full access to the biggest &amp; best WordPress community on the web.', 'wpmudev') ?></h3>
					<a class="btn" href="<?php echo apply_filters('wpmudev_join_url', 'http://premium.wpmudev.org/join/'); ?>">
						<button class="wpmu-button"><?php _e('Find out more &raquo;', 'wpmudev') ?></button>
					</a>
					<?php if (!$this->get_apikey()) { ?>
					<p class="support-already-member"><a href="admin.php?page=wpmudev&clear_key=1"><?php _e('Already a member?', 'wpmudev') ?></a></p>
					<?php } ?>
				</section>
			</section>
		</section>
	</section>
<?php } ?>

<hr class="section-head-divider" />
<div class="wrap grid_container">
	<h1 class="section-header">
		<i class="wdvicon-comments"></i><?php _e('Community', 'wpmudev') ?>
	</h1>
	<div class="listing-form-elements">
		<table cellpadding="0" cellspacing="0" border="0">
			<tbody>
				<tr>
					<td width="100%"><input type="text" id="forum-search-q" placeholder="<?php _e('Search community', 'wpmudev'); ?>" /><a href="#" id="forum-search-go" class="search-btn"><i class="wdvicon-search"></i></a></td>
				</tr>
			</tbody>
		</table>
	</div>
</div>
<div class="community-container grid_container wpmudev-dash">

	<?php if ($this->get_apikey() && $this->allowed_user()) { ?>
	<div class="community-content">

		<div class="community-reputation">
			<h1><?php _e('Your reputation:', 'wpmudev'); ?></h1>
			<?php  if (isset($profile['reputation']['overall']) && isset($profile['reputation']['unique_users'])) { ?>

				<!-- user rep level -->
				<?php  if (0 == $profile['reputation']['overall']) { ?>
				<span class="profile-reputation-badge"><section><?php _e('Brand new here', 'wpmudev'); ?></section></span>
				<?php } else if ($profile['reputation']['overall'] > 0 && $profile['reputation']['overall'] <= 10) { ?>
				<span class="profile-reputation-badge ul-10"><section><?php _e('Getting my WPMU DEV Wings', 'wpmudev'); ?></section></span>
				<?php } else if ($profile['reputation']['overall'] > 10 && $profile['reputation']['overall'] <= 50) { ?>
				<span class="profile-reputation-badge ul-50"><section><?php _e('Starting to get into this DEV thing', 'wpmudev'); ?></section></span>
				<?php } else if ($profile['reputation']['overall'] > 50 && $profile['reputation']['overall'] <= 200) { ?>
				<span class="profile-reputation-badge ul-200"><section><?php _e('Serious WPMU DEV-ster', 'wpmudev'); ?></section></span>
				<?php } else if ($profile['reputation']['overall'] > 200 && $profile['reputation']['overall'] <= 500) { ?>
				<span class="profile-reputation-badge ul-500"><section><?php _e('WPMU DEV Expert', 'wpmudev'); ?>"</section></span>
				<?php } else if ($profile['reputation']['overall'] > 500) { ?>
				<span class="profile-reputation-badge ul-500plus"><section><?php _e('Like some sort of WPMU DEV God', 'wpmudev'); ?></section></span>
				<?php } ?>

				<!-- user help support level -->
				<?php if ($profile['reputation']['unique_users'] > 0 && $profile['reputation']['unique_users'] < 5) { ?>
				<span class="profile-reputation-badge us-5"><section><?php _e("I'm helpful", 'wpmudev'); ?>"</section></span>
				<?php } else if ($profile['reputation']['unique_users'] > 5 && $profile['reputation']['unique_users'] < 10) { ?>
				<span class="profile-reputation-badge us-10"><section><?php _e('Seriously helpful member', 'wpmudev'); ?></section></span>
				<?php } else if ($profile['reputation']['unique_users'] > 10 && $profile['reputation']['unique_users'] < 20) { ?>
				<span class="profile-reputation-badge us-20"><section><?php _e('Exceptionally helpful', 'wpmudev'); ?></section></span>
				<?php } else if ($profile['reputation']['unique_users'] > 20) { ?>
				<span class="profile-reputation-badge us-20plus"><section><?php _e('Mindblowingly helpful member', 'wpmudev'); ?></section></span>
				<?php } ?>
				<!-- end -->

				<?php //if ($profile['reputation']['overall'] > 1000 && $profile['reputation']['unique_users'] >= 10) { ?>
				<?php if (!empty($profile['reputation']['is_lifetime_member']) && $profile['reputation']['is_lifetime_member']) { ?>
					<span class="profile-reputation-badge lifetime"><section><?php _e('Lifetime WPMU Dev member', 'wpmudev'); ?></section></span>
				<?php } ?>
				<br class="clear" />
				<span class="rep-points"><i><?php _e('You currently have ', 'wpmudev'); ?><span class="number-of-points"><?php echo number_format_i18n($profile['reputation']['overall']); ?></span><?php _e(' reputation points', 'wpmudev'); ?></i></span>
				<br />
				<a href="http://premium.wpmudev.org/forums/profile/<?php echo $profile['profile']['user_name']; ?>/reputation" target="_blank" class="wpmu-button icon"><i class="wdvicon-list-alt wdvicon-large"></i><?php _e('VIEW REPUTATION REPORT', 'wpmudev'); ?></a>
			<?php } ?>
			</div>

		<div class="community-quote">
			<i><?php _e('Help other members, participate in discussions, complete translations, post useful tips/tricks/ideas, and earn a <a href="http://premium.wpmudev.org/earn-your-wpmudev-membership/" target="_blank">free annual or lifetime membership</a>!', 'wpmudev'); ?></i>
		</div>
	</div>

	<div class="your-recent-topics">
		<h1><?php _e('Recent topics started by you:', 'wpmudev'); ?></h1>
		<table width="100%" class="your-recent-topics" border="0" cellpadding="0" cellspacing="0">
			<thead>
				<tr>
					<td width="2.7%"> </td>
					<td width="49%" align="left"><?php _e('Topic:', 'wpmudev'); ?></td>
					<td width="13%" align="center"><?php _e('Responses:', 'wpmudev'); ?></td>
					<td width="32.6%" align="center"><?php _e('Latest response by:', 'wpmudev'); ?></td>
					<td width="2.7%"> </td>
				</tr>
			</thead>
			<tbody>
				<?php if (@$profile['forum']['personal_threads']) foreach ($profile['forum']['personal_threads'] as $thread) { ?>
				<tr>
					<td></td>
					<td align="left"><a href="<?php echo $thread['link'];?>" target="_blank"><?php echo $thread['title'];?></a></td>
					<td align="center"><?php echo number_format_i18n($thread['posts']); ?></td>
					<td align="center"><?php echo $thread['user'];?><br /><span><?php echo date_i18n(get_option('date_format') . ' ' . get_option('time_format'), $thread['timestamp']);?></span></td>
					<td></td>
				</tr>
				<?php } else { ?>
					<tr><td></td><td align="center" colspan="3"><?php _e("You haven't started any topics yet.", 'wpmudev'); ?></td><td></td></tr>
				<?php } ?>
			</tbody>
		</table>
	</div>
	<?php } else { ?>

	<!-- PUT AN AD HERE ABOUT UPGRADING TO VIEW OUR COMMUNITY -->

	<?php } ?>

	<div class="most-popular-topics">
		<h1><?php _e('Latest topics:', 'wpmudev'); ?></h1>
		<?php $count = 1; if (@$profile['forum']['recent_threads']) foreach ($profile['forum']['recent_threads'] as $forum_id => $forum) { ?>
		<ul>
			<li><h1><?php echo $forum['title']; ?></h1><a href="<?php echo $this->support_url. '&tab=support&forum=' . $forum_id; ?>" class="wpmu-button cta small"><i class="wdvicon-comment wdvicon-large"></i><?php _e('ASK A QUESTION', 'wpmudev'); ?></a>
				<ul <?php echo (1<$count ? 'style="display:none"' : '');?> >
					<li>
						<table width="100%" cellpadding="0" cellspacing="0" border="0">
							<thead>
								<tr>
									<td width="2.7%"> </td>
									<td width="49%" align="left"><?php _e('Topic:', 'wpmudev'); ?></td>
									<td width="13%" align="center"><?php _e('Responses:', 'wpmudev'); ?></td>
									<td width="32.6%" align="center"><?php _e('Latest response by:', 'wpmudev'); ?></td>
									<td width="2.7%"> </td>
								</tr>
							</thead>
							<tbody>
							<?php unset($forum['title']); unset($forum['link']); foreach ($forum as $thread) { ?>
								<tr>
									<td></td>
									<td align="left"><a href="<?php echo $thread['link'];?>" target="_blank"><?php echo $thread['title'];?></a></td>
									<td align="center"><?php echo number_format_i18n($thread['posts']); ?></td>
									<td align="center"><?php echo $thread['user'];?><br /><span><?php echo date_i18n(get_option('date_format') . ' ' . get_option('time_format'), $thread['timestamp']);?></span></td>
									<td></td>
								</tr>
								<?php } ?>
							</tbody>
						</table>
					</li>
				</ul>
			</li>
		</ul>
			<?php $count++; ?>
		<?php } ?>
	</div>
</div>