<?php
/*
Plugin Name: WP-EMail
Plugin URI: http://www.lesterchan.net/portfolio/programming.php
Description: Allows people to recommand/send your WordPress blog's post/page to a friend.
Version: 2.11
Author: Lester 'GaMerZ' Chan
Author URI: http://www.lesterchan.net
*/


/*  
	Copyright 2007  Lester Chan  (email : gamerz84@hotmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


### Create Text Domain For Translations
load_plugin_textdomain('wp-email', 'wp-content/plugins/email');


### E-Mail Table Name
$wpdb->email = $table_prefix . 'email';


### Function: E-Mail Administration Menu
add_action('admin_menu', 'email_menu');
function email_menu() {
	if (function_exists('add_menu_page')) {
		add_menu_page(__('E-Mail', 'wp-email'), __('E-Mail', 'wp-email'), 'manage_email', 'email/email-manager.php');
	}
	if (function_exists('add_submenu_page')) {
		add_submenu_page('email/email-manager.php', __('Manage E-Mail', 'wp-email'), __('Manage E-Mail', 'wp-email'), 'manage_email', 'email/email-manager.php');
		add_submenu_page('email/email-manager.php', __('E-Mail Options', 'wp-email'), __('E-Mail Options', 'wp-email'),  'manage_email', 'email/email-options.php');
	}
}


### Function: E-Mail htaccess ReWrite Rules
add_filter('generate_rewrite_rules', 'email_rewrite');
function email_rewrite($wp_rewrite) {
	// WP-EMail Rules
	$rewrite_rules2 = $wp_rewrite->generate_rewrite_rule($wp_rewrite->permalink_structure.'email');
	array_splice($rewrite_rules2, 1);
	$r_rule = array_keys($rewrite_rules2);
	$r_rule = array_shift($r_rule);
	$r_rule = str_replace('/trackback', '', $r_rule);
	$r_link = array_values($rewrite_rules2);
	$r_link = array_shift($r_link);
	$r_link = str_replace('tb=1', 'email=1', $r_link);
    $email_rules = array($r_rule => $r_link, '(.+)/emailpage/?$' => 'index.php?pagename='.$wp_rewrite->preg_index(1).'&email=1');
	$wp_rewrite->rules = $email_rules + $wp_rewrite->rules;
	// WP-EMail PopUp Rules
	$rewrite_rules3 = $wp_rewrite->generate_rewrite_rule($wp_rewrite->permalink_structure.'emailpopup');
	array_splice($rewrite_rules3, 1);
	$r_rule2 = array_keys($rewrite_rules3);
	$r_rule2 = array_shift($r_rule2);
	$r_rule2 = str_replace('/trackback', '', $r_rule2);
	$r_link2 = array_values($rewrite_rules3);
	$r_link2 = array_shift($r_link2);
	$r_link2 = str_replace('tb=1', 'emailpopup=1', $r_link2);
	$emailpopup_rules = array($r_rule2 => $r_link2, '(.+)/emailpopuppage/?$' => 'index.php?pagename='.$wp_rewrite->preg_index(1).'&emailpopup=1');
	$wp_rewrite->rules = $emailpopup_rules + $wp_rewrite->rules;
}


### Function: E-Mail Public Variables
add_filter('query_vars', 'email_variables');
function email_variables($public_query_vars) {
	$public_query_vars[] = 'email';
	$public_query_vars[] = 'emailpopup';
	return $public_query_vars;
}


### Function: E-Mail Javascript
add_action('wp_head', 'email_js');
function email_js() {
	echo "\n".'<!-- Start Of Script Generated By WP-EMail 2.11 -->'."\n";
	echo '<script type="text/javascript">'."\n";
	echo '/* <![CDATA[ */'."\n";
	echo "\t".'function email_popup(email_url) {'."\n";
	echo "\t\t".'window.open(email_url, "_blank", "width=500,height=500,toolbar=0,menubar=0,location=0,resizable=0,scrollbars=1,status=0");'."\n";
	echo "\t".'}'."\n";
	echo '/* ]]> */'."\n";
	echo '</script>'."\n";
	echo '<link rel="stylesheet" href="'.get_option('siteurl').'/wp-content/plugins/email/email-css.css" type="text/css" media="screen" />'."\n";
	echo '<!-- End Of Script Generated By WP-EMail 2.11 -->'."\n";
}


### Function: Display E-Mail Link
function email_link($deprecated = '', $deprecated2 ='', $echo = true) {
	global $id;
	$output = '';
	$using_permalink = get_option('permalink_structure');
	$email_options = get_option('email_options');
	$email_style = intval($email_options['email_style']);
	$email_type = intval($email_options['email_type']);
	$email_text = stripslashes($email_options['post_text']);
	$email_icon = get_option('siteurl').'/wp-content/plugins/email/images/'.$email_options['email_icon'];
	$email_link = get_permalink();
	$email_html = stripslashes($email_options['email_html']);
	$onclick = '';
	// Fix For Static Page
	if(get_option('show_on_front') == 'page' && is_page()) {
		if(intval(get_option('page_on_front')) > 0) {
			$email_link = _get_page_link();
		}
	}
	switch($email_type) {
		// E-Mail Standalone Page
		case 1:
			if(!empty($using_permalink)) {
				if(is_page()) {
					if(substr($email_link, -1, 1) != '/') {
						$email_link= $email_link.'/';
					}
					$email_text = stripslashes($email_options['page_text']);
					$email_link = $email_link.'emailpage/';
				} else {
					$email_link = $email_link.'email/';
				}
			} else {
				if(is_page()) {
					$email_text = stripslashes($email_options['page_text']);
				}
				$email_link = $email_link.'&amp;email=1';
			}
			break;
		// E-Mail Popup
		case 2:
			if(!empty($using_permalink)) {
				if(is_page()) {
					if(substr($email_link, -1, 1) != '/') {
						$email_link= $email_link.'/';
					}
					$email_text = stripslashes($email_options['page_text']);
					$email_link = $email_link.'emailpopuppage/';
				} else {
					$email_link = $email_link.'emailpopup/';
				}
			} else {
				if(is_page()) {
					$email_text = stripslashes($email_options['page_text']);
				}
				$email_link = $email_link.'&amp;emailpopup=1';
			}
			$onclick = ' onclick="email_popup(this.href); return false;" ';
			break;
	}
	unset($email_options);
	switch($email_style) {
		// Icon + Text Link
		case 1:
			$output = '<img class="WP-EmailIcon" src="'.$email_icon.'" alt="'.$email_text.'" title="'.$email_text.'" style="border: 0px;" />&nbsp;<a href="'.$email_link.'"'.$onclick.' title="'.$email_text.'" rel="nofollow">'.$email_text.'</a>';
			break;
		// Icon Only
		case 2:
			$output = '<a href="'.$email_link.'"'.$onclick.' title="'.$email_text.'" rel="nofollow"><img class="WP-EmailIcon" src="'.$email_icon.'" alt="'.$email_text.'" title="'.$email_text.'" style="border: 0px;" /></a>';
			break;
		// Text Link Only
		case 3:
			$output = '<a href="'.$email_link.'"'.$onclick.' title="'.$email_text.'" rel="nofollow">'.$email_text.'</a>';
			break;
		case 4:
			$email_html = str_replace("%EMAIL_URL%", $email_link, $email_html);
			$email_html = str_replace("%EMAIL_POPUP%", $onclick, $email_html);
			$email_html = str_replace("%EMAIL_TEXT%", $email_text, $email_html);
			$email_html = str_replace("%EMAIL_ICON_URL%", $email_icon, $email_html);
			$output = $email_html;
			break;
	}
	if($echo) {
		echo $output."\n";
	} else {
		return $output;
	}
}


### Function: Deprecated Functions
function email_link_image() { email_link(); }
function email_popup($deprecated = '', $deprecated2 ='') { email_link(); }
function email_popup_image() { email_link(); }


### Function: Place E-Mail Link
add_filter('the_content', 'place_emaillink', 7);
function place_emaillink($content){
	if(!is_feed()) {
		 $content = str_replace("[email_link]", email_link('', '', false), $content);
	} else {
		$content = str_replace("[email_link]", __('Note: You can email this post by visiting the site.', 'wp-email'), $content);
	}   
	return $content;
}


### Function: Snippet Text
if(!function_exists('snippet_chars')) {
	function snippet_chars($text, $length = 0) {
		$text = htmlspecialchars_decode($text);
		 if (strlen($text) > $length){       
			return htmlspecialchars(substr($text,0,$length)).'...';             
		 } else {
			return htmlspecialchars($text);
		 }
	}
}


### Function: HTML Special Chars Decode
if (!function_exists('htmlspecialchars_decode')) {
   function htmlspecialchars_decode($text) {
       return strtr($text, array_flip(get_html_translation_table(HTML_SPECIALCHARS)));
   }
}


### Function: Add E-Mail Filters
function email_addfilters() {
	global $added_emailfilters;
	if(!$added_emailfilters) {
		add_filter('the_title', 'email_title');
		add_filter('the_content', 'email_form', '', false, false);
		$added_emailfilters = true;
	}
}


### Function: Remove E-Mail Filters
function email_removefilters() {
	remove_filter('the_title', 'email_title');
	remove_filter('the_content', 'email_form');
}


### Function: E-Mail Page Title
function email_pagetitle($page_title) {
	$page_title = '&raquo; '.__('E-Mail', 'wp-email').$page_title;
	return $page_title;
}


### Function: E-Mail Post ID
if(!function_exists('get_the_id')) {
	function get_the_id() {
		global $id;
		return $id;
	}
}


### Function: E-Mail Title
function email_title($page_title) {
	global $email_title_once;
	if(in_the_loop()) {
		$post_title = get_the_title();
		$post_author = the_author('', false);			
		$post_date = get_the_time(get_option('date_format').' ('.get_option('time_format').')', '', '', false);
		$post_category = email_category();			
		$post_category_alt = strip_tags($post_category);
		$template_title = stripslashes(get_option('email_template_title'));
		$template_title = str_replace("%EMAIL_POST_TITLE%", $post_title, $template_title);
		$template_title = str_replace("%EMAIL_POST_AUTHOR%", $post_author, $template_title);
		$template_title = str_replace("%EMAIL_POST_DATE%", $post_date, $template_title);
		$template_title = str_replace("%EMAIL_POST_CATEGORY%", $post_category, $template_title);
		$template_title = str_replace("%EMAIL_BLOG_NAME%", get_bloginfo('name'), $template_title);
		$template_title = str_replace("%EMAIL_BLOG_URL%", get_bloginfo('url'), $template_title);
		$template_title = str_replace("%EMAIL_PERMALINK%", get_permalink(), $template_title);
		return $template_title;
	} else {
		return $page_title;
	}
}


### Function: E-Mail Category
function email_category($separator = ', ', $parents='') {
	return get_the_category_list($separator, $parents);
}


### Function: E-Mail Content
function email_content() {
	$content = get_email_content();
	$content = str_replace(']]>', ']]&gt;', $content);
	$email_snippet = intval(get_option('email_snippet'));
	if($email_snippet > 0) {
		return snippet_chars($content , $email_snippet);
	} else {
		return $content;
	}
}


### Function: E-Mail Alternate Content
function email_content_alt() {
	remove_filter('the_content', 'wptexturize');
	$content = get_email_content();
	$content = clean_pre($content);
	$content = strip_tags($content);
	$email_snippet = intval(get_option('email_snippet'));
	if($email_snippet > 0) {
		return snippet_chars($content , $email_snippet);
	} else {
		return $content;
	}
}


### Function: E-Mail Get The Content
function get_email_content() {
	global $pages, $multipage, $numpages, $post;
	if (!empty($post->post_password)) {
		if (stripslashes($_COOKIE['wp-postpass_'.COOKIEHASH]) != $post->post_password) {
			return __('Password Protected Post', 'wp-email');
		}
	}
	if($multipage) {
		for($page = 0; $page < $numpages; $page++) {
			$content .= $pages[$page];
		}
	} else {
		$content = $pages[0];
	}
	$content = apply_filters('the_content', $content);
	return $content;
}


### Function: Get IP Address
function get_email_ipaddress() {
	if (empty($_SERVER["HTTP_X_FORWARDED_FOR"])) {
		$ip_address = $_SERVER["REMOTE_ADDR"];
	} else {
		$ip_address = $_SERVER["HTTP_X_FORWARDED_FOR"];
	}
	if(strpos($ip_address, ',') !== false) {
		$ip_address = explode(',', $ip_address);
		$ip_address = $ip_address[0];
	}
	return $ip_address;
}


### Function: Check For Password Protected Post
function not_password_protected() {
	global $post;
	if (!empty($post->post_password)) {
		if ($_COOKIE['wp-postpass_'.COOKIEHASH] != $post->post_password) {
			return false;
		}
	}
	return true;
}


### Function: Check Vaild Name (AlphaNumeric With Spaces Allowed Only)
if(!function_exists('is_valid_name')) {
	function is_valid_name($name) {
		if(ereg('[^[:space:]a-zA-Z0-9]', $name)) {
			return false;
		} else {
			return true;
		}
	}
}


### Function: Check Valid E-Mail Address
if(!function_exists('is_valid_email')) {
	function is_valid_email($email) {
	   $regex = '/^[A-z0-9][\w.-]*@[A-z0-9][\w\-\.]+\.[A-z0-9]{2,6}$/';
	   return (preg_match($regex, $email));
	}
}


### Function: Check Valid Remarks (Ensure No E-Mail Injections)
if(!function_exists('is_valid_remarks')) {
	function is_valid_remarks($content) { 
		$injection_strings = array('apparently-to', 'cc', 'bcc', 'boundary', 'charset', 'content-disposition', 'content-type', 'content-transfer-encoding', 'errors-to', 'in-reply-to', 'message-id', 'mime-version', 'multipart/mixed', 'multipart/alternative', 'multipart/related', 'reply-to', 'x-mailer', 'x-sender', 'x-uidl'); 
		foreach ($injection_strings as $spam) { 
			$check = strpos(strtolower($content), $spam); 
			if ($check !== false) {
				return false;
			}
		}
		return true;
	}
}


### Function: Check For E-Mail Spamming
function not_spamming() {
	global $wpdb;
	$current_time = current_time('timestamp');
	$email_ip = get_email_ipaddress();
	$email_host = @gethostbyaddr($email_ip);
	$email_status = __('Success', 'wp-email');
	$last_emailed = $wpdb->get_var("SELECT email_timestamp FROM $wpdb->email WHERE email_ip = '$email_ip' AND email_host = '$email_host' AND email_status = '$email_status' ORDER BY email_timestamp DESC LIMIT 1");
	$email_allow_interval = intval(get_option('email_interval'))*60;
	if(($current_time-$last_emailed) < $email_allow_interval) {
		return false;
	} else {
		return true;
	}
}


### Function: E-Mail Flood Interval
function email_flood_interval($echo = true) {
	$email_allow_interval_min = intval(get_option('email_interval'));
	if($echo) {
		echo $email_allow_interval_min;
	} else {
		return $email_allow_interval_min;
	}
}


### Function: E-Mail Form Header
function email_form_header($echo = true) {
	global $id;
	$using_permalink = get_option('permalink_structure');
	$permalink = get_permalink();
	// Fix For Static Page
	if(get_option('show_on_front') == 'page' && is_page()) {
		if(intval(get_option('page_on_front')) > 0) {
			$permalink = _get_page_link();
		}
	}
	$output = '';
	if(!empty($using_permalink)) {
		if(is_page()) {
			$output .= '<form action="'.$permalink.'emailpage/" method="post">'."\n";
			$output .= '<p><input type="hidden" name="page_id" value="'.$id.'" /></p>'."\n";
		} else {
			$output = '<form action="'.$permalink.'email/" method="post">'."\n";
			$output .= '<p><input type="hidden" name="p" value="'.$id.'" /></p>'."\n";
		}
	} else {
		if(is_page()) {
			$output .= '<form action="'.$permalink.'&amp;email=1" method="post">'."\n";
			$output .= '<p><input type="hidden" name="page_id" value="'.$id.'" /></p>'."\n";
		} else {
			$output .= '<form action="'.$permalink.'&amp;email=1" method="post">'."\n";
			$output .= '<p><input type="hidden" name="p" value="'.$id.'" /></p>'."\n";
		}
	}
	if($echo) {
		echo $output;
	} else {
		return $output;
	}
}


### Function: E-Mail Form Header For Popup
function email_popup_form_header($echo = true) {
	global $id;
	$using_permalink = get_option('permalink_structure');
	$permalink = get_permalink();
	// Fix For Static Page
	if(get_option('show_on_front') == 'page' && is_page()) {
		if(intval(get_option('page_on_front')) > 0) {
			$permalink = _get_page_link();
		}
	}
	$output = '';
	if(!empty($using_permalink)) {
		if(is_page()) {
			$output .= '<form action="'.$permalink.'emailpopuppage/" method="post">'."\n";
			$output .= '<p><input type="hidden" name="page_id" value="'.$id.'" /></p>'."\n";
		} else {
			$output = '<form action="'.$permalink.'emailpopup/" method="post">'."\n";
			$output .= '<p><input type="hidden" name="p" value="'.$id.'" /></p>'."\n";
		}
	} else {
		if(is_page()) {
			$output .= '<form action="'.$permalink.'&amp;emailpopup=1" method="post">'."\n";
			$output .= '<p><input type="hidden" name="page_id" value="'.$id.'" /></p>'."\n";
		} else {
			$output .= '<form action="'.$permalink.'&amp;emailpopup=1" method="post">'."\n";
			$output .= '<p><input type="hidden" name="p" value="'.$id.'" /></p>'."\n";
		}
	}
	if($echo) {
		echo $output;
	} else {
		return $output;
	}
}


### Function: Multiple E-Mails
function email_multiple($echo = true) {
	$email_multiple = intval(get_option('email_multiple'));
	if($email_multiple > 1) {
		$output = '<br /><em>'.sprintf(__('Separate multiple entries with a comma. Maximum %s entries.', 'wp-email'), $email_multiple).'</em>';
		if($echo) {
			echo $outut;
		} else {
			return $output;
		}
	}
}


### Function: Get EMail Total Sent
if(!function_exists('get_emails')) {
	function get_emails($echo = true) {
		global $wpdb;
		$totalemails = $wpdb->get_var("SELECT COUNT(email_id) FROM $wpdb->email");
		if($echo) {
			echo number_format($totalemails);
		} else {
			return number_format($totalemails);
		}
	}
}


### Function: Get EMail Total Sent Success
if(!function_exists('get_emails_success')) {
	function get_emails_success($echo = true) {
		global $wpdb; 
		$totalemails_success = $wpdb->get_var("SELECT COUNT(email_id) FROM $wpdb->email WHERE email_status = '".__('Success', 'wp-email')."'");
		if($echo) {
			echo number_format($totalemails_success);
		} else {
			return number_format($totalemails_success);
		}
	}
}


### Function: Get EMail Total Sent Failed
if(!function_exists('get_emails_failed')) {
	function get_emails_failed($echo = true) {
		global $wpdb; 
		$totalemails_failed = $wpdb->get_var("SELECT COUNT(email_id) FROM $wpdb->email WHERE email_status = '". __('Failed', 'wp-email')."'");
		if($echo) {
			echo number_format($totalemails_failed);
		} else {
			return number_format($totalemails_failed);
		}
	}
}


### Function: Get Most E-Mailed
if(!function_exists('get_mostemailed')) {
	function get_mostemailed($mode = '', $limit = 10, $chars = 0, $echo = true) {
		global $wpdb, $post;
		$where = '';
		$temp = '';
		if(!empty($mode) && $mode != 'both') {
			$where = "post_type = '$mode'";
		} else {
			$where = '1=1';
		}
		$mostemailed= $wpdb->get_results("SELECT $wpdb->posts.*, COUNT($wpdb->email.email_postid) AS email_total FROM $wpdb->email LEFT JOIN $wpdb->posts ON $wpdb->email.email_postid = $wpdb->posts.ID WHERE post_date < '".current_time('mysql')."' AND $where AND post_password = '' AND post_status = 'publish' GROUP BY $wpdb->email.email_postid ORDER  BY email_total DESC LIMIT $limit");
		if($mostemailed) {
			if($chars > 0) {
				foreach ($mostemailed as $post) {
						$post_title = get_the_title();
						$email_total = intval($post->email_total);
						$temp .= "<li><a href=\"".get_permalink()."\">".snippet_chars($post_title, $chars)."</a> - $email_total ".__('Emails', 'wp-email')."</li>\n";
				}
			} else {
				foreach ($mostemailed as $post) {
						$post_title = get_the_title();
						$email_total = intval($post->email_total);
						$temp .= "<li><a href=\"".get_permalink()."\">$post_title</a> - $email_total ".__('Emails', 'wp-email')."</li>\n";
				}
			}
		} else {
			$temp = '<li>'.__('N/A', 'wp-email').'</li>'."\n";
		}
		if($echo) {
			echo $temp;
		} else {
			return $temp;
		}
	}
}


### Function: Load WP-EMail
add_action('template_redirect', 'wp_email');
function wp_email() {
	global $post_excerpt, $post_content, $post_content_alt;
	if(intval(get_query_var('email')) == 1) {
		if(have_posts()) {
			while(have_posts()) {
				the_post();
				$post_excerpt = get_the_excerpt();
				$post_content = email_content();
				$post_content_alt = email_content_alt();
			}
		}
		include(ABSPATH . 'wp-content/plugins/email/wp-email.php');
		exit;
	} elseif(intval(get_query_var('emailpopup')) == 1) {
		if(have_posts()) {
			while(have_posts()) {
				the_post();
				$post_excerpt = get_the_excerpt();
				$post_content = email_content();
				$post_content_alt = email_content_alt();
			}
		}
		include(ABSPATH . 'wp-content/plugins/email/wp-email-popup.php');
		exit;
	}
}


### Function: E-Mail Form
function email_form($popup = false, $echo = true) {
	global $post_excerpt, $post_content, $post_content_alt, $wpdb;
	// Variables
	$post_title = get_the_title();
	$post_author = the_author('', false);			
	$post_date = get_the_time(get_option('date_format').' ('.get_option('time_format').')', '', '', false);
	$post_category = email_category();			
	$post_category_alt = strip_tags($post_category);
	$email_fields = get_option('email_fields');
	$email_image_verify = intval(get_option('email_imageverify'));
	$yourname = strip_tags(stripslashes(trim($_POST['yourname'])));
	$youremail = strip_tags(stripslashes(trim($_POST['youremail'])));
	$yourremarks = strip_tags(stripslashes(trim($_POST['yourremarks'])));
	$friendname = strip_tags(stripslashes(trim($_POST['friendname'])));
	$friendemail = strip_tags(stripslashes(trim($_POST['friendemail'])));
	$output = '<div class="wp-email">'."\n";
	$template_subtitle = stripslashes(get_option('email_template_subtitle'));
	$template_subtitle = str_replace("%EMAIL_POST_TITLE%", $post_title, $template_subtitle);
	$template_subtitle = str_replace("%EMAIL_POST_AUTHOR%", $post_author, $template_subtitle);
	$template_subtitle = str_replace("%EMAIL_POST_DATE%", $post_date, $template_subtitle);
	$template_subtitle = str_replace("%EMAIL_POST_CATEGORY%", $post_category, $template_subtitle);
	$template_subtitle = str_replace("%EMAIL_BLOG_NAME%", get_bloginfo('name'), $template_subtitle);
	$template_subtitle = str_replace("%EMAIL_BLOG_URL%", get_bloginfo('url'), $template_subtitle);
	$template_subtitle = str_replace("%EMAIL_PERMALINK%", get_permalink(), $template_subtitle);
	$output .= $template_subtitle;
	// If User Click On Mail
	if(!empty($_POST['wp-email'])) {
		// SMTP
		$imageverify = $_POST['imageverify'];
		$smtp_info = get_option('email_smtp');
		$smtp_info = explode('|', $smtp_info);
		$error = '';
		// Multiple Names/Emails
		$friends = array();
		$friendname_count = 0;
		$friendemail_count = 0;
		$multiple_names = explode(',', $friendname);
		$multiple_emails = explode(',', $friendemail);
		$multiple_max = intval(get_option('email_multiple'));
		if($multiple_max == 0) { $multiple_max = 1; }
		// Checking Your Name Field For Errors
		if(intval($email_fields['yourname']) == 1) {
			if(empty($yourname)) {
				$error .= '<br /><strong>&raquo;</strong> '.__('Your name is empty.', 'wp-email');
			}
		}
		// Checking Your E-Mail Field For Errors
		if(intval($email_fields['youremail']) == 1) {
			if(!is_valid_email($youremail) || empty($youremail)) {
				$error .= '<br /><strong>&raquo;</strong> '.__('Your email is invalid or is empty.', 'wp-email');
			}
		}
		// Checking Your Remarks Field For Errors
		if(intval($email_fields['yourremarks']) == 1) {
			if(!is_valid_remarks($yourremarks)) {
				$error .= '<br /><strong>&raquo;</strong> '.__('Your remark is invalid.', 'wp-email');
			}
		}
		// Checking Friend's Name Field For Errors
		if(intval($email_fields['friendname']) == 1) {
			if($multiple_names) {
				foreach($multiple_names as $multiple_name) {
					$multiple_name = trim($multiple_name);
					if(empty($multiple_name)) {
						$error .= '<br /><strong>&raquo;</strong> '.sprintf(__('Friend\'s name (%s) is empty.', 'wp-email'), $multiple_name);
					} else {
						$friends[$friendname_count]['name'] = $multiple_name;
						$friendname_count++;
					}
					if($friendname_count > $multiple_max) {
						break;
					}
				}
			}
		}
		// Checking Friend's E-Mail Field For Errors
		if(intval($email_fields['friendemail']) == 1) {
			if($multiple_emails) {
				foreach($multiple_emails as $multiple_email) {
					$multiple_email = trim($multiple_email);
					if(!is_valid_email($multiple_email) || empty($multiple_email)) {
						$error .= '<br /><strong>&raquo;</strong> '.sprintf(__('Friend\'s email (%s) is invalid or is empty.', 'wp-email'), $multiple_email);
					} else {
						$friends[$friendemail_count]['email'] = $multiple_email;
						$friendemail_count++;
					}
					if($friendemail_count > $multiple_max) {
						break;
					}
				}
			}
		}
		// Checking If The Fields Exceed The Size Of Maximum Entries Allowed
		if(intval($email_fields['friendname']) == 1 || intval($email_fields['friendemail']) == 1) {
			if(sizeof($friends) > $multiple_max) {
				$error .= '<br /><strong>&raquo;</strong> '.sprintf(__('Maximum %s entries allowed', 'wp-email'), $multiple_max);
			}
		}
		if(intval($email_fields['friendname']) == 1 && intval($email_fields['friendemail']) == 1) {
			if($friendname_count != $friendemail_count) {
				$error .= '<br /><strong>&raquo;</strong> '.__('Friends\' name count does not tally with friends\' email count.', 'wp-email');
			}
		}
		// Check Whether We Enable Image Verification
		if($email_image_verify) {
			$imageverify = strtoupper($imageverify);
			if(empty($imageverify)) {
				$error .= '<br /><strong>&raquo;</strong> '.__('Image verification is empty.', 'wp-email');
			} else {
				if($_SESSION['email_verify'] != md5($imageverify)) {
					$error .= '<br /><strong>&raquo;</strong> '.__('Image verification failed.', 'wp-email');
				}
			}
		}
		// If There Is No Error, We Process The E-Mail
		if(empty($error) && not_spamming()) {
			// If Remarks Is Empty, Assign N/A
			if(empty($yourremarks)) { $yourremarks = __('N/A', 'wp-email'); }
			// Template For E-Mail Subject
			$template_email_subject = stripslashes(get_option('email_template_subject'));
			$template_email_subject = str_replace("%EMAIL_YOUR_NAME%", $yourname, $template_email_subject);
			$template_email_subject = str_replace("%EMAIL_YOUR_EMAIL%", $youremail, $template_email_subject);
			$template_email_subject = str_replace("%EMAIL_POST_TITLE%", $post_title, $template_email_subject);
			$template_email_subject = str_replace("%EMAIL_POST_AUTHOR%", $post_author, $template_email_subject);
			$template_email_subject = str_replace("%EMAIL_POST_DATE%", $post_date, $template_email_subject);
			$template_email_subject = str_replace("%EMAIL_POST_CATEGORY%", $post_category_alt, $template_email_subject);
			$template_email_subject = str_replace("%EMAIL_BLOG_NAME%", get_bloginfo('name'), $template_email_subject);
			$template_email_subject = str_replace("%EMAIL_BLOG_URL%", get_bloginfo('url'), $template_email_subject);
			$template_email_subject = str_replace("%EMAIL_PERMALINK%", get_permalink(), $template_email_subject);
			// Template For E-Mail Body
			$template_email_body = stripslashes(get_option('email_template_body'));
			$template_email_body = str_replace("%EMAIL_YOUR_NAME%", $yourname, $template_email_body);
			$template_email_body = str_replace("%EMAIL_YOUR_EMAIL%", $youremail, $template_email_body);
			$template_email_body = str_replace("%EMAIL_YOUR_REMARKS%", $yourremarks, $template_email_body);
			$template_email_body = str_replace("%EMAIL_FRIEND_NAME%", $friendname, $template_email_body);
			$template_email_body = str_replace("%EMAIL_FRIEND_EMAIL%", $friendemail, $template_email_body);
			$template_email_body = str_replace("%EMAIL_POST_TITLE%", $post_title, $template_email_body);
			$template_email_body = str_replace("%EMAIL_POST_AUTHOR%", $post_author, $template_email_body);
			$template_email_body = str_replace("%EMAIL_POST_DATE%", $post_date, $template_email_body);
			$template_email_body = str_replace("%EMAIL_POST_CATEGORY%", $post_category, $template_email_body);
			$template_email_body = str_replace("%EMAIL_POST_EXCERPT%", $post_excerpt, $template_email_body);
			$template_email_body = str_replace("%EMAIL_POST_CONTENT%", $post_content, $template_email_body);
			$template_email_body = str_replace("%EMAIL_BLOG_NAME%", get_bloginfo('name'), $template_email_body);
			$template_email_body = str_replace("%EMAIL_BLOG_URL%", get_bloginfo('url'), $template_email_body);
			$template_email_body = str_replace("%EMAIL_PERMALINK%", get_permalink(), $template_email_body);
			// Template For E-Mail Alternate Body
			$template_email_bodyalt = stripslashes(get_option('email_template_bodyalt'));
			$template_email_bodyalt = str_replace("%EMAIL_YOUR_NAME%", $yourname, $template_email_bodyalt);
			$template_email_bodyalt = str_replace("%EMAIL_YOUR_EMAIL%", $youremail, $template_email_bodyalt);
			$template_email_bodyalt = str_replace("%EMAIL_YOUR_REMARKS%", $yourremarks, $template_email_bodyalt);
			$template_email_bodyalt = str_replace("%EMAIL_FRIEND_NAME%", $friendname, $template_email_bodyalt);
			$template_email_bodyalt = str_replace("%EMAIL_FRIEND_EMAIL%", $friendemail, $template_email_bodyalt);
			$template_email_bodyalt = str_replace("%EMAIL_POST_TITLE%", $post_title, $template_email_bodyalt);
			$template_email_bodyalt = str_replace("%EMAIL_POST_AUTHOR%", $post_author, $template_email_bodyalt);
			$template_email_bodyalt = str_replace("%EMAIL_POST_DATE%", $post_date, $template_email_bodyalt);
			$template_email_bodyalt = str_replace("%EMAIL_POST_CATEGORY%", $post_category_alt, $template_email_bodyalt);
			$template_email_bodyalt = str_replace("%EMAIL_POST_EXCERPT%", $post_excerpt, $template_email_bodyalt);
			$template_email_bodyalt = str_replace("%EMAIL_POST_CONTENT%", $post_content_alt, $template_email_bodyalt);
			$template_email_bodyalt = str_replace("%EMAIL_BLOG_NAME%", get_bloginfo('name'), $template_email_bodyalt);
			$template_email_bodyalt = str_replace("%EMAIL_BLOG_URL%", get_bloginfo('url'), $template_email_bodyalt);
			$template_email_bodyalt = str_replace("%EMAIL_PERMALINK%", get_permalink(), $template_email_bodyalt);
			// PHP Mailer Variables
			$mail = new PHPMailer();
			$mail->From     = $youremail;
			$mail->FromName = $yourname;
			foreach($friends as $friend) {
				$mail->AddAddress($friend['email'], $friend['name']);
			}
			$mail->Username = $smtp_info[0]; 
			$mail->Password = $smtp_info[1];
			$mail->Host     = $smtp_info[2];
			$mail->Mailer   = get_option('email_mailer');
			$mail->ContentType =  get_option('email_contenttype');
			$mail->Subject = $template_email_subject;
			if(get_option('email_contenttype') == 'text/plain') {
				$mail->Body    = $template_email_bodyalt;
			} else {
				$mail->Body    = $template_email_body;
				$mail->AltBody = $template_email_bodyalt;
			}
			// Send The Mail
			if($mail->Send()) {
				$email_status = __('Success', 'wp-email');
				// Template For Sent Successfully
				$template_email_sentsuccess = stripslashes(get_option('email_template_sentsuccess'));
				$template_email_sentsuccess = str_replace("%EMAIL_FRIEND_NAME%", $friendname, $template_email_sentsuccess);
				$template_email_sentsuccess = str_replace("%EMAIL_FRIEND_EMAIL%", $friendemail, $template_email_sentsuccess);
				$template_email_sentsuccess = str_replace("%EMAIL_POST_TITLE%", $post_title, $template_email_sentsuccess);
				$template_email_sentsuccess = str_replace("%EMAIL_BLOG_NAME%", get_bloginfo('name'), $template_email_sentsuccess);
				$template_email_sentsuccess = str_replace("%EMAIL_BLOG_URL%", get_bloginfo('url'), $template_email_sentsuccess);
				$template_email_sentsuccess = str_replace("%EMAIL_PERMALINK%", get_permalink(), $template_email_sentsuccess);
			// If There Is Error Sending
			} else {
				if($yourremarks == __('N/A', 'wp-email')) { $yourremarks = ''; }
				$email_status = __('Failed', 'wp-email');
				// Template For Sent Failed
				$template_email_sentfailed = stripslashes(get_option('email_template_sentfailed'));
				$template_email_sentfailed = str_replace("%EMAIL_FRIEND_NAME%", $friendname, $template_email_sentfailed);
				$template_email_sentfailed = str_replace("%EMAIL_FRIEND_EMAIL%", $friendemail, $template_email_sentfailed);
				$template_email_sentfailed = str_replace("%EMAIL_ERROR_MSG%", $mail->ErrorInfo, $template_email_sentfailed);
				$template_email_sentfailed = str_replace("%EMAIL_POST_TITLE%", $post_title, $template_email_sentfailed);
				$template_email_sentfailed = str_replace("%EMAIL_BLOG_NAME%", get_bloginfo('name'), $template_email_sentfailed);
				$template_email_sentfailed = str_replace("%EMAIL_BLOG_URL%", get_bloginfo('url'), $template_email_sentfailed);
				$template_email_sentfailed = str_replace("%EMAIL_PERMALINK%", get_permalink(), $template_email_sentfailed);
			}
			// Logging
			$email_yourname = addslashes($yourname);
			$email_youremail = addslashes($youremail);
			$email_yourremarks = addslashes($yourremarks);
			$email_postid = intval(get_the_id());
			$email_posttitle = addslashes($post_title);
			$email_timestamp = current_time('timestamp');
			$email_ip = get_email_ipaddress();
			$email_host = @gethostbyaddr($email_ip);
			foreach($friends as $friend) {
				$email_friendname = addslashes($friend['name']);
				$email_friendemail = addslashes($friend['email']);
				$wpdb->query("INSERT INTO $wpdb->email VALUES (0, '$email_yourname', '$email_youremail', '$email_yourremarks', '$email_friendname', '$email_friendemail', $email_postid, '$email_posttitle', '$email_timestamp', '$email_ip', '$email_host', '$email_status')");
			}
		// If There Are Errors
		} else {
			$error = substr($error, 21);
			$template_email_error = stripslashes(get_option('email_template_error'));				
			$template_email_error = str_replace("%EMAIL_ERROR_MSG%", $error, $template_email_error);
			$template_email_error = str_replace("%EMAIL_BLOG_NAME%", get_bloginfo('name'), $template_email_error);
			$template_email_error = str_replace("%EMAIL_BLOG_URL%", get_bloginfo('url'), $template_email_error);
			$template_email_error = str_replace("%EMAIL_PERMALINK%", get_permalink(), $template_email_error);				
		} // End if(empty($error))
	} // End if(!empty($_POST['wp-email']))
	// Display WP-EMail Success
	if($email_status == __('Success', 'wp-email')) {
		$output .= $template_email_sentsuccess;
	// Display WP-EMail Form
	} else {
		if (not_spamming()) {
			if(not_password_protected()) {
				if($popup){
					$output .= email_popup_form_header(false);
				} else {
					$output .= email_form_header(false);
				}
				$output .= '<!-- Display Error, If There Is Any -->'."\n";
				$output .= $template_email_sentfailed;
				$output .= $template_email_error;
				$output .= '<!-- End Display Error, If There Is Any -->'."\n";
				$output .= '<p><strong>'.__('* Required Field', 'wp-email').'</strong></p>'."\n";
				if(intval($email_fields['yourname']) == 1) {
					$output .= '<p>'."\n";
					$output .= '<strong><label for="yourname">'.__('Your Name: *', 'wp-email').'</label></strong><br />'."\n";
					$output .= '<input type="text" size="50" id="yourname" name="yourname" class="Forms" value="'.$yourname.'" />'."\n";
					$output .= '</p>'."\n";
				}
				if(intval($email_fields['youremail']) == 1) {
					$output .= '<p>'."\n";
					$output .= '<strong><label for="youremail">'.__('Your E-Mail: *', 'wp-email').'</label></strong><br />'."\n";
					$output .= '<input type="text" size="50" id="youremail" name="youremail" class="Forms" value="'.$youremail.'" />'."\n";
					$output .= '</p>'."\n";
				}
				if(intval($email_fields['yourremarks']) == 1) {
					$output .= '<p>'."\n";
					$output .= '	<strong><label for="yourremarks">'.__('Your Remark:', 'wp-email').'</label></strong><br />'."\n";
					$output .= '	<textarea cols="49" rows="8" id="yourremarks" name="yourremarks" class="Forms">'.$yourremarks.'</textarea>'."\n";
					$output .= '</p>'."\n";
				}
				if(intval($email_fields['friendname']) == 1) {
					$output .= '<p>'."\n";
					$output .= '<strong><label for="friendname">'.__('Friend\'s Name: *', 'wp-email').'</label></strong><br />'."\n";
					$output .= '<input type="text" size="50" id="friendname" name="friendname" class="Forms" value="'.$friendname.'" />'.email_multiple(false)."\n";
					$output .= '</p>'."\n";
				}
				if(intval($email_fields['friendemail']) == 1) {
					$output .= '<p>'."\n";
					$output .= '<strong><label for="friendemail">'.__('Friend\'s E-Mail: *', 'wp-email').'</label></strong><br />'."\n";
					$output .= '<input type="text" size="50" id="friendemail" name="friendemail" class="Forms" value="'.$friendemail.'" />'.email_multiple(false)."\n";
					$output .= '</p>'."\n";
				}
				if($email_image_verify) {
					$output .= '<p>'."\n";
					$output .= '<strong><label for="imageverify">'.__('Image Verification: *', 'wp-email').'</label></strong><br />'."\n";
					$output .= '<img src="'.get_option('siteurl').'/wp-content/plugins/email/email-image-verify.php" width="55" height="15" alt="'.__('E-Mail Image Verification', 'wp-email').'" /><input type="text" size="5" maxlength="5" id="imageverify" name="imageverify" class="Forms" />'."\n";
					$output .= '</p>'."\n";
				}
				$output .= '<p style="text-align: center"><input type="submit" value="'.__('     Mail It!     ', 'wp-email').'" name="wp-email" class="Buttons" /></p>'."\n";
				$output .= '</form>'."\n";
			} else { 
				$output .= get_the_password_form();
			} // End if(not_password_protected())
		} else {
			$output .= '<p>'.sprintf(__('Please wait for <strong>%s Minutes</strong> before sending the next article.', 'wp-email'), email_flood_interval(false)).'</p>'."\n";
		} // End if (not_spamming())
	} // End if($email_status == __('Success', 'wp-email'))
	$output .= '</div><p>&nbsp;'."\n";
	email_removefilters();
	if($echo) {
		echo $output;
	} else {
		return $output;
	}
}


### Function: Modify Default WordPress Listing To Make It Sorted By Most E-Mailed
function email_fields($content) {
	global $wpdb;
	$content .= ", COUNT($wpdb->email.email_postid) AS email_total";
	return $content;
}
function email_join($content) {
	global $wpdb;
	$content .= " LEFT JOIN $wpdb->email ON $wpdb->email.email_postid = $wpdb->posts.ID";
	return $content;
}
function email_groupby($content) {
	global $wpdb;
	$content .= " $wpdb->email.email_postid";
	return $content;
}
function email_orderby($content) {
	$orderby = trim(addslashes($_GET['orderby']));
	if(empty($orderby) && ($orderby != 'asc' || $orderby != 'desc')) {
		$orderby = 'desc';
	}
	$content = " email_total $orderby";
	return $content;
}


### Process The Sorting
/*
if($_GET['sortby'] == 'email') {
	add_filter('posts_fields', 'email_fields');
	add_filter('posts_join', 'email_join');
	add_filter('posts_groupby', 'email_groupby');
	add_filter('posts_orderby', 'email_orderby');
}
*/


### Function: Create E-Mail Table
add_action('activate_email/email.php', 'create_email_table');
function create_email_table() {
	global $wpdb;
	include_once(ABSPATH.'wp-admin/upgrade-functions.php');
	// Create E-Mail Table
	$create_table = "CREATE TABLE $wpdb->email (".
							"email_id int(10) NOT NULL auto_increment,".
							"email_yourname varchar(200) NOT NULL default '',".
							"email_youremail varchar(200) NOT NULL default '',".
							"email_yourremarks text NOT NULL,".
							"email_friendname varchar(200) NOT NULL default '',".
							"email_friendemail varchar(200) NOT NULL default '',".
							"email_postid int(10) NOT NULL default '0',".
							"email_posttitle text NOT NULL,".
							"email_timestamp varchar(20) NOT NULL default '',".
							"email_ip varchar(100) NOT NULL default '',".
							"email_host varchar(200) NOT NULL default '',".
							"email_status varchar(20) NOT NULL default '',".
							"PRIMARY KEY (email_id));";
	maybe_create_table($wpdb->email, $create_table);
	// Add In Options (12 Records)
	add_option('email_smtp', '', 'Your SMTP Name, Password, Server');
	add_option('email_contenttype', 'text/html', 'Your E-Mail Type');
	add_option('email_mailer', 'php', 'Your Mailer Type');
	add_option('email_template_subject', __('Recommended Article By %EMAIL_YOUR_NAME%: %EMAIL_POST_TITLE%', 'wp-email'), 'Template For E-Mail Subject');
	add_option('email_template_body', __('<p>Hi <strong>%EMAIL_FRIEND_NAME%</strong>,<br />Your friend, <strong>%EMAIL_YOUR_NAME%</strong>, has recommended this article entitled \'<strong>%EMAIL_POST_TITLE%</strong>\' to you.</p><p><strong>Here is his/her remark:</strong><br />%EMAIL_YOUR_REMARKS%</p><p><strong>%EMAIL_POST_TITLE%</strong><br />Posted By %EMAIL_POST_AUTHOR% On %EMAIL_POST_DATE% In %EMAIL_POST_CATEGORY%</p>%EMAIL_POST_CONTENT%<p>Article taken from %EMAIL_BLOG_NAME% - <a href="%EMAIL_BLOG_URL%">%EMAIL_BLOG_URL%</a><br />URL to article: <a href="%EMAIL_PERMALINK%">%EMAIL_PERMALINK%</a></p>', 'wp-email'), 'Template For E-Mail Body');
	add_option('email_template_bodyalt', __('Hi %EMAIL_FRIEND_NAME%,'."\n".
	'Your friend, %EMAIL_YOUR_NAME%, has recommended this article entitled \'%EMAIL_POST_TITLE%\' to you.'."\n\n".
	'Here is his/her remarks:'."\n".
	'%EMAIL_YOUR_REMARKS%'."\n\n".
	'%EMAIL_POST_TITLE%'."\n".
	'Posted By %EMAIL_POST_AUTHOR% On %EMAIL_POST_DATE% In %EMAIL_POST_CATEGORY%'."\n".
	'%EMAIL_POST_CONTENT%'."\n".
	'Article taken from %EMAIL_BLOG_NAME% - %EMAIL_BLOG_URL%'."\n".
	'URL to article: %EMAIL_PERMALINK%', 'wp-email'), 'Template For E-Mail Alternate Body');
	add_option('email_template_sentsuccess', '<p>'.__('Article: <strong>%EMAIL_POST_TITLE%</strong> Has Been Sent To <strong>%EMAIL_FRIEND_NAME% (%EMAIL_FRIEND_EMAIL%)</strong></p>', 'wp-email'), 'Template For E-Mail That Is Sent Successfully');
	add_option('email_template_sentfailed', '<p>'.__('An Error Has Occured When Trying To Send The E-Mail', 'wp-email').'<br /><strong>&raquo;</strong> %EMAIL_ERROR_MSG%</p>', 'Template For E-Mail That Failed To Sent');
	add_option('email_template_error', '<p>'.__('An Error Has Occured', 'wp-email').'<br /><strong>&raquo;</strong> %EMAIL_ERROR_MSG%</p>', 'Template For E-Mail That Has An Error');
	add_option('email_interval', 10, 'The Number Of Minutes Before The User Can E-Mail The Next Article');
	add_option('email_snippet', 100, 'Enable Snippet Feature For Your E-Mail?');
	add_option('email_multiple', 5, 'Maximum Number Of Multiple E-Mails');
	// Version 2.05 Options
	add_option('email_imageverify', 1, 'Enable Image Verification?');
	// Version 2.10 Options
	$email_options = array('post_text' => __('Email This Post', 'wp-email'), 'page_text' => __('Email This Page', 'wp-email'), 'email_icon' => 'email.gif', 'email_type' => 1, 'email_style' => 1, 'email_html' => '<a href="%EMAIL_URL%" rel="nofollow" title="%EMAIL_TEXT%">%EMAIL_TEXT%</a>');
	$email_fields = array('yourname' => 1, 'youremail' => 1, 'yourremarks' => 1, 'friendname' => 1, 'friendemail' => 1);
	add_option('email_options', $email_options, 'Email Options');
	add_option('email_fields', $email_fields, 'Email Fields');
	// Version 2.11 Options
	add_option('email_template_title', __('E-Mail \'%EMAIL_POST_TITLE%\' To A Friend', 'wp-email'), 'Template For E-Mail Page Title');
	add_option('email_template_subtitle', '<p style="text-align: center;">'.__('Email a copy of <strong>\'%EMAIL_POST_TITLE%\'</strong> to a friend', 'wp-email').'</p>', 'Template For E-Mail Page SubTitle');
	// Set 'manage_email' Capabilities To Administrator	
	$role = get_role('administrator');
	if(!$role->has_cap('manage_email')) {
		$role->add_cap('manage_email');
	}
}
?>