<?php get_header(); ?>
<div id="main-block">
    <div id="content">
	<?php if (have_posts()) : ?>
        <ul>
		<?php while (have_posts()) : the_post(); ?>
			<li class="post" id="post-<?php the_ID(); ?>">
                
                <div class="title">
            	    <h2><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>"><?php the_title(); ?></a></h2>
                </div>
                <div class="postdata">
                    <span class="date"><?php the_time('d M Y') ?>&nbsp;/&nbsp;</span>
                    <span class="category"><?php the_category(', ') ?></span>
                    <span class="comments"><?php comments_popup_link('No Comments', '1 Comment', '% Comments'); ?></span>
                </div>
        		<div class="entry">
        		    <?php the_content('Read the rest of this entry &raquo;'); ?>
        		</div>
        		<p>Posted by <?php the_author() ?> @ <?php the_time() ?> <?php edit_post_link(__('Edit')); ?></p>
        		<?php the_tags( '<p>Tags: ', ', ', '</p>'); ?>
			</li>
		<?php endwhile; ?>
        </ul>
        
        <?php comments_template(); ?>
        
		<div class="navigation">
			<span class="alignleft"><?php next_posts_link('Previous Page') ?></span>
			<span class="alignright"><?php previous_posts_link('Next Page') ?></span>
		</div>
		
    	<?php else : ?>
            <h2 class="t-center">No posts found matched your criteria</h2>
    	<?php endif; ?>
    </div>
</div>

<?php get_sidebar(); ?>

<?php get_footer(); ?>
