jQuery(window).load(function () {
    if ((jQuery().flexslider())) {

        /* ======================= */
        /* ==== NORMAL SLIDER ==== */

        jQuery('.flexslider.normal-slider').each(function () {
            var $this = jQuery(this);

            $this.flexslider({
                smoothHeight: true,
                controlNav: false,
                prevText: "",
                nextText: ""
            })
        });

        /* ============================ */
        /* ==== FLEXSLIDER CONTENT ==== */

        jQuery(".flexslider.std-slider .object").each(function () {
            var $this = jQuery(this);
            if ($this.hasClass("absolute")) {
                $this.css({
                    "top": $this.data("top"),
                    "bottom": $this.data("bottom"),
                    "left": $this.data("left"),
                    "right": $this.data("right")
                });
            } else {
                $this.css({
                    "margin-top": $this.data("top"),
                    "margin-bottom": $this.data("bottom"),
                    "margin-left": $this.data("left"),
                    "margin-right": $this.data("right")
                });
            }
        })


        /* ==================================== */
        /* ==== FLEXSLIDER WITH ANIMATIONS ==== */

        if (jQuery(".flexslider.std-slider").length > 0) {

            jQuery('.flexslider.std-slider').each(function () {
                var $this = jQuery(this);
                $this.find(".slides > li .inner").each(function () {
                    var $container = jQuery(this);
                    $container.css('min-height', $this.attr('data-height') + "px");
                })
                // initialize
                $this.find(".slides > li").each(function () {
                    var $slide_item = jQuery(this);
                    var bg = validatedata($slide_item.data('bg'), false);
                    if (bg) {
                        $slide_item.css('background-image', 'url("' + bg + '")');
                    }
                    $slide_item.css('min-height', $this.attr('data-height') + "px");

                    // hide slider content due to fade animation
                    //$slide_item.find(".inner").hide();
                    /*
                     $slide_item.find(".inner [data-fx]").each(function () {
                     $(this).removeClass("animated");
                     })
                     */
                    $slide_item.find('.inner').fadeOut("slow");
                })

                var direction = validatedata($this.attr('data-direction'), "horizontal");
                var animation = validatedata($this.attr('data-animation'), "fade");
                var loop = validatedata(parseBoolean($this.attr("data-loop")), false);
                var smooth = validatedata(parseBoolean($this.attr("data-smooth")), false);
                var slideshow = validatedata(parseBoolean($this.attr("data-slideshow")), false);
                var speed = validatedata(parseInt($this.attr('data-speed')), 7000);
                var animspeed = validatedata(parseInt($this.attr("data-animspeed")), 600);
                var controls = validatedata(parseBoolean($this.attr('data-controls')), false);
                var dircontrols = validatedata(parseBoolean($this.attr('data-dircontrols')), false);

                $this.flexslider({
                    direction: direction,        //String: Select the sliding direction, "horizontal" or "vertical"
                    animation: animation,              //String: Select your animation type, "fade" or "slide"
                    animationLoop: loop,             //Boolean: Should the animation loop? If false, directionNav will received "disable" classes at either end
                    smoothHeight: smooth,            //{NEW} Boolean: Allow height of the slider to animate smoothly in horizontal mode
                    slideshow: slideshow,                //Boolean: Animate slider automatically
                    slideshowSpeed: speed,           //Integer: Set the speed of the slideshow cycling, in milliseconds
                    animationSpeed: animspeed,            //Integer: Set the speed of animations, in milliseconds
                    touch: false,

                    // Primary Controls
                    controlNav: controls,               //Boolean: Create navigation for paging control of each clide? Note: Leave true for manualControls usage
                    directionNav: dircontrols,             //Boolean: Create navigation for previous/next navigation? (true/false)
                    manualControls: ".flex-control-nav li",

                    pauseOnHover: true,            //Boolean: Pause the slideshow when hovering over slider, then resume when no longer hovering
                    prevText: " ",           //String: Set the text for the "previous" directionNav item
                    nextText: " ",
                    useCSS: false,

                    // Callback API
                    start: function () {
                        $this.removeClass("loading-slider");

                        setTimeout(function () {
                            $this.find(".slides > li.flex-active-slide .inner").fadeIn("slow");
                            $this.find(".slides > li.flex-active-slide .inner [data-fx]").each(function () {
                                var $content = jQuery(this);
                                $content.addClass($content.data('fx')).addClass("activate");
                            })
                        }, 650);

                    },
                    before: function () {

                        $this.find(".slides > li .inner").fadeOut("slow");
                    },           //Callback: function(slider) - Fires asynchronously with each slider animation
                    after: function () {
                        setTimeout(function () {
                            $this.find(".slides > li.flex-active-slide .inner").fadeIn("slow");
                            $this.find(".slides > li.flex-active-slide .inner [data-fx]").each(function () {
                                var $content = jQuery(this);
                                $content.addClass($content.data('fx')).addClass("activate");
                            })
                        }, 150);
                    },            //Callback: function(slider) - Fires after each slider animation completes
                    end: function () {
                    },              //Callback: function(slider) - Fires when the slider reaches the last slide (asynchronous)
                    added: function () {
                    },            //{NEW} Callback: function(slider) - Fires after a slide is added
                    removed: function () {
                    }           //{NEW} Callback: function(slider) - Fires after a slide is removed
                });
            });
        }
    }
});


