
/* ==== DROPDOWN MEGA MENU ==== */

jQuery(function () {
    "use strict";
    window.prettyPrint && prettyPrint()
    jQuery(document).on('hoverState', '.yamm .dropdown-menu', function (e) {
        e.stopPropagation()
    })
})

/* ==== HELPER FUNCTIONS ==== */

function validatedata($attr, $defaultValue) {
    "use strict";
    if ($attr !== undefined) {
        return $attr
    }
    return $defaultValue;
}

function parseBoolean(str, $defaultValue) {
    "use strict";
    if (str == 'true') {
        return true;
    }
    return $defaultValue;
    //return /true/i.test(str);
}

jQuery(window).scroll(function () {
    "use strict";
    function fixNavBar() {

        var $header = jQuery('header.section');
        var $cache = jQuery('.navbar.navbar-default');
        if (jQuery(window).scrollTop() > 360) {
            $header.css({'padding-top': '150px'});
            $cache.addClass('navbar-fixed-top');
        }
        else if (jQuery(window).scrollTop() < 200) {
            $cache.removeClass('navbar-fixed-top');
            $header.css({'padding-top': '0px'});
        }
    }

    fixNavBar();
});

jQuery(document).ready(function () {
    "use strict";

    // menu for onepager
    jQuery("#nav > li > a[href^='/#']").each(function () {
        var $this = jQuery(this);
        jQuery($this.parent()).removeClass("active").addClass("onepage");
        // remove unnecessary active classes
        $this.parent().removeClass("active");
    });

    // remove unnecessary active classes
    jQuery("#nav > li > a[href='/']").parent().removeClass("active");

    if (jQuery().pageScroller) {
        // initiate page scroller plugin
        jQuery('body').pageScroller({
            navigation: '.onepage',
            scrollOffset: -70
        });
    }

    jQuery('.btn-scroll[href^="#"]').on('click', function (e) {
        e.preventDefault();

        var $target = jQuery(this).hash;
        $target = jQuery($target);

        jQuery('html, body').stop().animate({
            'scrollTop': $target.offset().top
        }, 900, 'swing', function () {
            window.location.hash = target;
        });
    });

    var isSmallDesktop = false;
    var isPhone = false;
    var isTablet = false;


    function checkDeviceType() {
        isSmallDesktop = (jQuery(window).width() < 992);

        isPhone = device.mobile();
        isTablet = device.tablet();
        // adjusting for smaller screens
        if (isPhone || isTablet || isSmallDesktop) {

            jQuery("body").addClass("isMobile");
        } else {
            jQuery("body").addClass("isDesktop");
        }

    }

    checkDeviceType();

    /* ======================================= */
    /* === CLICKABLE MAIN PARENT ITEM MENU === */
    jQuery(".navbar li.dropdown > .dropdown-toggle").removeAttr("data-toggle data-target");

    /* ======================== */
    /* ==== ANIMATION CHECK ==== */

    if (isPhone || isTablet || isSmallDesktop) {
        // disable animation on mobile
        jQuery("body").removeClass("cssAnimate");
    }

    /* =============================== */
    /* ==== PLACEHOLDERS FALLBACK ==== */

    if (jQuery().placeholder) {
        jQuery("input[placeholder],textarea[placeholder]").placeholder();
    }


    /* =============================== */
    /* ==== TOOLTIPS AND POPOVERS ==== */

    jQuery("[data-toggle='tooltip']").tooltip();

    jQuery("[data-toggle='popover']").popover({trigger: "hover", html: true});




    /* ==================== */
    /* ==== FIT VIDEOS ==== */

    if (jQuery().fitVids) {
        jQuery('.fit-video').fitVids();
    }


});


jQuery(window).load(function () {
    "use strict";

    var isSmallDesktop = (jQuery(window).width() < 992);

    /* ================================ */
    /* ==== DROPDOWN MENU ON HOVER ==== */


    if (device.mobile() || device.tablet() || isSmallDesktop) {

    } else {

        /* yamm menu on hover */
        var $dropdown = jQuery(".navbar .dropdown");

        $dropdown.each(function () {
            var $this = jQuery(this);

            var $dropmenu = $this.find("> .dropdown-menu");
            $this.addClass("drop-collapsed");
        });
    }

    var navTimeout;

    function showMenu() {
        var $this = jQuery(this);

        navTimeout = setTimeout(function () {
            $this.find("> .dropdown-menu").css("display", "block");
            setTimeout(function () {
                $this.removeClass("drop-collapsed");
            }, 10);
        }, 100);
    }

    function hideMenu() {

        clearTimeout(navTimeout);

        $dropdown.each(function () {
            var $this = jQuery(this);
            $this.addClass("drop-collapsed");

            setTimeout(function () {
                jQuery(".drop-collapsed > ul.dropdown-menu").css("display", "none");
            }, 300);
        });
    }

    var hovsettings = {
        timeout: 0,
        interval: 0,
        over: showMenu,
        out: hideMenu
    };


    if (device.mobile() || device.tablet() || isSmallDesktop) {

    } else {
        $dropdown.hoverIntent(hovsettings);
    }


    /* =========================================== */
    /* ==== SIDEBAR MASONRY FOR SMALL SCREENS ==== */

    if (jQuery().masonry && (jQuery(window).width() < 992) && (jQuery(window).width() > 767)) {

        jQuery('.sidebar .row').masonry({
            itemSelector: '.col-sm-6.col-md-12, .widget',
            layoutMode: 'sloppyMasonry',
            resizable: false, // disable normal resizing
            // set columnWidth to a percentage of container width
            masonry: {}
        });
    }


});


