<?php
require_once get_template_directory() . '/framework/createit/ctThemeLoader.php';

$c = new ctThemeLoader();
$c->init('daycare');

function roots_setup() {


	// Make theme available for translation
	load_theme_textdomain('ct_theme', get_template_directory() . '/lang');

	// Add default posts and comments RSS feed links to <head>.
	add_theme_support('automatic-feed-links');

	// Add post thumbnails (http://codex.wordpress.org/Post_Thumbnails)
	add_theme_support('post-thumbnails');

	add_theme_support('post-formats', array('aside', 'gallery', 'link', 'image', 'quote', 'video', 'audio'));

	add_theme_support('custom-header');

    add_theme_support( 'woocommerce' );



    //add size for featured image
    add_image_size('featured_image', 688, 244, true);
    add_image_size('post_format_gallery', 688, 503, true);
    add_image_size('widget_gallery', 223, 150, true);
    add_image_size('gallery_thumb', 180, 130, true);
    add_image_size('gallery_thumb_index', 346, 250, true);
    add_image_size('gallery_big', 380, 280, true);
    add_image_size('gallery_tall', 178, 276, true);
    add_image_size('sidebar_gallery', 104, 103, true);

    require_once CT_THEME_SETTINGS_MAIN_DIR . '/options/ctCustomizeManagerHandler.class.php';
    new ctCustomizeManagerHandler();
}

add_action('after_setup_theme', 'roots_setup');

if(!function_exists('ct_admin_documentation')) {
    function ct_admin_documentation() {
        global $submenu;
        $submenu['themes.php'][129] = array(
            __('Documentation','ct_theme'),
            'manage_options',
            'http://createit.support/documentation/daycare-documentation/'
        );
    }
}
add_action( 'admin_menu', 'ct_admin_documentation' );

require_once 'theme/theme_functions.php';







