<?php
/*
Template Name: Faq Template
*/
?>


<!--container!--></div>
<?php get_template_part('templates/page', 'head'); ?>

<?php $breadcrumbs = ct_show_index_post_breadcrumbs('post') ? 'yes' : 'no'; ?>
<?php $custom = get_post_custom(get_the_ID()) ?>
<?php $pageTitle = ct_get_single_post_title('page'); ?>

</div>


<?php
$show = false;
$image = '';
$top = 0;
$left = 0;

if (!isset($custom['show_page_obj'][0])) {
    $custom['show_page_obj'][0] = 'global';
}
if (ct_get_option('effects_top_object_show', 1)) {
    if (isset($custom['show_page_obj'][0]) && $custom['show_page_obj'][0] == 'yes') {
        if (isset($custom['page_meta_top_img'][0]) && isset ($custom['page_meta_top_img_top'][0]) && isset ($custom['page_meta_top_img_left'][0])) {
            $image = $custom['page_meta_top_img'][0];
            $top = $custom['page_meta_top_img_top'][0];
            $left = $custom['page_meta_top_img_left'][0];
            $show = true;
        }
    } else if ($custom['show_page_obj'][0] == 'global') {
        if (ct_get_option('faq_effects_top_object_image') != '') {
            $image = ct_get_option('faq_effects_top_object_image', '');
            $top = ct_get_option('faq_effects_top_object_top', 0);
            $left = ct_get_option('faq_effects_top_object_left', 0);
            $show = true;
        }
    } else {
        $show = false;

    }

} else {
    $show = false;

}

?>


<?php $custom = get_post_custom(get_the_ID()) ?>

<?php if (isset($custom['header_block'][0]) && $custom['header_block'][0] != '' && is_numeric($custom['header_block'][0] )) {
    $blockObject = get_post($custom['header_block'][0]);
    if (is_object($blockObject)) {
        echo do_shortcode($blockObject->post_content);
    }
} ?>


<div class="container">
    <div class="row below-menu">
        <div class="col-md-12">
            <div class="shadow-box">
                <?php if ($show == true): ?>
                    <div class="pageobject"<?php echo ct_esc_attrs(array(
                            array('attr' => 'data-left', 'val' => $left . 'px'),
                            array('attr' => 'data-top', 'val' => $top),
                            array('attr' => 'data-zindex', 'val' => '1000'))
                    )?>>
                        <img src="<?php echo esc_url($image) ?>" alt="<?php echo __('top image','ct_theme')?>">
                    </div>

                <?php endif ?>

                <?php echo do_shortcode('[title_row line="true" header="' .  $pageTitle  . '" breadcrumbs="' . $breadcrumbs . '"]') ?>

                <?php get_template_part('templates/content-faq'); ?>
            </div>
            <!--col-md-12 end!-->
        </div>
    </div>
    <!--row_end!-->


</div>


