<?php if (!post_password_required() && (get_post_type() == 'post' && ct_get_option("posts_single_show_comments", 1)) || (get_post_type() == 'page' && ct_get_option("pages_single_show_comments", 0))): ?>



    <?php
    function theme_comments($comment, $args, $depth)
    {
        $GLOBALS['comment'] = $comment;?>
        <?php

        global $post;

        $byAuthorClass = ( $comment->user_id === $post->post_author ) ?'bypostauthor':'';

        ?>
        <li class="<?php echo sanitize_html_class($byAuthorClass)?>">
            <div class="oneComment" id="comment-<?php comment_ID(); ?>">
                <div class="media">

                    <a class="pull-left" href="<?php comment_author_url(); ?>">
                        <?php echo get_avatar($comment, $size = '55', $default = 'mystery'); //no escape required ?>
                    </a>

                    <div class="media-body">
                        <div class="inner-body">
                            <strong>
                                <?php if (ct_get_option("posts_show_author_active", 1)): ?>
                                <span
                                    class="comment-author <?php echo(is_user_logged_in() ? 'active' : '') ?> "><i
                                        class="fa fa-stop"></i>
                                    <?php else: ?>
                                    <span class="comment-author">
                <?php endif; ?>
                <?php echo __('Posted by', 'ct_theme') ?> <?php echo get_comment_author_link() //no escape required?></span>
                                    <?php echo esc_html(get_comment_date()); ?><?php if (get_comment_time()): ?> <?php _e('at', 'ct_theme') ?> <?php echo esc_html(get_comment_time()) ?><?php endif; ?>
                                    <?php if ($comment->comment_parent != '0') : ?>
                                        <?php $comment_parent = get_comment($comment->comment_parent); ?>
                                        <span
                                            class="color-motive-light"> <?php echo __('in reply to', 'ct_theme') ?> <?php echo  esc_html($comment_parent->comment_author); ?></span>
                                    <?php endif ?>
                            </strong>
                            <?php comment_text() ?>
		                <?php if (ct_get_option("posts_single_show_comment_form", 1)): ?>
                            <?php comment_reply_link(array_merge($args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
                        <?php endif; ?>

                        </div>
                    </div>
                </div>
            </div>
        </li>
    <?php
    }

    ?>

    <?php $commentsCount = count(get_comments(array('type' => 'comment', 'post_id' => $post->ID))); ?>

    <?php if (comments_open() || $commentsCount > 0): ?>

        <?php if ($commentsCount > 0): ?>
            <hr><?php endif ?>

        <section>
            <ul class="commentList">
                <?php wp_list_comments(array('callback' => 'theme_comments', 'style' => 'ol', 'type' => 'comment')); ?>
            </ul>
        </section>


        <?php if (pings_open()): ?>
            <?php
            $pingbacksCount = count(get_comments(array('type' => 'pingback', 'post_id' => $post->ID)));
            $trackbacksCount = count(get_comments(array('type' => 'trackback', 'post_id' => $post->ID)));
            ?>
            <?php if ($pingbacksCount > 0): ?>
                <header class="page-header text-center">
                    <h1 class="page-title"><?php echo __('Pingbacks', 'ct_theme') ?></h1>
                </header>
                <ul class="commentList list-unstyled">
                    <?php wp_list_comments(array('callback' => 'theme_comments', 'style' => 'ol', 'type' => 'pingback')); ?>
                </ul>
            <?php endif; ?>
            <?php if ($trackbacksCount > 0): ?>
                <header class="page-header text-center">
                    <h1 class="page-title"><?php echo __('Trackbacks', 'ct_theme') ?></h1>
                </header>
                <ul class="commentList list-unstyled">
                    <?php wp_list_comments(array('callback' => 'theme_comments', 'style' => 'ol', 'type' => 'trackback')); ?>
                </ul>
            <?php endif; ?>
        <?php endif; ?>

    <?php endif; ?>

    </article>

    <hr>

    <?php if (paginate_comments_links(array('echo' => false)) !== null): ?>
        <ul class="pagination pull-right">
            <?php

            $Newcomments = str_replace('<a', '<li><a ', paginate_comments_links(array('echo' => false, 'prev_text' => '<i class="fa fa-chevron-left"></i>', 'next_text' => '<i class="fa fa-chevron-right"></i>')));
            $Newcomments = str_replace('</a>', '</a></li>', $Newcomments);
            $Newcomments = str_replace('<span class=\'page-numbers current\'>', '<li class="active"><a>', $Newcomments);
            $Newcomments = str_replace('</span>', '</a></li>', $Newcomments);
            if (strpos($Newcomments, 'prev page-numbers') == false) {
                $Newcomments = '<li class="disabled"><a href="#"><i class="fa fa-chevron-left"></i></a></li>' . $Newcomments;
            }
            if (strpos($Newcomments, 'next page-numbers') == false) {
                $Newcomments .= '<li class="disabled"><a href="#"><i class="fa fa-chevron-right"></i></a></li>';
            }

            echo $Newcomments;//no escape required

            ?>


        </ul>

        <div class="clearfix"></div>

    <?php endif ?>



    <?php if (((get_post_type() == 'post' && ct_get_option("posts_single_show_comment_form", 1)) || get_post_type() == 'page' && ct_get_option("pages_single_show_comment_form", 0)) && comments_open()) : // Comment Form ?>

        <h4 class="color-motive"><?php echo __('Leave a Reply', 'ct_theme') ?></h4>
        <p><?php echo __('Your email address will not be published. Required fields are marked *', 'ct_theme') ?></p>

        <div class="row">
            <div class="col-md-9">
                <!-- comment form ****** -->
                <form id="respond" action="<?php echo esc_attr(get_option('siteurl')); ?>/wp-comments-post.php" method="post">

                    <div class="row">
                        <div class="col-sm-6">
                            <div class="form-group">
                                <input placeholder="<?php echo __('Name*', 'ct_theme') ?>" name="name" type="text"
                                       class="form-control">
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <input placeholder="<?php echo __('Email*', 'ct_theme') ?>" name="email" type="email"
                                       class="form-control">
                            </div>
                        </div>

                        <div class="col-xs-12">
                            <div class="form-group">
                                <textarea placeholder="<?php echo __('Message*', 'ct_theme') ?>" name="comment"
                                          class="form-control" rows="5"></textarea>
                            </div>
                            <button type="submit"
                                    class="btn btn-primary uppercase witharrow"><?php echo __('Submit Request', 'ct_theme') ?></button>
                        </div>
                    </div>


                    <?php comment_id_fields(); ?>
                    <?php do_action('comment_form', get_the_ID()); ?>
                    <?php if (false): ?><?php comment_form() ?><?php endif; ?>
                </form>
            </div>
        </div>
        <!-- ********************* -->
        <!-- / comment form ****** -->
    <?php endif; ?>





<?php endif; ?>