<?php
if (ct_get_option('activities_index_show_pagination')) {
    $postsPerPage = ct_get_option('activities_items_per_page', 10);
} else {
    $postsPerPage = -1;
}
$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
$posts = query_posts(array(
    'post_type' => 'activity',
    'posts_per_page' => $postsPerPage,
    'paged' => $paged
));

?>



<?php if (have_posts()) : ?>
    <?php

    global $post;
    $counter = 0;
    $postCount = 0;

    //var_dump($postsPerPage);
    ?>
    <?php while (have_posts()) : the_post(); ?>
        <?php
        $custom = get_post_custom($post->ID);


        $summary = isset($custom["summary"][0]) ? $custom["summary"][0] : "";

        ?>

        <?php if ($counter == 2 || $postCount == 0): ?>
            <div class="row">
            <?php $counter = 0 ?>
        <?php endif; ?>

        <div class="col-md-6">
            <div class="row">
                <div class="col-sm-4 text-center">
                    <br>
                    <img src="<?php echo esc_html(ct_get_feature_image_src(get_the_ID(), 'featured_image')) ?>"
                         alt="<?php the_title() ?>">
                    <br>
                    <br>
                    <a href="<?php the_permalink() ?>"
                       class="btn btn-primary witharrow uppercase"><?php echo esc_html(ct_get_option('activities_more_btn_label', __('More','ct_theme'))) ?>
                    </a>
                </div>
                <div class="col-sm-8">
                    <h4><a href="<?php the_permalink() ?>"><?php the_title() ?></a></h4>
                    <?php if (ct_get_option('activities_index_show_meta', 1)): ?>

                    <?php endif; ?>
                    <p><?php echo esc_html($summary) ?></p>
                </div>
            </div>
        </div>

        <?php if (++$counter == 2 || ++$postCount == sizeof($posts) || $postCount == $postsPerPage - 2): ?>

            </div>
            <hr>
        <?php endif; ?>

    <?php endwhile; ?>

    <!-- / blog-list -->


    <?php if (isset($wp_query) && $wp_query->max_num_pages > 1) : ?>


        <ul class="pagination pull-right">
            <?php if ($paged != 1): ?>
                <li><a href="<?php echo esc_url(get_previous_posts_page_link()); ?>"><i class="fa fa-chevron-left"></i></a></li>
            <?php else: ?>
                <li class="disabled"><a><i class="fa fa-chevron-left"></i></a></li>
            <?php endif; ?>



            <?php for ($i = 1; $i <= $wp_query->max_num_pages; $i++) { ?>
                <?php if ($paged == $i): ?>
                    <li class="active"><a><?php echo (int)$i; ?></a>
                    </li>
                <?php else: ?>
                    <li><a href=" <?php echo esc_url(get_pagenum_link($i)); ?>"><?php echo (int)$i; ?></a></li>
                <?php endif ?>
            <?php } ?>



            <?php if ($paged != $wp_query->max_num_pages): ?>
                <li><a href="<?php echo esc_url(get_next_posts_page_link()); ?>"><i class="fa fa-chevron-right"></i></a></li>
            <?php else: ?>
                <li class="disabled"><a><i class="fa fa-chevron-right"></i></a></li>
            <?php endif; ?>

        </ul>
        <!-- / pagination -->

        <?php if (false): ?><?php posts_nav_link(); ?><?php endif; ?>
    <?php endif; ?>


<?php else: ?>
    <article>
        <h4 class="no-result-found">
            <?php _e('No search results found', 'ct_theme'); ?>
        </h4>
    </article>
<?php endif; ?>
