<?php
if (ct_get_option('galleries_index_show_pagination')) {
    $postsPerPage = ct_get_option('galleries_items_per_page', 10);
} else {
    $postsPerPage = -1;
}
$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
$posts = query_posts(array(
    'post_type' => 'gallery',
    'posts_per_page' => $postsPerPage,
    'paged' => $paged
));

?>



<?php if (have_posts()) : ?>

    <?php while (have_posts()) : the_post(); ?>
        <?php echo do_shortcode('[gallery  id="'.get_the_id().'"]') ?>

    <?php endwhile; ?>

    <!-- / blog-list -->


    <?php if (isset($wp_query) && $wp_query->max_num_pages > 1) : ?>


        <ul class="pagination pull-right">
            <?php if ($paged != 1): ?>
                <li><a href="<?php echo esc_url(get_previous_posts_page_link()); ?>"><i class="fa fa-chevron-left"></i></a></li>
            <?php else: ?>
                <li class="disabled"><a><i class="fa fa-chevron-left"></i></a></li>
            <?php endif; ?>



            <?php for ($i = 1; $i <= $wp_query->max_num_pages; $i++) { ?>
                <?php if ($paged == $i): ?>
                    <li class="active"><a><?php echo (int)$i; ?></a>
                    </li>
                <?php else: ?>
                    <li><a href=" <?php echo esc_url(get_pagenum_link($i)); ?>"><?php echo (int)$i; ?></a></li>
                <?php endif ?>
            <?php } ?>



            <?php if ($paged != $wp_query->max_num_pages): ?>
                <li><a href="<?php echo esc_url(get_next_posts_page_link()); ?>"><i class="fa fa-chevron-right"></i></a></li>
            <?php else: ?>
                <li class="disabled"><a><i class="fa fa-chevron-right"></i></a></li>
            <?php endif; ?>

        </ul>
        <!-- / pagination -->

        <?php if (false): ?><?php posts_nav_link(); ?><?php endif; ?>
    <?php endif; ?>


<?php else: ?>
    <article>
        <h4 class="no-result-found">
            <?php _e('No search results found', 'ct_theme'); ?>
        </h4>
    </article>
<?php endif; ?>
