<?php if (have_posts()) : ?>
    <?php while (have_posts()) : the_post(); ?>
        <?php $format = get_post_format();
        $format = $format ? $format : 'standard';
        $class = $format == 'standard' ? 'blog-article' : 'blog-article format-' . $format;?>

        <?php $galleries = get_posts( array('post_type'=>'gallery', 'posts_per_page' => -1) ); ?>




        <div class="row">
            <div class="col-sm-8">
                <?php the_content()?>
            </div>
            <div class="col-sm-4">
                <div class="btn-group pull-right">
                    <button type="button" class="btn btn-primary uppercase dropdown-toggle" data-toggle="dropdown">
                        <?php echo  (ct_get_option('gallery_pick_label','Pick Gallery to View')!=''?esc_html(ct_get_option('gallery_pick_label',__('Pick Gallery to View','ct_theme'))):__('Pick Gallery to View','ct_theme'))?> <i class="fa fa-chevron-down"></i>
                    </button>
                    <ul class="dropdown-menu" role="menu">
                        <?php if(!empty($galleries)):?>
                        <?php foreach ($galleries as $p):?><li><a href="<?php echo esc_url(get_permalink($p->ID))?>"><?php echo esc_html($p->post_title) ?></a></li><?php endforeach?>
                        <?php endif?>
                    </ul>
                </div>
                <div class="clearfix"></div>
            </div>
        </div>
        <hr>

        <?php
        $formatter= new ctGalleryFormatter();
        global $post;
        $args = array(
            'post_type' => 'attachment',
            'numberposts' => -1,
            'post_status' => null,
            'post_parent' => get_the_id(),
            'posts_per_page' => -1
        );
        $attachments = get_posts($args);
        if ($attachments) {

            $counter=0;
            $itemsArr = array();
            foreach ($attachments as $attach) {
                $image_small = wp_get_attachment_image_src($attach->ID, 'gallery_thumb');
                $image_full = wp_get_attachment_image_src($attach->ID, 'full');
                $image_big = wp_get_attachment_image_src($attach->ID, 'gallery_big');
                $image_tall = wp_get_attachment_image_src($attach->ID, 'gallery_tall');
                $itemsArr[$counter]['item_title'] = get_the_title($attach->ID);
                $itemsArr[$counter]['item_description'] = $attach->post_content;
                $itemsArr[$counter]['item_src_thumb'] = $image_small[0];
                $itemsArr[$counter]['item_src_full'] = $image_full[0];
                $itemsArr[$counter]['item_src_tall'] = $image_tall[0];
                $itemsArr[$counter]['item_src_big'] = $image_big[0];
                $counter++;
            }

            ;
           // return raw HTML
            echo  $formatter->format('gallery_single', $itemsArr );//no escape required
        }


        ?>






    <?php endwhile; ?>
<?php endif ?>