<?php
global $wp_query;
$arrgs = $wp_query->query_vars;
?>

<?php if (have_posts()) : ?>
    <?php while (have_posts()) : the_post(); ?>
        <?php $format = get_post_format();


        $format = $format ? $format : 'standard';
        $class = $format == 'standard' ? 'blog-article' : 'blog-article format-' . $format;?>


        <?php
        //adds no media class
        if (
            ($format == 'standard'
                && !has_post_thumbnail(get_the_id())
                || !ct_get_option("posts_index_show_image", 1))
            || ($format == 'image'
                && !has_post_thumbnail(get_the_id())
                || !ct_get_option("posts_index_show_image", 1))
            || $format == 'quote'
            || $format == 'link'
            || $format == 'aside'
            || $format == 'audio'
        ) {
            $class .= ' no-media';
        }
        ?>
        <?php $prev = get_previous_post(); ?>
        <?php $next = get_next_post();
        ?>


        <?php
        /*update view count meta*/
        $view_count = get_post_meta(get_the_id(), 'post_view_count', true);
        if ($view_count == '') {
            $view_count = 0;
            delete_post_meta(get_the_id(), 'post_view_count');
            add_post_meta(get_the_id(), 'post_view_count', 0);
        } else {
            $view_count++;
            update_post_meta(get_the_id(), 'post_view_count', $view_count);
        }
        ?>


        <article id="post-<?php the_ID(); ?>" <?php post_class($class); ?>>
            <?php get_template_part('templates/post_single/content-' . $format); ?>


        <?php

        $next = ct_get_next_post();
        $prev = ct_get_previous_post();

        if (!empty($next)) {
            $PostNext = array(
                'data-toggle' => 'popover',
                'data-placement' => 'top',
                'data-title' => $next['title'],
                'data-content' => (!empty($next['image']) ? '<img alt=\''.__('post next','ct_theme').'\' src=\'' . $next['image'] . '\'/>' : '') . strip_tags($next['excerpt']),
                'href' => get_permalink(get_adjacent_post(false, '', false)),
                'data-original-title' => '',
                'title' => $next['title'],
            );
        } else {
            $PostNext = '';
        }

        if (!empty($prev)) {
            $PostPrev = array(
                'data-toggle' => 'popover',
                'data-placement' => 'top',
                'data-title' => $prev['title'],
                'data-content' => (!empty($prev['image']) ? '<img alt=\''.__('post prev','ct_theme').'\' src=\'' . $next['image'] . '\'/>' : '') . strip_tags($prev['excerpt']),
                'href' => get_permalink(get_adjacent_post(false, '', true)),
                'data-original-title' => '',
                'title' => $prev['title'],
            );
        } else {
            $PostPrev = '';
        }



        ?>

        <?php if (ct_get_option("posts_single_show_pagination", 1) && ($prev || $next)): ?>
            <div class="row">
                <div class="col-xs-12 text-center">
                    <ul class="pagination">

                        <?php if ($prev): ?>
                            <li><a  <?php echo ct_get_attributes($PostPrev)//echo escaped attributes?>><i class="fa fa-chevron-left"></i></a>
                            </li>
                        <?php else: ?>
                            <li class="disabled"><a href="#"><i class="fa fa-chevron-left"></i></a></li>
                        <?php endif; ?>


                        <li class="active"><a href="#"><?php echo (ct_get_option('single_post_prev_label','Previous Post')!=''?esc_html(ct_get_option('single_post_prev_label',__('Previous Post','ct_theme'))):__('Previous Post','ct_theme')).' - '.(ct_get_option('single_post_next_label',__('Next Post','ct_theme'))!=''?esc_html(ct_get_option('single_post_next_label',__('Next Post','ct_theme'))):__('Next Post','ct_theme'))?></a></li>

                        <?php if ($next): ?>
                            <li><a <?php echo ct_get_attributes($PostNext) //output escaped attributes?>><i class="fa fa-chevron-right"></i></a>
                            </li>
                        <?php else: ?>
                            <li class="disabled"><a href="#"><i class="fa fa-chevron-right"></i></a></li>
                        <?php endif; ?>
                    </ul>
                    <div class="clearfix visible-sm visible-xs"></div>
                </div>
            </div>
        <?php endif; ?>

        <?php comments_template('/templates/comments.php'); ?>
    <?php endwhile; ?>
<?php endif ?>
