<?php
//The Query
global $wp_query;
$arrgs = $wp_query->query_vars;


if (defined('NEWS_TEMPLATE') && NEWS_TEMPLATE == true) {
    $limit = ct_get_option('pages_news_posts_limit', 2) != '' ? ct_get_option('pages_news_posts_limit', 2) : 2;
} else {
    $limit = get_option('posts_per_page', 3);
}

$arrgs['posts_per_page'] = $limit;
$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
$arrgs['paged'] = $paged;
$wp_query->query($arrgs);
?>


<?php if (have_posts()) : ?>

    <?php while (have_posts()) : the_post(); ?>
        <?php $format = get_post_format();
        $format = $format ? $format : 'standard';
        $class = $format == 'standard' ? 'blog-article' : 'blog-article format-' . $format;

        if (
            ($format == 'standard'
                && !has_post_thumbnail(get_the_id())
                || !ct_get_option("posts_index_show_image", 1))
            || ($format == 'image'
                && !has_post_thumbnail(get_the_id())
                || !ct_get_option("posts_index_show_image", 1))
            || $format == 'quote'
            || $format == 'link'
            || $format == 'aside'
            || $format == 'audio'
        ) {
            $class .= ' no-media';
        }
        ?>

        <article id="post-<?php the_ID(); ?>" <?php post_class($class); ?>>
            <?php get_template_part('templates/post/content-' . $format); ?>
        </article>
        <hr>


    <?php endwhile; ?>

    <!-- / blog-list-->
    <?php get_template_part('templates/post/content-post', 'pagination'); ?>

<?php else: ?>
    <article>
        <h4 class="no-result-found">
            <?php _e('No search results found', 'ct_theme'); ?>
        </h4>
    </article>
<?php endif; ?>
