<?php global $post; ?>
<?php get_template_part('templates/post/content-meta'); ?>

<blockquote>
    <p>
        <?php echo esc_html(strip_tags(strip_shortcodes(get_post_meta($post->ID, 'quote', true)))) ?>
    </p>

    <footer><?php echo esc_html(strip_tags(strip_shortcodes(get_post_meta($post->ID, 'quoteAuthor', true)))) ?></footer>
</blockquote>


<div class="row">
    <div class="col-sm-10">
        <div class="clearfix visible-xs"></div>

        <?php if (ct_get_option("posts_index_show_author", 1) && !ct_get_option("posts_show_author_active", 1)): ?>
            <span class="blog-author">
            <?php echo __('Posted by', 'ct_theme') ?><?php the_author_posts_link() ?></span>
        <?php elseif (ct_get_option("posts_index_show_author", 1) && ct_get_option("posts_show_author_active", 1)): ?>
            <span class="blog-author <?php echo(is_user_logged_in() ? 'active' : '') ?> "><i class="fa fa-stop"></i>
                <?php echo __('Posted by', 'ct_theme') ?> <?php the_author_posts_link() ?></span>
        <?php endif ?>


        <?php if (ct_get_option("posts_index_show_tags", 1) && get_the_tag_list()): ?>
            <ul class="blog-tags">
                <?php echo get_the_tag_list(); //no escape required?>
            </ul>
        <?php endif; ?>

        <?php if (ct_get_option("posts_index_show_categories", 1)): ?>
            <br><br>
            <ul class="blog-tags">
                <li> <?php echo ct_get_categories_string(get_the_ID(), $separator = '</li> <li> ', $taxonomy = 'category') //no escape required?></li>
            </ul>
        <?php endif ?>

    </div>
    <?php if (ct_get_option("posts_index_show_more", 1)) : ?>
        <div class="col-sm-2 hidden-xs">
            <a href="<?php echo esc_url(get_permalink(get_the_ID())) ?>"
               class="btn btn-primary btn-more pull-right"><?php echo(ct_get_option('posts_index_more_label', 'more') != ''?esc_html(ct_get_option('posts_index_more_label', __('more', 'ct_theme'))):__('more', 'ct_theme')) ?></a>
        </div>
    <?php endif ?>
</div>




