<?php global $post;?>
<?php get_template_part('templates/post/content-meta'); ?>


<?php if (ct_get_option("posts_index_show_image", 1) && has_post_thumbnail(get_the_ID())): ?>

    <?php get_template_part('templates/post/content-featured-image'); ?>

<?php endif; ?>

<a href="<?php echo esc_url(get_permalink(get_the_ID())) ?>"><h3 class="article-title"><?php echo esc_html(ct_get_blog_item_title()) ?></h3></a>


<?php $excerpt = get_extended($post->post_excerpt); ?>

<?php if ((ct_get_option("posts_index_show_excerpt", 1)) && (get_the_content())) : ?>
    <?php $ismore = @strpos($post->post_content, '<!--more-->'); ?>
    <?php if ($ismore) : ?>
        <?php $content = get_extended($post->post_content); ?>
        <p><?php echo do_shortcode($content['main']); ?></p>
    <?php elseif ($excerpt['main'] != '') : ?>
        <p><?php echo do_shortcode($excerpt['main']); ?></p>
    <?php else : ?>
        <?php echo ct_get_excerpt_by_id(get_the_id()); ?>
    <?php endif ?>

<?php elseif (ct_get_option("posts_index_show_excerpt")==0 && ct_get_option("posts_index_show_fulltext")==1 && get_the_content() ) : ?>
    <?php $content = get_extended($post->post_content); ?>
    <p><?php echo do_shortcode($content['main']); ?></p>
<?php endif ?>


<div class="row">
    <div class="col-sm-10">

        <div class="clearfix visible-xs"></div>

        <?php if (ct_get_option("posts_index_show_author", 1) && !ct_get_option("posts_show_author_active", 1)): ?>
            <span class="blog-author">
            <?php echo __('Posted by', 'ct_theme') ?> <?php the_author_posts_link() ?></span>
        <?php elseif (ct_get_option("posts_index_show_author", 1) && ct_get_option("posts_show_author_active", 1)): ?>
            <span class="blog-author <?php echo(is_user_logged_in() ? 'active' : '') ?> "><i class="fa fa-stop"></i>
                <?php echo __('Posted by', 'ct_theme') ?> <?php the_author_posts_link() ?></span>
        <?php endif ?>


        <?php if (ct_get_option("posts_index_show_tags", 1) && get_the_tag_list()): ?>
            <ul class="blog-tags">
                <?php echo get_the_tag_list();//no escape required ?>
            </ul>
        <?php endif; ?>

        <?php if (ct_get_option("posts_index_show_categories", 1)): ?>
        <br><br>
            <ul class="blog-tags">
        <li> <?php echo ct_get_categories_string(get_the_ID(), $separator = '</li> <li> ', $taxonomy = 'category')//no escape required ?></li>
        </ul>
        <?php endif ?>


    </div>
    <?php if (ct_get_option("posts_index_show_more", 1)) : ?>
        <div class="col-sm-2 hidden-xs">
            <a href="<?php echo esc_url(get_permalink(get_the_ID())) ?>"
               class="btn btn-primary btn-more pull-right"><?php echo (ct_get_option('posts_index_more_label','more')!='' ? esc_html(ct_get_option('posts_index_more_label',__('more','ct_theme'))) : __('more','ct_theme')) ?></a>
        </div>
    <?php endif ?>
</div>



