<?php global $post;?>
<?php get_template_part('templates/post/content-meta'); ?>


<?php if (ct_get_option("posts_single_show_image", 1) && has_post_thumbnail(get_the_ID())): ?>

    <?php get_template_part('templates/post/content-featured-image'); ?>

<?php endif; ?>

<h4 class="article-title"><?php echo esc_html(ct_get_blog_item_title()) ?></h4>

<?php if (ct_get_option("posts_single_show_content", 1) && get_the_content()): ?>
    <?php the_content(); ?>
<?php endif ?>


<?php echo str_replace( "<li></li>", '', wp_link_pages( array(
        'before'           => '<div class="text-center"><ul class="pagination"><li class="active"></li><li>',
        'after'            => '</li></ul></div>',
        'separator'        => '</li><li>',
        'link_before'      => '<span>',
        'link_after'       => '</span>',
        'next_or_number'   => "next",
        'nextpagelink'     => '<i class="fa fa-chevron-right"></i>',
        'previouspagelink' => '<i class="fa fa-chevron-left"></i>',
        'echo'             => false
    )
) ); //no escape required?>

<div class="row">
    <div class="col-sm-10">

        <div class="clearfix visible-xs"></div>

        <?php if (ct_get_option("posts_single_show_author", 1) && !ct_get_option("posts_show_author_active", 1)): ?>
            <span class="blog-author">
            <?php echo __('Posted by', 'ct_theme') ?> <?php the_author_posts_link() ?></span>
        <?php elseif (ct_get_option("posts_single_show_author", 1) && ct_get_option("posts_show_author_active", 1)): ?>
            <span class="blog-author <?php echo(is_user_logged_in() ? 'active' : '') ?> "><i class="fa fa-stop"></i>
                <?php echo __('Posted by', 'ct_theme') ?> <?php the_author_posts_link() ?></span>
        <?php endif ?>


        <?php if (ct_get_option("posts_single_show_tags", 1) && get_the_tag_list()): ?>
            <ul class="blog-tags">
                <?php echo get_the_tag_list(); //no escape required?>
            </ul>
        <?php endif; ?>

        <?php if (ct_get_option("posts_single_show_categories", 1)): ?>
            <br><br>
            <ul class="blog-tags">
                <li> <?php echo ct_get_categories_string(get_the_ID(), $separator = '</li> <li> ', $taxonomy = 'category') //no escape required?></li>
            </ul>
        <?php endif ?>

    </div>

</div>



