<?php
function ct_hex_2_rgb($hex, $asString = true)
{
    $hex = str_replace("#", "", $hex);

    if (strlen($hex) == 3) {
        $r = hexdec(substr($hex, 0, 1) . substr($hex, 0, 1));
        $g = hexdec(substr($hex, 1, 1) . substr($hex, 1, 1));
        $b = hexdec(substr($hex, 2, 1) . substr($hex, 2, 1));
    } else {
        $r = hexdec(substr($hex, 0, 2));
        $g = hexdec(substr($hex, 2, 2));
        $b = hexdec(substr($hex, 4, 2));
    }
    $rgb = array($r, $g, $b);
    if ($asString) {
        return implode(",", $rgb);
    }
    return $rgb; // returns an array with the rgb values
}

function ct_get_theme_background($key, $selector)
{
    // $background is the saved custom image, or the default image.
    $background = get_theme_mod($key . '_image');
    $background = str_replace('#', '', $background);
    // $color is the saved custom color.
    // A default has to be specified in style.css. It will not be printed here.
    $color = get_theme_mod($key . '_color');
    $color = str_replace('#', '', $color);

    if (!$background && (!$color || $color == '#'))
        return;

    $style = $color ? "background-color: #$color;" : '';
    if ($background) {
        $image = " background-image: url('$background');";

        $repeat = get_theme_mod($key . '_background_repeat', 'repeat');
        if (!in_array($repeat, array('no-repeat', 'repeat-x', 'repeat-y', 'repeat')))
            $repeat = 'repeat';
        $repeat = " background-repeat: $repeat;";

        $position = get_theme_mod($key . '_background_position_x', 'left');
        if (!in_array($position, array('center', 'right', 'left')))
            $position = 'left';
        $position = " background-position: top $position;";

        $attachment = get_theme_mod($key . '_background_attachment', 'scroll');
        if (!in_array($attachment, array('fixed', 'scroll')))
            $attachment = 'scroll';
        $attachment = " background-attachment: $attachment;";

        $style .= $image . $repeat . $position . $attachment;
    }

    return $selector . '{' . $style . '}';
}

$motive = esc_html(get_theme_mod('lead_color'));
$motive2 = esc_html(get_theme_mod('lead_color'));
$motive_light = esc_html(get_theme_mod('lead_color_2'));
$motive_lighter = esc_html(get_theme_mod('lead_color_3'));


$backgroundColor = get_theme_mod('background_color');
$headerTextColor = get_theme_mod('header_textcolor');

?>



<?php _custom_background_cb() ?>

<style type="text/css" media="all">
<?php $font = ct_get_option('style_font_style'); $fontSize = ct_get_option_pattern('style_font_size', 'font-size: %dpx;',16); ?>
<?php if($font||($fontSize && $fontSize!=16)):?>
body {
<?php if ($font): ?> <?php $normalized = explode(':', $font); ?> <?php if (isset($normalized[1])): ?> font-family: '<?php echo esc_html($normalized[0])?>', sans-serif;
<?php if(is_numeric($normalized[1])): ?> font-weight: <?php echo esc_html($normalized[1]);?>;
<?php else:?> font-style: <?php echo esc_html($normalized[1]);?>;
<?php endif;?> <?php endif; ?> <?php endif;?> <?php echo (int)$fontSize?> <?php //default styles ?> <?php //echo ct_get_option_pattern('style_color_basic_background', 'background-color: %s;')?> <?php echo ct_get_option_pattern('style_color_basic_background_image', 'background: url(%s) repeat;') //no escape required?> <?php echo ct_get_option_pattern('style_color_basic_text', 'color: %s;')//no escape required?> <?php if (ct_get_option('style_color_basic_background') && !ct_get_option('style_color_basic_background_image')): ?> background-image: none;
<?php endif;?>
}

<?php endif;?>

<?php $sizes = array('1'=>32,'2'=>32,'3'=>24,'4'=>18,'5'=>18,'6'=>18)?>
<?php foreach($sizes as $tag=>$size):?>
<?php if(ct_get_option('style_font_size_h'.$tag)!=38.5):?>
<?php echo ct_get_option_pattern('style_font_size_h'.$tag, 'h'.$tag.'{font-size: %dpx;}',$size)//no escape required?>
<?php endif;?>
<?php endforeach;?>

<?php if($headerTextColor):?>
h1, h1 a, h2, h2 a, h3, h3 a, h4, h4 a, h5, h5 a, h6, h6 a {
    color: # <?php echo esc_html($headerTextColor)?> !important
}

<?php endif;?>

<?php if( $motive || $backgroundColor ):?>
/* =================== */
/* === BODY STYLES === */

body {

<?php if ($backgroundColor==''):?> background: <?php echo esc_attr($motive) ?>;
    background: -moz-radial-gradient(center, ellipse cover, <?php echo esc_attr($motive) ?> 0%, <?php echo esc_attr($motive2) ?> 100%);
    background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, <?php echo esc_attr($motive) ?>), color-stop(100%, <?php echo esc_attr($motive2) ?>));
    background: -webkit-radial-gradient(center, ellipse cover, <?php echo esc_attr($motive) ?> 0%, <?php echo esc_attr($motive2) ?> 100%);
    background: -o-radial-gradient(center, ellipse cover, <?php echo esc_attr($motive) ?> 0%, <?php echo esc_attr($motive2) ?> 100%);
    background: -ms-radial-gradient(center, ellipse cover, <?php echo esc_attr($motive) ?> 0%, <?php echo esc_attr($motive2) ?> 100%);
    background: radial-gradient(ellipse at center, <?php echo esc_attr($motive) ?> 0%, <?php echo esc_attr($motive2) ?> 100%);
    filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='<?php echo esc_attr($motive) ?>', endColorstr='<?php echo esc_attr($motive2) ?>', GradientType=1);

<?php else:?> background-color: # <?php echo esc_attr($backgroundColor)?> !important;
    background-image: none !important;
    background-repeat: no-repeat !important;
    filter: none !important;
}

body:before {
<?php if ($backgroundColor==''):?> background: rgba(127, 206, 238, 0);
    background: -moz-linear-gradient(top, rgba(127, 206, 238, 0) 0%, rgba(199, 236, 237, 1) 100%);
    background: -webkit-gradient(left top, left bottom, color-stop(0%, rgba(127, 206, 238, 0)), color-stop(100%, rgba(199, 236, 237, 1)));
    background: -webkit-linear-gradient(top, rgba(127, 206, 238, 0) 0%, rgba(199, 236, 237, 1) 100%);
    background: -o-linear-gradient(top, rgba(127, 206, 238, 0) 0%, rgba(199, 236, 237, 1) 100%);
    background: -ms-linear-gradient(top, rgba(127, 206, 238, 0) 0%, rgba(199, 236, 237, 1) 100%);
    background: linear-gradient(to bottom, rgba(127, 206, 238, 0) 0%, rgba(199, 236, 237, 1) 100%);
    filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='#7fceee', endColorstr='#c7eced', GradientType=0);
<?php else:?> display: none !important;
<?php endif;?>
}

<?php endif?>
<?php endif;?>

<?php if($motive && $motive!='#'):?>

/* =================== */
/* === BODY STYLES === */
a {
    color: <?php echo esc_attr($motive) ?>;
}

a:hover,
a:focus {
    color: <?php echo esc_attr($motive) ?>;
}

.form-control:focus {
    border-color: <?php echo esc_attr($motive) ?>;
}

/* ===================== */
/* === NAVBAR STYLES === */
.navbar-default .navbar-nav > .active > a,
.navbar-default .navbar-nav > .active > a:hover,
.navbar-default .navbar-nav > .active > a:focus {
    color: <?php echo esc_attr($motive) ?>;
}

.navbar-default .navbar-nav > li > a:hover,
.navbar-default .navbar-nav > li > a:focus {
    color: <?php echo esc_attr($motive) ?>;
    text-decoration: underline;
}

.navbar .dropdown-menu > li a {
    color: <?php echo esc_attr($motive) ?>;
}

.navbar .dropdown-menu > li a:hover,
.navbar .dropdown-menu > li a:focus {
    color: <?php echo esc_attr($motive_light) ?>;
    background-color: transparent;
    text-decoration: none;
}

.navbar .dropdown-menu > li a:hover .program-title,
.navbar .dropdown-menu > li a:focus .program-title {
    color: <?php echo esc_attr($motive_light) ?>;
}

.yamm .nav.navbar-right .yamm-fw .dropdown-menu h4 {
    color: <?php echo esc_attr($motive_light) ?>;
}

.navbar .dropdown-menu li.active a {
    color: <?php echo esc_attr($motive_light) ?>;
}

.navbar li.dropdown > .dropdown-menu > li.dropdown-submenu:after {
    color: <?php echo esc_attr($motive) ?>;
}

.navbar li.dropdown:hover > .dropdown-menu > li.dropdown-submenu:hover:after,
.navbar li.dropdown:hover > .dropdown-menu > li.dropdown-submenu:active:after,
.navbar li.dropdown:hover > .dropdown-menu > li.dropdown-submenu:focus:after {
    color: <?php echo esc_attr($motive_light) ?>;
}

.navbar .nav > li > a:hover,
.navbar .nav > li > a:focus {
    background-color: transparent;
}

/* ================== */
/* === TYPOGRAPHY === */
.color-motive {
    color: <?php echo esc_attr($motive) ?>;
}

.color-motive-light {
    color: <?php echo esc_attr($motive_light) ?>;
}

blockquote p:before,
blockquote p:after {
    color: <?php echo esc_attr($motive_light) ?>;
}

/* =================== */
/* === BREADCRUMBS === */
.breadcrumb {
    padding: 0px;
    background-color: transparent;
}

.breadcrumb a:hover {
    color: <?php echo esc_attr($motive) ?>;
}

.breadcrumb > .active {
    color: <?php echo esc_attr($motive_light) ?>;
}

/* =============== */
/* === BUTTONS === */
.btn-primary {
    background-color: <?php echo esc_attr($motive_light) ?>;
    border-color: <?php echo esc_attr($motive_light) ?>;
    color: #ffffff
}

.btn-primary:hover,
.btn-primary:focus,
.btn-primary:active,
.btn-primary.active,
.open .dropdown-toggle.btn-primary {
    background-color: <?php echo esc_attr($motive) ?>;
    border-color: <?php echo esc_attr($motive) ?>;
    color: #ffffff;
}

footer .contactForm .btn-primary {
    background-color: <?php echo esc_attr($motive) ?>;
    border-color: <?php echo esc_attr($motive) ?>;
}

footer .contactForm .btn-primary:hover {
    background-color: <?php echo esc_attr($motive_light) ?>;
    border-color: <?php echo esc_attr($motive_light) ?>;
}

/* ============= */
/* === LISTS === */
ol li:before {
    color: <?php echo esc_attr($motive_light) ?>;
}

ul.circle li:before {
    background-color: <?php echo esc_attr($motive_light) ?>;
}

/* ================== */
/* === PAGINATION === */
.pagination li:first-child a,
.pagination li:last-child a,
.pagination li:first-child a:hover,
.pagination li:last-child a:hover {
    color: <?php echo esc_attr($motive) ?>;
    background-color: transparent;
    border-color: transparent;
}

.pagination > li > a,
.pagination > li > span {
    background-color: <?php echo esc_attr($motive_lighter) ?>;
    border-color: <?php echo esc_attr($motive_lighter) ?>;
    color: <?php echo esc_attr($motive) ?>;
}

.pagination > .active > a,
.pagination > .active > span,
.pagination > .active > a:hover,
.pagination > .active > span:hover,
.pagination > .active > a:focus,
.pagination > .active > span:focus {
    background-color: <?php echo esc_attr($motive_light) ?>;
    border-color: <?php echo esc_attr($motive_light) ?>;
    color: #ffffff;
}

.pagination > li > a:hover,
.pagination > li > span:hover,
.pagination > li > a:focus,
.pagination > li > span:focus {
    background-color: <?php echo esc_attr($motive) ?>;
    border-color: <?php echo esc_attr($motive) ?>;
    color: #ffffff;
}

/* ====================== */
/* === GENERAL STYLES === */
.programs .program-title {
    color: <?php echo esc_attr($motive) ?>;
}

.sub-menu .title {
    color: <?php echo esc_attr($motive_light) ?>;
}

.sub-menu .nav-tabs,
.sub-menu .nav-tabs > li > a {
    background-color: transparent;
}

.sub-menu .nav-tabs > li > a:hover,
.sub-menu .nav-tabs > li > a:focus {
    background-color: transparent;
}

.sub-menu .nav-tabs > li.active > a,
.sub-menu .nav-tabs > li.active > a:hover,
.sub-menu .nav-tabs > li.active > a:focus {
    background-color: transparent;
    border-color: transparent;
    color: #ffffff;
}

.sub-menu .tab-content > .active {
    background-color: #ffffff;
}

.blog-tags > li,
.blog-categories > li {
    background-color: <?php echo esc_attr($motive_lighter) ?>;
}

.shadow-box.daycare-widget ul li a:hover,
.shadow-box.daycare-widget ul li a:focus {
    color: <?php echo esc_attr($motive_light) ?>;
}

.shadow-box.daycare-widget ul li.active a {
    color: <?php echo esc_attr($motive_light) ?>;
}

.shadow-box.daycare-widget.widget-archives ul li a {
    color: <?php echo esc_attr($motive) ?>;
    text-decoration: underline;
}

.list-counter .timestamp {
    color: <?php echo esc_attr($motive_light) ?>;
}

.list-counter .list-quantity {
    background-color: <?php echo esc_attr($motive_lighter) ?>;
}

.scrollUp,
.scrollDown {
    color: <?php echo esc_attr($motive) ?>;
}

.blog-author {
    background-color: <?php echo esc_attr($motive_lighter) ?>;
}

.commentList .btn-primary {
    background-color: <?php echo esc_attr($motive_lighter) ?>;
    border-color: <?php echo esc_attr($motive_lighter) ?>;
    color: #000000;
}

.commentList .btn-primary:hover {
    background-color: <?php echo esc_attr($motive) ?>;
    border-color: <?php echo esc_attr($motive) ?>;
    color: #ffffff;
}

.commentList a {
    color: <?php echo esc_attr($motive_light) ?>;
}

article .article-info .date {
    background-color: <?php echo esc_attr($motive_light) ?>;
}

article .article-info .date:before {
    border-color: transparent transparent transparent <?php echo esc_attr($motive_light) ?>;
}

article .article-info .article-socials .btn {
    background-color: <?php echo esc_attr($motive_light) ?>;
}

article .article-info .article-socials .btn:hover {
    background-color: <?php echo esc_attr($motive) ?>;
}

.quote {
    background-color: <?php echo esc_attr($motive_lighter) ?>;
}

footer.type1 a:hover {
    color: <?php echo esc_attr($motive) ?>;
}

footer.type2,
footer.type3 {
    color: <?php echo esc_attr($motive) ?>;
}

footer.type2 a,
footer.type3 a {
    color: <?php echo esc_attr($motive) ?>;
}

footer .contacts {
    background-color: <?php echo esc_attr($motive) ?>;
}

footer .contacts a:hover,
footer .contacts a:focus,
footer .contacts a:active {
    color: <?php echo esc_attr($motive_light) ?> !important;
}

footer.type2 .contacts,
footer.type3 .contacts {
    background-color: <?php echo esc_attr($motive) ?>;
    color: #ffffff;
}

footer.type2 .contacts a,
footer.type3 .contacts a {
    color: #ffffff;
}

footer.type2 .contacts a:hover,
footer.type2 .contacts a:focus,
footer.type2 .contacts a:active,
footer.type3 .contacts a:hover,
footer.type2 .contacts a:focus,
footer.type2 .contacts a:active {
    color: <?php echo esc_attr($motive_light) ?> !important;
}

.line-right {
    border-right: 1px solid rgba(<?php echo esc_attr($rgb)?>, 0.3);
}

/* =================== */
/* === IMAGE BLOCK === */
.info-block {
    background-color: <?php echo esc_attr($motive_lighter) ?>;
}

/* =============== */
/* === TWITTER === */
.tweets_display ul.tweet_list li a {
    color: <?php echo esc_attr($motive_light) ?>;
}

/* ======================== */
/* === IMAGE/PERSON BOX === */
.person-box .description,
.image-box .description {
    background-color: <?php echo esc_attr($motive_light) ?>;
}

.person-box .inner-box {
    background-color: <?php echo esc_attr($motive) ?>;
}

.person-box .person-contacts-title {
    color: <?php echo esc_attr($motive_lighter) ?>;
}

.person-box .description:hover,
.image-box .description:hover,
.person-box .description.hover,
.image-box .description.hover {
    background-color: rgba(<?php echo esc_attr($rgb) ?>, 0.8);
}

.image-box:hover .description {
    background-color: rgba(<?php echo esc_attr($rgb)?>, 0.8);
}

/* =============== */
/* === SOCIALS === */
ul.socials > li > a {
    background-color: <?php echo esc_attr($motive_light) ?>;
}

ul.socials > li > a:hover,
ul.socials > li > a:focus,
ul.socials > li > a:active {
    background-color: <?php echo esc_attr($motive) ?>;
    color: #ffffff;
}

/* ================= */
/* === ACCORDION === */
.panel-group.accordion > .panel > .panel-heading > a {
    color: <?php echo esc_attr($motive_light) ?>;
}

.panel-group.accordion > .panel > .panel-heading > a.collapsed, .panel-group.accordion-type2 > .panel > .panel-heading > a.collapsed {
    color: #111111;
}

.panel-group.accordion-type2 > .panel > .panel-heading > a {
    background-color: <?php echo esc_attr($motive_light) ?>;
    border: none;
}

.panel-group.accordion-type2 > .panel > .panel-heading > a.collapsed {
    background-color: rgba(<?php echo esc_attr($rgb) ?>, 0.5);
}

/* ============== */
/* === TABLES === */
.table thead {
    background-color: <?php echo esc_attr($motive_lighter) ?>;
}

.table thead .title-important {
    background-color: <?php echo esc_attr($motive_light) ?>;
}

/* ================ */
/* === CALENDAR === */
.calendar .fc-header {
    color: <?php echo esc_attr($motive) ?>;
}
.calendar .fc-header .fc-header-title h2{
    color: <?php echo esc_attr($motive) ?>;
}

.calendar .fc-header .fc-button {
    color: <?php echo esc_attr($motive_light) ?>;
}
.calendar .fc-header .fc-button.fc-button-today {
    color: <?php echo esc_attr($motive_light) ?>;
}

.calendar .fc-header .fc-button.fc-button-today.fc-state-disabled {
    color: #000000;
}

.calendar .fc-event .fc-event-inner {
    background-color: <?php echo esc_attr($motive_light) ?>;
}

.calendar .fc-event .fc-event-inner:hover {
    background-color: <?php echo esc_attr($motive) ?>;
}

/* ======================== */
/* === POPOVER & TOOLTIP === */
.popover .popover-title {
    background-color: <?php echo esc_attr($motive_light) ?>;
}

/* ============ */
/* === TABS === */
.nav-tabs {
    background-color: <?php echo esc_attr($motive_lighter) ?>;
}

.nav-tabs > li.active > a,
.nav-tabs > li.active > a:hover,
.nav-tabs > li.active > a:focus {
    background-color: <?php echo esc_attr($motive_light) ?>;
    border-color: <?php echo esc_attr($motive_light) ?>;
}

.nav-tabs > li {
    margin-bottom: 0;
}

.nav-tabs > li > a {
    border-right-color: #ffffff;
    background-color: <?php echo esc_attr($motive_lighter) ?>;
    color: <?php echo esc_attr($motive_light) ?>;
}

.nav > li > a:hover,
.nav > li > a:focus {
    border-color: <?php echo esc_attr($motive) ?>;
    background-color: <?php echo esc_attr($motive) ?>;
    color: #ffffff;
}

.tab-content > .active {
    background-color: <?php echo esc_attr($motive_light) ?>;
}

/* ================== */
/* === FLEXSLIDER === */
.flexslider a {
    color: <?php echo esc_attr($motive) ?>;
}

.flexslider a:hover,
.flexslider a:focus,
.flexslider a:active {
    color: #ffffff;
}

.flexslider.std-slider .flex-direction-nav .flex-next:hover,
.flexslider.std-slider .flex-direction-nav .flex-prev:hover {
    color: <?php echo esc_attr($motive) ?>;
}

/* ================== */
/* === DATEPICKER === */
.datepicker table tr td.active:hover,
.datepicker table tr td.active:hover:hover,
.datepicker table tr td.active.disabled:hover,
.datepicker table tr td.active.disabled:hover:hover,
.datepicker table tr td.active:focus,
.datepicker table tr td.active:hover:focus,
.datepicker table tr td.active.disabled:focus,
.datepicker table tr td.active.disabled:hover:focus,
.datepicker table tr td.active:active,
.datepicker table tr td.active:hover:active,
.datepicker table tr td.active.disabled:active,
.datepicker table tr td.active.disabled:hover:active,
.datepicker table tr td.active.active,
.datepicker table tr td.active:hover.active,
.datepicker table tr td.active.disabled.active,
.datepicker table tr td.active.disabled:hover.active,
.open .dropdown-toggle.datepicker table tr td.active,
.open .dropdown-toggle.datepicker table tr td.active:hover,
.open .dropdown-toggle.datepicker table tr td.active.disabled,
.open .dropdown-toggle.datepicker table tr td.active.disabled:hover {
    background-color: <?php echo esc_attr($motive) ?>;
    border-color: <?php echo esc_attr($motive) ?>;
}

/* ===================== */
/* === IMAGE GALLERY === */
.packeryItem .description {
    background-color: rgba(<?php echo esc_attr($rgb) ?>, 0.8);
}

.gallerymessage {
    background-color: <?php echo esc_attr($motive_light) ?>;
}

.navbar-default .navbar-toggle {
    border-color: <?php echo esc_attr($motive) ?>;
}

.navbar-default .navbar-toggle .icon-bar {
    background-color: <?php echo esc_attr($motive) ?>;
}

<?php endif;?>

<?php /*custom style - code tab*/ ?>
<?php echo ct_get_option('code_custom_styles_css')?>
</style>

