<?php

$sections[] = array(
    'icon' => NHP_OPTIONS_URL . 'img/glyphicons/glyphicons_151_edit.png',
    'title' => __('Index', 'ct_theme'),
    'group' => __("Programs", 'ct_theme'),
    'desc' => __("Setup index program settings", 'ct_theme'),
    'fields' => array(
        array(
            'id' => "program_index_page",
            'type' => 'pages_select',
            'title' => __("Index page", 'ct_theme'),
            'desc' => __('Which page should be as Programs index?', 'ct_theme')
        ),

        array(
            'id' => 'programs_more_btn_label',
            'title' => __("More button label", 'ct_theme'),
            'type' => 'text',
            'std' => __('More', 'ct_theme')
        ),
        array(
            'id' => 'programs_index_show_pagination',
            'title' => __("Show pagination?", 'ct_theme'),
            'type' => 'select_show',
            'std' => 1
        ),

        array(
            'id' => 'programs_items_per_page',
            'title' => __("Programs pages show at most", 'ct_theme'),
            'type' => 'text',
            'desc' => __('Show pagination must be enable', 'ct_theme'),
            'std' => '6'
        ),




        array(
            'id' => 'info_extra_menu',
            'type' => 'info',
            'desc' => __('<h4>Programs navbar menu options</h4>', 'ct_theme')
        ),

        array(
            'id' => 'programs_index_add_menu_container',
            'title' => __("Show featured programs in menu ?", 'ct_theme'),
            'type' => 'select_show',
            'desc' => __('show or hide related programs in menu', 'ct_theme'),
            'std' => ''
        ),
        array(
            'id' => 'programs_index_menu_container_title',
            'title' => __("Title Programs extra menu container", 'ct_theme'),
            'default' => 'Programs',
            'type' => 'text',
            'std' => 10
        ),

        array(
            'id' => 'programs_index_menu_featured_slot_1',
            'title' => __("Menu Featured Programs - slot 1", 'ct_theme'),
            'type' => 'posts_select',
            'args' => array('post_type' => 'program'),
            'empty_label'=>__('None','ct_theme'),
            'desc' => __('You can use this setting to ...', 'ct_theme'),
            'std' => '',
        ),
        array(
            'id' => 'programs_index_menu_featured_slot_2',
            'title' => __("Menu Featured Programs - slot 2", 'ct_theme'),
            'type' => 'posts_select',
            'args' => array('post_type' => 'program'),
            'empty_label'=>__('None','ct_theme'),
            'desc' => __('You can use this setting to ...', 'ct_theme'),
            'std' => ''
        ),
        array(
            'id' => 'programs_index_menu_featured_slot_3',
            'title' => __("Menu Featured Programs - slot 3", 'ct_theme'),
            'type' => 'posts_select',
            'args' => array('post_type' => 'program'),
            'empty_label'=>__('None','ct_theme'),
            'desc' => __('You can use this setting to ...', 'ct_theme'),
            'std' => ''
        ),
        array(
            'id' => 'programs_index_menu_featured_slot_4',
            'title' => __("Menu Featured Programs - slot 4", 'ct_theme'),
            'type' => 'posts_select',
            'args' => array('post_type' => 'program'),
            'empty_label'=>__('None','ct_theme'),
            'desc' => __('You can use this setting to ...', 'ct_theme'),
            'std' => ''
        ),
        array(
            'id' => 'programs_index_menu_featured_slot_5',
            'title' => __("Menu Featured Programs - slot 5", 'ct_theme'),
            'type' => 'posts_select',
            'args' => array('post_type' => 'program'),
            'empty_label'=>__('None','ct_theme'),
            'desc' => __('You can use this setting to ...', 'ct_theme'),
            'std' => ''
        ),

    )
);

$sections[] = array(
    'icon' => NHP_OPTIONS_URL . 'img/glyphicons/glyphicons_151_edit.png',
    'title' => __('Single', 'ct_theme'),
    'group' => __("Programs", 'ct_theme'),
    'desc' => __("Setup single program settings", 'ct_theme'),
    'fields' => array(

        array(
            'id' => 'programs_single_page_title',
            'title' => __("Programs single page title", 'ct_theme'),
            'type' => 'text',
            'desc' => __('you can set page title for programs single items', 'ct_theme'),
            'std' => 'programs'
        ),


        array(
            'id' => 'programs_single_show_breadcrumbs',
            'title' => __("Show breadcrumbs", 'ct_theme'),
            'type' => 'select_show',
            'std' => 1
        ),


        array(
            'id' => 'programs_single_show_tweet',
            'title' => __("Show Tweet button", 'ct_theme'),
            'type' => 'select_show',
            'std' => 1
        ),

        array(
            'id' => 'programs_single_show_fb_share',
            'title' => __("Show Facebook Share button", 'ct_theme'),
            'type' => 'select_show',
            'std' => 1
        ),

        array(
            'id' => 'programs_single_show_socials',
            'title' => __("Show socials icons?", 'ct_theme'),
            'type' => 'select_show',
            'std' => 1
        ),

        array(
            'id' => 'programs_single_twitter_message',
            'title' => __("Default tweet share message", 'ct_theme'),
            'type' => 'text',
            'desc' => __('e.g. Check this awesome Daycare template!', 'ct_theme'),
            'std' => ''
        ),
        array(
            'id' => 'programs_single_twitter_link',
            'title' => __('Add post permalink to tweet message?', 'ct_theme'),
            'type' => 'select',
            'std' => 'yes',
            'options' => array(
                'yes' => __('yes', 'ct_theme'),
                'no' => __('no', 'ct_theme')
            ),
        ),



        array(
            'id' => 'program_single_info_meta',
            'type' => 'Top image object settings',
            'desc' => __('<h4>Meta options</h4>', 'ct_theme')
        ),

        array(
            'id' => 'single_program_effects_top_object_image',
            'type' => 'upload',
            'title' => __('Select image', 'ct_theme'),
            'desc' => __("Top image object for program single", 'ct_theme')
        ),


        array(
            'id' => 'single_program_effects_top_object_top',
            'title' => __("Top value in px", 'ct_theme'),
            'type' => 'text',
            'std' => 0
        ),
        array(
            'id' => 'single_program_effects_top_object_left',
            'title' => __("Left value in px", 'ct_theme'),
            'type' => 'text',
            'std' => 0
        ),
    )

);

