<?php
/**
 *
 * @author alex
 */

class ctCustomizeManagerHandler {

	/**
	 *
	 */
	public function __construct() {
		add_action('customize_register', array($this, 'customizeRegister'), 20);
		add_theme_support('custom-background', array('wp-head-callback' => array($this, 'wpHeadCallback')));
	}

	/**
	 * Customize theme preview
	 * @param WP_Customize_Manager $wp_manager
	 * @return \WP_Customize_Manager
	 */

	public function customizeRegister($wp_manager) {

        //$wp_manager->remove_control( 'header_textcolor' );
        //$wp_manager->remove_control( 'background_color' );


        /** @var $sec WP_Customize_Section */
        $wp_manager->remove_section('header_image');
        $wp_manager->remove_section('background_image');
        $sec = $wp_manager->get_section('colors');
        $sec->title = __('Daycare - General settings', 'ct_theme');
        $sec->priority = 1;


        $wp_manager->add_setting('lead_color');
        $wp_manager->add_control(new WP_Customize_Color_Control($wp_manager, 'lead_color', array(
            'label' => __('Theme Main Color', 'ct_theme'),
            'section' => 'colors',
            'default' => '#00a3d9',
            'priority' => 1
        )));
        $wp_manager->add_setting('lead_color_2');
        $wp_manager->add_control(new WP_Customize_Color_Control($wp_manager, 'lead_color_2', array(
            'label' => __('Theme Main Color 2', 'ct_theme'),
            'section' => 'colors',
            'default' => '#00a3d9',
            'priority' => 2
        )));
        $wp_manager->add_setting('lead_color_3');
        $wp_manager->add_control(new WP_Customize_Color_Control($wp_manager, 'lead_color_3', array(
            'label' => __('Theme Main Color 3', 'ct_theme'),
            'section' => 'colors',
            'default' => '#00a3d9',
            'priority' => 3
        )));



        $wp_manager->add_section('ct_header', array(
            'title' => __('Daycare - Header', 'ct_theme'),
            'priority' => 2
        ));


            $wp_manager->add_setting( 'footer_bg1', array('type' => 'theme_mod') );
            $wp_manager->add_control( new WP_Customize_Image_Control( $wp_manager, 'footer_bg1', array(
                'label'    => __( 'Footer background 1', 'themeslug' ),
                'section'  => 'backgrounds_section',
                'settings' => 'footer_bg1',

            ) ) );

            $wp_manager->add_setting( 'footer_bg2', array('type' => 'theme_mod') );
            $wp_manager->add_control( new WP_Customize_Image_Control( $wp_manager, 'footer_bg2', array(
                'label'    => __( 'Footer background 2', 'themeslug' ),
                'section'  => 'backgrounds_section',
                'settings' => 'footer_bg2',

            ) ) );

            return $wp_manager;
        }


	public function wpHeadCallback() {
		require_once CT_THEME_SETTINGS_MAIN_DIR . '/custom_style.php';
	}

}