<?php
/**
 * Class ctVisualComposerWrapperShortcode
 * Shortcode wrapper
 */
if ( class_exists( 'WPBakeryShortCode' ) ) {
	class ctVisualComposerWrapperShortcode extends WPBakeryShortCode {
		/**
		 * @var ctShortcode
		 */

		protected $shortcodeObject;

		/**
		 * @param ctShortcode $shortcode
		 * @param array $options
		 */

		public function __construct( $shortcode, $options = array() ) {

			//hide from selection
			if ( $shortcode->getParentShortcodeName() ) {
				$options['content_element'] = true;
				$options['as_child']        = array( 'only' => $shortcode->getParentShortcodeName() );
			}

			if ( ! isset( $options['show_settings_on_create'] ) ) {
				$attibutes = $shortcode->getAttributes(); //without any plugins
				if ( count( $attibutes ) == 1 && isset( $attibutes['class'] ) ) {
					$options['show_settings_on_create'] = false;
				}
			}

			parent::__construct( $options );

			if (function_exists('vc_map')) {
				vc_map($options);
			} else {
				wpb_map($options);
			}

			$this->shortcodeObject = $shortcode;


			//for legacy compatibility
			if(apply_filters('ct_dynamic_vc_extension',true)){
				$name = 'WPBakeryShortCode_' . $options['base'];

				if ( ( $c = $this->getDefaultCustomClass() ) && ! class_exists( $name ) ) {
					eval( "class $name extends $c{}" );
				}
			}



		}

		/**
		 * Custom implementation
		 */

		protected function getDefaultCustomClass() {
			if ( strpos( $this->shortcodeObject->getShortcodeName(), 'slider_item' ) !== false ) {
				return 'WPBakeryShortCode_Base_Slider_Item';
			}

			return '';
		}

		/**
		 * Return content
		 *
		 * @param $atts
		 * @param null $content
		 *
		 * @return mixed|void
		 */


		protected function content( $atts, $content = null ) {
			return $this->shortcodeObject->handleShortcode( $atts, $content );
		}
	}

	/**
	 * Base slider - shows image preview
	 */
	class WPBakeryShortCode_Base_Slider_Item extends WPBakeryShortCode {
		public function __construct( $settings ) {
			$settings['class'] = 'wpb_slider_item';
			parent::__construct( $settings ); // TODO: Change the autogenerated stub
		}

		public function singleParamHtmlHolder( $param, $value ) {
			$output = '';
			// Compatibility fixes
			$old_names = array(
				'yellow_message',
				'blue_message',
				'green_message',
				'button_green',
				'button_grey',
				'button_yellow',
				'button_blue',
				'button_red',
				'button_orange'
			);
			$new_names = array(
				'alert-block',
				'alert-info',
				'alert-success',
				'btn-success',
				'btn',
				'btn-info',
				'btn-primary',
				'btn-danger',
				'btn-warning'
			);
			$value     = str_ireplace( $old_names, $new_names, $value );
			$param_name = isset( $param['param_name'] ) ? $param['param_name'] : '';
			$type       = isset( $param['type'] ) ? $param['type'] : '';
			$class      = isset( $param['class'] ) ? $param['class'] : '';
			if ( ! empty( $param['holder'] ) ) {
				if ( $param['holder'] !== 'hidden' ) {
					$output .= '<' . $param['holder'] . ' class="wpb_vc_param_value ' . $param_name . ' ' . $type . ' ' . $class . '" name="' . $param_name . '">' . $value . '</' . $param['holder'] . '>';
				} elseif ( $param['holder'] == 'input' ) {
					$output .= '<' . $param['holder'] . ' readonly="true" class="wpb_vc_param_value ' . $param_name . ' ' . $type . ' ' . $class . '" name="' . $param_name . '" value="' . $value . '">';
				} elseif ( in_array( $param['holder'], array( 'img', 'iframe' ) ) ) {
					$output .= '<' . $param['holder'] . ' class="wpb_vc_param_value ' . $param_name . ' ' . $type . ' ' . $class . '" name="' . $param_name . '" src="' . esc_url($value) . '">';
				}
			}
			if ( ! empty( $param['admin_label'] ) && $param['admin_label'] === true ) {
				$output .= '<span class="vc_admin_label admin_label_' . $param['param_name'] . ( empty( $value ) ? ' hidden-label' : '' ) . '"><label>' . esc_html__( $param['heading'], 'ct_theme' ) . '</label>: ' . $value . '</span>';
			}

			return $output;
		}
	}
}