<?php
/**
 * Woocommerce custom modifications
 */

add_theme_support('woocommerce');


function ct_is_woocommerce_active()
{
    return class_exists('WooCommerce');
}

if (!ct_is_woocommerce_active()) {
    return;
}

add_filter('roots-nice-search', '__return_false');

/**
 *
 * custom js
 *
 **/
if (!function_exists('ct_woo_scripts')) {
    function ct_woo_scripts()
    {
        wp_register_script('ct-woo-select2', CT_THEME_DIR_URI . '/woocommerce/js/select2.js', array('jquery'), false, true);
        wp_enqueue_script('ct-woo-select2');

        wp_register_script('ct-woo-customjs', CT_THEME_DIR_URI . '/woocommerce/js/woocommerce.js', array('jquery'), false, true);
        wp_enqueue_script('ct-woo-customjs');

        global $woocommerce;
        if(floatval($woocommerce->version) >= 2.3){
            wp_register_script( 'ct-woo-qt-change', CT_THEME_DIR_URI . '/woocommerce/js/qt-change.js', array( 'jquery' ), false, true );
            wp_enqueue_script( 'ct-woo-qt-change' );
        }

        if (is_product()) {
            wp_register_script('ct-woo-check-gallery', CT_THEME_DIR_URI . '/woocommerce/js/check-gallery.js', array('wc-add-to-cart-variation'), false, true);
            wp_enqueue_script('ct-woo-check-gallery');

            wp_register_script('ct-flex-easing', CT_THEME_ASSETS . '/js/jquery.easing.1.3.min.js', array('ct-flex-slider'), false, true);
            wp_enqueue_script('ct-flex-easing');

            wp_register_script('ct-flex-slider', CT_THEME_ASSETS . '/js/jquery.flexslider-min.js', array('jquery'), false, true);
            wp_enqueue_script('ct-flex-slider');
        }
    }
}

add_action('wp_enqueue_scripts', 'ct_woo_scripts');

/**
 *
 *WP roots issue with - fix
 *http://wordpress.stackexchange.com/questions/95293/wp-enqueue-style-will-not-let-me-enforce-screen-only
 *    'media'   => 'only screen and (max-width: ' . apply_filters( 'woocommerce_style_smallscreen_breakpoint', $breakpoint = '768px' ) . ')'
 *
 **/
remove_filter('style_loader_tag', 'roots_clean_style_tag');

/**
 *
 *redirect to page on login
 *
 **/
add_filter('woocommerce_login_redirect', 'ras_login_redirect');
function ras_login_redirect($redirect_to)
{
    $redirect_to = home_url();
    return $redirect_to;
}

/**
 *
 *Remove woocommerce title
 *
 **/
add_filter('woocommerce_show_page_title', '__return_false');

/**
 *
 *Move Listing Filters to other places
 *
 **/
remove_action('woocommerce_before_shop_loop', 'woocommerce_result_count', 20);
add_action('ct_product_list_number', 'woocommerce_result_count');


remove_action('woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30);
//add_action( 'ct_before_sidebar_shop', 'woocommerce_catalog_ordering', 20);
//add_action( 'ct_before_sidebar_shop', 'ct_catalog_ordering_title', 10);

/*
if ( ! function_exists( 'ct_catalog_ordering_title' ) ) {
    function ct_catalog_ordering_title(){
        echo '<h4 class="color-motive uppercase">'.__('Sorting','ct_theme').'</h4>';
    }
}*/


/**
 *
 *Move Rating to top of title
 *
 **/
remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5);
add_action('ct_product_rating', 'woocommerce_template_loop_rating');

remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_title', 5);
add_action('woocommerce_single_product_summary', 'woocommerce_template_single_title', 10);

remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10);
add_action('woocommerce_single_product_summary', 'woocommerce_template_single_rating', 5);

remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_price', 10);
add_action('woocommerce_single_product_summary', 'woocommerce_template_single_price', 15);

/**
 *
 *Move item add to cart to another hook
 *
 **/
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30);
add_action('ct_single_product_summary', 'woocommerce_template_single_add_to_cart', 20);


function ct_catalog_add_cart(){
    add_action('ct_single_product_summary', 'woocommerce_template_single_add_to_cart', 20);
    return true;
}

add_filter('ct_catalog.product.item.action.add_to_cart','ct_catalog_add_cart');

function ct_catalog_remove_add_cart(){
    remove_action('ct_single_product_summary', 'woocommerce_template_single_add_to_cart', 20);
    return true;
}

add_filter('ct_catalog.product.item.remove.add_to_cart','ct_catalog_remove_add_cart');

function ct_catalog_custom_button(){
    return 'ct_single_product_summary';
}

add_filter('ct_catalog.single_product_summary','ct_catalog_custom_button');

/**
 *
 *Add product arrow navigation
 *
 **/
function ct_product_go_back_links()
{
    $product_cats = wp_get_post_terms(get_the_ID(), 'product_cat');
    $prev = get_next_post();
    $next = get_previous_post();
    if ($prev || $next) {
        echo '<div class="single-product-navigation hidden-xs">';
        if ($prev) {
            echo '<a href="' . esc_url(get_permalink($prev->ID)) . '"
               class="btn-prev">' . __('<i class="fa fa-chevron-left"></i> Prev', 'ct_theme') . '</a>';
        }
        if ($next) {
            echo '<a href="' . esc_url(get_permalink($next->ID)) . '"
               class="btn-next">' . __('Next <i class="fa fa-chevron-right"></i>', 'ct_theme') . '</a>';
        }
        echo '</div>';
    }
}

function ct_product_go_back_links_2()
{
    $product_cats = wp_get_post_terms(get_the_ID(), 'product_cat');
    $prev = get_next_post();
    $next = get_previous_post();
    if ($prev || $next) {
        echo '<div class="single-product-navigation visible-xs">';
        if ($prev) {
            echo '<a href="' . esc_url(get_permalink($prev->ID)) . '"
               class="btn-prev">' . __('<i class="fa fa-chevron-left"></i> Prev', 'ct_theme') . '</a>';
        }
        if ($next) {
            echo '<a href="' . esc_url(get_permalink($next->ID)) . '"
               class="btn-next">' . __('Next <i class="fa fa-chevron-right"></i>', 'ct_theme') . '</a>';
        }
        echo '</div>';
    }
}

add_action('ct_single_product_summary', 'ct_product_go_back_links', 10);
add_action('woocommerce_single_product_summary', 'ct_product_go_back_links_2', 0);

/**
 *
 *Move item images
 *
 **/
remove_action('woocommerce_before_single_product_summary', 'woocommerce_show_product_images', 20);
add_action('woocommerce_after_single_product_summary', 'woocommerce_show_product_images', 5);


/**
 *
 *Move product meta to sidebar
 *
 **/
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40);
add_action('ct_before_sidebar_product', 'woocommerce_template_single_meta');


/**
 *
 *Display 8 products per page
 *
 **/
add_filter('loop_shop_per_page', create_function('$cols', 'return 9;'), 20);


/**
 *
 *Change number or products per row to 2
 *
 **/
add_filter('loop_shop_columns', 'loop_columns');
if (!function_exists('loop_columns')) {
    function loop_columns()
    {
        return 3; // 2 products per row
    }
}

/**
 *
 *Overwrite default woocommerce cart widget
 *
 **/
if (!function_exists('override_woocommerce_widgets')) {
    function override_woocommerce_widgets()
    {
        if (class_exists('WC_Widget_Cart')) {
            unregister_widget('WC_Widget_Cart');
            include_once(dirname(__FILE__) . '/widgets/class-wc-widget-cart.php');
            register_widget('Custom_WooCommerce_Widget_Cart');
        }
    }
}
add_action('widgets_init', 'override_woocommerce_widgets', 15);

/**
 *
 *Ensure cart contents update when products are added to the cart via AJAX
 *
 **/
add_filter('add_to_cart_fragments', 'woocommerce_header_add_to_cart_fragment');

function woocommerce_header_add_to_cart_fragment($fragments)
{
    global $woocommerce;

    ob_start();

    ?>
    <div class="ct-cart">
        <a href="<?php echo esc_url($woocommerce->cart->get_cart_url()); ?>"
           title="<?php _e('View your shopping cart', 'woothemes'); ?>">
            <i class="fa fa-fw fa-2x fa-shopping-cart"></i><span class="cart-numbers"><span
                    class="number-items"><?php echo sprintf(_n('%d item', '%d items', $woocommerce->cart->cart_contents_count, 'ct_theme'), esc_html($woocommerce->cart->cart_contents_count)); ?></span> &boxh;
                <span class="items-total"><?php echo $woocommerce->cart->get_cart_total();//no escape required ?></span></span>
        </a>
    </div>
    <?php

    $fragments['.ct-cart'] = ob_get_clean();

    return $fragments;

}

/**
 *
 * Single Product Share
 *
 */
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_sharing', 50);
add_action('ct_product_share', 'woocommerce_template_single_sharing');
add_action('woocommerce_share', 'ct_wooshare');
function ct_wooshare()
{
    global $post;

    $thumb_id = get_post_thumbnail_id();
    $thumb_url = wp_get_attachment_image_src($thumb_id, 'full', true);
    if (isset($thumb_url[0])) {
        $thumbSrc = $thumb_url[0];
    } else {
        $thumbSrc = '';
    }


    echo '
    <h4 class="color-motive uppercase">' . __('Share this product', 'ct_theme') . '</h4>
    <ul class="socials">
        <li>
            <a href="' . esc_url('http://www.facebook.com/sharer.php?u=' . get_permalink()) . '" target="_blank" data-toggle="tooltip" data-placement="top" title="" data-original-title="Facebook"><i class="fa fa-facebook"></i></a>
        </li>
        <li>
            <a href="' . esc_url('https://twitter.com/share?url=' . get_permalink()) . '" target="_blank" data-toggle="tooltip" data-placement="top" title="" data-original-title="Twitter"><i class="fa fa-twitter"></i></a>
        </li>
        <li>
            <a href="' . esc_url('https://plus.google.com/share?url=' . get_permalink()) . '" target="_blank" data-toggle="tooltip" data-placement="top" title="" data-original-title="Google +"><i class="fa fa-google-plus"></i></a>
        </li>
        <li>
            <a href="' . esc_url('mailto:?subject=' . get_the_title() . '&body=' . apply_filters('woocommerce_short_description', $post->post_excerpt) . get_permalink()) . '" data-toggle="tooltip" data-placement="top" title="" data-original-title="' . __('Mail', 'ct_theme') . '"><i class="fa fa-envelope"></i></a>
        </li>
    </ul>';
}

/**
 *
 * Change number of related products on product page
 * Set your own value for 'posts_per_page'
 *
 */
function woo_related_products_limit()
{
    global $product;

    $args['posts_per_page'] = 3;
    return $args;
}

add_filter('woocommerce_output_related_products_args', 'ct_related_products_args');
function ct_related_products_args($args)
{

    $args['posts_per_page'] = 3; // 3 related products
    $args['columns'] = 3; // arranged in 3 columns
    return $args;
}

/**
 *
 * Change number of upsell products on product page
 * Set your own value for 'posts_per_page'
 *
 */
remove_action('woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 15);
add_action('woocommerce_after_single_product_summary', 'ct_woocommerce_output_upsells', 15);

if (!function_exists('ct_woocommerce_output_upsells')) {
    function ct_woocommerce_output_upsells()
    {
        woocommerce_upsell_display(3, 3); // Display 3 products in rows of 3
    }
}

/**
 *
 * Add responsive wrapper to Woocommerce tables
 *
 */
function ct_wrapper_woo_tables()
{
    echo '<div class="table-responsive">';
}

function ct_wrapper_woo_tables_end()
{
    echo '</div>';
}

add_action('woocommerce_before_cart_table', 'ct_wrapper_woo_tables', 10);
add_action('woocommerce_after_cart_table', 'ct_wrapper_woo_tables_end', 10);
add_action('yith_wcwl_before_wishlist', 'ct_wrapper_woo_tables', 10);
add_action('yith_wcwl_after_wishlist', 'ct_wrapper_woo_tables_end', 10);


add_action('ct_custom_breadcrumb', 'ct_woocommerce_breadcrumbs');
if (!function_exists('ct_woocommerce_breadcrumbs')) {
    //draw breadcrumbs for shop (needs ctBreadcrumbs class)
    function ct_woocommerce_breadcrumbs()
    {
        if (class_exists('ctBreadcrumbs')) {
            $breadcrumbs = new ctBreadcrumbs;
            echo $breadcrumbs->display(); //no escape required
        }
    }
}


