<?php

/**
 * Admission shortcode
 */
class ctAdmissionRowShortcode extends ctShortcode implements ctVisualComposerShortcodeInterface
{

    /**
     * Returns name
     * @return string|void
     */
    public function getName()
    {
        return 'Admission Row';
    }

    /**
     * Shortcode name
     * @return string
     */
    public function getShortcodeName()
    {
        return 'admission_row';
    }

    /**
     * Returns shortcode type
     * @return mixed|string
     */

    public function getShortcodeType()
    {
        return self::TYPE_SHORTCODE_ENCLOSING;
    }


    /**
     * Handles shortcode
     * @param $atts
     * @param null $content
     * @return string
     */

    public function handle($atts, $content = null)
    {
        extract(shortcode_atts($this->extractShortcodeAttributes($atts), $atts));

        $mainContainerAtts = array(
            'class' => array(
                'row',
                $class
            )
        );

        if (empty($img_src)) {
            $image = '';
        } else  {
            $image  = '<img src="' . $img_src . '" alt="'.__('image','ct_theme').'">';
        }

        if (empty($title)) {
            $title = '';
        } else  {
            $title = '<h4 class="color-motive">'.$title.'</h4>';
        }



       $html= '
       <div ' . $this->buildContainerAttributes($mainContainerAtts, $atts) . '>
                    <div class="col-sm-4 text-center">
                        <br>
                        '.$image.'
                        <br>
                        '.$title.'
                    </div>
                    <div class="col-sm-8">
                        '.$content.'
                    </div>
                </div>
       ';
        return do_shortcode($html);
    }



    /**
     * Returns config
     * @return null
     */
    public function getAttributes()
    {
        return array(
            'title' => array('label' => __('Title', 'ct_theme'), 'default' => '', 'type' => 'input'),
            'content' => array('label' => __('Content', 'ct_theme'), 'default' => '', 'type' => 'textarea'),
            'img_src' => array('label' => __("Image source", 'ct_theme'), 'default' => '', 'type' => 'image', 'help' => __("Image source", 'ct_theme')),
            'class' => array('label' => __("Custom class", 'ct_theme'), 'default' => '', 'type' => 'input', 'help' => __('Adding custom class allows you to set diverse styles in css to the element. Type in name of class, which you defined in css. You can add as much classes as you like.', 'ct_theme')),


        );

    }

    /**
     * Returns additional info about VC
     * @return ctVisualComposerInfo
     */
    public function getVisualComposerInfo() {
        return new ctVisualComposerInfo( $this, array( 'icon' => 'fa-cogs', 'container'=>true ) );
    }

}

new ctAdmissionRowShortcode();



