<?php

/**
 * Pricelist shortcode
 */
class ctIconTextShortcode extends ctShortcode implements ctVisualComposerShortcodeInterface{


    /**
     * Returns name
     * @return string|void
     */
    public function getName()
    {
        return 'Icon text';
    }

    /**
     * Shortcode name
     * @return string
     */
    public function getShortcodeName()
    {
        return 'icon_text';
    }

    /**
     * Returns shortcode type
     * @return mixed|string
     */

    public function getShortcodeType()
    {
        return self::TYPE_SHORTCODE_ENCLOSING;
    }


    /**
     * Handles shortcode
     * @param $atts
     * @param null $content
     * @return string
     */

    public function handle($atts, $content = null)
    {
        extract(shortcode_atts($this->extractShortcodeAttributes($atts), $atts));

        $mainContainerAtts = array(
            'class' => array(
                'media',
                $class
            )
        );


        if ($new_window == 'true' || $new_window == 'yes'){
            $new_window = 'target="blank"';
        }else{
            $new_window='';
        }


        $link = !empty($link) ? '[link link="' . $link . '" email="' . $email . '" '.$new_window.']' . strip_tags(strip_shortcodes($text)) . '[/link]' : strip_tags(strip_shortcodes($text));
        if ($motive=='yes'){
            $iconShortcode = $icon ? '<span class="h4 color-motive">[icon awesome="fa ' . $icon . '"]</span>' : '';
        }else{
            $iconShortcode = $icon ? '[icon awesome="fa ' . $icon . '"]' : '';
        }


        $html = '<div ' . $this->buildContainerAttributes($mainContainerAtts, $atts) . '>';
        $html .= '<div class="pull-left">';
        $html .= $iconShortcode;
        $html .= '</div>';
        $html .= '<div class="media-body">';
        if ($motive=='yes'){
            $html .= '<span class="h4 color-motive"> ' . $link . '</span>';
        }else{
            $html .= $link;
        }
        $html .= '</div>';
        $html .= '</div>';

        return do_shortcode($html);
    }


    /**
     * Returns config
     * @return null
     */
    public function getAttributes()
    {
        return array(
            'text' => array('label' => __('Text', 'ct_theme'), 'default' => '', 'type' => 'input'),
            'icon' => array('label' => __('Icon', 'ct_theme'), 'type' => "icon", 'default' => '', 'link' => CT_THEME_ASSETS . '/shortcode/awesome/index.html'),
            'link' => array('label' => __('Link', 'ct_theme'), 'default' => '', 'type' => 'input'),
            'motive' => array('label' => __('Motive Color', 'ct_theme'), 'default' => 'no', 'type' => 'select', 'choices' => array('yes' => __('yes', 'ct_theme'), 'no' => __('no', 'ct_theme')),),
            'target' => array('label' => __("Target", 'ct_theme'), 'default' => '_self', 'type' => 'input', 'help' => __("target", 'ct_theme')),
            'email' => array('label' => __('Email link?', 'ct_theme'), 'default' => 'no', 'type' => 'select', 'options' => array('yes' => 'yes', 'no' => 'no'), 'help' => __("Select yes for email link", 'ct_theme')),
            'new_window' => array('label' => __('Open link in new Window?', 'ct_theme'), 'default' => 'no', 'type' => 'select', 'choices' => array('yes' => __('yes', 'ct_theme'), 'no' => __('no', 'ct_theme'))),
            'class' => array('label' => __("Custom class", 'ct_theme'), 'default' => '', 'type' => 'input', 'help' => __('Adding custom class allows you to set diverse styles in css to the element. Type in name of class, which you defined in css. You can add as much classes as you like.', 'ct_theme')),
        );
    }

    /**
     * Returns additional info about VC
     * @return ctVisualComposerInfo
     */
    public function getVisualComposerInfo() {
        return new ctVisualComposerInfo( $this, array( 'icon' => 'fa-caret-square-o-up' ) );
    }
}

new ctIconTextShortcode();



