<?php

/**
 * Draws events
 */
class ctWeeklyMenuShortcode extends ctShortcode implements ctVisualComposerShortcodeInterface
{


    /**
     * Returns name
     * @return string|void
     */
    public function getName()
    {
        return 'Weekly Menu';
    }

    /**
     * Shortcode name
     * @return string
     */
    public function getShortcodeName()
    {
        return 'weekly_menu';
    }


    /**
     * Handles shortcode
     * @param $atts
     * @param null $content
     * @return string
     */

    public function handle($atts, $content = null)
    {
        $attributes = shortcode_atts($this->extractShortcodeAttributes($atts), $atts);
        extract($attributes);

        if (empty($menu_id)) {
            $custom = get_post_custom(ctMealPlan::getCurrentMenuID());

        } else {
            $custom = get_post_custom($menu_id);
        }
        return ctMealPlan::formatWeeklyMenu($custom["menuTableJson"][0]);

    }

    /**
     * Shortcode type
     * @return string
     */
    public function getShortcodeType()
    {
        return self::TYPE_SHORTCODE_SELF_CLOSING;
    }

    /**
     * Returns config
     * @return null
     */
    public function getAttributes()
    {
        $atts = (array(
            'menu_id' => array('label' => __("Menu id", 'ct_theme'), 'default' => '', 'type' => 'input', 'help' => __('Leave blank for use Theme Options','ct_theme')),

        ));

        return $atts;
    }

    /**
     * Returns additional info about VC
     * @return ctVisualComposerInfo
     */
    public function getVisualComposerInfo()
    {
        return new ctVisualComposerInfo($this, array('icon' => 'fa-list-alt'));
    }
}

new ctWeeklyMenuShortcode();