<?php

/**
 * Recent activities
 *
 */
class ctRecentActivitiesShortcode extends ctShortcodeQueryable implements ctVisualComposerShortcodeInterface{


    /**
     * Returns name
     * @return string|void
     */
    public function getName()
    {
        return 'Recent activities';
    }

    /**
     * Shortcode name
     * @return string
     */
    public function getShortcodeName()
    {
        return 'recent_activities';
    }


    /**
     * Handles shortcode
     * @param $atts
     * @param null $content
     * @return string
     */
    public function handle($atts, $content = null)
    {
        $attributes = shortcode_atts($this->extractShortcodeAttributes($atts), $atts);

        extract($attributes);
        $recentposts = $this->getCollection($attributes, array('post_type' => 'activity'));


        $shortcode = '[icon_box class="' . $class . '"]';
        if (empty($recentposts)) {
            return '';
        }

        $counter = 0;
        foreach ($recentposts as $p) {

            $custom = get_post_custom($p->ID);
            $summary = isset($custom["summary"][0]) ? $custom["summary"][0] : "";
            $summary.=('... <a href=\''.esc_url(get_permalink($p->ID)).'\'>'.$more.'</a>');
            $shortcode .= '[icon_box_item link="'.get_permalink($p->ID).'" title="' . $p->post_title . '" description="' . $summary . '" image="' . ct_get_feature_image_src($p->ID, 'featured_image') . '"][/icon_box_item]';
            if ($counter == 1){
                $shortcode .= '<div class="clearfix visible-sm"></div>';
                $counter=0;
            }
            $counter++;
        }
        $shortcode .= '[/icon_box]';
        return do_shortcode($shortcode);


    }


    /**
     * Shortcode type
     * @return string
     */
    public function getShortcodeType()
    {
        return self::TYPE_SHORTCODE_SELF_CLOSING;
    }

    /**
     * Returns config
     * @return null
     */
    public function getAttributes()
    {
        $atts = $this->getAttributesWithQuery(array(

            'limit' => array('label' => __('limit', 'ct_theme'), 'default' => 5, 'type' => 'input'),
            'more' => array('label' => __('more label', 'ct_theme'), 'default' => __('more &gt;&gt;','ct_theme'), 'type' => 'input'),
            'class' => array('label' => __("Custom class", 'ct_theme'), 'default' => '', 'type' => 'input')

        ));
        return $atts;
    }

    /**
     * Returns additional info about VC
     * @return ctVisualComposerInfo
     */
    public function getVisualComposerInfo() {
        return new ctVisualComposerInfo( $this, array( 'icon' => 'fa-book' ) );
    }
}

new ctRecentActivitiesShortcode();