<?php

/**
 * Pricelist shortcode
 */
class ctActivityBoxShortcode extends ctShortcode implements ctVisualComposerShortcodeInterface{


    /**
     * Returns name
     * @return string|void
     */
    public function getName()
    {
        return 'Activity box';
    }

    /**
     * Shortcode name
     * @return string
     */
    public function getShortcodeName()
    {
        return 'activity_box';
    }

    /**
     * Returns shortcode type
     * @return mixed|string
     */

    public function getShortcodeType()
    {
        return self::TYPE_SHORTCODE_ENCLOSING;
    }


    /**
     * Handles shortcode
     * @param $atts
     * @param null $content
     * @return string
     */

    public function handle($atts, $content = null)
    {
        extract(shortcode_atts($this->extractShortcodeAttributes($atts), $atts));

        $mainContainerAtts = array(
            'class' => array(
                'col-md-6',
                $class
            )
        );


        $html = '
        <div class="col-md-6">
                        <div class="row">
                            <div class="col-sm-4 text-center">
                                <br>
                                <img src="' . $image . '" alt="'.__('activity','ct_theme').'">
                                <br>
                                <br>
                                <a href="' . esc_url($link) . '" class="btn btn-primary witharrow uppercase">' . $button_text . '</a>
                            </div>
                            <div class="col-sm-8">
                                <h4><a href="#">' . $title . '</a></h4>
                                <span class="meta">' . $before_date . ' ' . $date . ' ' . $before_author . ' <a href="' . esc_url($author_link) . '" class="color-motive-light">' . $author . '</a></span>
                                <p>' . $content . '</p>
                            </div>
                        </div>
                    </div>
        ';
        return do_shortcode($html);
    }


    /**
     * Returns config
     * @return null
     */
    public function getAttributes()
    {
        return array(
            'title' => array('label' => __('Title', 'ct_theme'), 'default' => '', 'type' => 'input'),
            'image' => array('label' => __("Image source", 'ct_theme'), 'default' => '', 'type' => 'image', 'help' => __("Image source", 'ct_theme')),
            'link' => array('label' => __('Link', 'ct_theme'), 'default' => '#', 'type' => 'input'),
            'date' => array('label' => __('Date', 'ct_theme'), 'default' => '', 'type' => 'input'),
            'content' => array('label' => __('Description', 'ct_theme'), 'default' => '', 'type' => 'textarea'),
            'author' => array('label' => __('Author', 'ct_theme'), 'default' => '', 'type' => 'input'),
            'author_link' => array('label' => __('Author Link', 'ct_theme'), 'default' => '#', 'type' => 'input'),
            'button_text' => array('label' => __('Button text', 'ct_theme'), 'default' => '', 'type' => 'input'),
            'before_date' => array('label' => __('Before Date', 'ct_theme'), 'default' => __("Posted on", 'ct_theme'), 'type' => 'input'),
            'before_author' => array('label' => __('Before Author', 'ct_theme'), 'default' => __("by", 'ct_theme'), 'type' => 'input'),
            'class' => array('label' => __("Custom class", 'ct_theme'), 'default' => '', 'type' => 'input', 'help' => __('Adding custom class allows you to set diverse styles in css to the element. Type in name of class, which you defined in css. You can add as much classes as you like.', 'ct_theme')),
        );

    }

    /**
     * Returns additional info about VC
     * @return ctVisualComposerInfo
     */
    public function getVisualComposerInfo() {
        return new ctVisualComposerInfo( $this, array( 'icon' => 'fa-book' ) );
    }
}

new ctActivityBoxShortcode();



