<?php


/**
 * Pricelist shortcode
 */
class ctIconBoxItemShortcode extends ctShortcode implements ctVisualComposerShortcodeInterface
{


    /**
     * Returns name
     * @return string|void
     */
    public function getName()
    {
        return 'Icon Box item';
    }

    /**
     * Shortcode name
     * @return string
     */
    public function getShortcodeName()
    {
        return 'icon_box_item';
    }

    /**
     * Returns shortcode type
     * @return mixed|string
     */

    public function getShortcodeType()
    {
        return self::TYPE_SHORTCODE_ENCLOSING;
    }

    /**
     * Handles shortcode
     * @param $atts
     * @param null $content
     * @return string
     */

    public function handle($atts, $content = null)
    {
        extract(shortcode_atts($this->extractShortcodeAttributes($atts), $atts));

        $mainContainerAtts = array(
            'class' => array(
                'text-center',
                'table-cell',
                $class
            )
        );


        if ($link) {
            $linktag = '<a href="' . esc_url($link) . '">' . esc_html($title) . '</a>';
        } else {
            $linktag = $title;
        }

        if ($link != '') {
            $imageHtml = '<a href="' . esc_url($link) . '"><img src="' . esc_url($image) . '" alt="' . __('image', 'ct_theme') . '"></a>';
        } else {
            $imageHtml = '<img src="' . esc_url($image) . '" alt="' . __('image', 'ct_theme') . '">';
        }

        $html = '

       <div ' . $this->buildContainerAttributes($mainContainerAtts, $atts) . '>
            <span class="icon">' . $imageHtml . '</span>
            <span class="program-title">' . $linktag . '</span>
            <br>
            <br>
            <p>
                ' . $description . '
            </p>
        </div>
       ';

        return do_shortcode($html);
    }

    /**
     * Returns config
     * @return null
     */
    public function getAttributes()
    {
        return array(
            'title' => array('label' => __('title', 'ct_theme'), 'default' => '', 'type' => 'input'),
            'description' => array('label' => __('description', 'ct_theme'), 'default' => '', 'type' => 'input'),
            'image' => array('label' => __("image", 'ct_theme'), 'default' => '', 'type' => 'image', 'help' => __("Image source", 'ct_theme')),
            'link' => array(
                'label' => __("Link", 'ct_theme'),
                'default' => '',
                'type' => 'input',
                'help' => __("Link URL", 'ct_theme')
            ),
            'class' => array('label' => __("Custom class", 'ct_theme'), 'default' => '', 'type' => 'input', 'help' => __('Adding custom class allows you to set diverse styles in css to the element. Type in name of class, which you defined in css. You can add as much classes as you like.', 'ct_theme')),
        );

    }

    /**
     * Returns additional info about VC
     * @return ctVisualComposerInfo
     */
    public function getVisualComposerInfo()
    {
        return new ctVisualComposerInfo($this, array('icon' => 'fa-caret-square-o-up'));
    }
}

new  ctIconBoxItemShortcode();

