<?php

/**
 * Pricelist shortcode
 */
class ctLightBoxShortcode extends ctShortcode implements ctVisualComposerShortcodeInterface
{

    /**
     * Returns name
     * @return string|void
     */
    public function getName()
    {
        return 'Light box';
    }

    /**
     * Shortcode name
     * @return string
     */
    public function getShortcodeName()
    {
        return 'light_box';
    }

    /**
     * Returns shortcode type
     * @return mixed|string
     */

    public function getShortcodeType()
    {
        return self::TYPE_SHORTCODE_ENCLOSING;
    }


    /**
     * Handles shortcode
     * @param $atts
     * @param null $content
     * @return string
     */

    public function handle($atts, $content = null)
    {
        extract(shortcode_atts($this->extractShortcodeAttributes($atts), $atts));

        $mainContainerAtts = array(
            'class' => array(
                'info-block',
                $class
            )
        );

        $box = '';
        $headerShortcode = $header ? '[header class="color-motive" level="5"]'.$header.'[/header]' : '';
        //$contentShortcode = $content ? '[paragraph]' . $content . '[/paragraph]' : '';

        if (empty($img_src)) {
            $box = $headerShortcode . $content;

        } else if ($image_place == 'left') {
            $box = '<img class="pull-left" src="' . $img_src . '" alt="'.__('block image','ct_theme').'">
                    ' . $headerShortcode . $content . '
        ';

        } else if ($image_place == 'right') {
            $box = '<img class="pull-right" src="' . $img_src . '" alt="'.__('block image','ct_theme').'">
                    ' . $headerShortcode . $content . '
        ';
        }


        $html = '<div ' . $this->buildContainerAttributes($mainContainerAtts, $atts) . '>';
        $html .= $box;
        $html .= '</div>';

        return do_shortcode($html);
    }



    /**
     * Returns config
     * @return null
     */
    public function getAttributes()
    {
        return array(
            'header' => array('label' => __('Title', 'ct_theme'), 'default' => '', 'type' => 'input'),
            'content' => array('label' => __('Description', 'ct_theme'), 'default' => '', 'type' => 'textarea'),
            'class' => array('label' => __("Custom class", 'ct_theme'), 'default' => '', 'type' => 'input', 'help' => __('Adding custom class allows you to set diverse styles in css to the element. Type in name of class, which you defined in css. You can add as much classes as you like.', 'ct_theme')),
            'img_src' => array('label' => __("Image source", 'ct_theme'), 'default' => '', 'type' => 'image', 'help' => __("Image source", 'ct_theme')),
            'image_place' => array('label' => __('Image place', 'ct_theme'), 'default' => 'left', 'type' => 'select',
                'choices' => array('left' => 'left', 'right' => 'right'), 'help' => __("Image place", 'ct_theme')),
        );

    }

    /**
     * Returns additional info about VC
     * @return ctVisualComposerInfo
     */
    public function getVisualComposerInfo() {
        return new ctVisualComposerInfo( $this, array( 'icon' => 'fa-caret-square-o-up' ) );
    }

}

new ctLightBoxShortcode();



