<?php


/**
 * Pricelist shortcode
 */
class ctNavBoxItemShortcode extends ctShortcode implements ctVisualComposerShortcodeInterface{


    /**
     * Returns name
     * @return string|void
     */
    public function getName()
    {
        return 'Nav Box item';
    }

    /**
     * Shortcode name
     * @return string
     */
    public function getShortcodeName()
    {
        return 'nav_box_item';
    }

    /**
     * Returns shortcode type
     * @return mixed|string
     */

    public function getShortcodeType()
    {
        return self::TYPE_SHORTCODE_ENCLOSING;
    }

    /**
     * Handles shortcode
     * @param $atts
     * @param null $content
     * @return string
     */

    public function handle($atts, $content = null)
    {
        extract(shortcode_atts($this->extractShortcodeAttributes($atts), $atts));

        if ($type == 'onepager') {
            $linkAttr = '#' . $el_id;
        } else {
            $linkAttr = $link;
        }

        $html = '
            <div class="table-cell text-center">
                <a class="btn-scroll" href="' .esc_url( $linkAttr) . '">
                    <span class="icon">
                        <img src="' . $image . '" alt="'.__('nav box image','ct_theme').'">
                    </span>
                    <span class="big-number color-motive-light">' . $number . '</span>
                    <span class="number-description text-center color-motive">' . $description . '</span>
                </a>
            </div>
		';
        return do_shortcode($html);
    }

    /**
     * Returns config
     * @return null
     */
    public function getAttributes()
    {
        return array(
            'type' => array('label' => __('Type', 'ct_theme'), 'default' => 'onepager', 'type' => 'select',
                'choices' => array('onepager' => __('onepager navigation', 'ct_theme'), 'link' => __('link navigation', 'ct_theme')), 'help' => __("Onepager navigation scrolls to page element. Link Navigation goes to entered url", 'ct_theme')),
            'description' => array('label' => __('description', 'ct_theme'), 'default' => '', 'type' => 'input'),
            'number' => array('label' => __('Number', 'ct_theme'), 'default' => '', 'type' => 'input'),
            'image' => array('label' => __("image", 'ct_theme'), 'default' => '', 'type' => 'image', 'help' => __("Image source", 'ct_theme')),
            'link' => array(
                'label' => __("Link", 'ct_theme'),
                'default' => '',
                'type' => 'input',
                'help' => __("Link URL", 'ct_theme')
            ),
            'el_id' => array('label' => __('Element ID for onepager navigation', 'ct_theme'), 'default' => '', 'type' => 'input'),

            'class' => array('label' => __("Custom class", 'ct_theme'), 'default' => '', 'type' => 'input', 'help' => __('Adding custom class allows you to set diverse styles in css to the element. Type in name of class, which you defined in css. You can add as much classes as you like.', 'ct_theme')),
        );

    }

    /**
     * Returns additional info about VC
     * @return ctVisualComposerInfo
     */
    public function getVisualComposerInfo() {
        return new ctVisualComposerInfo( $this, array( 'icon' => 'fa-navicon' ) );
    }
}

new  ctNavBoxItemShortcode();




/**
 * Created by PhpStorm.
 * User: Patryk
 * Date: 26.07.14
 * Time: 18:30
 */ 