<?php




/**
 * infobox shortcode
 */
class ctNavBoxShortcode extends ctShortcode implements ctVisualComposerShortcodeInterface{


    /**
     * Returns name
     * @return string|void
     */
    public function getName() {
        return 'Nav Box';
    }

    /**
     * Shortcode name
     * @return string
     */
    public function getShortcodeName() {
        return 'nav_box';
    }

    /**
     * Returns shortcode type
     * @return mixed|string
     */

    public function getShortcodeType() {
        return self::TYPE_SHORTCODE_ENCLOSING;
    }


    /**
     * Handles shortcode
     * @param $atts
     * @param null $content
     * @return string
     */

    public function handle($atts, $content = null) {
        extract(shortcode_atts($this->extractShortcodeAttributes($atts), $atts));

        $mainContainerAtts = array(
            'class' => array(
                'programs',
                $class,
            )
        );



        return '
		<div '.$this->buildContainerAttributes($mainContainerAtts, $atts).'>
	       '.do_shortcode($content).'
        </div>
		';
    }

    /**
     * Child shortcode info
     * @return array
     */

    public function getChildShortcodeInfo() {
        return array('name' => 'nav_box_item', 'min' => 1, 'max' => 4, 'default_qty' => 4);
    }



    /**
     * Returns config
     * @return null
     */
    public function getAttributes() {
        return array(
            'title' => array('label' => __('title', 'ct_theme'), 'default' => '', 'type' => 'input'),
            'class' => array('label' => __("Custom class", 'ct_theme'), 'default' => '', 'type' => 'input', 'help' => __('Adding custom class allows you to set diverse styles in css to the element. Type in name of class, which you defined in css. You can add as much classes as you like.', 'ct_theme')),
        );

    }

    /**
     * Returns additional info about VC
     * @return ctVisualComposerInfo
     */
    public function getVisualComposerInfo() {
        return new ctVisualComposerInfo( $this, array( 'icon' => 'fa-navicon' ) );
    }
}

new ctNavBoxShortcode();

//#28147
if(class_exists('WPBakeryShortCodesContainer')){
    class WPBakeryShortcode_nav_box extends WPBakeryShortCodesContainer{}
}