<?php

/**
 * Calendar shortcode
 */
class ctCalendarShortcode extends ctShortcode implements ctVisualComposerShortcodeInterface
{


    /**
     * Returns name
     * @return string|void
     */
    public function getName()
    {
        return 'Calendar';
    }

    /**
     * Shortcode name
     * @return string
     */
    public function getShortcodeName()
    {
        return 'calendar';
    }

    /**
     * Returns shortcode type
     * @return mixed|string
     */

    public function getShortcodeType()
    {
        return self::TYPE_SHORTCODE_ENCLOSING;
    }

    public function enqueueScripts()
    {
        wp_register_script('moment_full_calendar', CT_THEME_DIR_URI . '/assets/js/moment.min.js', array('jquery'), null, true);
        wp_enqueue_script('moment_full_calendar');

        wp_register_script('full_calendar', CT_THEME_DIR_URI . '/assets/js/fullcalendar.js', array('moment_full_calendar'), null, true);
        wp_enqueue_script('full_calendar');

        wp_register_script('g_calendar', CT_THEME_DIR_URI . '/assets/js/gcal.js', array('full_calendar'), null, true);
        wp_enqueue_script('g_calendar');
    }


    /**
     * Handles shortcode
     * @param $atts
     * @param null $content
     * @return string
     */

    public function handle($atts, $content = null)
    {
        $attributes = shortcode_atts($this->extractShortcodeAttributes($atts), $atts);
        $id = 'calendar' . rand(100, 1000);
        $this->addInlineJS($this->getInlineJS($attributes, $id), true);
        extract($attributes);

        $mainContainerAtts = array(
            'class' => array(
                'calendar',
                $class
            ),
            'id' => $id
        );


        $html = '<div ' . $this->buildContainerAttributes($mainContainerAtts, $atts) . '></div><div class="clearfix"></div>';

        return do_shortcode($html);
    }


    /**
     * returns inline js
     * @param $attributes
     * @param $id
     * @return string
     */
    protected function getInlineJS($attributes, $id)
    {
        return '
            jQuery(document).ready(function() {
    var date = new Date();

    jQuery("#' . esc_js($id) . '").fullCalendar({
        googleCalendarApiKey: "'.esc_js($attributes['apikey']).'",
        header: {
            left: "title",
            right: "prev, today, next"
        },
        defaultView: "basicDay",
        buttonText: {
            today: "TODAY"
        },
        handleWindowResize: true,
        agendaDay: {
            allDayText: ""
        },
        // for agendaWeek and agendaDay
        editable: false,

        events: {
            googleCalendarId: "'.esc_js($attributes['link']).'"
        },


        eventClick: function(event) {
        // opens events in a popup window
        window.open(event.url, "gcalevent", "width=700,height=600");
        return false;
    }
    });
});

        ';
    }


    /**
     * Returns config
     * @return null
     */
    public function getAttributes()
    {
        return array(

            'apikey' => array('label' => __("API key used for Google Calendar", 'ct_theme'), 'default' => '', 'type' => 'input'),
            'link' => array('label' => __("Link to Google Calendar", 'ct_theme'), 'default' => '', 'type' => 'input'),
            'class' => array('label' => __("Custom class", 'ct_theme'), 'default' => '', 'type' => 'input', 'help' => __('Adding custom class allows you to set diverse styles in css to the element. Type in name of class, which you defined in css. You can add as much classes as you like.', 'ct_theme')),
        );

    }

    /**
     * Returns additional info about VC
     * @return ctVisualComposerInfo
     */
    public function getVisualComposerInfo()
    {
        return new ctVisualComposerInfo($this, array('icon' => 'fa-calendar'));
    }
}

new ctCalendarShortcode();