<?php

/**
 * Contact shortcode
 */
class ctContactUsSectionShortcode extends ctShortcode implements ctVisualComposerShortcodeInterface
{


    /**
     * Returns name
     * @return string|void
     */
    public function getName()
    {
        return 'Contact Section';
    }

    /**
     * Shortcode name
     * @return string
     */
    public function getShortcodeName()
    {
        return 'contact_section';
    }

    /**
     * Handles shortcode
     * @param $atts
     * @param null $content
     * @return string
     */

    public function handle($atts, $content = null)
    {
        $class = '';
        $shortcodeEmail = '';
        $shortcodePhone = '';

        extract(shortcode_atts($this->extractShortcodeAttributes($atts), $atts));

        $mainContainerAtts = array(
            'class' => array(
                'addressBox',
                'text-center',
                $class
            ),
        );

        $arrayEmail = explode(",", $email);
        $arrayPhone = explode(",", $phone);

        if ($email != '') {
            $i = 0;
            $shortcodeEmail = '';
            foreach ($arrayEmail as $value) {
                $shortcodeEmail .= ' <a href="mailto:' . is_email($value) . '">' . $value . '</a><br>';
            }
        }

        if ($phone != '') {
            $i = 0;
            $shortcodePhone = '';
            foreach ($arrayPhone as $value) {
                $shortcodePhone .= $value;
                $shortcodePhone .= '<br>';
            }

        }

        $title = ($title !== '') ? '<h4 class="color-motive">' . $title . '</h4>' : '';


        if ($email != '') {
            $shortcodeEmail = '';
            foreach ($arrayEmail as $value) {
                $shortcodeEmail .= '
                        <div class="media">
                            <div class="pull-left">
                                <span class="h4 color-motive">
                                    &#x00040;
                                </span>
                            </div>
                            <div class="media-body">
                                <span class="h4 color-motive">
                                    <a href="mailto:' . is_email($value) . '">' . $value . '</a>
                                </span>
                            </div>
                        </div><br>

                        ';
            }
        }

        if ($phone != '') {
            $shortcodePhone = '';
            foreach ($arrayPhone as $value) {
                $shortcodePhone .= '<div class="media">
                            <div class="pull-left">
                                <span class="h4 color-motive">
                                    <i class="fa fa-phone"></i>
                                </span>
                            </div>
                            <div class="media-body">
                                <span class="h4 color-motive">
                                    ' . $value . '
                                </span>
                            </div>
                        </div><br>';
            }

        }


        return do_shortcode('

        <div class="row">
                    <div class="col-md-7">
                        ' . $title . '
                        <p>' . $description . '</p>
                        <br>
                        <div class="row">
                            <div class="col-sm-6">
                                 ' . do_shortcode('[google_maps map_type="' . $map_type . '" location="' . $map_location . '" height="' . $map_height . '"]') . '
                            </div>
                            <div class="col-sm-6">
                                <p>
                                    ' . $address . '
                                </p>
                                <span class="h4 color-motive"><a href="' . esc_url($directions_url) . '">' . $directions_label . '</a></span>
                                <br>
                                <br>
                                ' . $shortcodePhone . $shortcodeEmail . '
                            </div>
                        </div>
                    </div>
            <div class="col-md-5">
                ' . $content . '
            </div>
        </div>
        ');
    }


    /**
     * Returns config
     *
     * @return null
     */
    public function getAttributes()
    {
        return array(
            'title' => array('label' => __('Title', 'ct_theme'), 'default' => __('Map header', 'ct_theme'), 'type' => 'input'),
            'description' => array('label' => __('Description', 'ct_theme'), 'default' => __('Map description', 'ct_theme'), 'type' => 'input'),
            'map_location' => array('label' => __('Map location', 'ct_theme'), 'default' => '', 'type' => 'input'),
            'map_height' => array('label' => __('Map height', 'ct_theme'), 'default' => 310, 'type' => 'input'),
            'map_type' => array('label' => __('Select map type', 'ct_theme'), 'default' => 'HYBRID', 'type' => 'select', 'options' => array(
                'ROADMAP' => 'Roadmap',
                'SATELLITE' => 'Satellite',
                'HYBRID' => 'Hybrid',
                'TERRAIN' => 'Terrain',
            )),
            'content' => array('label' => __('Content', 'ct_theme'), 'default' => '', 'type' => "textarea"),
            'directions_label' => array('label' => __('Directions label', 'ct_theme'), 'default' => __('Directions', 'ct_theme'), 'type' => 'input'),
            'directions_url' => array('label' => __('Directions url', 'ct_theme'), 'default' => '', 'type' => 'input'),
            'widgetmode' => array('default' => 'false', 'type' => false),
            'phone' => array('label' => __('phone', 'ct_theme'), 'default' => '', 'type' => 'input', 'help' => __("separating items with a comma", 'ct_theme')),
            'email' => array('label' => __('email', 'ct_theme'), 'default' => '', 'type' => 'input', 'help' => __("enter email address", 'ct_theme')),
            'address' => array('label' => __('address', 'ct_theme'), 'default' => '', 'type' => 'input', 'help' => __('type ' . htmlspecialchars('<br>') . ' to enter the next line', 'ct_theme')),
        );
    }

    /**
     * Returns additional info about VC
     * @return ctVisualComposerInfo
     */
    public function getVisualComposerInfo()
    {
        return new ctVisualComposerInfo($this, array('icon' => 'fa-envelope', 'container' => true));
    }
}

new ctContactUsSectionShortcode();