<?php

/**
 * Contact shortcode
 */
class ctContactUsShortcode extends ctShortcode implements ctVisualComposerShortcodeInterface{


    /**
     * Returns name
     * @return string|void
     */
    public function getName()
    {
        return 'Contact Us';
    }

    /**
     * Shortcode name
     * @return string
     */
    public function getShortcodeName()
    {
        return 'contact_us';
    }

    /**
     * Handles shortcode
     * @param $atts
     * @param null $content
     * @return string
     */

    public function handle($atts, $content = null)
    {
        $class = '';
        $shortcodeEmail = '';
        $shortcodePhone = '';

        extract(shortcode_atts($this->extractShortcodeAttributes($atts), $atts));

        $mainContainerAtts = array(
            'class' => array(
                'addressBox',
                'text-center',
                $class
            ),
        );

        $arrayEmail = explode(",", $email);
        $arrayPhone = explode(",", $phone);

        if ($email != '') {
            $i = 0;
            $shortcodeEmail = '';
            foreach ($arrayEmail as $value) {
                $shortcodeEmail .= ' <a href="mailto:' . is_email($value) . '">' . $value . '</a><br>';
            }
        }

        if ($phone != '') {
            $i = 0;
            $shortcodePhone = '';
            foreach ($arrayPhone as $value) {
                $shortcodePhone .= $value;
                $shortcodePhone .= '<br>';
            }

        }

        $title = ($title !== '') ? '<h4 class="color-motive">' . $title . '</h4>' : '';


        if ($email != '') {
            $shortcodeEmail = '';
            foreach ($arrayEmail as $value) {
                $shortcodeEmail .= '
                        <div class="media">
                            <div class="pull-left">
                                <span class="h4 color-motive">
                                    &#x00040;
                                </span>
                            </div>
                            <div class="media-body">
                                <span class="h4 color-motive">
                                    <a href="mailto:' . is_email($value) . '">' . $value . '</a>
                                </span>
                            </div>
                        </div><br>

                        ';
            }
        }

        if ($phone != '') {
            $shortcodePhone = '';
            foreach ($arrayPhone as $value) {
                $shortcodePhone .= '<div class="media">
                            <div class="pull-left">
                                <span class="h4 color-motive">
                                    <i class="fa fa-phone"></i>
                                </span>
                            </div>
                            <div class="media-body">
                                <span class="h4 color-motive">
                                    ' . $value . '
                                </span>
                            </div>
                        </div><br>';
            }

        }


        return '
                <div class="row">'.$title.'
                    <div class="col-sm-6">
                    '.do_shortcode('[google_maps map_type="'.$map_type.'" location="'.$map_location.'" height="'.$map_height.'"]').'
                    </div>
                    <div class="col-sm-6">
                        <p>' . $address . '
                        </p>
                        <span class="h4 color-motive"><a href="' . esc_url($directions_url) . '">' . $directions_label . '</a></span>
                        <br>
                        <br>
                        ' . $shortcodePhone . $shortcodeEmail . '</div></div>
                ';
    }


    /**
     * Returns config
     *
     * @return null
     */
    public function getAttributes()
    {
        return array(
            'title' => array('label' => __('Title', 'ct_theme'), 'default' => __('', 'ct_theme'), 'type' => 'input'),
            'map_location' => array('label' => __('Map location', 'ct_theme'), 'default' => '', 'type' => 'input'),
            'map_height' => array('label' => __('Map height', 'ct_theme'), 'default' => 310, 'type' => 'input'),
            'map_type' => array('label' => __('Select map type', 'ct_theme'), 'default' => 'HYBRID', 'type' => 'select', 'options' => array(
                'ROADMAP' => 'Roadmap',
                'SATELLITE' => 'Satellite',
                'HYBRID' => 'Hybrid',
                'TERRAIN' => 'Terrain',
            )),
            'directions_label' => array('label' => __('Directions label', 'ct_theme'), 'default' => __('Directions', 'ct_theme'), 'type' => 'input'),
            'directions_url' => array('label' => __('Directions url', 'ct_theme'), 'default' => '', 'type' => 'input'),
            'widgetmode' => array('default' => 'false', 'type' => false),
            'phone' => array('label' => __('phone', 'ct_theme'), 'default' => '', 'type' => 'input', 'help' => __("separating items with a comma", 'ct_theme')),
            'email' => array('label' => __('email', 'ct_theme'), 'default' => '', 'type' => 'input', 'help' => __("enter email address", 'ct_theme')),
            'address' => array('label' => __('address', 'ct_theme'), 'default' => '', 'type' => 'input', 'help' => __('type ' . htmlspecialchars('<br>') . ' to enter the next line', 'ct_theme')),
            );
    }

    /**
     * Returns additional info about VC
     * @return ctVisualComposerInfo
     */
    public function getVisualComposerInfo() {
        return new ctVisualComposerInfo( $this, array( 'icon' => 'fa-envelope' ) );
    }
}

new ctContactUsShortcode();