<?php
require_once CT_THEME_LIB_DIR . '/shortcodes/socials/ctTwitterShortcodeBase.class.php';

/**
 * Twitter shortcode
 */
class ctTwitterShortcode extends ctTwitterShortcodeBase implements ctVisualComposerShortcodeInterface{


    /**
     * Handles shortcode
     * @param $atts
     * @param null $content
     * @return string
     */

    public function handle($atts, $content = null)
    {
        $attributes = shortcode_atts($this->extractShortcodeAttributes($atts), $atts);
        extract($attributes);
        $this->addInlineJS($this->getInlineJS(), true);


        $mainContainerAtts = array(
            'class' => array(
                'tweets'
            ),
            'id' => 'twitter-' . rand(100, 1000)
        );


        //$newwindow = $newwindow == 'false' || $newwindow == 'no' ? false : true;

        $html = '';
        $followLink = $this->getFollowLink($user);
        $tweets = $this->getTweets($attributes);

        $counter = 1;
        $class = ' tweet';

        if ($widgetmode == true) {

            $scrollBoxFormatterArgs = array(
                'main_container_height' => '300px',
                'icon_up_class' => 'fa fa-chevron-up',
                'icon_down_class' => 'fa fa-chevron-down',
                'ul_max_height' => '300px',
                'main_container_class' => 'with-scroll',
                'no_scroll' => false,
                'ul_class' => 'tweet_list slides',
                'before_list' => '<div class="tweets_display">',
                'after_list' => '</div>',
                'raw_content' => true
            );


            foreach ($tweets as $tweet) {
                //$html .= $counter == 1 ? '<ul class="tweet_list ">' : '';
                $class .= $counter == 1 ? ' tweet_first' : '';
                $class .= $counter == 2 ? ' tweet_even' : ' tweet_odd';
                $html .= '<li style="list-style: none" class="tweetBox ' . $class . '">
                <p>
                        <a class="tweet_user" href="' . esc_url($followLink) . '">' . $tweet->user . '</a>
						<span class="tweet_text">' . $tweet->content . '</span>
						<span class="tweet_time">
							<a href="' . esc_url($followLink) . '" title="' . $tooltip . '">' . $this->ago($tweet->updated) . '</a>
						</span>
                </p>
	               </li>';

                //$html .= $counter == 3 ? '</ul>' : '';
                $counter++;
                $counter = ($counter < 4) ? $counter : 1;
            }

            $formatter = new ctScrollBoxFormatter();
            $html = $formatter->format($html, $scrollBoxFormatterArgs);


        } else {
            foreach ($tweets as $tweet) {
                $html .= $counter == 1 ? '<ul class="tweet_list ">' : '';
                $class .= $counter == 1 ? ' tweet_first' : '';
                $class .= $counter == 2 ? ' tweet_even' : ' tweet_odd';
                $html .= '<li style="list-style: none" class="tweetBox ' . $class . '">

						<span class="tweet_text">
						<a href="' . esc_url($followLink) . '">' . $tweet->user . '</a>
							' . $tweet->content . '
						</span>
						<span class="tweet_time">

							<a href="' . $followLink . '">' . $this->ago($tweet->updated) . '</a>
						</span>
	               </li>';

                $html .= $counter == 3 ? '</ul>' : '';
                $counter++;
                $counter = ($counter < 4) ? $counter : 1;

            }
        }


        if ($counter != 1 && $widgetmode != true) {
            $html .= '</ul>';
        }

        if ($widgetmode == "true") {

            $headerShortcode = $header ? '[header class ="color-motive uppercase" level="4"]' . $header . '[/header]' : '';
        } else {
            $headerShortcode = $header ? '[header level="3"]' . $header . '[/header]' : '';
        }


        if ($button && $widgetmode == "false") {
            $followButton_shortcode = '[button type="primary" size="sm" icon="fa-twitter" link="' . $followLink . '"]' . $button . '[/button]';
        } else {
            $followButton_shortcode = '';
        }


        $twitter = $headerShortcode;
        $twitter .= '<div ' . $this->buildContainerAttributes($mainContainerAtts, $atts) . '>'
            . $html
            . $followButton_shortcode . '
 </div>
        ';
        return do_shortcode($twitter);
    }
    /**
     * returns inline js
     * @param $attributes
     * @param $id
     * @return string
     */
    protected function getInlineJS()
    {
        return '

             /* ======================= */
    /* ==== WIDGET SCROLL ==== */

    jQuery(".with-scroll").each(function(){
        var $this = jQuery(this);

        $this.find("ul").css({
            "max-height": $this.data("height")
        });
        $this.find(".tweets_display ul").css({
            "max-height": $this.data("height")
        });

        var step = 100;
        var scrolling = false;

        // Wire up events for the "scrollUp" link:
        $this.find(".scrollUp").bind("click", function (event) {
            event.preventDefault();
            // Animates the scrollTop property by the specified
            // step.
            $this.find("ul").animate({
                scrollTop: "-=" + step + "px"
            });
        }).bind("mouseover", function (event) {
            scrolling = true;
            scrollContent("up");
        }).bind("mouseout", function (event) {
            scrolling = false;
        });


        $this.find(".scrollDown").bind("click", function (event) {
            event.preventDefault();
            $this.find("ul").animate({
                scrollTop: "+=" + step + "px"
            });
        }).bind("mouseover", function (event) {
            scrolling = true;
            scrollContent("down");
        }).bind("mouseout", function (event) {
            scrolling = false;
        });

        function scrollContent(direction) {
            var amount = (direction === "up" ? "-=3px" : "+=3px");
            $this.find("ul").animate({
                scrollTop: amount
            }, 1, function () {
                if (scrolling) {
                    scrollContent(direction);
                }
            });
        }
    });

        ';
    }

    /**
     * Returns config
     * @return null
     */
    public function getAttributes()
    {
        $args = array_merge(
            array(
                'widgetmode' => array('default' => 'false', 'type' => false),
                'header' => array('label' => __('header', 'ct_theme'), 'default' => __('Latest Tweets', 'ct_theme'), 'type' => 'input'),
                'tooltip' => array('label' => __('Tweet time tooltip text', 'ct_theme'), 'default' => __('view tweet on twitter', 'ct_theme'), 'type' => 'input'),
            ), parent::getAttributes());
        return $args;
    }

    /**
     * Returns additional info about VC
     * @return ctVisualComposerInfo
     */
    public function getVisualComposerInfo() {
        return new ctVisualComposerInfo( $this, array( 'icon' => 'fa-twitter' ) );
    }
}

new ctTwitterShortcode();