<?php
if (!class_exists('ct_extra_menu_container')) {
    class ct_extra_menu_container
    {
        public $page_id = '';
        protected $html = '';

        public function set_html($html)
        {
            $this->html = $html;
        }

        public function get_html()
        {
            return $this->html;
        }


        public function __construct($page_id, $html)
        {
            $this->page_id = $page_id;
            $this->html = $html;
            add_filter('walker_nav_menu_start_el', array($this, 'add_custom_content'), 10, 2);
        }

        public function add_custom_content($item_output, $item)
        {
            if ($item->object_id == $this->page_id && $item->menu_item_parent == 0) {

                //set active class for Big menu
                if ('program' === get_post_type() && is_single()) {

                    add_filter('ct_nc_class_parent_class',  'set_active_class');
                    function set_active_class()
                    {
                        return 'yamm-fw';
                    }
                }
                return $this->get_html();


            } else {
                return $item_output;
            }
        }

    }
}


if (!function_exists('ctMakeProgramsMenuContainer')) {
    function ctMakeProgramsMenuContainer()
    {
        $html = '</li><li class="dropdown yamm-fw"><a href="' . get_permalink(ct_get_option("program_index_page")) . '" data-toggle="dropdown" class="dropdown-toggle">' . ct_get_option("programs_index_menu_container_title", 'Programs') . '</a>
            <ul class="dropdown-menu">
            <li>
            <div class="yamm-content">
            <h4>' . ct_get_option("programs_index_menu_container_title", 'Programs') . '</h4>
            <div class="table text-center programs">';

        $arrId = array();
        $arrId[0] = '';
        $slotNumber = 6;
        for ($i=1;$i < intval($slotNumber); $i++){
            $arrId[$i] = ct_get_option("programs_index_menu_featured_slot_".$i);
        }

        foreach ($arrId as $key) {
            if ($key != '') {

                $title = get_the_title($key);
                $custom = get_post_custom($key);
                $age_min = $custom['program_meta_age_min'][0];
                $age_max = $custom['program_meta_age_max'][0];
                $imgsrc = ct_get_feature_image_src($key, 'featured_program');

                $html .= '<div class="table-cell">';
                $html .= '<a href="' . get_permalink($key) . '">';
                $html .= '<span class="icon">';
                $html .= '<img src="' . $imgsrc . '" alt="'.__('Big menu image','ct_theme').'"></span>';
                $html .= '<span class="program-title">';
                $html .= '<strong>' . $title . '<br>';
                if ($age_min == '' && $age_max == '') {
                    $age = __('all ages', 'ct_theme');
                } else if ($age_min < 1 && $age_max < 1) {
                    $age = $age_min * 100 . ' - ' . $age_max * 100 . ' ' . __('months', 'ct_theme');
                } else {
                    $age = $age_min . ' - ' . $age_max . ' ' . __('years', 'ct_theme');
                }
                $html .= $age . '</strong></span></a></div>';
            }
        }
        return $html . '</div></div></li></ul>';
    }
}