<?php

class ctGalleryFormatter
{


    public function __construct()
    {
        wp_register_script('ctMagnificPopupInit', CT_THEME_ASSETS . '/js/magnificPopupInit.js');
        wp_enqueue_script('ctMagnificPopupInit');

    }


    public function format($type = 'gallery_section', $items = array(), $args = array())
    {

        $args = array_merge($this->getDefaultArgs(), $args);


        if ($type == 'gallery_section') {
            return $this->get_gallery_section($args, $items);
        } else if ($type = 'gallery_single') {
            return $this->get_gallery_single($items);
        }

        return false;
    }

    protected function getDefaultArgs()
    {
        return array(
            'gal_title' => '',
            'gal_link' => '',
            'gal_date' => '',
            'gal_before_date' => __('Posted on', 'ct_theme'),
            'gal_author' => '',
            'gal_author_url' => '',
            'gal_before_author' => false,
            'gal_description' => '',
            'gal_gallery_dropdown_label' => __('Pick Gallery to View', 'ct_theme'),
            'gal_custom_class' => '',
            'gal_columns' => 3,
            'gal_show_meta' => 'true',
            'gal_show_content' => 'true',
        );
    }

    protected function get_gallery_section($args, $gal_items)
    {

        //verify items
        if (is_array($gal_items) && !empty($gal_items)) {
            // Items loop
            $items = '';
            foreach ($gal_items as $key => $value) {
                if (isset($value['item_src_full'])
                    && isset($value['item_src_thumb'])
                ) {

                    if (!isset($value['item_title'])) {
                        $value['item_title'] = '';
                    }
                    if (!isset($value['item_description'])) {
                        $value['item_description'] = '';
                    }
                    $cols = $args['gal_columns'] == 3 ? 'col-md-4 col-sm-4' : 'col-md-3 col-sm-4';
                    //var_dump($args['gal_columns']);
                    $items .= '<div class="' . $cols . '">';
                    $items .= '<div class="image-box">';
                    $items .= '<a class="popup" data-type="image" href="' . esc_url($value['item_src_full']) . '" title="' . $value['item_description'] . '">';
                    $items .= '<img src="' . $value['item_src_thumb'] . '" alt="' . $value['item_title'] . '" class="fit-image">';
                    $items .= '</a>';
                    $items .= '<div class="description">';
                    $items .= $value['item_title'];
                    $items .= '</div></div></div>';
                } else {
                    continue;
                }
            }

        } else {
            return false;
        }
        $html = '<a href="' . esc_url($args['gal_link']) . '"><h4 class="color-motive">' . $args['gal_title'] . '</h4></a>';
        $html .= $args['gal_show_meta'] != 'true' ? '' : '<span class="meta">' . $args['gal_before_date'] . ' ' . $args['gal_date'] . ' ' . $args['gal_before_author'] . ' ' . '<a href="' . esc_url($args['gal_author_url']) . '" class="color-motive-light">' . $args['gal_author'] . '</a></span>';
        $html .= $args['gal_show_content'] != 'true' ? '' : '<p>' . strip_tags(strip_shortcodes($args['gal_description'])) . '</p>';
        $html .= '<section class="gallery">';
        $html .= '<div class="row">';
        $html .= $items;
        $html .= '</div>';
        $html .= '</section>';
        $html .= '<hr>';

        return $html;

    }

    protected function get_gallery_single($gal_items)
    {


        wp_register_script('ctGallerySingleInit', CT_THEME_ASSETS . '/js/ctGallerySingleInit.js');
        wp_enqueue_script('ctGallerySingleInit');
        wp_register_script('ct-infinitescroll', CT_THEME_ASSETS . '/js/infinitescroll.min.js', array('jquery'), false, true);
        wp_enqueue_script('ct-infinitescroll');
        wp_register_script('packery', CT_THEME_DIR_URI . '/assets/js/packery.pkgd.min.js', array('jquery'), null, true);
        wp_enqueue_script('packery');


        //verify items
        if (is_array($gal_items) && !empty($gal_items)) {
            $tilesCounter = 0;
            $tileClass = array(
                'pSmall', 'pSmall', 'pSmall', 'pBig', 'pTall', 'pSmall', 'pTall', 'pBig', 'pSmall', 'pSmall'
            );

            //Duplicate titleClass Array if the number of images is multiple of 10
            for ($i= 1; $i < count($gal_items); $i++){
                if ($i % 10 == 0) {
                    $tileClass=array_merge($tileClass,$tileClass);
                }
            }

            // Items loop
            $items = '';

            foreach ($gal_items as $key => $value) {

                if ($tilesCounter == count($tileClass) + 1) {
                    // $tilesCounter = 0;
                }

                //var_dump($value);
                if (isset($value['item_src_full'])
                    && isset($value['item_src_thumb'])
                    && isset($value['item_src_big'])
                    && isset($value['item_src_tall'])
                ) {

                    if (!isset($value['item_title'])) {
                        $value['item_title'] = '';
                    }
                    if (!isset($value['item_description'])) {
                        $value['item_description'] = '';
                    }

                    if (!isset($tileClass[$tilesCounter])) continue;

                    $items .= '<div class="packeryItem ' . $tileClass[$tilesCounter] . ' hidden">';
                    $items .= '<div class="inner">';
                    $items .= '<div class="postImage">';
                    $items .= '<a class="popup" data-type="image" href="' . esc_url($value['item_src_full']) . '" title="' . $value['item_description'] . '">';
                    if ($tileClass[$tilesCounter] == 'pBig') {
                        $items .= '<img src="' . $value['item_src_big'] . '" alt="' . $value['item_title'] . '" class="fit-image">';
                    } else if ($tileClass[$tilesCounter] == 'pTall') {
                        $items .= '<img src="' . $value['item_src_tall'] . '" alt="' . $value['item_title'] . '" class="fit-image">';
                    } else {
                        $items .= '<img src="' . $value['item_src_thumb'] . '" alt="' . $value['item_title'] . '" class="fit-image">';
                    }
                    $items .= '</a>';
                    $items .= '</div>';
                    $items .= '<div class="description">';
                    $items .= $value['item_title'];
                    $items .= '</div></div></div>';
                } else {
                    continue;
                }

                $tilesCounter++;
                // var_dump($tilesCounter);
            }

            return '<div class="clearfix"><div id="packagery" class="gallery">' . $items . '</div></div>';

        } else {
            return false;
        }
    }
}

