<?php

/**
 * Handles all Meal schedules and logic
 */
class ctMealPlan
{

    const POST_TYPE = 'ctMealPlan';


    public function __construct()
    {


        if (is_admin() && 'ctmealplan' == self::get_current_post_type()) {
            add_action('admin_init', array($this, 'startPlugin'));

            add_action( 'wp_print_scripts', array($this, 'ctDequeueScripts'), 100 );

            add_action('admin_footer-post.php', array('ctMealPlan', 'getInlineJS')); //  post edit page
            add_action('admin_footer-post-new.php', array('ctMealPlan', 'getInlineJS')); // add new post page
        } else {
            return '';
        }


    }

    /**
     * Dequeue jqueryedittable script added by catalog mode - bug #28031
     */
    function ctDequeueScripts() {
        if (wp_script_is('jquery_edittable_js')){
            wp_dequeue_script('jquery_edittable_js');
        }

    }
    
    public function startPlugin()
    {


        wp_register_script('ctEdittable-js', CT_THEME_ASSETS . '/plugins/editTable-master/ctJquery.edittable.js', array('jquery'));
        wp_enqueue_script('ctEdittable-js');
        wp_register_style('ctEdittable-css', CT_THEME_ASSETS . '/plugins/editTable-master/jquery.edittable.min.css');
        wp_enqueue_style('ctEdittable-css');

    }

    /**
     * gets the current post type in the WordPress Admin
     */
    public static function get_current_post_type()
    {
        global $post, $typenow, $current_screen;

        //we have a post so we can just get the post type from that
        if ($post && $post->post_type)
            return $post->post_type;

        //check the global $typenow - set in admin.php
        elseif ($typenow)
            return $typenow;

        //check the global $current_screen object - set in sceen.php
        elseif ($current_screen && $current_screen->post_type)
            return $current_screen->post_type;

        //lastly check the post_type querystring
        elseif (isset($_REQUEST['post_type']))
            return sanitize_key($_REQUEST['post_type']);


        elseif (isset ($_REQUEST['post']) && get_post_type($_REQUEST['post']))
            return get_post_type($_REQUEST['post']);

        //we do not know the post type!
        return null;
    }


    public static $currentMenuID;

    public static function getCurrentMenuID()
    {

        $nextMonday = strtotime('next monday');
        $weekNo = date('W');
        $weekNoNextMonday = date('W', $nextMonday);


        if (get_option('ctWeekNoNextMonday') == '') {
            update_option('ctWeekNoNextMonday', $weekNoNextMonday);
        } else {
            $weekNoNextMonday = get_option('ctWeekNoNextMonday');
        }


        if ($weekNoNextMonday == $weekNo) {
            if (self::getMenuNextWeekSetting() == 'repeat') {
                return ct_get_option('meal_plan_current_menu');
            } elseif (self::getMenuNextWeekSetting() == 'loop') {
                $nextMenu = self::getNextMenuLoopID(ct_get_option('meal_plan_current_menu'));
                ct_set_option('meal_plan_current_menu', $nextMenu);
                return $nextMenu;
            }
        } else {
            return ct_get_option('meal_plan_current_menu');
        }


    }


    public static function getMenuNextWeekSetting()
    {
        if (ct_get_option('meal_plan_next_week') == 'repeat') {
            return 'repeat';
        } else {
            return 'loop';
        }
    }


    public static function getNextMenuLoopID($currentID)
    {

        //@todo order by menu_order asc

        $post_ids = get_posts(array(
            'numberposts' => -1, // get all posts.
            'post_type' => self::POST_TYPE,
            'fields' => 'ids', // Only get post IDs
            'order' => 'ASC',
        ));
        $currentKeyByMenuId = array_search($currentID, $post_ids);
        $nextMenuId = isset($post_ids[$currentKeyByMenuId + 1]) ? $post_ids[$currentKeyByMenuId + 1] : $post_ids[0];
        return $nextMenuId;
    }

    public static function getInitJson()
    {
        $items = array();
        foreach (self::getMealtimes() as $key) {
            $items[][0] = $key;
        }
        return json_encode($items);
    }


    public static function mergeMealtimes($json = array())
    {

        $arr = json_decode($json);
        $mealTimes = self::getMealtimes();

        $counter = 0;
        if ($arr != false) {
            foreach ($mealTimes as $key) {
                $arr[$counter][0] = $key;
                $counter++;
            }
            array_splice($arr, $counter);
        }

        return json_encode($arr);
    }


    public static function getDays()
    {


        $days = ct_get_option('meal_plan_days', '');
        if (!empty($days)) {
            $days = explode("\n", $days);
            return array_filter(array_map('trim', $days));//remove whitespaces from days array

        } else {
            return array(
                array(__('Monday', 'ct_theme')),
                array(__('Tuesday', 'ct_theme')),
                array(__('Wednesday', 'ct_theme')),
                array(__('Thursday', 'ct_theme')),
                array(__('Friday', 'ct_theme')),
                array(__('Saturday', 'ct_theme')),
                array(__('Sunday', 'ct_theme')),
            );
        }
    }

    public static function getMealtimes()
    {
        $mealtimes = ct_get_option('meal_plan_mealtimes', '');
        if (!empty($mealtimes)) {
            $mealtimes = explode("\n", $mealtimes);
            return array_filter(array_map('trim', $mealtimes));//remove whitespaces from days array
        } else {
            return array(
                array(__('Morning Snack', 'ct_theme')),
                array(__('Lunch', 'ct_theme')),
                array(__('Afternoon Snack', 'ct_theme')),
                array(__('Fruit Snack', 'ct_theme')),
            );
        }
    }


    public static function getFoodItems()
    {
        $foodArr = array();

        $args = array(
            'posts_per_page' => -1,
            'offset' => 0,
            'category' => '',
            'category_name' => '',
            'orderby' => 'post_date',
            'order' => 'DESC',
            'include' => '',
            'exclude' => '',
            'meta_key' => '',
            'meta_value' => '',
            'post_type' => 'menu',
            'post_mime_type' => '',
            'post_parent' => '',
            'post_status' => 'publish',
            'suppress_filters' => true);

        $attachments = get_posts($args);

        if ($attachments) {
            $counter = 0;
            foreach ($attachments as $attach) {
                $foodArr[$counter]['id'] = $attach->ID;
                $foodArr[$counter]['food_name'] = $attach->post_title;
                $counter++;
            }
            $foodArr[$counter]['id'] = '';
            $foodArr[$counter]['food_name'] = '';
        }
        return $foodArr;
    }


    public static function getMealTimeLabel()
    {
        return ct_get_option('meal_plan_mealtime_label', __('Mealtime', 'ct_theme'));
    }


    public static function getMealTableHeaderColsJson()
    {
        $days = self::getDays();
        $mealtimeLabel = self::getMealTimeLabel();
        array_unshift($days, $mealtimeLabel);
        return json_encode($days);
    }

    public static function getMealTableRowTemplateJson()
    {
        $rowTemplate = array('input2');
        foreach (self::getDays() as $key) {
            $rowTemplate[] = 'select';
        }
        return json_encode($rowTemplate);
    }


    public static function getFoodItemsHTML($items = array())
    {

        $html = '';
        if (!empty($items)) {
            foreach ($items as $item) {
                if (!isset($item['id'])
                    && !isset($item['food_name'])
                    || empty($item['id'])
                    || empty($item['food_name'])
                ) {
                    continue;
                } else {
                    $html .= '<option value=\'' . $item['id'] . '\'>' . $item['food_name'] . '</option>';
                }
            }
            $html .= '<option  value=\'0\'> </option>';
        } else {
            return '';
        }

        return $html;
    }


    public static function getInlineJS()
    {

        $foodItemsHtml = self::getFoodItemsHTML(self::getFoodItems());
        echo '<script type="text/javascript">


window.onload = function () {
    /**
     * Example 4 - Custom field types & validation
     */
    //var $tx= [0];
    var mynewtable = jQuery("#menuTableJson").editTable({
        field_templates: {

            "select": {
                //no escape required
                html: "<select style=\' max-width: 100px; text-overflow: ellipsis; visibility: visible\' value=\'\' name=\'foodItemsArr[]\'  class=\'foodSel\'>' . $foodItemsHtml . '</select>",
                getValue: function (input) {
                    var $ = jQuery;


                    $tx = [];
                    $firstVal = jQuery(input).val();

                    console.log(input);
                    jQuery(input).siblings().each(function () {
                        var $val = jQuery(this).val();

                        if (jQuery.isNumeric($val)) {
                            $tx.push(jQuery(this).val());
                        }
                    });


                    if ($tx.length > 0) {
                        return $tx.toString();
                    } else {
                        return $firstVal;
                    }
                },

                setValue: function (input, value) {
                    var select = jQuery(input);

                    if (jQuery.isNumeric(value)) {

                        select.find("option").filter(function () {
                            return jQuery(this).val() == value;
                        }).attr("selected", true);
                        return select;
                    } else {
                        $html = [];
                        var $foodItemsArr = value.split(",");

                        $foodItemsArr.forEach(function (foodItemID) {
                            select.find("option").filter(function () {
                                return jQuery(this).val() == foodItemID;
                            }).attr("selected", true);

                            $html.push(select);
                        });
                        return $html;
                    }
                }
            },

            "input2": {
                html: "<p value=\'\'></p>",
                getValue: function (input) {
                    return jQuery(input).html();

                },
                setValue: function (input, value) {
                    return jQuery(input).text(value);
                }
            }
        },
        //no escape required
        row_template: ' . self::getMealTableRowTemplateJson() . ',
        headerCols: ' . self::getMealTableHeaderColsJson() . ',
        first_row: false,

        tableClass: "inputtable"
    });




//clone select

    var $td = jQuery(".inputtable td").each(function (index, element) {

        var $foodItemSelect = jQuery(".foodSel", this);
        var $len = $foodItemSelect.length;

        if ($foodItemSelect.val() == 0) {

            $foodItemSelect.after("<a class=\'addFoodItem icon-button\' href=\'#\'>+</a>").remove(".foodSel");
        } else {
            $foodItemSelect.each(function (index, element) {
                var $this = jQuery(this);
                if (index == $len - 1) {
                    $this.after("<a href=\'#\' class=\'delFoodItem icon-button\' >-</a><br><a class=\'addFoodItem icon-button\' href=\'#\'>+</a>");
                } else {
                    $this.after("<a href=\'#\' class=\'delFoodItem icon-button\' >-</a>");
                }
            });

        }


    });


    jQuery(".addFoodItem").on("click", function () {
        var $this = jQuery(this);
        var $el = jQuery(this).parent().find("select:last");

        if ($el.size() == 0) {
            var $html = "<select style=\' max-width: 100px; text-overflow: ellipsis; visibility: visible\' value=\'\' name=\'foodItemsArr[]\'  class=\'foodSel\'>' . $foodItemsHtml . '</select><a href=\'#\' class=\'delFoodItem icon-button\' >-</a><br>";

            $this.before($html);
        } else {
            var $firstSelect = jQuery(this).closest("td").find("select:first");
            $el.clone(true, true).insertAfter($el).before("<a href=\'#\' class=\'delFoodItem icon-button\' >-</a><br>");
        }

        return false;
    });


    jQuery(document).on("click", ".delFoodItem", function () {
        var $elButton = jQuery(this);
        var $elSelect = $elButton.prev();
        var $elBr1 = $elButton.next("br");
        var $elBr2 = $elButton.prev("br");

        var $br = jQuery(this).closest("td").find("br:last");
        $elSelect.remove();
        $elButton.remove();
        $elBr1.remove();
        $elBr2.remove();

        return false;
    });
};


</script>';
    }


    public static function getProductData($foodItemID = null)
        //get products data array from ID or ID series
    {
        $foodItems = array();
        if (!empty($foodItemID)) {
            $foodItemIDArr = explode(',', $foodItemID);
            if ($foodItemIDArr != false) {
                foreach ($foodItemIDArr as $key) {
                    $post_object = get_post($key);
                    if (is_object($post_object)) {
                        $title = $post_object->post_title;
                        $content = $post_object->post_content;
                        $image = ct_get_feature_image_src($key);
                        $foodItems[] = array('image' => $image, 'meal_name' => $title, 'content' => $content);
                    } else {
                        return '';
                    }
                }
            } elseif (!empty($foodItemID) && is_numeric($foodItemID)) {
                $post_object = get_post($foodItemID);
                if (is_object($post_object)) {
                    $title = $post_object->post_title;
                    $content = $post_object->post_content;
                    $image = ct_get_feature_image_src($foodItemID);
                    $foodItems[] = array('image' => $image, 'meal_name' => $title, 'content' => $content);
                } else {
                    return '';
                }
            } else {
                return '';
            }
        } else {
            return '';
        }
        return $foodItems;
    }


    public static function getMealTimesFromMenuArr($items = array())
    {
        $mealTimesArr = array();
        if (!empty($items)) {
            foreach ($items as $key) {
                $mealTimesArr[] = $key[0];
            }
        } else {
            return '';
        }

        return $mealTimesArr;
    }


    public static function convert($items = array())
        //convert from editTable-master json
    {
        $foodArray = array();
        if (is_array($items)) {
            $days = self::getDays();
            $mealTimesArr = self::getMealTimesFromMenuArr($items);

            if (empty($mealTimesArr)) {
                return '';
            }

            $counter1 = 1;

            $active = false;


            foreach ($days as $key) {
                $counter2 = 0;
                foreach ($mealTimesArr as $key2) {
                    if ($active == false) {
                        $foodArray[$key]['active'] = 'true';
                        $active = true;
                    }
                    $foodArray[$key]['mealtimes'][$counter2]['mealtime_name'] = $items[$counter2][0];


                    if (isset($items[$counter2][$counter1])) {
                        $foodArray[$key]['mealtimes'][$counter2]['food_items'] = self::getProductData($items[$counter2][$counter1]);
                    } else {
                        $foodArray[$key]['mealtimes'][$counter2]['food_items'] = 0;
                    }

                    $counter2++;
                }
                $counter1++;
            }
            return $foodArray;
        } else {
            return $foodArray;
        }
    }


    protected static function getDefaultWidgetArgs()
    {
        return array(
            'title' => '',
            'icon' => '',
            'description' => '',
        );
    }


    public static function formatWidget($data, $dayNumber = 1, $args = array())
    {
        $args = array_merge(self::getDefaultWidgetArgs(), $args);
        $itemsArr = self::getDayItems($data, $dayNumber);

        //$args = self::getDefaultWidgetArgs();
        if (isset($args['ID']) && !empty($args['ID'])) {
            $accordionID = $args['ID'];
        } else {
            $accordionID = 'accordion' . rand(1, 1000);
        }


        if (is_array($itemsArr) && !empty($itemsArr) && isset($itemsArr['mealtimes']) && is_array($itemsArr['mealtimes'])) {
            // Items loop
            $items = '';
            $counter = 0;
            $act = true;
            foreach ($itemsArr['mealtimes'] as $key) {

                if (!isset($key['mealtime_name'])) {
                    $value['mealtime_name'] = '';
                }
                if ($act == true) {
                    $active = '';
                    $active2 = 'panel-collapse collapse in';
                } else {
                    $active = 'collapsed';
                    $active2 = 'panel-collapse collapse';
                }
                $act = false;
                $items .= '<div class="panel">';
                $items .= '<div class="panel-heading">';
                $items .= '<a class="' . $active . '" data-toggle="collapse" data-parent="#' . $accordionID . '" href="#collapse' . $counter . '_' . $accordionID . '">' . $key['mealtime_name'] . '</a>';
                $items .= '</div>';
                $items .= '<div id="collapse' . $counter . '_' . $accordionID . '" class="' . $active2 . '">';
                $items .= '<div class="panel-body">';


                if (isset($key ['food_items']) && is_array($key['food_items']) && !empty($key['food_items'])) {
                    foreach ($key ['food_items'] as $key2 => $value2) {
                        $items .= '<span  data-toggle="popover" data-placement="left" data-title="' . $value2['meal_name'] . '" data-content="<img src=\'' . $value2['image'] . '\'/> ' . $value2['content'] . '">' . $value2['meal_name'] . '</span><br>';
                    }
                }

                $items .= '</div>';
                $items .= '</div>';
                $items .= '</div>';

                $counter++;
            }

        } else {
            return false;
        }

        $html = '<div class="icon">';
        $html .= '<img src="' . $args['icon'] . '">';
        $html .= '</div>';
        $html .= '<h4 class="color-motive uppercase">' . $args['title'] . '</h4>';
        $html .= '<p>' . $args['description'] . '</p>';
        $html .= '<div class="panel-group accordion" id="' . $accordionID . '">';
        $html .= $items;
        $html .= '</div>';

        return $html;


    }


    public static function getDayItems($json = null, $dayNumber)
    {
        if (empty($json) || $dayNumber >= count(self::getDays())) {
            return '';
        } else {
            $items = self::convert(json_decode($json));
            $keys = array_keys($items);
            if (isset($items[$keys[$dayNumber]])) {
                return $items[$keys[$dayNumber]];
            } else {
                return '';
            }
        }
    }


    public static function getTodayDayNumber()
    {
        $date = date("d-m-Y");
        $dayofweek = date('w', strtotime($date));
        return 0 == $dayofweek ? 6 : $dayofweek - 1;
    }

    public static function getNextDayNumber()
    {
        return self::getTodayDayNumber() + 1 == count(self::getDays()) ? 0 : self::getTodayDayNumber() + 1;
    }

    public static function getTodayMenuWidgetHTML($args = array())
    {
        $custom = get_post_custom(ctMealPlan::getCurrentMenuID());
        return ctMealPlan::formatWidget($custom["menuTableJson"][0], self::getTodayDayNumber(), $args);
    }

    public static function getNextDayMenuWidgetHTML($args = array())
    {
        //next week tommarow
        if (0 == self::getNextDayNumber()) {

            //check menu for next week
            if (self::getMenuNextWeekSetting() == 'repeat') {
                //next week -> repeat
                $custom = get_post_custom(ctMealPlan::getCurrentMenuID());

            } else {
                //next week -> loop
                $custom = get_post_custom(ctMealPlan::getNextMenuLoopID(ctMealPlan::getCurrentMenuID()));
            }
        } else {
            //use current menu
            $custom = get_post_custom(ctMealPlan::getCurrentMenuID());
        }

        return ctMealPlan::formatWidget($custom["menuTableJson"][0], self::getNextDayNumber(), $args);
    }

    public static function getCustomMenuWidgetHTML($dayNumber, $args = array())
    {

        //next week tommarow
        if (0 == self::getNextDayNumber()) {

            //check menu for next week
            if (self::getMenuNextWeekSetting() == 'repeat') {
                //next week -> repeat
                $custom = get_post_custom(ctMealPlan::getCurrentMenuID());

            } else {
                //next week -> loop
                $custom = get_post_custom(ctMealPlan::getNextMenuLoopID(ctMealPlan::getCurrentMenuID()));
            }

        } else {
            //use current menu
            $custom = get_post_custom(ctMealPlan::getCurrentMenuID());
        }

        return ctMealPlan::formatWidget($custom["menuTableJson"][0], $dayNumber - 1, $args);
    }


    public static function formatWeeklyMenu($json, $args = array())
    {
        $args = array_merge(self::getDefaultArgs(), $args);
        return self::getMenuHtml(self::convert(json_decode($json), $args));
    }

    protected static function getDefaultArgs()
    {
        return array(
            'ID' => '',
            'popup_placement' => 'left',
        );
    }

    protected static function getMenuHtml($items, $args = array())
    {

        $args = self::getDefaultArgs();
        if (isset($args['ID']) && !empty($args['ID'])) {
            $accordionID = $args['ID'];
        } else {
            $accordionID = 'accordion' . rand(1, 1000);
        }

        //clean empty days
        foreach ($items as $key => $value) {
            $unset = true;
            foreach ($value['mealtimes'] as $key2 => $value2) {
                if (is_array($value2['food_items']) && !empty($value2['food_items'])) {
                    $unset = false;
                }
            }
            if ($unset == true) {
                unset($items[$key]);
            }
        }

        $html = '';

        if (is_array($items) && !empty($items)) {
            $mealtimesHtml = '';
            $counter = 0;
            $html = '';

            //days loop
            foreach ($items as $key => $value) {


                if (!is_array($value) || empty($value)) {
                    continue;
                } else {

                    if (isset($value['active']) && $value['active'] == 'true') {
                        $activeClass = 'in';
                        $statusClass = 'collapse';
                    } else {
                        $activeClass = '';
                        $statusClass = 'collapsed';
                    }


                    $html .= '<div class="panel">
                        <div class="panel-heading">
                            <a class="' . $statusClass . '" data-toggle="collapse" data-parent="#' . $accordionID . '" href="#collapse' . $counter . '_' . $accordionID . '" >' . $key . ' </a>
                        </div>';
                    //mealtimes loop
                    $mealtimesNames = array();
                    $mealtimesHtml .= '<tbody><tr>';
                    if (is_array($value['mealtimes']) && !empty($value['mealtimes'])) {
                        foreach ($value['mealtimes'] as $key2 => $value2) {
                            if (!is_array($value2) || empty($value2)) {
                                continue;
                            } else {
                                //food items loop
                                $mealtimesHtml .= '<th><ul class="clean">';
                                $mealtimesNames[] = $value2['mealtime_name'];
                                if (is_array($value2['food_items']) && !empty($value2['food_items'])) {
                                    foreach ($value2['food_items'] as $key3 => $value3) {
                                        if (!is_array($value3) || empty($value3)) {
                                            continue;
                                        } else {
                                            if (isset($value3['popup']) && $value3['popup'] == false) {
                                                //hide popup for this item
                                                $mealtimesHtml .= '<li><span>' . $value3['meal_name'] . '</span></li>';
                                            } else {
                                                //show popup for this item
                                                $mealtimesHtml .= '
                                <li><span  data-toggle="popover"
                                 data-placement="' . $args['popup_placement'] . '"
                                  data-title="' . $value3['meal_name'] . '"

                                   data-content="'.(!empty($value3['image'])?'<img src=\'' . esc_url($value3['image']) . '\'/>':'') . $value3['content'] . '">' . $value3['meal_name'] . '
                                   </span></li>
                                ';
                                            }
                                        }
                                    }
                                } else {
                                    continue;
                                }
                                $mealtimesHtml .= '</ul></th>';
                            }
                        }
                    } else {
                        continue;
                    }
                    $mealtimesHtml .= '</tr></tbody>';
                    //add mealtimes table pre-header
                    if (is_array($mealtimesNames) && !empty($mealtimesNames)) {
                        $cache = '<thead><tr>';
                        foreach ($mealtimesNames as $k => $mealTimeName) {
                            if (empty($mealTimeName)) {
                                continue;
                            } else {
                                $cache .= '<th>' . $mealTimeName . '</th>';
                            }
                        }
                        $mealtimesHtml = $cache . '</tr></thead>' . $mealtimesHtml;
                    }


                    $html .= '<div id="collapse' . $counter . '_' . $accordionID . '" class="panel-collapse collapse ' . $activeClass . '">
                            <div class="panel-body">
                            <div class="table-responsive">
                            <table class="table">';
                    $html .= $mealtimesHtml;
                    $mealtimesHtml = '';
                    $html .= '</table></div></div></div></div><!--panel end!-->';
                }
                $counter++;
            }
        }

        return '<div class="panel-group no-padding accordion-type2" id="' . $accordionID . '">' . $html . '</div>';


    }
}


new ctMealPlan();

