<?php

/**
 * Created by PhpStorm.
 * User: Patryk
 * Date: 23.07.14
 * Time: 16:46
 */
class ctScrollBoxFormatter
{

    public function format($items = array(), $args = array())
    {

        $html = '';
        $itemsHtml = '';
        if (!isset($args['raw_content'])) {
            $args['raw_content'] = false;
        }

        if (!isset($args['before_item_global'])) {
            $args['before_item_global'] = '<li>';
        }

        if (!isset($args['after_item_global'])) {
            $args['after_item_global'] = '</li>';
        }





        if (is_array($items) && $args['raw_content'] == false) {

            // Items loop
            foreach ($items as $key => $value) {
                if (isset($value['title'])
                    && isset($value['link'])
                    && isset($value['timestamp_value'])
                ) {
                    $itemsHtml .= $args['before_item_global'];
                    if(array_key_exists('before_item',$value) && !empty($value['before_item'])){
                        $itemsHtml.=$value['before_item'];
                    }

                    $itemsHtml .= '<a href="' . esc_url($value['link']) . '">' . $value['title'] . '</a>';
                    $itemsHtml .= '<span class="timestamp">' . $value['timestamp_value'] . '</span>';

                    if(array_key_exists('tooltip_title',$value) && array_key_exists('tooltip_placement',$value) && array_key_exists('list_quantity_value',$value)){
                        $itemsHtml .= '<span class="list-quantity" data-toggle="tooltip" data-placement="' . $value['tooltip_placement'] . '" title="" data-original-title="' . $value['tooltip_title'] . '">' . $value['list_quantity_value'] . '</span>';
                    }

                    if(array_key_exists('after_item',$value) && !empty($value['after_item'])){
                        $itemsHtml.=$value['after_item'];
                    }

                    $itemsHtml .= $args['after_item_global'];
                } else {
                    continue;
                }
            }

            if (empty($itemsHtml)) {
                return '';
            }
        } else if ($args['raw_content'] == true) {
            $itemsHtml = $items;
        } else {
            return '';
        }


        if (empty($args)
            || !is_array($args)
            && !isset($args['main_container_height'])
            && !isset($args['icon_up_class'])
            && !isset($args['icon_down_class'])
            && !isset($args['ul_max_height'])
            && !isset($args['main_container_class'])
            && !isset($args['ul_class'])
            && !isset($args['before_list'])
            && !isset($args['after_list'])
            && !isset($args['before_item'])
            && !isset($args['after_item'])
        ) {
            $args = $this->getDefaultArgs();
        }

        $html .= '<div class="with-scroll ' . $args['main_container_class'] . '" data-height="' . $args['main_container_height'] . '">';
        $html .= ($args['no_scroll'] == false) ? '<span class="scrollUp"><i class="' . $args['icon_up_class'] . '"></i></span>' : '';
        $html .= $args['before_list'];
        $html .= '<ul class="' . $args['ul_class'] . '" style="max-height: ' . $args['ul_max_height'] . ';">';
        $html .= $itemsHtml;
        $html .= '</ul>';
        $html .= $args['after_list'];
        $html .= ($args['no_scroll'] == false) ? '<span class="scrollDown"><i class="' . $args['icon_down_class'] . '"></i></span>' : '';
        $html .= '</div>';

        return $html;
    }

    protected function getDefaultArgs()
    {
        return array(
            'main_container_height' => '165',
            'icon_up_class' => 'fa fa-chevron-up',
            'icon_down_class' => 'fa fa-chevron-down',
            'ul_max_height' => '165',
            'main_container_class' => '',
            'no_scroll' => false,
            'ul_class' => 'list-counter',
            'before_list' => '',
            'after_list' => '',
            'before_item_global' => '<li>',
            'after_item_global' => '</li>',
            'raw_content' => false
        );
    }


}