<?php


/**
 * Draws works
 */
class ctGalleryShortcode extends ctShortcodeQueryable implements ctVisualComposerShortcodeInterface{


    /**
     * Returns name
     * @return string|void
     */
    public function getName()
    {
        return 'Gallery';
    }

    /**
     * Shortcode name
     * @return string
     */
    public function getShortcodeName()
    {
        return 'gallery';
    }



    public function enqueueHeadScripts()
    {
        wp_register_script('ct-magnific-popup', CT_THEME_ASSETS . '/js/jquery.magnific-popup.min.js', array('jquery'), false, true);
        wp_enqueue_script('ct-magnific-popup');
    }

    /**
     * Handles shortcode
     * @param $atts
     * @param null $content
     * @return string
     */

    public function handle($atts, $content = null)
    {
        $attributes = shortcode_atts($this->extractShortcodeAttributes($atts), $atts);
        extract($attributes);


        $id = rand(100, 1000);
        $this->addInlineJS($this->getInlineJS($id));

        $recentposts = $this->getCollection($attributes, array('post_type' => 'gallery'));

        $html = '';
        $formatter = new ctGalleryFormatter();


        $limitThumbs = ct_get_option('gallery_index_limit',3)!=''?ct_get_option('gallery_index_limit_thumbs',3):3;

        foreach ($recentposts as $p) {
            $args = array(
                'post_type' => 'attachment',
                'numberposts' => -1,
                'post_status' => null,
                'post_parent' => $p->ID
            );
            $attachments = get_posts($args);
            if ($attachments) {

                $counter = 0;
                $itemsArr = array();
                foreach ($attachments as $attach) {
                    $image_small = wp_get_attachment_image_src($attach->ID, 'gallery_thumb_index');
                    $image_full = wp_get_attachment_image_src($attach->ID, 'full');
                    $image_big = wp_get_attachment_image_src($attach->ID, 'galery_big');
                    $image_tall = wp_get_attachment_image_src($attach->ID, 'galery_tall');
                    $itemsArr[$counter]['item_title'] = get_the_title($attach->ID);
                    $itemsArr[$counter]['item_description'] = $attach->post_content;
                    $itemsArr[$counter]['item_src_thumb'] = $image_small[0];
                    $itemsArr[$counter]['item_src_big'] = $image_big[0];
                    $itemsArr[$counter]['item_src_tall'] = $image_tall[0];
                    $itemsArr[$counter]['item_src_full'] = $image_full[0];
                    $counter++;
                    if ($limitThumbs == $counter)break;
                };
                //build main container args
                $galleryArgs = array(
                    'gal_title' => ($show_title=='yes' || $show_title=='true'?$p->post_title:''),
                    'gal_link' => get_permalink($p->ID),
                    'gal_date' => get_the_date($p->id),
                    'gal_before_date' => $gal_before_date,
                    'gal_author' => ($show_author=='yes' || $show_author=='true'?get_userdata($p->post_author)->display_name:''),
                    'gal_before_author' => ($show_author=='yes' || $show_author=='true'?$gal_before_author:''),
                    'gal_author_url' => get_author_posts_url($p->post_author),
                    'gal_description' => $p->post_content,
                    'gal_custom_class' => $class,
                    'gal_columns' => $columns,
                    'gal_show_meta' => $show_meta,
                    'gal_show_content' => $show_description,
                );

                $html .= $formatter->format('gallery_section', $itemsArr, $galleryArgs);
            }
        }

        return do_shortcode($html);

    }

    /**
     * returns JS
     * @param $id
     * @return string
     */
    protected function getInlineJS($id)
    {


    }


    /**
     * creates class name for the category
     * @param $cat
     * @return string
     */
    protected function getCatFilterClass($cat)
    {
        return strtolower(str_replace(' ', '-', $cat->slug));
    }


    /**
     * Shortcode type
     * @return string
     */
    public function getShortcodeType()
    {
        return self::TYPE_SHORTCODE_SELF_CLOSING;
    }

    /**
     * Returns config
     * @return null
     */
    public function getAttributes()
    {
        $atts = $this->getAttributesWithQuery(array(
            'columns' => array('label' => __('columns', 'ct_theme'), 'default' => 3, 'type' => 'select', 'choices' => array('4' => '4', '3' => '3'), 'help' => __("Number of columns", 'ct_theme')),
            'gal_before_date' => array('label' => __('Before date', 'ct_theme'), 'default' => __('Posted on', 'ct_theme'), 'type' => "input"),
            'gal_before_author' => array('label' => __('Before author', 'ct_theme'), 'default' => __('by', 'ct_theme'), 'type' => "input"),
            'limit' => array('label' => __('limit', 'ct_theme'), 'default' => 3, 'type' => 'input', 'help' => __("Number galleries", 'ct_theme')),
            'show_meta' => array('label' => __('Show meta?', 'ct_theme'), 'default' => 'false', 'type' => 'select', 'options' => array(
                'true' => __('true', 'ct_theme'),
                'false' => __('false', 'ct_theme')
            )),
            'show_description' => array('label' => __('Show description?', 'ct_theme'), 'default' => 'true', 'type' => 'select', 'options' => array(
                'true' => __('true', 'ct_theme'),
                'false' => __('false', 'ct_theme')
            )),

            'show_author' => array('label' => __('Show author?', 'ct_theme'), 'default' => 'false', 'type' => 'select', 'options' => array(
                'true' => __('true', 'ct_theme'),
                'false' => __('false', 'ct_theme')
            )),

            'show_title' => array('label' => __('Show title?', 'ct_theme'), 'default' => 'true', 'type' => 'select', 'options' => array(
                'true' => __('true', 'ct_theme'),
                'false' => __('false', 'ct_theme')
            )),


            'class' => array('label' => __("Custom class", 'ct_theme'), 'default' => '', 'type' => 'input', 'help' => __('Adding custom class allows you to set diverse styles in css to the element. Type in name of class, which you defined in css. You can add as much classes as you like.', 'ct_theme')),

        ));

        if (isset($atts['cat'])) {
            unset($atts['cat']);
        }
        return $atts;
    }

    /**
     * Returns additional info about VC
     * @return ctVisualComposerInfo
     */
    public function getVisualComposerInfo() {
        return new ctVisualComposerInfo( $this, array( 'icon' => 'fa-picture-o' ) );
    }
}

new ctGalleryShortcode();